/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import esecurity.validator.x509status.ocsp.OCSPRequest;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public class HttpOCSPClient {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private OCSPRequest b;
    private OCSPResponse c;
    private BasicOCSPResp d;
    private UrlClient e = null;
    private CertDB f = null;

    public HttpOCSPClient(NetworkConfig networkConfig, Logger logger, CertDB certDB) throws CapiException {
        this.e = new UrlClient(networkConfig, a);
        if (logger != null) {
            a = logger;
        }
        if (certDB == null) {
            throw new CapiException("Invalid Cert DB", 1001);
        }
        this.f = certDB;
    }

    public OCSPRequest createOCSPRequest(X509Certificate object, X509Certificate x509Certificate, boolean bl, boolean bl2) throws OCSPException, CapiException, CertificateException {
        try {
            object = new OCSPRequest((X509Certificate)object, x509Certificate, bl2, bl);
        }
        catch (Exception exception) {
            throw new CapiException("error generating ocsp request: " + exception.getMessage(), 31008, exception);
        }
        a.debug("Unsigned request created");
        return object;
    }

    private OCSPResponse a(String object, byte[] object2) throws OCSPException {
        try {
            X509Certificate x509Certificate = this.b.getIssuerCert();
            try {
                object2 = new OCSPResp(object2);
            }
            catch (Exception exception) {
                a.debug("ASN1Object cannot be parsed or the response status is invalid");
                throw new OCSPException("OCSP response parsing error");
            }
            Object object3 = this.b.getReqCert();
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)object2.getResponseObject();
            if (basicOCSPResp == null) {
                int n = object2.getStatus();
                a.debug("responseStatus: " + n);
                String string = OCSPResponse.getResponseStatusName(n);
                throw new OCSPException("OCSP responder error: status " + string + " (" + n + ")");
            }
            int n = object2.getStatus();
            String string = OCSPResponse.getResponseStatusName(n);
            if (n != 0) {
                a.debug("Not successful; got response status: " + string);
                throw new OCSPException("OCSP responder error: status " + string + " (" + n + ")");
            }
            this.c = new OCSPResponse((OCSPResp)object2, (CertificateID)object3);
            a.debug("Successful OCSP response: -------->");
            this.d = this.c.getBasicOcspResponse();
            object2 = this;
            a.debug("----init verifyOCSPResponse----");
            a.debug("getting singleResponse...");
            object3 = object2.c.getSingleResponse();
            a.debug("done...");
            ASN1Primitive aSN1Primitive = OCSPResponse.certificateIDToASN1Primitive(object2.b.getReqCert());
            object3 = OCSPResponse.certificateIDToASN1Primitive(object3.getCertID());
            if (!object3.equals(aSN1Primitive)) {
                a.debug("Request certificate doesn't match response certificate");
                throw new OCSPException("OCSP singleResponse no match request certificate");
            }
            a.debug("getting signer certificate...");
            try {
                object3 = HttpOCSPClient.a(object2.d, x509Certificate);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                a.debug("Failed during verifying BasicOcspResponse" + noSuchAlgorithmException.getMessage());
                throw new OCSPException("OCSP basicOcspResponse NoSuchAlgorithmException");
            }
            catch (InvalidKeyException invalidKeyException) {
                a.debug("Failed during verifying BasicOcspResponse" + invalidKeyException.getMessage());
                throw new OCSPException("OCSP basicOcspResponse InvalidKeyException");
            }
            catch (SignatureException signatureException) {
                a.debug("Failed during verifying BasicOcspResponse" + signatureException.getMessage());
                throw new OCSPException("OCSP basicOcspResponse SignatureException");
            }
            catch (OCSPException oCSPException) {
                a.debug("Failed during verifying BasicOcspResponse" + oCSPException.getMessage());
                throw new OCSPException("OCSP basicOcspResponse OCSPException");
            }
            if (object3 == null) {
                throw new OCSPException("OCSP singleResponse cert not inside");
            }
            a.debug("...done");
            if (((Certificate)object3).equals(x509Certificate)) {
                a.debug("Signature validated by the issuer cert");
            } else {
                a.debug("Signature not validated by the issuer cert; checking authorization ...");
                boolean bl = HttpOCSPClient.a((X509Certificate)object3);
                if (!((X509Certificate)object3).getIssuerDN().equals(x509Certificate.getSubjectDN())) {
                    if (bl) {
                        try {
                            object2.f.onLineVerify(HTTP.defaultConfig, ((Certificate)object3).getEncoded());
                        }
                        catch (CertDBException certDBException) {
                            throw new OCSPException("OCSP responder certificate is not trusted");
                        }
                    } else {
                        throw new OCSPException("OCSP responder certificate is not trusted");
                    }
                }
            }
            SingleResp singleResp = this.c.getSingleResponse();
            object2 = singleResp;
            if (singleResp == null) {
                a.debug("No response got for our request!");
                throw new OCSPException("OCSP singleResponse not present");
            }
            object2 = this.c.getNonce();
            if (object2 != null) {
                byte[] byArray = this.b.getNonce();
                object = byArray;
                if (byArray == null) {
                    a.warn("why null nonce into the request?");
                    throw new CapiException("null nonce into the OCSP request", 31008);
                }
                if (!Arrays.areEqual((byte[])object, (byte[])object2)) {
                    throw new CapiException("OCSP nonce values do not match!", 31008);
                }
            } else {
                if (!((String)object).toLowerCase().startsWith("https")) {
                    throw new CapiException("OCSP nonce is not present into the response. OCSP server could be vulnerable", 31008);
                }
                a.warn("null nonce into the response, but OCSP on https (apply relaxed check)");
            }
            return this.c;
        }
        catch (CertDBException certDBException) {
            a.debug("CertDBException: " + certDBException.getMessage(), (Throwable)certDBException);
            throw new OCSPException("Error verifying cert in certDB: " + certDBException.getMessage());
        }
        catch (Exception exception) {
            a.debug("Exception: " + exception.getMessage(), (Throwable)exception);
            throw new OCSPException(exception.getMessage());
        }
    }

    private static X509Certificate a(BasicOCSPResp basicOCSPResp, X509Certificate x509Certificate) throws OCSPException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, Exception, OCSPException {
        a.debug("getting signer cert from response ... ");
        X509CertificateHolder[] x509CertificateHolderArray = basicOCSPResp.getCerts();
        if (x509CertificateHolderArray.length > 0) {
            a.debug("Certs chain included; trying with issuer cert...");
            for (int i = 0; i <= x509CertificateHolderArray.length; ++i) {
                try {
                    if (!basicOCSPResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(ProvUtils.bcProvider).build(x509CertificateHolderArray[i]))) continue;
                    return new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(x509CertificateHolderArray[i]);
                }
                catch (Exception exception) {
                    a.debug("Failed verifying basicOcspResponse with cert: " + x509CertificateHolderArray[i].toString() + " " + exception.getMessage());
                }
            }
            throw new OCSPException("Failed basicOCSPResponse verify");
        }
        a.debug("Certs not included; trying with issuer cert...");
        if (basicOCSPResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(ProvUtils.bcProvider).build(x509Certificate.getPublicKey()))) {
            return x509Certificate;
        }
        throw new OCSPException("Failed basicOCSPResponse verify with issuer certificate");
    }

    private static boolean a(X509Certificate object) throws Exception {
        a.debug("searching id-kp-OCSPSigning ... ");
        object = ((X509Certificate)object).getExtendedKeyUsage();
        if (object == null) {
            return false;
        }
        if (object.size() == 0) {
            return false;
        }
        String[] stringArray = new String[object.size()];
        for (int i = 0; i < object.size(); ++i) {
            stringArray[i] = (String)object.get(i);
            if (stringArray[i].compareTo(KeyPurposeId.id_kp_OCSPSigning.getId()) != 0) continue;
            return true;
        }
        return false;
    }

    public OCSPResponse sendOCSPRequest(String string, it.actalis.ellips.capi.core.Certificate object, it.actalis.ellips.capi.core.Certificate object2) throws CapiException, OCSPException {
        object = new it.actalis.ellips.capi.core.Certificate(((it.actalis.ellips.capi.core.Certificate)object).getEncoded().getBytes()).getInternalCert();
        object2 = new it.actalis.ellips.capi.core.Certificate(((it.actalis.ellips.capi.core.Certificate)object2).getEncoded().getBytes()).getInternalCert();
        return this.sendOCSPRequest(string, (X509Certificate)object, (X509Certificate)object2);
    }

    public OCSPResponse sendOCSPRequest(String string, X509Certificate object, X509Certificate object2) throws CapiException, OCSPException {
        this.c = null;
        a.debug("Creating encoded unsigned OCSP request");
        try {
            this.b = this.createOCSPRequest((X509Certificate)object, (X509Certificate)object2, true, true);
        }
        catch (Exception exception) {
            a.debug("[sendOCSPRequest] OCSP Download error: " + exception.getMessage());
            throw new OCSPException("Ocsp Request creation failed");
        }
        object = this.b.getEncodedOCSPReq();
        a.debug("doPost request to " + string);
        object2 = "application/ocsp-request";
        try {
            RequestData requestData = new RequestData();
            requestData.setPostdata((byte[])object);
            requestData.setContentType((String)object2);
            object = this.e.downloadUrl(string, requestData, null);
            if (object == null || !object.getStatus().equals("OK")) {
                a.error("Errore richiesta Ocsp Code {}", (Object)object.getStatus_code());
                throw new CapiException("General exception", 31008);
            }
            object = object.getData();
        }
        catch (SecurityException securityException) {
            a.debug(securityException.getMessage(), (Throwable)securityException);
            a.debug("[sendOCSPRequest] SecurityException: " + securityException.getMessage());
            throw new CapiException("Security Exception", 31008);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            a.debug("[sendOCSPRequest] Exception: " + exception.getMessage());
            throw new CapiException("General exception", 31008);
        }
        a.debug("doPost ? Done. ");
        a.debug("Parse response: ");
        this.c = this.a(string, (byte[])object);
        if (this.c == null) {
            a.debug("[sendOCSPRequest] No singleResponse into OCSPresponse");
            throw new OCSPException("OCSP singleResponse not present");
        }
        return this.c;
    }
}

