/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging.utils;

import it.actalis.ellips.capi.logging.EllipsLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EllipsLoggerUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipLogger(EllipsLogger logger, OutputStream saveTo) throws IOException {
        if (logger.getConfig() == null) {
            throw new IOException("Selected logger config is null");
        }
        if (!logger.getConfig().isFileAppenderSet()) {
            throw new IOException("Selected logger does not have a file appender");
        }
        if (saveTo == null) {
            throw new IllegalArgumentException("Parameter saveTo is null");
        }
        File appender = logger.getConfig().getFileAppender();
        FileInputStream fis = null;
        ZipOutputStream zos = null;
        try {
            int readed;
            fis = new FileInputStream(appender);
            zos = new ZipOutputStream(saveTo);
            zos.putNextEntry(new ZipEntry(appender.getName()));
            byte[] buffer = new byte[8192];
            while ((readed = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, readed);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (zos != null) {
                zos.close();
            }
        }
    }
}

