/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.parser;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.parser.tsa.TSRParserBuilder;
import esecurity.validator.parser.utils.EventHandlerMultiSelector;
import esecurity.validator.parser.utils.EventHandlerSelector;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCContainerFactory;
import it.actalis.ellips.capi.asic.parser.util.ASiCContentData;
import it.actalis.ellips.capi.asic.utils.ASiCCommonUtils;
import it.actalis.ellips.capi.asic.utils.MetaInfDocInfo;
import it.actalis.ellips.capi.asic.utils.MetaInfSignatureInfo;
import it.actalis.ellips.capi.asic.utils.xml.ASiCXMLUtils;
import it.actalis.ellips.capi.cms.parser.CadesParserBuilder;
import it.actalis.ellips.capi.container.ContainerParser;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.ByteInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.utils.xml.ASiCManifestType;
import it.actalis.ellips.capi.utils.xml.DataObjectReferenceType;
import it.actalis.ellips.capi.utils.xml.ReferenceType;
import it.actalis.ellips.capi.utils.xml.SignatureType;
import it.actalis.ellips.capi.utils.xml.XAdESSignaturesType;
import it.actalis.ellips.capi.xml.parser.XadesParserBuilder;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.naming.OperationNotSupportedException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCInternalParser
extends ContainerParser<ASiCContainer> {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private ZipInputStream b;
    private InputStream c;
    private ZipEntry d;
    private Map<String, ASiCContentData> e;
    private Map<String, MetaInfSignatureInfo> f;
    private Map<String, List<String>> g;
    private final ASiCContainerFactory h = new ASiCContainerFactory();
    private final NetworkConfig i;
    private final TimeZone j;
    private ASiCSignatureType k = null;

    private boolean a() throws CapiException, IOException {
        String string;
        if (!"mimetype".equals(this.d.getName())) {
            if (this.h.getFormat() == null) {
                throw new CapiException("ASiC format should be specified in mimetype or file extension.", 50023);
            }
            return false;
        }
        if (this.d.getMethod() != 0) {
            throw new CapiException("MIME type file inside ASiC has incorrect format: ZIP method is not STORE.", 50023);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = this.b.read()) >= 0) {
                byteArrayOutputStream.write((byte)n);
            }
            byteArrayOutputStream.flush();
            string = new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                a.error("Unable to close byte array output stream.", (Throwable)iOException);
            }
        }
        this.h.setMimetypeContent(string);
        ASiCFormat aSiCFormat = null;
        if ("application/vnd.etsi.asic-s+zip".equals(string)) {
            aSiCFormat = ASiCFormat.SIMPLE;
        } else if ("application/vnd.etsi.asic-e+zip".equals(string)) {
            aSiCFormat = ASiCFormat.EXTENDED;
        }
        if (this.h.getFormat() == null) {
            if (aSiCFormat == null) {
                throw new CapiException("MIME type inside file is not an ASiC one and MIME type could not be inferred from file extension.", 50023);
            }
            this.h.setFormat(aSiCFormat);
        } else if (aSiCFormat != null && aSiCFormat != this.h.getFormat()) {
            throw new CapiException("MIME type inside file is not conformant with file extension.", 50023);
        }
        return true;
    }

    private void b() throws CapiException, IOException {
        try (CacheOutputStream cacheOutputStream = new CacheOutputStream(8192);){
            int n;
            while ((n = this.b.read()) >= 0) {
                cacheOutputStream.write((int)((byte)n));
            }
            cacheOutputStream.flush();
            Object object = new ASiCContentData();
            InputHandler inputHandler = DataHandlerBuilder.get().setInputStream(cacheOutputStream.getCache(false)).setName(this.d.getName()).buildInput();
            ((ASiCContentData)object).setContentData(inputHandler);
            this.e.put(this.d.getName(), (ASiCContentData)object);
            if (this.h.getFormat() != null && this.h.getFormat().equals((Object)ASiCFormat.SIMPLE) && !this.f.isEmpty()) {
                object = this.f.entrySet().iterator().next();
                object.getValue().setDataFilename(this.d.getName());
            }
            return;
        }
    }

    private void c() throws CapiException, IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = this.b.read()) >= 0) {
                byteArrayOutputStream.write((byte)n);
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                a.error("Unable to close byte output stream.", (Throwable)iOException);
            }
        }
        if (this.d.getName().matches("META-INF/ASiCManifest.*[.]xml")) {
            ASiCInternalParser aSiCInternalParser = this;
            aSiCInternalParser.a(aSiCInternalParser.d.getName(), byArray);
            return;
        }
        if (ASiCCommonUtils.isValidSignatureFilename(this.d.getName(), this.h.getFormat()) && !this.d.getName().equals("META-INF/manifest.xml")) {
            if (this.f.containsKey(this.d.getName())) {
                MetaInfSignatureInfo metaInfSignatureInfo = this.f.get(this.d.getName());
                metaInfSignatureInfo.setSignedContent(byArray);
            } else {
                MetaInfSignatureInfo metaInfSignatureInfo = new MetaInfSignatureInfo();
                if ((this.h.getFormat() == null || !this.h.getFormat().equals((Object)ASiCFormat.EXTENDED)) && this.h.getFormat() != null && this.h.getFormat().equals((Object)ASiCFormat.SIMPLE)) {
                    if (!this.e.isEmpty()) {
                        metaInfSignatureInfo.setDataFilename(this.e.keySet().iterator().next());
                    }
                    metaInfSignatureInfo.setSignatureFilename(this.d.getName());
                    new HashMap();
                }
                metaInfSignatureInfo.setSignedContent(byArray);
                this.f.put(this.d.getName(), metaInfSignatureInfo);
            }
            if (this.h.getFormat() == ASiCFormat.EXTENDED && this.d.getName().matches("META-INF/.*signatures.*[.]xml")) {
                this.a(byArray);
            }
        }
    }

    private static <T> T a(byte[] byArray, Class<T> clazz) throws CapiException {
        Object object;
        Object object2 = new ByteArrayInputStream(byArray);
        if (!ASiCXMLUtils.isValidManifest((InputStream)object2)) {
            throw new CapiException("XML file is not a valid ASiC manifest.", 3010);
        }
        ((ByteArrayInputStream)object2).reset();
        object2 = null;
        try {
            object = new JacksonXmlModule();
            object.setDefaultUseWrapper(false);
            WstxInputFactory wstxInputFactory = new WstxInputFactory();
            WstxOutputFactory wstxOutputFactory = new WstxOutputFactory();
            wstxInputFactory = new XmlFactory((XMLInputFactory)wstxInputFactory, (XMLOutputFactory)wstxOutputFactory);
            object = new XmlMapper((XmlFactory)wstxInputFactory, object);
            object.registerModule((Module)new JaxbAnnotationModule());
            object.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            object2 = object.readValue(byArray, clazz);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        catch (Throwable throwable) {
            a.error(throwable.getMessage(), throwable);
        }
        if (object2 == null) {
            object = new CapiException("Unable to parse ASiC manifest.", 3010);
            a.error("Unable to parse ASiC manifest: ", (Throwable)object);
            throw object;
        }
        return (T)object2;
    }

    private void a(String string, byte[] object) throws CapiException {
        MetaInfSignatureInfo metaInfSignatureInfo;
        ASiCManifestType aSiCManifestType = ASiCInternalParser.a((byte[])object, ASiCManifestType.class);
        String object22 = aSiCManifestType.getSigReference().getURI();
        if (this.f.containsKey(object22)) {
            metaInfSignatureInfo = this.f.get(object22);
        } else {
            metaInfSignatureInfo = new MetaInfSignatureInfo();
            this.f.put(object22, metaInfSignatureInfo);
        }
        metaInfSignatureInfo.setDataFilename(string);
        metaInfSignatureInfo.setSignatureFilename(object22);
        metaInfSignatureInfo.setManifestContent((byte[])object);
        object = new HashMap();
        for (DataObjectReferenceType dataObjectReferenceType : aSiCManifestType.getDataObjectReference()) {
            String string2 = dataObjectReferenceType.getURI();
            MetaInfDocInfo metaInfDocInfo = new MetaInfDocInfo();
            metaInfDocInfo.setDataFilename(string2);
            metaInfDocInfo.setManifestFilename(string);
            metaInfDocInfo.setDigestMethod(DigestAlgorithm.valueFromXadesId((String)dataObjectReferenceType.getDigestMethod().getAlgorithm()));
            metaInfDocInfo.setDigestValue(dataObjectReferenceType.getDigestValue());
            ((HashMap)object).put(string2, metaInfDocInfo);
        }
        metaInfSignatureInfo.setDocsInfo((HashMap<String, MetaInfDocInfo>)object);
    }

    private void a(byte[] byArray) throws CapiException {
        Object object;
        Object object2;
        Object object3;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (!ASiCXMLUtils.isValidASiCXADESSignature(byteArrayInputStream)) {
            throw new CapiException("XML file is not conformant to XADES-E ASiC specifications.", 3010);
        }
        byteArrayInputStream.reset();
        if (!this.d.getName().matches("META-INF/.*signatures.*[.]xml")) {
            return;
        }
        Object object4 = new XAdESSignaturesType();
        try {
            object3 = new JacksonXmlModule();
            object3.setDefaultUseWrapper(false);
            WstxInputFactory wstxInputFactory = new WstxInputFactory();
            WstxOutputFactory object5 = new WstxOutputFactory();
            object2 = new XmlFactory((XMLInputFactory)wstxInputFactory, (XMLOutputFactory)object5);
            object = new XmlMapper((XmlFactory)object2, (JacksonXmlModule)object3);
            object.registerModule((Module)new JaxbAnnotationModule());
            object.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            object4 = (XAdESSignaturesType)object.readValue(byArray, XAdESSignaturesType.class);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        if (object4 == null) {
            object3 = new CapiException("Unable to parse XADES ASiC-E signatures.", 3010);
            a.error("Unable to parse XADES ASiC-E signatures: ", (Throwable)object3);
            throw object3;
        }
        for (SignatureType signatureType : ((XAdESSignaturesType)object4).getSignature()) {
            object2 = signatureType.getSignedInfo().getReference();
            if (this.f.containsKey(this.d.getName())) {
                object = this.f.get(this.d.getName());
            } else {
                object = new MetaInfSignatureInfo();
                this.f.put(this.d.getName(), (MetaInfSignatureInfo)object);
            }
            object3 = this.a(byteArrayInputStream, signatureType.getId());
            ((MetaInfSignatureInfo)object).setSignedContent((byte[])object3);
            ((MetaInfSignatureInfo)object).setDataFilename(this.d.getName());
            ((MetaInfSignatureInfo)object).setSignatureFilename(this.d.getName());
            ((MetaInfSignatureInfo)object).setManifestContent(byArray);
            object4 = new HashMap();
            object3 = object2.iterator();
            while (object3.hasNext()) {
                Object object5;
                ReferenceType referenceType = (ReferenceType)object3.next();
                try {
                    object2 = URLDecoder.decode(referenceType.getURI(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object2 = referenceType.getURI();
                }
                if (this.g.containsKey(this.d.getName())) {
                    this.g.get(this.d.getName()).add((String)object2);
                } else {
                    object5 = new ArrayList<Object>();
                    object5.add(object2);
                    this.g.put(this.d.getName(), (List<String>)object5);
                }
                if (referenceType.getType() != null && !referenceType.getType().equals("")) continue;
                object5 = new MetaInfDocInfo();
                ((MetaInfDocInfo)object5).setDataFilename((String)object2);
                ((MetaInfDocInfo)object5).setManifestFilename(this.d.getName());
                ((MetaInfDocInfo)object5).setDigestMethod(DigestAlgorithm.valueFromXadesId((String)referenceType.getDigestMethod().getAlgorithm()));
                ((MetaInfDocInfo)object5).setDigestValue(referenceType.getDigestValue());
                ((HashMap)object4).put(object2, object5);
                ((MetaInfSignatureInfo)object).setDocsInfo((HashMap<String, MetaInfDocInfo>)object4);
            }
        }
    }

    private byte[] a(ByteArrayInputStream object, String object2) {
        try {
            ((ByteArrayInputStream)object).reset();
            Object object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object3).newDocumentBuilder().parse((InputStream)object);
            object3 = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult((OutputStream)object3);
            Object object4 = object.getElementsByTagName("asic:XAdESSignatures");
            if (object4.getLength() == 0) {
                object4 = object.getElementsByTagNameNS("http://uri.etsi.org/02918/v1.2.1#", "XAdESSignatures");
            }
            if (object4.getLength() == 0) {
                object4 = object.getElementsByTagName("ns:document-signatures");
            }
            if (object4.getLength() == 0) {
                object4 = object.getElementsByTagName("signatures");
            }
            object4 = object4.item(0);
            NodeList nodeList = object.getElementsByTagName("ds:Signature");
            if (nodeList.getLength() == 0) {
                nodeList = object.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            }
            object = null;
            boolean bl = false;
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                bl = object.getAttributes().getNamedItem("Id").getNodeValue().equals(object2);
            }
            object2 = ASiCInternalParser.a((Node)object4);
            object4 = ASiCInternalParser.a((Node)object);
            ((ArrayList)object2).removeAll((Collection<?>)object4);
            object2 = ((ArrayList)object2).iterator();
            while (object2.hasNext()) {
                object4 = (Node)object2.next();
                ((Element)object).setAttribute(object4.getNodeName(), object4.getNodeValue());
            }
            object2 = new DOMSource((Node)object);
            TransformerFactory.newInstance().newTransformer().transform((Source)object2, streamResult);
            return ((ByteArrayOutputStream)object3).toByteArray();
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private static ArrayList<Node> a(Node object) {
        object = object.getAttributes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (!node.getNodeName().startsWith("xmlns")) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private void d() throws CapiException {
        Object object;
        Object object2;
        if (this.f.isEmpty()) {
            throw new CapiException("META-INF has no signature file.", 50023);
        }
        if (this.e.isEmpty()) {
            throw new CapiException("No data in the container.", 50023);
        }
        boolean bl = false;
        for (String string : this.e.keySet()) {
            if (string.contains("/")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new CapiException("No data in the container root.", 50023);
        }
        if (this.h.getFormat() == ASiCFormat.SIMPLE) {
            if (this.f.size() > 1) {
                throw new CapiException("ASiC-S with more than one signature file.", 50023);
            }
            if (this.e.size() > 1) {
                throw new CapiException("ASiC-S with more than one content file.", 50023);
            }
            object2 = this.e.keySet().iterator().next();
            if (((String)object2).startsWith("META-INF")) {
                throw new CapiException("ASiC-S with content not placed in container root.", 50023);
            }
        }
        object2 = new ArrayList<String>(this.e.keySet());
        int n = 0;
        for (String string : this.f.keySet()) {
            String string2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            object = this.f.get(string);
            if (object == null) {
                throw new CapiException("Signature file '" + string + "' is present in ASiC manifest but not in META-INF folder.", 50023);
            }
            if (((MetaInfSignatureInfo)object).getSignedContent() == null || ((MetaInfSignatureInfo)object).getManifestContent() != null && (((MetaInfSignatureInfo)object).getDocsInfo() == null || ((MetaInfSignatureInfo)object).getDocsInfo().isEmpty())) {
                throw new CapiException("Signature " + string + " not present or not associated with content.", 50023);
            }
            Object object7 = new ArrayList<String>();
            if (((MetaInfSignatureInfo)object).getManifestContent() != null) {
                object7.addAll(((MetaInfSignatureInfo)object).getDocsInfo().keySet());
            } else {
                object7.add(((MetaInfSignatureInfo)object).getDataFilename());
            }
            byte[] byArray = ((MetaInfSignatureInfo)object).getSignedContent();
            if ("META-INF/signature.p7s".equals(string) || string.matches("META-INF/.*signature.*[.]p7s")) {
                this.k = ASiCSignatureType.CADES;
            } else if ("META-INF/signatures.xml".equals(string) || string.matches("META-INF/.*signatures.*[.]xml")) {
                this.k = ASiCSignatureType.XADES;
            } else if ("META-INF/timestamp.tst".equals(string) || string.matches("META-INF/.*timestamp.*[.]tst")) {
                this.k = ASiCSignatureType.TIMESTAMP;
            } else {
                throw new CapiException("META-INF has no valid signature file.", 50023);
            }
            if (this.h.getSignatureType() == null) {
                this.h.setSignatureType(this.k);
            } else if (this.h.getSignatureType() != this.k) {
                throw new CapiException("Signatures of different types inside the same ASiC container.", 50023);
            }
            ParsedTransientDocument parsedTransientDocument = null;
            try {
                switch (this.k) {
                    case CADES: 
                    case TIMESTAMP: {
                        object6 = object;
                        object5 = this;
                        object4 = null;
                        object3 = ((MetaInfSignatureInfo)object6).getDataFilename().substring(((MetaInfSignatureInfo)object6).getDataFilename().lastIndexOf("/") + 1);
                        if (object5.h.getFormat() == ASiCFormat.SIMPLE) {
                            object4 = object5.e.get(((MetaInfSignatureInfo)object6).getDataFilename()).getContentData();
                        } else if (object5.h.getFormat() == ASiCFormat.EXTENDED) {
                            object4 = new ByteArrayInputStream(((MetaInfSignatureInfo)object6).getManifestContent());
                        }
                        object3 = DataHandlerBuilder.get().setInputStream((InputStream)object4).setName((String)object3).buildInput();
                        object4 = object;
                        object6 = byArray;
                        object5 = this;
                        object4 = new ByteInputHandler((byte[])object6, ((MetaInfSignatureInfo)object4).getSignatureFilename().substring(((MetaInfSignatureInfo)object4).getSignatureFilename().lastIndexOf("/") + 1));
                        switch (object5.k) {
                            case CADES: {
                                ParsedTransientDocument parsedTransientDocument2 = new CadesParserBuilder().build((InputHandler)object4).parse((InputHandler)object4, (EventHandlerSelector)new b((InputHandler)object3), object5.i, object5.j);
                                break;
                            }
                            case TIMESTAMP: {
                                ParsedTransientDocument parsedTransientDocument2 = new TSRParserBuilder().build((InputHandler)object4).parse((InputHandler)object4, (EventHandlerSelector)new b((InputHandler)object3), object5.i, object5.j);
                                break;
                            }
                            case XADES: {
                                ParsedTransientDocument parsedTransientDocument2 = new XadesParserBuilder().build((InputHandler)object4).parse((InputHandler)object4, (EventHandlerSelector)new b((InputHandler)object3), object5.i, object5.j);
                                break;
                            }
                            default: {
                                ParsedTransientDocument parsedTransientDocument2 = parsedTransientDocument = null;
                            }
                        }
                        if (this.h.getFormat() != ASiCFormat.EXTENDED) break;
                        ((SignatureInformation)parsedTransientDocument.getSignerInfo().get(n)).getRefDocs().clear();
                        parsedTransientDocument.getRefsDocs().clear();
                    }
                }
            }
            catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
            ArrayList<InputHandler> arrayList = new ArrayList<InputHandler>();
            Iterator iterator = object7.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                object5 = this.e.get(string2);
                if (object5 == null) continue;
                arrayList.add(((ASiCContentData)object5).getContentDataHandler());
            }
            iterator = object7.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (string2 == null) continue;
                int n2 = object2.indexOf(string2);
                if (n2 >= 0) {
                    object2.remove(n2);
                }
                if (string.matches("META-INF/.*signatures.*[.]xml") && string2.startsWith("#")) continue;
                object7 = this.e.get(string2);
                object3 = string2;
                object4 = object7;
                object6 = object;
                ASiCInternalParser aSiCInternalParser = this;
                if (object4 == null) {
                    throw new CapiException("Manifest contains file that are not present.", 50023);
                }
                object4 = ((ASiCContentData)object4).getContentData();
                if (aSiCInternalParser.h.getFormat() == ASiCFormat.EXTENDED) {
                    object6 = ((MetaInfSignatureInfo)object6).getDocsInfo().get(object3);
                    MessageDigest messageDigest = DigestUtils.getDigest((String)((MetaInfDocInfo)object6).getDigestMethod().toString());
                    try {
                        byte[] byArray2 = DigestUtils.updateDigest((MessageDigest)messageDigest, (InputStream)object4).digest();
                        object4 = byArray2;
                        if (Arrays.equals(byArray2, ((MetaInfDocInfo)object6).getDigestValue())) {
                            aSiCInternalParser.e.get(object3).setHashValid(true);
                        }
                    }
                    catch (IOException iOException) {
                        throw new CapiException("Error when process ASiC-E File", 1003, (Throwable)iOException);
                    }
                }
                try {
                    switch (this.k) {
                        case CADES: 
                        case TIMESTAMP: {
                            if (this.h.getFormat() == ASiCFormat.EXTENDED) {
                                aSiCInternalParser = new ParsedTransientDocument(DataHandlerBuilder.get().setInputStream(this.e.get(string2).getContentData()).setName(string2).buildInput());
                                ((SignatureInformation)parsedTransientDocument.getSignerInfo().get(n)).addRefDoc(new ReferenceDoc(aSiCInternalParser.getId(), this.e.get(string2).isHashValid()));
                            }
                            break;
                        }
                        case XADES: {
                            ParsedTransientDocument parsedTransientDocument3;
                            object3 = arrayList;
                            object4 = object;
                            object6 = byArray;
                            aSiCInternalParser = this;
                            object4 = new ByteInputHandler((byte[])object6, ((MetaInfSignatureInfo)object4).getSignatureFilename().substring(((MetaInfSignatureInfo)object4).getSignatureFilename().lastIndexOf("/") + 1));
                            switch (aSiCInternalParser.k) {
                                case XADES: {
                                    parsedTransientDocument3 = new XadesParserBuilder().build((InputHandler)object4).parse((InputHandler)object4, (EventHandlerSelector)new a((List<InputHandler>)object3), aSiCInternalParser.i, aSiCInternalParser.j);
                                    break;
                                }
                                default: {
                                    parsedTransientDocument3 = null;
                                }
                            }
                            aSiCInternalParser = parsedTransientDocument3;
                            this.h.addXadesTransientDocument(string2, (ParsedTransientDocument)aSiCInternalParser);
                        }
                    }
                }
                catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                }
                this.h.addObjectData(string2, (ASiCContentData)object7);
                this.h.addSignedFile(string2, (ASiCContentData)object7);
            }
            switch (this.k) {
                case CADES: {
                    this.h.addCadesTransientDocument(((MetaInfSignatureInfo)object).getDataFilename().substring(((MetaInfSignatureInfo)object).getDataFilename().lastIndexOf("/") + 1), parsedTransientDocument);
                    break;
                }
                case TIMESTAMP: {
                    this.h.addTimestampTransientDocument(((MetaInfSignatureInfo)object).getDataFilename().substring(((MetaInfSignatureInfo)object).getDataFilename().lastIndexOf("/") + 1), parsedTransientDocument);
                }
            }
            ++n;
        }
        if (!object2.isEmpty()) {
            Iterator<String> iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string;
                string = iterator.next();
                object = this.e.get(string);
                this.h.addUnsignedFile(string, (ASiCContentData)object);
            }
        }
    }

    public ASiCInternalParser(NetworkConfig networkConfig, TimeZone timeZone) {
        this.i = networkConfig;
        this.j = timeZone;
    }

    public ASiCContainer parse(InputHandler object) throws CapiException {
        Object object2 = this;
        this.b = null;
        ((ASiCInternalParser)((Object)object2)).d = null;
        ((ASiCInternalParser)((Object)object2)).e = new HashMap<String, ASiCContentData>();
        ((ASiCInternalParser)((Object)object2)).f = new HashMap<String, MetaInfSignatureInfo>();
        ((ASiCInternalParser)((Object)object2)).g = new HashMap<String, List<String>>();
        ((ASiCInternalParser)((Object)object2)).h.reset();
        object2 = object.getName();
        int n = ((String)object2).lastIndexOf(".");
        object2 = n >= 0 ? ((String)object2).substring(n) : "";
        if (((String)object2).equalsIgnoreCase(".scs") || ((String)object2).equalsIgnoreCase(".asics")) {
            this.h.setFormat(ASiCFormat.SIMPLE);
        } else if (((String)object2).equalsIgnoreCase(".sce") || ((String)object2).equalsIgnoreCase(".asice")) {
            this.h.setFormat(ASiCFormat.EXTENDED);
        }
        try {
            object2 = object.getInputAsNewStream();
        }
        catch (IOException iOException) {
            throw new CapiException("IOException occurred: " + iOException.getMessage(), 1003);
        }
        if (object2 instanceof ZipInputStream) {
            throw new CapiException("The input stream to read should be passed as a simple input stream, not already as a ZipInputStream (e.g. FileInputStream is ok).", 1002);
        }
        this.c = new BufferedInputStream((InputStream)object2);
        this.b = new ZipInputStream(this.c);
        try {
            if (this.h.getFormat() == null) {
                this.h.setFormat(ASiCCommonUtils.getFormatFromMime(object));
            }
            this.d = this.b.getNextEntry();
            if (this.d == null) {
                throw new CapiException("Container is empty.", 50023);
            }
            if (this.a()) {
                this.d = this.b.getNextEntry();
            }
            while (this.d != null) {
                if (!this.d.isDirectory()) {
                    boolean bl = this.d.getName().startsWith("META-INF/");
                    boolean bl2 = ASiCCommonUtils.isValidManifestFilename(this.d.getName());
                    n = ASiCCommonUtils.isValidSignatureFilename(this.d.getName(), this.h.getFormat()) ? 1 : 0;
                    if ("mimetype".equals(this.d.getName())) {
                        this.a();
                    } else if (bl && (bl2 || n != 0)) {
                        this.c();
                    } else {
                        this.b();
                    }
                }
                this.d = this.b.getNextEntry();
            }
            this.d();
        }
        catch (CapiException capiException) {
            object = capiException;
            throw capiException;
        }
        catch (IOException iOException) {
            throw new CapiException("IOException occurred: " + iOException.getMessage(), 1003);
        }
        finally {
            try {
                this.b.close();
            }
            catch (IOException iOException) {
                a.error("Unable to close input ZIP stream.", (Throwable)iOException);
            }
        }
        try {
            return this.h.buildASiCContainer();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            throw new CapiException("Error during ASiC container build, see inner exception.", 1003, (Throwable)operationNotSupportedException);
        }
    }

    private static final class a
    implements EventHandlerMultiSelector {
        private final HashMap<String, InputHandler> a = new HashMap();
        private final InputHandler b;

        public a(List<InputHandler> object) {
            this.b = object.get(0);
            object = object.iterator();
            while (object.hasNext()) {
                InputHandler inputHandler = (InputHandler)object.next();
                this.a.put(inputHandler.getName(), inputHandler);
            }
        }

        public final InputHandler selectHandler(String string) {
            return this.a.get(string);
        }

        public final List<InputHandler> selectAllHandler() {
            return new ArrayList<InputHandler>(this.a.values());
        }

        public final InputHandler selectHandler() {
            return this.b;
        }
    }

    private static final class b
    implements EventHandlerSelector {
        private final InputHandler a;

        public b(InputHandler inputHandler) {
            this.a = inputHandler;
        }

        public final InputHandler selectHandler() {
            return this.a;
        }
    }
}

