/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.KeyHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.java6.PCSC6;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.PKCS11TokenInfo;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.NativePKCS11Slot;
import it.actalis.pkcs11.nat.Platform;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pcsc.SCardUtils;
import it.arubapec.ca.pkcs11.card.Atr;
import it.arubapec.ca.pkcs11.card.AtrType;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.Card;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardFamilyMatch;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import it.arubapec.ca.pkcs11.card.CardStore;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.PData;
import it.arubapec.ca.pkcs11.card.ReaderEvent;
import it.arubapec.ca.pkcs11.card.ReaderListener;
import it.arubapec.ca.pkcs11.card.a;
import it.arubapec.ca.pkcs11.card.c;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.smartcardio.ATR;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;

public class CardService {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final CardFamily akFamily = new CardFamily("AK", "12345", "12345678", CNSStrategy.LABEL, DSStrategy.LABEL);
    private CardStore b = null;
    private static List<CardTerminal> c = new ArrayList<CardTerminal>();
    private static TerminalFactory d = null;
    private static final List<KeyHandler> e = new ArrayList<KeyHandler>();
    private static boolean f = false;
    private static Thread g = null;
    private static boolean h = false;
    private static final List<ReaderListener> i = new ArrayList<ReaderListener>();
    private static CardService j = null;

    public static CardService getInstance() {
        if (j == null) {
            j = new CardService(null);
        }
        return j;
    }

    public static CardService getInstance(File file) {
        if (j == null) {
            j = new CardService(file);
        }
        return j;
    }

    private CardService(File file) {
        try {
            this.b = CardStore.getInstance(file);
            akFamily.addLib(CardLibrary.bit4IdUniversalEmbedded);
            akFamily.addLib(CardLibrary.bit4IdUniversal);
            return;
        }
        catch (IOException iOException) {
            a.error("Impossibile inizializzare lo store delle carte {}", (Object)iOException.getMessage(), (Object)iOException);
            return;
        }
    }

    public CardStore getCardStore() {
        return this.b;
    }

    public CardFamilyMatch getFromAtr(it.actalis.ellips.util.ATR object4) {
        String string = object4.getMessage().toLowerCase();
        String string2 = object4.getTerminalName().toLowerCase();
        a.debug("Search matching for ATR " + string);
        for (Atr atr : this.b.getCompleteAtr()) {
            if (atr.getType() != AtrType.COMPLETE || !atr.getValue().equalsIgnoreCase(string)) continue;
            return new CardFamilyMatch(atr.getCardFamily(), string2);
        }
        for (Atr atr : this.b.getRegexAtr()) {
            Pattern pattern = Pattern.compile(atr.getValue().toLowerCase());
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return new CardFamilyMatch(atr.getCardFamily(), string2);
        }
        ATR aTR = new ATR(PCSC6.hexStringToByteArray((String)object4.getMessage()));
        byte[] byArray = aTR.getHistoricalBytes();
        if (byArray != null && byArray.length >= 4) {
            byte by = byArray[3];
            for (Atr atr : this.b.getHistoricalAtr()) {
                byte by2 = new Byte(atr.getValue());
                if (by2 != by) continue;
                return new CardFamilyMatch(atr.getCardFamily(), string2);
            }
        }
        return null;
    }

    public List<Card> retrieveCardList() throws IOException, CapiException {
        ArrayList<Card> arrayList = new ArrayList<Card>();
        if (this.b == null) {
            throw new IOException("No Card Database Found");
        }
        ArrayList<Card> arrayList2 = SCardUtils.retrieveATR();
        int n = arrayList2.size();
        a.debug("Individuati ATRs " + n);
        for (it.actalis.ellips.util.ATR aTR : arrayList2) {
            List<Card> list;
            CardFamilyMatch cardFamilyMatch = this.getFromAtr(aTR);
            if (cardFamilyMatch == null || (list = CardService.a(cardFamilyMatch, arrayList)) == null || list.size() <= 0) continue;
            arrayList.add(list.get(0));
        }
        arrayList2 = new ArrayList<Card>();
        NativePKCS11 nativePKCS11 = CardService.initModule(akFamily);
        if (nativePKCS11 != null) {
            try {
                PKCS11Slot[] pKCS11SlotArray = nativePKCS11.getSlotList(true);
                if (pKCS11SlotArray != null) {
                    PKCS11Slot[] pKCS11SlotArray2 = pKCS11SlotArray;
                    int n2 = pKCS11SlotArray.length;
                    for (int i = 0; i < n2; ++i) {
                        PKCS11Slot pKCS11Slot = pKCS11SlotArray2[i];
                        if (!CardService.a(pKCS11Slot, arrayList)) continue;
                        Card card = new Card();
                        card.setCardFamily(akFamily);
                        card.setSerial(pKCS11Slot.getTokenInfo().serialNumber());
                        card.setSlot(pKCS11Slot);
                        Card card2 = card;
                        card2.setpData(PData.getInstance(card2));
                        arrayList2.add(card);
                    }
                }
            }
            finally {
                nativePKCS11.libFinalizePublic();
            }
        }
        if (!arrayList2.isEmpty()) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private static boolean a(PKCS11Slot object, List<Card> list) {
        object = ((PKCS11Slot)object).getInfo().description();
        a.debug("Description dello slot che sto analizzando: {}", object);
        if (!((String)object).startsWith("HID")) {
            a.debug("Ritorno false, la description non inizia per HID");
            return false;
        }
        if (list.isEmpty()) {
            a.debug("Ritorno true, la lista lstCards e' vuota");
            return true;
        }
        if (a.isDebugEnabled()) {
            a.debug("Lista lstCards contiene {} elementi:", (Object)list.size());
            for (Card card : list) {
                a.debug("-> Card serial: {}, Family name: {}, Slot description: {}", new Object[]{card.getSerial(), card.getCardFamily().getName(), card.getSlot().getInfo().description()});
            }
        }
        for (Card card : list) {
            if (!((String)object).equals(card.getSlot().getInfo().description())) continue;
            a.debug("Ritorno false, targetSlot-description [{}] coincide con card slot description [{}]", object, (Object)card.getSlot().getInfo().description());
            return false;
        }
        a.debug("Ritorno true, targetSlot ancor non riconosciuto");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static List<Card> a(CardFamilyMatch cardFamilyMatch, List<Card> list) {
        ArrayList arrayList;
        block25: {
            PKCS11Slot[] pKCS11SlotArray;
            a.debug("start listing all card supported by family");
            a.info("Module " + cardFamilyMatch.getFamily().getName());
            if (a.isDebugEnabled()) {
                a.debug("Referenced libraries: ");
                for (CardLibrary object2 : cardFamilyMatch.getFamily().getLib()) {
                    a.debug(String.format("%s\n windows:%s\n osx:%s\n linux:%s", object2.getDriveName(), object2.getWindowsDrive(), object2.getOsxDrive(), object2.getLinuxDrive()));
                }
            }
            a.info("Terminal name: " + cardFamilyMatch.getTerminalName());
            arrayList = new ArrayList();
            Object var3_5 = null;
            NativePKCS11 nativePKCS11 = cardFamilyMatch.getFamily().getPKCS11(true);
            if (nativePKCS11 == null) {
                throw new CapiException("pkcs11 null", 11000);
            }
            String string = nativePKCS11.getInfo().manufacturerID();
            a.info("Drive manufacturer: " + string);
            try {
                pKCS11SlotArray = nativePKCS11.getSlotList(true);
                if (pKCS11SlotArray == null || pKCS11SlotArray.length == 0) {
                    throw new PKCS11Exception("No card found");
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.error(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                a.debug("no card associated to this module was found into the slots");
                a.debug("end listing all card supported by family");
                if (nativePKCS11 != null) {
                    nativePKCS11.libFinalizePublic();
                }
                return null;
            }
            try {
                a.info("Number of cards found into the pkcs11 module slots: " + pKCS11SlotArray.length);
                for (int i = 0; i < pKCS11SlotArray.length; ++i) {
                    Object object = pKCS11SlotArray[i];
                    if (object instanceof NativePKCS11Slot) {
                        a.info("Slot native ID......: " + ((NativePKCS11Slot)object).getNativeID());
                    }
                    try {
                        Object object2;
                        try {
                            object2 = ((PKCS11Slot)object).getTokenInfo();
                            String string2 = ((PKCS11TokenInfo)object2).manufacturer().trim();
                            object2 = ((PKCS11TokenInfo)object2).serialNumber().trim();
                            object = ((PKCS11Slot)object).getInfo().description().trim();
                            a.info("Card manufacturer...: [{}]", (Object)string2);
                            a.info("Card serial.........: [{}]", object2);
                            a.info("Card slot name......: [{}]", object);
                            if (string2.toUpperCase().contains("ATHENA") && !string.toUpperCase().contains("ATHENA")) {
                                a.info("Smartcard Athena on non-Athena driver!");
                                continue;
                            }
                            if (!cardFamilyMatch.getTerminalName().equals("CUSTOMOVERRIDE") && !cardFamilyMatch.getTerminalName().toLowerCase().startsWith(((String)object).toLowerCase())) {
                                a.debug("Carta skippata in quanto il lettore non corrisponde a quello rilevato in fase di match atr");
                                continue;
                            }
                            for (Card card : list) {
                                if (!card.getSerial().equals(object2)) continue;
                                a.debug("Carta skippata in quanto gi\u00e0 rilevata precedentemente");
                            }
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            object = pKCS11Exception;
                            if (pKCS11Exception.getCode() == 225) {
                                a.info("skip: found a smartcard that matches with another manufacturer driver");
                                continue;
                            }
                            a.debug(((Throwable)object).getMessage() + " code: " + ((PKCS11Exception)object).getCode());
                            throw object;
                        }
                        object = new Card();
                        ((Card)object).setCardFamily(cardFamilyMatch.getFamily());
                        ((Card)object).setSerial((String)object2);
                        ((Card)object).setSlot(pKCS11SlotArray[i]);
                        Object object3 = object;
                        ((Card)object3).setpData(PData.getInstance((Card)object3));
                        arrayList.add(object);
                        a.info("This card is added to the module card list");
                        if (!Platform.isMac()) continue;
                        a.info("for Mac only: no more cards are considered for this module!");
                        break;
                    }
                    catch (Exception exception) {
                        a.error("skip: " + exception.getMessage(), (Throwable)exception);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    a.error(throwable.getMessage(), throwable);
                    a.debug("Generic exception! The card list may be incomplete!");
                    break block25;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    void var3_7;
                    a.debug("end listing all card supported by family");
                    if (var3_7 != null) {
                        var3_7.libFinalizePublic();
                    }
                }
            }
            a.debug("end listing all card supported by family");
            if (nativePKCS11 != null) {
                nativePKCS11.libFinalizePublic();
            }
        }
        return arrayList;
    }

    public static NativePKCS11 initModule(CardFamily cardFamily) throws CapiException {
        a.debug("initModule() start");
        NativePKCS11 nativePKCS11 = null;
        try {
            a.debug("module need to be initialized");
            nativePKCS11 = cardFamily.getPKCS11(true);
            a.debug("initialization done");
        }
        catch (PKCS11Exception pKCS11Exception) {
            PKCS11Exception pKCS11Exception2 = pKCS11Exception;
            if (pKCS11Exception.getCode() != 401) {
                a.error(pKCS11Exception2.getMessage() + " code: " + pKCS11Exception2.getCode(), (Throwable)pKCS11Exception2);
                throw pKCS11Exception2.toCapiException();
            }
            a.debug("module is already intialized and a 'double initialization' exception was generated, but the exception is ignored");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            cardFamily.setSelected_lib(null);
            a.error(unsatisfiedLinkError.getMessage());
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException(exception.getMessage(), 11000);
        }
        finally {
            a.debug("initModule() end");
        }
        return nativePKCS11;
    }

    public void finalize() throws Throwable {
        System.out.println("CardMonitor -> stop()");
        h = false;
        if (g != null) {
            f = true;
        }
        super.finalize();
    }

    private static boolean a(List<CardTerminal> object) {
        object = object.iterator();
        while (object.hasNext()) {
            CardTerminal cardTerminal = (CardTerminal)object.next();
            if (c.contains(cardTerminal)) continue;
            return true;
        }
        return false;
    }

    private static boolean b(List<CardTerminal> list) {
        for (CardTerminal cardTerminal : c) {
            if (list.contains(cardTerminal)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ReaderListener object) {
        if (object == null) {
            return;
        }
        List<ReaderListener> list = i;
        synchronized (list) {
            i.add((ReaderListener)object);
        }
        if (!h) {
            object = this;
            System.out.println("CardMonitor -> start()");
            h = true;
            object = new Thread(new a((CardService)object));
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ReaderListener readerListener) {
        if (readerListener == null) {
            return;
        }
        List<ReaderListener> list = i;
        synchronized (list) {
            i.remove(readerListener);
            return;
        }
    }

    static /* synthetic */ TerminalFactory a() {
        return d;
    }

    static /* synthetic */ TerminalFactory a(TerminalFactory terminalFactory) {
        d = terminalFactory;
        return d;
    }

    static /* synthetic */ List b() {
        return e;
    }

    static /* synthetic */ boolean a(boolean bl) {
        f = false;
        return false;
    }

    static /* synthetic */ Thread a(Thread thread) {
        g = thread;
        return g;
    }

    static /* synthetic */ boolean c() {
        return f;
    }

    static /* synthetic */ void a(CardService object, CardException cardException) throws Exception {
        object = cardException;
        if (((Throwable)object).getCause() == null) {
            throw object;
        }
        if (!"SCARD_E_NO_READERS_AVAILABLE".equals(((Throwable)object).getCause().getMessage())) {
            if (!"SCARD_E_SERVICE_STOPPED".equals(((Throwable)object).getCause().getMessage())) {
                throw object;
            }
            SCardUtils.clearTerminalsList();
            d = TerminalFactory.getDefault();
        }
    }

    static /* synthetic */ boolean a(CardService cardService, List list) {
        if (list == null) {
            if (!c.isEmpty()) {
                c = new ArrayList<CardTerminal>();
                return true;
            }
            return false;
        }
        if (CardService.a(list) || CardService.b(list)) {
            c = list;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void a(CardService cardService) {
        ReaderEvent readerEvent = new ReaderEvent();
        readerEvent.setCardTerminals(c);
        readerEvent.setType(ReaderEvent.ReaderEventType.onChange);
        List<ReaderListener> list = i;
        synchronized (list) {
            for (ReaderListener readerListener : i) {
                new Thread(new c(cardService, readerListener, readerEvent)).start();
            }
            return;
        }
    }

    static /* synthetic */ void a(CardService object, Map object2, Throwable object3) {
        Map map = object2;
        object2 = object3;
        object = map;
        Object object4 = object3 = ((Throwable)object2).getMessage() == null ? object2.getClass().getName() : ((Throwable)object2).getMessage();
        if (object.containsKey(object3)) {
            if (System.currentTimeMillis() - (Long)object.get(object3) > 30000L) {
                a.error(((Throwable)object2).getMessage(), (Throwable)object2);
                object.put(object3, System.currentTimeMillis());
                return;
            }
        } else {
            a.error(((Throwable)object2).getMessage(), (Throwable)object2);
            object.put(object3, System.currentTimeMillis());
        }
    }

    static /* synthetic */ Logger d() {
        return a;
    }

    static /* synthetic */ Thread e() {
        return g;
    }
}

