/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.capi.provider.pkcs11.PKCS11Token;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import org.slf4j.Logger;

public class Pkcs11TokenManagerImpl
implements TokenManager {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public Provider retrieveProviderForKey(PrivateKey privateKey) {
        if (privateKey instanceof Actalis_PrivateKey) {
            return ActalisSingleton.getActalisProvider();
        }
        return null;
    }

    public TokenSpi retrieveTokenByAlias(String string) {
        try {
            return Token.getTokenSpi((String)string);
        }
        catch (CapiException capiException) {
            a.info("Nessun Token Trovato per questo alias.");
            return null;
        }
    }

    public TokenSpi initToken(String string) {
        PKCS11Token pKCS11Token = null;
        if (string.equals("PKCS11Token")) {
            a.debug("trying to load Token PKCS11...");
            pKCS11Token = new PKCS11Token();
        }
        return pKCS11Token;
    }
}

