/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf.parser;

import esecurity.validator.bean.PadesSpecific;
import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.PadesCertificationLevel;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.CRLUtils;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.RevisionInformation;
import it.actalis.ellips.capi.pdf.SignedPDF;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.TimeZone;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class PadesParser
extends SignatureParser {
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public PadesParser(SignatureParserBuilder builder) {
        super(builder);
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    public ParsedTransientDocument parse(InputHandler source, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) throws ParsingException {
        if (timeZone != null) {
            this.df.setTimeZone(timeZone);
        }
        return this.parse(source, null);
    }

    public ParsedTransientDocument parse(InputHandler source, byte[] password) throws ParsingException {
        ParsedTransientDocument doc = new ParsedTransientDocument(source);
        Closeable oh = null;
        SignedPDF signedPdf = null;
        try {
            signedPdf = new SignedPDF(source.getInputAsNewStream(), password);
            if (signedPdf.isSigned()) {
                String id;
                LinkedList<X509Certificate> certs = signedPdf.getCerts();
                for (X509Certificate cert : certs) {
                    id = Utils.calculateDigest((InputStream)new ByteArrayInputStream(cert.getEncoded()), (String)Constants.SHA256);
                    RefCertificate refCert = new RefCertificate();
                    refCert.setId(id);
                    refCert.setContent(cert.getEncoded());
                    refCert.setCapiCertificate(new Certificate(cert));
                    doc.addCert(refCert);
                }
                for (RevisionInformation rev : signedPdf.getRevisions()) {
                    for (PadesSignatureInformation signInfo : rev.getSignatures()) {
                        doc.setSigned(true);
                        SignatureInformation info = new SignatureInformation();
                        info.setSignatureInfo(signInfo.getRawSignature());
                        if (!signInfo.getSubFilter().equals("ETSI.RFC3161")) {
                            info.setFormat(SignatureFormat.PADES);
                        } else {
                            info.setFormat(SignatureFormat.TST);
                        }
                        info.setContainerFormat(ContainerFormat.SELF);
                        info.setContainsGraphometricInfo(signInfo.getGraphometricInfo() != null);
                        info.setCorrupted(!signInfo.isValidSignature());
                        PadesSpecific spec = new PadesSpecific();
                        if (signInfo.getCertificationLevel() == PadesCertificationLevel.NOT_CERTIFIED.getLevelValue()) {
                            spec.setCertificationLevel(PadesCertificationLevel.NOT_CERTIFIED);
                        } else if (signInfo.getCertificationLevel() == PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING_AND_ANNOTATIONS.getLevelValue()) {
                            spec.setCertificationLevel(PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING_AND_ANNOTATIONS);
                        }
                        if (signInfo.getCertificationLevel() == PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING.getLevelValue()) {
                            spec.setCertificationLevel(PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING);
                        }
                        if (signInfo.getCertificationLevel() == PadesCertificationLevel.CERTIFIED_NO_CHANGES_ALLOWED.getLevelValue()) {
                            spec.setCertificationLevel(PadesCertificationLevel.CERTIFIED_NO_CHANGES_ALLOWED);
                        }
                        spec.setLocation(signInfo.getLocation());
                        spec.setReason(signInfo.getReason());
                        spec.setSubFilter(signInfo.getSubFilter());
                        spec.setNextRevisionsUpdateAnnotation(signInfo.nextRevisionUpdateAnnotation());
                        spec.setNextRevisionsUpdateForm(signInfo.nextRevisionUpdateField());
                        spec.setNextRevisionsUpdateObject(signInfo.nextRevisionsUpdateObject());
                        spec.setNextRevisionsSigned(signInfo.nextRevisionsSigned());
                        spec.setSignatureDate(this.df.format(signInfo.getSignDate().getTime()));
                        spec.setAllRevisionsCovered(signInfo.isSignature_cover_all_revision());
                        spec.setCertInDictionary(signInfo.getCertificateInSigDictionary() != null);
                        spec.setMultipleSigners(signInfo.hasMultipleSigners());
                        info.setPadesSpecific(spec);
                        info.setSignatureDate(this.df.format(signInfo.getSignDate().getTime()));
                        if (signInfo.getSignerCertificate() != null) {
                            Certificate cert = signInfo.getSignerCertificate();
                            String refCertId = Utils.calculateDigest((InputStream)new ByteArrayInputStream(cert.getInternalCert().getEncoded()), (String)Constants.SHA256);
                            info.setRefsCertId(refCertId);
                            info.setSignerName(cert.getName());
                            RefCertificate refCert = new RefCertificate();
                            refCert.setId(refCertId);
                            refCert.setContent(cert.getInternalCert().getEncoded());
                            refCert.setCapiCertificate(cert);
                            doc.addCert(refCert);
                        } else {
                            info.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                        }
                        doc.addSignerInfo(info);
                        byte[] tstByte = signInfo.getSignatureTimeStampToken();
                        byte[] signByte = signInfo.getSignature();
                        if (tstByte == null) continue;
                        InputHandler signatureInputHandler = DataHandlerBuilder.get().setBytes(signByte).buildInput();
                        info.addTimeStampToken(TSTUtils.tstToVol((TransientDocument)doc, (byte[])tstByte, (InputHandler)signatureInputHandler, (String)"", (DateFormat)this.df));
                    }
                }
                for (RefCertificate rcert : doc.getCerts()) {
                    if (certs.contains(rcert.getCapiCertificate().getInternalCert())) continue;
                    certs.add(rcert.getCapiCertificate().getInternalCert());
                }
                for (CRL crl : signedPdf.getCrls()) {
                    CRLUtils.addRefCrl((LinkedList)doc.getCrls(), (CRL)crl, signedPdf.getCerts());
                }
                for (BasicOCSPResp ocsp : signedPdf.getOcsps()) {
                    id = Utils.calculateDigest((InputStream)new ByteArrayInputStream(ocsp.getEncoded()), (String)Constants.SHA256);
                    RefOcsp refOcsp = new RefOcsp();
                    refOcsp.setId(id);
                    refOcsp.setContent(ocsp.getEncoded());
                    doc.addOcspresp(refOcsp);
                }
            } else {
                doc.setSigned(false);
            }
        }
        catch (Exception ex) {
            throw new ParsingException("Unable to parse file", (Throwable)ex);
        }
        finally {
            Util.closeQuietly(oh);
            if (signedPdf != null) {
                signedPdf.close();
            }
        }
        return doc;
    }
}

