/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JPanel;

public class TextContainer
extends JPanel {
    private int m_width;
    private int m_height;
    private String m_text;
    private AttributedString styledText;
    private Font optimalFontSize;
    private int fontSize;
    private int fontStyle;
    private String fontName;
    private int anchorCorner;

    public TextContainer(String text, int width, int height, String name, int style, int size, int anchorCorner) {
        this.m_text = text;
        this.m_width = width;
        this.m_height = height;
        this.styledText = new AttributedString(text);
        this.fontName = name;
        this.fontSize = size;
        this.fontStyle = style;
        this.optimalFontSize = new Font(this.fontName, this.fontStyle, this.fontSize);
        this.styledText.addAttribute(TextAttribute.FONT, this.optimalFontSize);
        this.anchorCorner = anchorCorner;
    }

    public String getText() {
        return this.m_text;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.m_width, this.m_height);
    }

    public void paint(Graphics g, boolean scaleFont) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (!System.getProperty("java.version").startsWith("1.5")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        FontRenderContext frc = g2.getFontRenderContext();
        g2.setFont(this.optimalFontSize);
        g2.setColor(Color.BLACK);
        float offsetY = 5.0f;
        float offsetX = 5.0f;
        float startYPosition = offsetY;
        while (true) {
            float f;
            startYPosition = this.calculateIfFit(frc, offsetX, offsetY);
            if (!(f < 0.0f) || this.fontSize <= 1) break;
            --this.fontSize;
            this.optimalFontSize = new Font(this.fontName, this.fontStyle, this.fontSize);
            this.styledText.addAttribute(TextAttribute.FONT, this.optimalFontSize);
            frc = g2.getFontRenderContext();
        }
        if (scaleFont) {
            while (true) {
                float f;
                startYPosition = this.calculateIfFit(frc, offsetX, offsetY);
                if (!(f > 0.0f) || this.fontSize >= 100) break;
                ++this.fontSize;
                this.optimalFontSize = new Font(this.fontName, this.fontStyle, this.fontSize);
                this.styledText.addAttribute(TextAttribute.FONT, this.optimalFontSize);
                frc = g2.getFontRenderContext();
            }
        }
        int fontSizeValid = this.fontSize;
        startYPosition = this.anchorCorner == 1 ? Math.max(offsetY, startYPosition) : offsetY;
        this.optimalFontSize = new Font(this.fontName, this.fontStyle, fontSizeValid);
        this.styledText.addAttribute(TextAttribute.FONT, this.optimalFontSize);
        frc = g2.getFontRenderContext();
        this.paintAll(g2, frc, offsetX, startYPosition);
    }

    private void paintAll(Graphics2D g2, FontRenderContext frc, float offsetX, float startYPosition) {
        AttributedCharacterIterator m_iterator = this.styledText.getIterator();
        int m_start = m_iterator.getBeginIndex();
        int m_end = m_iterator.getEndIndex();
        LineBreakMeasurer measurer = new LineBreakMeasurer(m_iterator, frc);
        measurer.setPosition(m_start);
        float x = offsetX;
        float y = startYPosition;
        int nextOffset = 0;
        while (measurer.getPosition() < m_end) {
            nextOffset = measurer.nextOffset((float)this.m_width - offsetX);
            nextOffset = this.nextTextIndex(nextOffset, measurer.getPosition(), this.m_text);
            TextLayout layout = measurer.nextLayout((float)this.m_width - offsetX, nextOffset, false);
            float dx = layout.isLeftToRight() ? offsetX : (float)this.m_width - layout.getAdvance();
            layout.draw(g2, x + dx, y += layout.getAscent());
            y += layout.getDescent() + layout.getLeading();
        }
    }

    private int nextTextIndex(int nextOffset, int measurerPosition, String text) {
        for (int i = measurerPosition + 1; i < nextOffset; ++i) {
            if (text.charAt(i) != '\n') continue;
            return i;
        }
        return nextOffset;
    }

    private float calculateIfFit(FontRenderContext frc, float offsetX, float offsetY) {
        AttributedCharacterIterator m_iterator = this.styledText.getIterator();
        int m_start = m_iterator.getBeginIndex();
        int m_end = m_iterator.getEndIndex();
        LineBreakMeasurer measurer = new LineBreakMeasurer(m_iterator, frc);
        measurer.setPosition(m_start);
        float y = offsetY;
        if (this.anchorCorner == 1) {
            y = (float)this.m_height - offsetY;
        }
        int nextOffset = 0;
        while (measurer.getPosition() < m_end) {
            nextOffset = measurer.nextOffset((float)this.m_width - offsetX);
            nextOffset = this.nextTextIndex(nextOffset, measurer.getPosition(), this.m_text);
            TextLayout layout = measurer.nextLayout((float)this.m_width - offsetX, nextOffset, false);
            if (this.anchorCorner == 0) {
                y += layout.getAscent() + layout.getDescent() + layout.getLeading();
                continue;
            }
            if (this.anchorCorner != 1) continue;
            y -= layout.getAscent() + layout.getDescent() + layout.getLeading();
        }
        if (this.anchorCorner == 1) {
            return y;
        }
        return (float)this.m_height - y;
    }
}

