/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.utils;

import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.File;
import javax.naming.OperationNotSupportedException;
import org.slf4j.Logger;

public class ASiCCommonUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static final String getExtensionForFormat(ASiCFormat format) {
        switch (format) {
            case SIMPLE: {
                return ".asics";
            }
            case EXTENDED: {
                return ".asice";
            }
        }
        logger.error("Unable to find file extension for format '" + format.toString() + "'.");
        return null;
    }

    public static final String getMimeTypeForFormat(ASiCFormat format) {
        switch (format) {
            case SIMPLE: {
                return "application/vnd.etsi.asic-s+zip";
            }
            case EXTENDED: {
                return "application/vnd.etsi.asic-e+zip";
            }
        }
        logger.error("Unable to find MIME type for format '" + format.toString() + "'.");
        return null;
    }

    public static final String getExtensionShortForFormat(ASiCFormat format) {
        switch (format) {
            case SIMPLE: {
                return ".scs";
            }
            case EXTENDED: {
                return ".sce";
            }
        }
        logger.error("Unable to find file extension for format '" + format.toString() + "'.");
        return null;
    }

    public static final String getFilePath(ASiCFormat format, String destFolder, String destFilenameWithNoExt) {
        String actualDestFolder = destFolder.endsWith(File.separator) ? destFolder : destFolder + File.separator;
        File outputFile = new File(actualDestFolder + destFilenameWithNoExt + ASiCCommonUtils.getExtensionForFormat(format));
        return outputFile.getAbsolutePath();
    }

    public static void throwExceptionIfUnsupportedGetSignature(ASiCSignatureType actual, ASiCSignatureType wanted) throws OperationNotSupportedException {
        if (actual != wanted) {
            throw new OperationNotSupportedException("Unable to get " + (Object)((Object)wanted) + " signature on a " + (Object)((Object)actual) + " ASiC container!");
        }
    }
}

