/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.envelope;

import esecurity.validator.bean.ParsedTransientDocument;
import it.actalis.ellips.capi.asic.ASiCOptions;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCContainerFactory;
import it.actalis.ellips.capi.asic.parser.util.ASiCContentData;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;

public class ASiCEContainer
extends ASiCContainer {
    protected Map<String, ParsedTransientDocument> cadesTransientDocuments;
    protected Map<String, ParsedTransientDocument> timestampTransientDocuments;
    protected Map<String, ParsedTransientDocument> xadesTransientDocuments;
    protected List<String> signedDocs;
    protected List<String> unsignedDocs;

    public Map<String, ParsedTransientDocument> getCadesTransientDocuments() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.CADES);
        return this.cadesTransientDocuments;
    }

    public Map<String, ParsedTransientDocument> getTimestampTransientDocuments() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.TIMESTAMP);
        return this.timestampTransientDocuments;
    }

    public Map<String, ParsedTransientDocument> getXadesTransientDocuments() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.XADES);
        return this.xadesTransientDocuments;
    }

    ASiCEContainer(ASiCOptions opts, ASiCContainerFactory.ASiCFactoryOptions factoryOpts) throws OperationNotSupportedException {
        super(opts, factoryOpts);
        switch (opts.getSignatureType()) {
            case CADES: {
                this.cadesTransientDocuments = factoryOpts.getCadesTransientDocuments();
                break;
            }
            case TIMESTAMP: {
                this.timestampTransientDocuments = factoryOpts.getTimestampTransientDocuments();
                break;
            }
            case XADES: {
                this.xadesTransientDocuments = factoryOpts.getXadesTransientDocuments();
                break;
            }
            default: {
                throw new OperationNotSupportedException("XADES not supported yet.");
            }
        }
        this.unsignedDocs = factoryOpts.getUnsignedDocs();
        this.signedDocs = factoryOpts.getSignedDocs();
    }

    public InputStream getContentStream(String filename) throws IOException {
        if (this.data.containsKey(filename)) {
            InputStream is = ((ASiCContentData)this.data.get(filename)).getContentData();
            return is;
        }
        return null;
    }

    public boolean getHashVerified(String filename) throws IOException {
        if (this.data.containsKey(filename)) {
            return ((ASiCContentData)this.data.get(filename)).isHashValid();
        }
        return false;
    }

    public List<String> getUnsignedDocs() {
        return this.unsignedDocs;
    }

    public List<String> getSignedDocs() {
        return this.signedDocs;
    }
}

