/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card.athena;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.NativePKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11Slot;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.athena.AthenaConstants;
import it.arubapec.ca.pkcs11.card.athena.AthenaFsStrategyParameters;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class AthenaDsFsGenerator {
    private NativePKCS11 pkcs11;
    private NativePKCS11Slot slot;
    private AthenaFsStrategyParameters param;
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public AthenaDsFsGenerator(NativePKCS11 pkcs11, NativePKCS11Slot slot, AthenaFsStrategyParameters param) {
        this.pkcs11 = pkcs11;
        this.slot = slot;
        this.param = param;
    }

    public void generateDsFs() throws CapiException {
        logger.info("Inizio Procedura di creazione FileSystem di Firma Athena");
        String cardReader = new String(this.slot.getInfo().description());
        cardReader = cardReader.replaceFirst("\\s++$", "");
        logger.debug("Individuato Lettore :{}", (Object)cardReader);
        logger.debug("Inizialiazzazione policy pin");
        this.slot.setPinRules();
        logger.debug("Inizialiazzazione policy pin avvenuta con successo");
        logger.debug("Inizio Control CONTROL_GET_DFDS_SM_ENCRYPTED_KEYS");
        byte[] array = new byte[128];
        this.slot.control(AthenaConstants.CONTROL_GET_DFDS_SM_ENCRYPTED_KEYS, array, array.length);
        logger.debug("Control CONTROL_GET_DFDS_SM_ENCRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])array));
        String decryted0405HexStr = Hex.toHexString((byte[])this.param.getClient().serverReq("DF-DS", "D", array));
        decryted0405HexStr = decryted0405HexStr.substring(decryted0405HexStr.length() / 2) + decryted0405HexStr.substring(0, decryted0405HexStr.length() / 2);
        logger.debug("Risultanto inversione Byte {}", (Object)decryted0405HexStr);
        byte[] decodedString = Hex.decode((String)decryted0405HexStr);
        logger.debug("Inizio Control CONTROL_SET_DFDS_SM_DECRYPTED_KEYS");
        this.slot.control(AthenaConstants.CONTROL_SET_DFDS_SM_DECRYPTED_KEYS, decodedString, decodedString.length);
        logger.debug("Control CONTROL_SET_DFDS_SM_DECRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])decodedString));
        logger.debug("Inizio Control2 CONTROL_GET_CHALLENGE");
        byte[] chal = new byte[16];
        this.slot.control2(cardReader, AthenaConstants.CONTROL_GET_CHALLENGE, chal, 16L);
        logger.debug("Control2 CONTROL_GET_CHALLENGE Terminato con successo {}", (Object)Hex.toHexString((byte[])chal));
        logger.debug("Send Challenge to Admin Server");
        byte[] signedChallenger = this.param.getClient().serverReq("DF-DS", "A", chal);
        logger.debug("Admin Server Return Signed Challenge {}", (Object)Hex.toHexString((byte[])signedChallenger));
        logger.debug("Inizio Control2 CONTROL_EXTERNAL_AUTHENTICATE_DFDS");
        this.slot.control2(cardReader, AthenaConstants.CONTROL_EXTERNAL_AUTHENTICATE_DFDS, signedChallenger, signedChallenger.length);
        logger.debug("Control2 CONTROL_EXTERNAL_AUTHENTICATE_DFDS Terminato con successo");
        String pLabelStr = "";
        for (int ii = 0; ii < 32; ++ii) {
            pLabelStr = pLabelStr + " ";
        }
        logger.debug("Inizio Init Token");
        this.slot.initToken(this.param.getPuk(), pLabelStr);
        logger.debug("Init Token terminata con successo");
        logger.debug("Inizio Open Session");
        PKCS11Session session = this.slot.openSession(6, null, null);
        logger.debug("Inizio Login");
        session.login(true, this.param.getPuk());
        session.initPIN(this.param.getPin());
        logger.debug("Impostato PIN CNS");
        ((NativePKCS11Session)session).initPIN4(null, this.param.getPuk(), (byte)4, (byte)0);
        logger.debug("InitPIN4 Impostato PUK di FIRMA");
        ((NativePKCS11Session)session).initPIN4(this.param.getPuk(), this.param.getPin(), (byte)3, (byte)0);
        logger.debug("InitPIN4 Impostato PIN di FIRMA");
        session.logout();
        session.close();
        logger.debug("Chiusa Sessione");
        logger.debug("Inizio Control CONTROL_GET_DF2_SM_ENCRYPTED_KEYS");
        byte[] array2 = new byte[128];
        this.slot.control(AthenaConstants.CONTROL_GET_DF2_SM_ENCRYPTED_KEYS, array2, array2.length);
        logger.debug("Control2 CONTROL_GET_DF2_SM_ENCRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])array2));
        logger.debug("Send CONTROL_GET_DF2_SM_ENCRYPTED_KEYS to Admin Server");
        byte[] decrypted4142 = this.param.getClient().serverReq("DF2", "D", array2);
        if (decrypted4142 != null) {
            try {
                String decryted4142Hex = Hex.toHexString((byte[])decrypted4142);
                logger.debug("Admin Server Return Decrypted 4142 {}", (Object)decryted4142Hex);
                decryted4142Hex = decryted4142Hex.substring(decryted4142Hex.length() / 2) + decryted4142Hex.substring(0, decryted4142Hex.length() / 2);
                decrypted4142 = Hex.decode((String)decryted4142Hex);
                logger.debug("Inizio Control CONTROL_SET_DF2_SM_DECRYPTED_KEYS");
                this.slot.control(AthenaConstants.CONTROL_SET_DF2_SM_DECRYPTED_KEYS, decrypted4142, decrypted4142.length);
                logger.debug("Control2 CONTROL_SET_DF2_SM_DECRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])decrypted4142));
                byte[] controlArr = new byte[]{-17, 21};
                logger.debug("Inizio Control CONTROL_UPDATE_DF2_EF_AVAIL_MEMORY");
                this.slot.control(AthenaConstants.CONTROL_UPDATE_DF2_EF_AVAIL_MEMORY, controlArr, controlArr.length);
                logger.debug("Control2 CONTROL_UPDATE_DF2_EF_AVAIL_MEMORY Terminato con successo {}", (Object)Hex.toHexString((byte[])controlArr));
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        } else {
            logger.info("Attenzione chiave ");
        }
        logger.info("Terminata Procedura di creazione FileSystem di Firma Athena");
    }
}

