/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.util.ATR;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.Platform;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pcsc.SCardUtils;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.Card;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardFamilyMatch;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import it.arubapec.ca.pkcs11.card.CardService;
import it.arubapec.ca.pkcs11.card.CardUtilsConfig;
import it.arubapec.ca.pkcs11.card.CertificateInfo;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.DataFileInfo;
import it.arubapec.ca.pkcs11.card.FamilyName;
import it.arubapec.ca.pkcs11.card.ObjectsInfo;
import it.arubapec.ca.utils.ConfigParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

@Deprecated
public class CardUtils {
    public static final int KEY_DS = 0;
    public static final int KEY_AUTH = 1;
    public static final int KEY_CNS = 2;
    public static final int KEY_P11 = 3;
    public static final int CNSKEY_SIZE = 1024;
    public static final int DSKEY_SIZE = 2048;
    private static String mstrBlackListSerial;
    private static CardFamily lastCustomOverride;
    private static final Logger logger;
    public static final String NO_CARD_DETECTED = "No card detected";
    public static final String NO_MODULE_LOADED = "No module loaded";
    public static final String NO_DRIVER_INIT = "No driver initialized for identified modules";
    public static final String NO_CARD_LOADED = "No card loaded";
    public static final String NO_VALID_URL = "Not valid URL:";
    private static CardService cardService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static int SetBlackList(String strBlackListSerialNumber) {
        int intReturn;
        int intRet = 0;
        try {
            mstrBlackListSerial = strBlackListSerialNumber;
        }
        catch (Exception ex) {
            intRet = -1;
        }
        finally {
            intReturn = intRet;
        }
        return intReturn;
    }

    public static List<Card> retrieveCardListV2(ConfigParameter conf) {
        CardUtilsConfig setup = new CardUtilsConfig();
        setup.setP11Override(conf.getP11Override());
        setup.setIgnoreATR(conf.getIgnoreAtr());
        setup.setRuntimeType(conf.getRuntimeType());
        return CardUtils.retrieveCardListV2(setup);
    }

    public static List<Card> retrieveCardListV2(CardUtilsConfig setup) {
        ArrayList<Card> cardList = new ArrayList<Card>();
        try {
            Map<CardFamily, List<Card>> mapModule_CardList = CardUtils.retrieveCardMap(setup);
            for (List<Card> currCardList : mapModule_CardList.values()) {
                cardList.addAll(currCardList);
            }
        }
        catch (IOException ex) {
            logger.error("Errore metodo retrieveCardMap(): " + ex.getMessage(), (Throwable)ex);
            cardList.clear();
        }
        return cardList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Card refreshCard(Card card) {
        Card objRet;
        block6: {
            objRet = null;
            try {
                if (card.getSetup() == null && card.getConf() == null) {
                    throw new CapiException("Card without any configuration!", 1003);
                }
                List<Card> objCardList = null;
                objCardList = card.getConf() != null ? CardUtils.retrieveCardListV2(card.getConf()) : CardUtils.retrieveCardListV2(card.getSetup());
                if (objCardList.size() <= 0) break block6;
                logger.info("scandisco l'elenco delle card");
                for (int intCounter = 0; intCounter < objCardList.size(); ++intCounter) {
                    logger.info("confronto il seriale card con il seriale previsto dalla richiesta di rinnovo");
                    if (!objCardList.get(intCounter).getSerial().equals(card.getSerial())) continue;
                    logger.info("card individuata");
                    objRet = objCardList.get(intCounter);
                    break;
                }
            }
            catch (Throwable ex) {
                logger.error("Errore in fase di recupero card valida: " + ex.getMessage());
            }
        }
        return objRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyPin(Card objCard, String Pin) throws PKCS11Exception {
        boolean blnReturn;
        block17: {
            blnReturn = false;
            if (objCard != null) {
                NativePKCS11 objPkcs11 = null;
                try {
                    objPkcs11 = objCard.getCardFamily().getPKCS11(true);
                    PKCS11Session Session = objCard.getSlot().openSession(6, null, null);
                    if (Session == null) break block17;
                    try {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.login(false, Pin);
                        blnReturn = true;
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        throw ex;
                    }
                    finally {
                        if (Session != null) {
                            try {
                                Session.logout();
                            }
                            catch (PKCS11Exception ex) {
                                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            }
                            Session.close();
                        }
                    }
                }
                finally {
                    if (objPkcs11 != null) {
                        objPkcs11.libFinalizePublic();
                    }
                }
            }
        }
        return blnReturn;
    }

    public static int ResetPinPuk(Card objCard, String strOldPuk) throws PKCS11Exception {
        int intReturn = -1;
        if (objCard != null) {
            intReturn = CardUtils.initPin(objCard, strOldPuk, objCard.getCardFamily().getDefaultPIN()) ? (CardUtils.changePuk(objCard, strOldPuk, objCard.getCardFamily().getDefaultPUK()) ? 1 : -2) : -3;
        }
        return intReturn;
    }

    public static String DecryptCodiceUtente(String CodiceBusta, String CodiceUtente) {
        String strReturn = "";
        try {
            strReturn = CardUtils.Decode(CodiceBusta.getBytes("UTF-8"), Base64.decode((byte[])CodiceUtente.getBytes("UTF-8"))).substring(0, 8);
        }
        catch (UnsupportedEncodingException ex) {
            strReturn = "KO-Errore in fase di decifratura: " + ex.getMessage();
        }
        return strReturn;
    }

    public static String DecryptPIN(String CodiceBusta, String PIN) {
        String strReturn = "";
        try {
            strReturn = CardUtils.Decode(CodiceBusta.getBytes("UTF-8"), Base64.decode((byte[])PIN.getBytes("UTF-8"))).substring(0, 5);
        }
        catch (UnsupportedEncodingException ex) {
            strReturn = "KO-Errore in fase di decifratura: " + ex.getMessage();
        }
        return strReturn;
    }

    public static String DecryptPUK(String CodiceBusta, String PUK) {
        String strReturn = "";
        try {
            strReturn = CardUtils.Decode(CodiceBusta.getBytes("UTF-8"), Base64.decode((byte[])PUK.getBytes("UTF-8"))).substring(0, 8);
        }
        catch (UnsupportedEncodingException ex) {
            strReturn = "KO-Errore in fase di decifratura: " + ex.getMessage();
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String Decode(byte[] Codice, byte[] ToDecode) {
        String strReturn = "";
        String strRet = "";
        byte[] bobjReturn = new byte[16];
        byte[] iv = new byte[16];
        byte[] ToDecodeBlock = new byte[16];
        for (int i = 0; i < 32; ++i) {
            if (i < 16) {
                if (i > 7) {
                    iv[i] = 0;
                    continue;
                }
                iv[i] = ToDecode[i];
                continue;
            }
            ToDecodeBlock[i - 16] = ToDecode[i];
        }
        AESEngine engine = new AESEngine();
        CBCBlockCipher objCipher = new CBCBlockCipher((BlockCipher)engine);
        PaddedBufferedBlockCipher cip2 = new PaddedBufferedBlockCipher((BlockCipher)objCipher);
        try {
            cip2.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(CardUtils.SHA256(new String(Codice))), iv));
            int len = cip2.processBytes(ToDecodeBlock, 0, 16, bobjReturn, 0);
            if (len == 0) {
                len = cip2.doFinal(bobjReturn, len);
            }
            strRet = new String(bobjReturn);
        }
        catch (Exception ex) {
            if (ex.getMessage().equals("pad block corrupted")) {
                objCipher = new CBCBlockCipher((BlockCipher)engine);
                try {
                    cip2 = new PaddedBufferedBlockCipher((BlockCipher)objCipher, (BlockCipherPadding)new ZeroBytePadding());
                    cip2.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(CardUtils.SHA256(new String(Codice))), iv));
                    int len = cip2.processBytes(ToDecodeBlock, 0, 16, bobjReturn, 0);
                    if (len == 0) {
                        len = cip2.doFinal(bobjReturn, len);
                    }
                    strRet = new String(bobjReturn);
                }
                catch (Exception ex2) {
                    strRet = "KO-Errore in fase di decifratura: " + ex2.getMessage();
                }
            } else {
                strRet = "KO-Errore in fase di decifratura: " + ex.getMessage();
            }
        }
        finally {
            strReturn = strRet;
        }
        return strReturn;
    }

    public static String installX509(Card objCard, String PIN, String KeyID, String X509) {
        return CardUtils._installX509(objCard, PIN, KeyID, X509);
    }

    public static String installX509(Card objCard, String KeyID, String X509) {
        return CardUtils._installX509(objCard, "", KeyID, X509);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String _installX509(Card objCard, String PIN, String KeyID, String X509) {
        String strRet = "";
        if (objCard == null) return "KO-Nessuna card individuata";
        try {
            CardUtils.refreshCard(objCard);
            PKCS11Session Session = objCard.getSlot().openSession(6, null, null);
            if (Session == null) return strRet;
            try {
                try {
                    Session.logout();
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                }
                if (PIN != null && !PIN.equals("")) {
                    Session.login(false, PIN);
                } else {
                    Session.login(false, objCard.getCardFamily().getDefaultPIN());
                }
                int[] intTemplate = new int[]{0, 258};
                Object[] objTemplate = new Object[]{PKCS11Object.CERTIFICATE, KeyID};
                if (CardUtils.ObjectExists(Session, intTemplate, objTemplate) == 0) {
                    CertificateFactory objCertFact = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream objIn = new ByteArrayInputStream(Base64.decode((String)X509));
                    X509Certificate objX509 = (X509Certificate)objCertFact.generateCertificate(objIn);
                    ASN1Integer ser = new ASN1Integer(objX509.getSerialNumber());
                    if (objX509 != null) {
                        int[] intCertTemplate = new int[]{0, 128, 2, 1, 130, 258, 3, 17, 129, 257};
                        Object[] objCertTemplate = new Object[]{PKCS11Object.CERTIFICATE, PKCS11Object.X_509, PKCS11Object.FALSE, PKCS11Object.TRUE, ser.getEncoded("DER"), KeyID.getBytes("UTF-8"), KeyID.getBytes("UTF-8"), objX509.getEncoded(), PrincipalUtil.getIssuerX509Principal((X509Certificate)objX509).getEncoded(), PrincipalUtil.getSubjectX509Principal((X509Certificate)objX509).getEncoded()};
                        try {
                            Session.createObject(intCertTemplate, objCertTemplate);
                            strRet = "OK";
                            return strRet;
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            strRet = "KO-" + ex.getMessage();
                        }
                        return strRet;
                    } else {
                        strRet = "KO-Errore in fase di generazione dell'oggetto X509";
                    }
                    return strRet;
                } else {
                    strRet = "KO-La card contiene gi\u00e0 un certificato con la chiave indicata";
                }
                return strRet;
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                strRet = "KO-Errore in fase di login alla card";
                return strRet;
            }
            catch (Exception e) {
                strRet = "KO-Errore in fase di installazione del certificato";
                return strRet;
            }
            finally {
                if (Session != null) {
                    try {
                        Session.logout();
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    }
                    Session.close();
                }
            }
        }
        catch (PKCS11Exception ex) {
            logger.debug(ex.getMessage() + " code: " + ex.getCode());
            return "KO-Errore in fase di accesso alla card";
        }
    }

    public static String ChangePinPuk(Card objCard, String OldPIN, String NewPIN, String OldPUK, String NewPUK) throws PKCS11Exception {
        String strReturn = "KO-";
        strReturn = CardUtils.changePin(objCard, OldPIN, NewPIN) ? (CardUtils.changePuk(objCard, OldPUK, NewPUK) ? "OK" : "KO-Fallito changePuk") : "KO-Fallito changePin";
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changePin(Card objCard, String oldPin, String newPin) throws PKCS11Exception {
        boolean blnReturn = false;
        if (objCard != null) {
            CardUtils.refreshCard(objCard);
            PKCS11Session Session = objCard.getSlot().openSession(6, null, null);
            try {
                try {
                    Session.logout();
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                }
                Session.login(false, oldPin);
                Session.setPIN(oldPin, newPin);
                blnReturn = true;
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                throw ex;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (Session != null) {
                    try {
                        Session.logout();
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    }
                    Session.close();
                }
            }
        }
        return blnReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changePuk(Card objCard, String oldPuk, String newPuk) throws PKCS11Exception {
        boolean blnReturn = false;
        if (objCard != null) {
            CardUtils.refreshCard(objCard);
            PKCS11Session Session = objCard.getSlot().openSession(6, null, null);
            try {
                try {
                    Session.logout();
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                }
                Session.login(true, oldPuk);
                Session.setPIN(oldPuk, newPuk);
                blnReturn = true;
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                throw ex;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (Session != null) {
                    try {
                        Session.logout();
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    }
                    Session.close();
                }
            }
        }
        return blnReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initPin(Card objCard, String Puk, String newPin) throws PKCS11Exception {
        boolean blnReturn = false;
        if (objCard != null) {
            CardUtils.refreshCard(objCard);
            PKCS11Session Session = objCard.getSlot().openSession(6, null, null);
            try {
                try {
                    Session.logout();
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                }
                Session.login(true, Puk);
                Session.initPIN(newPin);
                blnReturn = true;
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                throw ex;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (Session != null) {
                    try {
                        Session.logout();
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    }
                    Session.close();
                }
            }
        }
        return blnReturn;
    }

    public static String generateKey(Card objCard, String PIN, int Type2, int Size, int baseId) {
        return CardUtils._generateKey(objCard, PIN, Type2, Size, baseId);
    }

    public static String generateKey(Card objCard, String PIN, int Type2, int Size) {
        return CardUtils._generateKey(objCard, PIN, Type2, Size, -1);
    }

    public static String generateKey(Card objCard, int Type2, int Size) {
        return CardUtils._generateKey(objCard, "", Type2, Size, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String _generateKey(Card objCard, String PIN, int Type2, int Size, int baseId) {
        String strRet = "";
        if (objCard == null) return "KO-" + CardUtils.class.getName() + "-Errore nessuna card individuata";
        try {
            CardUtils.refreshCard(objCard);
            PKCS11Session Session = objCard.getSlot().openSession(6, null, null);
            if (Session != null) {
                try {
                    if (PIN != null & !PIN.equals("")) {
                        CardUtils.LoginUser(Session, PIN);
                    } else {
                        CardUtils.LoginUser(Session, objCard.getCardFamily().getDefaultPIN());
                    }
                    strRet = CardUtils.GenerateKeyPair(Session, Type2, Size, objCard.getCardFamily().getSelected_lib().getDrive(), baseId);
                }
                catch (Exception ex) {
                    strRet = "KO-" + CardUtils.class.getName() + "-" + ex.getMessage();
                }
            }
            if (Session == null) return strRet;
            try {
                Session.logout();
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
            }
            Session.close();
            return strRet;
        }
        catch (PKCS11Exception ex) {
            logger.debug(ex.getMessage() + " code: " + ex.getCode());
            return "KO-" + CardUtils.class.getName() + "-" + ex.getMessage();
        }
        catch (Exception ex) {
            return "KO-" + CardUtils.class.getName() + "-" + ex.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String GenerateKeyPair(PKCS11Session session, int KeyType2, int Size, String LibName, int forcedBaseId) {
        String strRet;
        block35: {
            Object keyref = null;
            int BaseID = Math.max(0, forcedBaseId);
            String ID = "";
            String LabelPub = "";
            String LabelPriv = "";
            String strReturn = "";
            strRet = "KO-Errore generico in fase di generazione chiave";
            boolean error = false;
            try {
                if (session != null) {
                    ObjectsInfo infoKeyIDsBefore = CardUtils.retrieveKeysIDList(session, true);
                    switch (KeyType2) {
                        case 0: {
                            if (LibName.contains("asepkcs")) {
                                ID = "Firma" + String.valueOf(BaseID);
                                LabelPub = "Firma" + String.valueOf(BaseID);
                                LabelPriv = "Firma" + String.valueOf(BaseID);
                                break;
                            }
                            ID = "DS" + String.valueOf(BaseID);
                            LabelPub = "DS" + String.valueOf(BaseID);
                            LabelPriv = "DS" + String.valueOf(BaseID);
                            break;
                        }
                        case 1: {
                            ID = "AUTH" + String.valueOf(BaseID);
                            LabelPub = "AUTH" + String.valueOf(BaseID);
                            LabelPriv = "AUTH" + String.valueOf(BaseID);
                            break;
                        }
                        case 2: {
                            ID = "CNS" + String.valueOf(BaseID);
                            LabelPub = "CNS" + String.valueOf(BaseID);
                            LabelPriv = "CNS" + String.valueOf(BaseID);
                            break;
                        }
                        case 3: {
                            ID = "FP11" + String.valueOf(BaseID);
                            LabelPub = "FP11" + String.valueOf(BaseID);
                            LabelPriv = "FP11" + String.valueOf(BaseID);
                            break;
                        }
                    }
                    int[] intTemplate = new int[]{0, 258};
                    Object[] objTemplate = new Object[]{PKCS11Object.PRIVATE_KEY, ID};
                    while (CardUtils.ObjectExists(session, intTemplate, objTemplate) == 1) {
                        ++BaseID;
                        switch (KeyType2) {
                            case 0: {
                                if (LibName.contains("asepkcs")) {
                                    ID = "Firma" + String.valueOf(BaseID);
                                    LabelPub = "Firma" + String.valueOf(BaseID);
                                    LabelPriv = "Firma" + String.valueOf(BaseID);
                                    break;
                                }
                                ID = "DS" + String.valueOf(BaseID);
                                LabelPub = "DS" + String.valueOf(BaseID);
                                LabelPriv = "DS" + String.valueOf(BaseID);
                                break;
                            }
                            case 1: {
                                ID = "AUTH" + String.valueOf(BaseID);
                                LabelPub = "AUTH" + String.valueOf(BaseID);
                                LabelPriv = "AUTH" + String.valueOf(BaseID);
                                break;
                            }
                            case 2: {
                                ID = "CNS" + String.valueOf(BaseID);
                                LabelPub = "CNS" + String.valueOf(BaseID);
                                LabelPriv = "CNS" + String.valueOf(BaseID);
                                break;
                            }
                            case 3: {
                                ID = "FP11" + String.valueOf(BaseID);
                                LabelPub = "FP11" + String.valueOf(BaseID);
                                LabelPriv = "FP11" + String.valueOf(BaseID);
                                break;
                            }
                        }
                        objTemplate[1] = ID;
                        if (BaseID <= 9) continue;
                        error = true;
                        break;
                    }
                    if (!error) {
                        Integer pub = PKCS11Object.PUBLIC_KEY;
                        Integer priv = PKCS11Object.PRIVATE_KEY;
                        Boolean decryptVal = Boolean.FALSE;
                        Boolean wrapVal = Boolean.FALSE;
                        if (KeyType2 != 0) {
                            decryptVal = Boolean.TRUE;
                            wrapVal = Boolean.TRUE;
                        }
                        int[] intPubKeyTemplate = new int[]{0, 258, 2, 1, 3, 260, 266, 262, 289, 290, 267};
                        Object[] objPubKeyTemplate = new Object[]{pub, ID.getBytes(), PKCS11Object.FALSE, PKCS11Object.TRUE, LabelPub, decryptVal, PKCS11Object.TRUE, wrapVal, Size, new BigInteger("65537"), PKCS11Object.TRUE};
                        int[] intPriKeyTemplate = new int[]{0, 258, 2, 1, 3, 259, 261, 264, 263, 265};
                        Object[] objPriKeyTemplate = new Object[]{priv, ID.getBytes(), PKCS11Object.TRUE, PKCS11Object.TRUE, LabelPriv, PKCS11Object.TRUE, decryptVal, PKCS11Object.TRUE, wrapVal, PKCS11Object.TRUE};
                        int trials = 5;
                        logger.debug("start with key generation trials (5)");
                        try {
                            boolean bCheckModLen = true;
                            if (bCheckModLen) {
                                boolean bGenerationBitsOk = false;
                                for (int iTry = 0; iTry < 5; ++iTry) {
                                    logger.debug("trial " + iTry + "...");
                                    PKCS11Object[] objects = session.generateKeyPair(0, null, intPubKeyTemplate, objPubKeyTemplate, intPriKeyTemplate, objPriKeyTemplate);
                                    logger.debug("generation done. now check consistency");
                                    int nBitsKey0 = objects[0].getBigIntegerAttributeValue(288).bitLength();
                                    int nBitsKey1 = objects[1].getBigIntegerAttributeValue(288).bitLength();
                                    if (nBitsKey0 != Size || nBitsKey1 != Size) {
                                        objects[0].destroy();
                                        objects[1].destroy();
                                        logger.error(String.format("errore %d: le chiavi dovevano essere a %d bit. La chiave 0 e' a %d bit e la chiave 1 e' a %d bit", iTry, Size, nBitsKey0, nBitsKey1));
                                        continue;
                                    }
                                    BigInteger shifted0 = objects[0].getBigIntegerAttributeValue(288).shiftRight(nBitsKey0 - 8);
                                    if (shifted0.intValue() == 0) {
                                        objects[0].destroy();
                                        objects[1].destroy();
                                        logger.error(String.format("errore %d: La chiave 0 e' lunga %d bit ma il primo byte \u00e8 a zero", iTry, nBitsKey0));
                                        continue;
                                    }
                                    BigInteger shifted1 = objects[1].getBigIntegerAttributeValue(288).shiftRight(nBitsKey1 - 8);
                                    if (shifted1.intValue() == 0) {
                                        objects[0].destroy();
                                        objects[1].destroy();
                                        logger.error(String.format("errore %d: La chiave 1 e' lunga %d bit ma il primo byte \u00e8 a zero", iTry, nBitsKey1));
                                        continue;
                                    }
                                    logger.info("chiavi generate con la dimensione richiesta");
                                    bGenerationBitsOk = true;
                                    break;
                                }
                                if (bGenerationBitsOk) {
                                    logger.debug("search for created key ID...");
                                    ObjectsInfo infoKeyIDsAfter = CardUtils.retrieveKeysIDList(session, true);
                                    for (int iAfterId = 0; iAfterId < infoKeyIDsAfter.getIDs().size(); ++iAfterId) {
                                        String curId = infoKeyIDsAfter.getIDs().get(iAfterId);
                                        boolean bFound = false;
                                        for (int iBeforeId = 0; iBeforeId < infoKeyIDsBefore.getIDs().size(); ++iBeforeId) {
                                            if (!curId.equals(infoKeyIDsBefore.getIDs().get(iBeforeId))) continue;
                                            bFound = true;
                                            break;
                                        }
                                        if (bFound) continue;
                                        strRet = curId;
                                        logger.debug("key ID is: " + strRet);
                                        break block35;
                                    }
                                    break block35;
                                }
                                strRet = "KO-Errore generazione chiave " + ID + ". Dimensione chiave non conforme alla richiesta";
                                break block35;
                            }
                            PKCS11Object[] objects = session.generateKeyPair(0, null, intPubKeyTemplate, objPubKeyTemplate, intPriKeyTemplate, objPriKeyTemplate);
                            strRet = ID;
                        }
                        catch (Exception ex) {
                            strRet = "KO-Errore generazione chiave " + ID + ": " + ex.getMessage();
                        }
                        break block35;
                    }
                    strRet = "KO-" + CardUtils.class.getName() + "Errore in fase di generazione chiave: elenco chiavi esaurito";
                    break block35;
                }
                strRet = "KO-" + CardUtils.class.getName() + "Errore in fase di generazione chiave: sessione non valida";
            }
            catch (Exception ex) {
                strRet = "KO-" + CardUtils.class.getName() + "Errore in fase di generazione chiave: " + ex.getMessage();
            }
            finally {
                strReturn = strRet;
            }
        }
        return strRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existObject(Card objCard, int[] intTemplate, Object[] objTemplate, String strPIN) {
        int intReturn = 0;
        int intTemp = 0;
        long intSession = 0L;
        try {
            PKCS11Session Session = null;
            try {
                Session = objCard.getSlot().openSession(6, null, null);
                CardUtils.LoginUser(Session, strPIN);
                if (intSession != 0L && intTemp == 0) {
                    intTemp = CardUtils.ObjectExists(Session, intTemplate, objTemplate);
                }
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                intTemp = -1;
            }
            finally {
                if (Session != null) {
                    try {
                        Session.logout();
                    }
                    catch (PKCS11Exception pKCS11Exception) {}
                    Session.close();
                }
            }
        }
        catch (PKCS11Exception ex) {
            logger.debug(ex.getMessage() + " code: " + ex.getCode());
            intTemp = -1;
        }
        finally {
            intReturn = intTemp;
        }
        return intReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ObjectExists(PKCS11Session Session, int[] intTemplate, Object[] objTemplate) {
        int intReturn = 0;
        int intTemp = 0;
        try {
            Session.findObjectsInit(intTemplate, objTemplate);
            PKCS11Object objFound = Session.findObject();
            Session.findObjectsFinal();
            if (objFound != null) {
                intTemp = 1;
            }
        }
        catch (PKCS11Exception ex) {
            logger.debug(ex.getMessage() + " code: " + ex.getCode());
            intTemp = -1;
        }
        finally {
            intReturn = intTemp;
        }
        return intReturn;
    }

    private static String formatPlus(String s) {
        char[] c = s.toCharArray();
        String s1 = "";
        for (int i = 0; i <= c.length - 1; ++i) {
            if (c[i] == '+') continue;
            s1 = s1 + c[i];
        }
        return s1;
    }

    private static String getHexFromNumber(int Numero, int Lunghezza) {
        String strReturn = "";
        String strHexString = Integer.toHexString(Numero);
        for (int i = 1; i <= Lunghezza; ++i) {
            if (strHexString.length() >= Lunghezza) continue;
            strHexString = "0" + strHexString;
        }
        strReturn = strHexString;
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String destroyUserDataFile(Card objCard, String PIN) {
        String strReturn;
        block21: {
            strReturn = "";
            String strUserHash = "";
            String strRet = "";
            try {
                if (objCard == null) break block21;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                if (Session == null) break block21;
                try {
                    if (strRet.equals("")) {
                        CardUtils.LoginUser(Session, PIN);
                        int[] intTemplate = new int[]{0};
                        Object[] objTemplate = new Object[]{PKCS11Object.DATA};
                        Session.findObjectsInit(intTemplate, objTemplate);
                        PKCS11Object objFound = Session.findObject();
                        Session.findObjectsFinal();
                        if (objFound != null) {
                            objFound.destroy();
                            strRet = CardUtils.ObjectExists(Session, intTemplate, objTemplate) != 1 ? "OK" : "KO-Errore in fase di cancellazione PDATA";
                        }
                    }
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di Login: " + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception ex) {
                strRet = "KO-" + ex.getMessage();
            }
            finally {
                strReturn = strRet.equals("") ? strUserHash : strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveCertificate(PKCS11Session Session, int[] intTemplate, Object[] objTemplate) {
        String strReturn = "";
        String strRet = "KO-Errore in fase di recupero certificato da rimuovere";
        try {
            if (Session != null) {
                if (CardUtils.ObjectExists(Session, intTemplate, objTemplate) == 1) {
                    Session.findObjectsInit(intTemplate, objTemplate);
                    PKCS11Object objFound = Session.findObject();
                    Session.findObjectsFinal();
                    byte[] value = objFound.getByteArrayAttributeValue(17);
                    strRet = new String(Base64.encode((byte[])value));
                } else {
                    strRet = "";
                }
            }
        }
        catch (Exception ex) {
            strRet = "KO-" + ex.getMessage();
        }
        finally {
            strReturn = strRet;
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveCertificate(Card objCard, int[] intTemplate, Object[] objTemplate) {
        String strReturn;
        block20: {
            strReturn = "";
            String strRet = "KO-Errore in fase di recupero certificato da rimuovere";
            try {
                if (objCard == null) break block20;
                PKCS11Session Session = null;
                try {
                    try {
                        Session = objCard.getSlot().openSession(6, null, null);
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                    }
                    if (Session != null) {
                        strRet = CardUtils.retrieveCertificate(Session, intTemplate, objTemplate);
                    }
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception ex) {
                strRet = "KO-" + ex.getMessage();
            }
            finally {
                strReturn = strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveCertificate(Card objCard, String KeyID) {
        String strRet = "KO-Errore in fase di recupero certificato da rimuovere";
        try {
            if (objCard != null) {
                int[] intTemplate = new int[]{0, 258};
                Object[] objTemplate = new Object[]{PKCS11Object.CERTIFICATE, KeyID};
                String string = CardUtils.retrieveCertificate(objCard, intTemplate, objTemplate);
                return string;
            }
        }
        catch (Exception ex) {
            strRet = "KO-" + ex.getMessage();
        }
        return strRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CertificateInfo> retrieveCertificates(Card objCard, int[] intTemplate, Object[] objTemplate) {
        ArrayList<CertificateInfo> lstReturn;
        block23: {
            lstReturn = null;
            ArrayList<CertificateInfo> lstRet = new ArrayList<CertificateInfo>();
            try {
                if (objCard == null) break block23;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                    if (Session != null && CardUtils.ObjectExists(Session, intTemplate, objTemplate) > 0) {
                        Session.findObjectsInit(intTemplate, objTemplate);
                        PKCS11Object obj = null;
                        while ((obj = Session.findObject()) != null) {
                            byte[] value = obj.getByteArrayAttributeValue(17);
                            byte[] id = obj.getByteArrayAttributeValue(258);
                            CertificateInfo objInfo = new CertificateInfo();
                            objInfo.setX509(new String(Base64.encode((byte[])value)));
                            objInfo.setID(new String(id));
                            lstRet.add(objInfo);
                        }
                    }
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                lstReturn = lstRet;
            }
        }
        return lstReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectsInfo retrieveKeysIDList(PKCS11Session session, boolean blnPrivate) {
        ObjectsInfo objRet;
        block13: {
            logger.debug("get IDs list");
            objRet = new ObjectsInfo();
            objRet.setEsito("OK");
            objRet.setTipo("PubKey");
            if (blnPrivate) {
                objRet.setTipo("PriKey");
            }
            try {
                int[] intTemplate = new int[]{0};
                Object[] objTemplate = new Object[]{PKCS11Object.PRIVATE_KEY};
                objTemplate[0] = blnPrivate ? PKCS11Object.PRIVATE_KEY : PKCS11Object.PUBLIC_KEY;
                if (CardUtils.ObjectExists(session, intTemplate, objTemplate) > 0) {
                    logger.debug("some ids are present");
                    session.findObjectsInit(intTemplate, objTemplate);
                    logger.debug("ids found");
                    PKCS11Object obj = null;
                    try {
                        while ((obj = session.findObject()) != null) {
                            String id = new String(obj.getByteArrayAttributeValue(258), "UTF-8");
                            objRet.getIDs().add(id);
                        }
                        break block13;
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        throw ex;
                    }
                    finally {
                        session.findObjectsFinal();
                    }
                }
                objRet.setEsito("OK");
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                objRet.setEsito("KO-" + ex.getMessage());
            }
            catch (UnsupportedEncodingException ex) {
                objRet.setEsito("KO-" + ex.getMessage());
            }
        }
        logger.debug(objRet.getIDs().size() + " ids returned to caller");
        return objRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectsInfo retrieveKeysIDList(Card objCard, String strPIN, boolean blnPrivate) {
        ObjectsInfo objReturn;
        block18: {
            objReturn = null;
            try {
                if (objCard != null) {
                    PKCS11Session session = null;
                    try {
                        objCard = CardUtils.refreshCard(objCard);
                        session = objCard.getSlot().openSession(6, null, null);
                        if (session != null) {
                            CardUtils.LoginUser(session, strPIN);
                            objReturn = CardUtils.retrieveKeysIDList(session, blnPrivate);
                        }
                        break block18;
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        objReturn.setEsito("KO-" + ex.getMessage());
                        break block18;
                    }
                    finally {
                        if (session != null) {
                            try {
                                session.logout();
                            }
                            catch (PKCS11Exception ex) {
                                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            }
                            session.close();
                        }
                    }
                }
                objReturn.setEsito("KO-Errore in fase listing chiavi");
            }
            catch (Exception ex) {
                objReturn.setEsito("KO-" + ex.getMessage());
                objReturn.setIDs(null);
            }
        }
        return objReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectsInfo retrieveCertsIDList(Card objCard, String strPIN) {
        ObjectsInfo objReturn;
        block23: {
            objReturn = null;
            ObjectsInfo objRet = new ObjectsInfo();
            objRet.setEsito("OK");
            objRet.setTipo("Cert");
            try {
                if (objCard != null) {
                    PKCS11Session Session = null;
                    try {
                        Session = objCard.getSlot().openSession(6, null, null);
                        if (Session == null) break block23;
                        try {
                            CardUtils.LoginUser(Session, strPIN);
                            int[] intTemplate = new int[]{0};
                            Object[] objTemplate = new Object[]{PKCS11Object.CERTIFICATE};
                            if (CardUtils.ObjectExists(Session, intTemplate, objTemplate) > 0) {
                                Session.findObjectsInit(intTemplate, objTemplate);
                                PKCS11Object obj = null;
                                while ((obj = Session.findObject()) != null) {
                                    String id = new String(obj.getByteArrayAttributeValue(258), "UTF-8");
                                    objRet.getIDs().add(id);
                                }
                            } else {
                                objRet.setEsito("OK");
                            }
                            break block23;
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            objRet.setEsito("KO-" + ex.getMessage());
                            break block23;
                        }
                        finally {
                            if (Session != null) {
                                try {
                                    Session.logout();
                                }
                                catch (PKCS11Exception ex) {
                                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                                }
                                Session.close();
                            }
                        }
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        objRet.setEsito("KO-" + ex.getMessage());
                    }
                    break block23;
                }
                objRet.setEsito("KO-Errore in fase listing certificati");
            }
            catch (Exception ex) {
                objRet.setEsito("KO-" + ex.getMessage());
                objRet.setIDs(null);
            }
            finally {
                objReturn = objRet;
            }
        }
        return objReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DataFileInfo> retrieveDataFiles(Card objCard, int[] intTemplate, Object[] objTemplate) {
        ArrayList<DataFileInfo> lstReturn;
        block23: {
            lstReturn = null;
            ArrayList<DataFileInfo> lstRet = new ArrayList<DataFileInfo>();
            try {
                if (objCard == null) break block23;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                    if (Session != null && CardUtils.ObjectExists(Session, intTemplate, objTemplate) > 0) {
                        Session.findObjectsInit(intTemplate, objTemplate);
                        PKCS11Object obj = null;
                        while ((obj = Session.findObject()) != null) {
                            byte[] value = obj.getByteArrayAttributeValue(17);
                            byte[] id = obj.getByteArrayAttributeValue(258);
                            DataFileInfo objInfo = new DataFileInfo();
                            objInfo.setContent(new String(Base64.encode((byte[])value)));
                            objInfo.setID(new String(id));
                            lstRet.add(objInfo);
                        }
                    }
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                lstReturn = lstRet;
            }
        }
        return lstReturn;
    }

    /*
     * Exception decompiling
     */
    public static String retrieveUserDataFile(Card objCard) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveKeyModulus(Card objCard, String KeyID, String strPIN, boolean blnPrivate) {
        String strRet;
        block21: {
            strRet = "KO-Errore in fase di recupero del modulo della chiave " + KeyID;
            try {
                if (objCard == null) break block21;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                    if (Session == null) break block21;
                    boolean blnGo = true;
                    try {
                        CardUtils.LoginUser(Session, strPIN);
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        blnGo = false;
                        strRet = "KO-Errore in fase di login per recupero oggetto privato: " + ex.getMessage();
                    }
                    if (blnGo) {
                        int[] intTemplate = new int[]{0, 258};
                        Object[] objTemplate = new Object[]{PKCS11Object.PRIVATE_KEY, KeyID};
                        objTemplate[0] = blnPrivate ? PKCS11Object.PRIVATE_KEY : PKCS11Object.PUBLIC_KEY;
                        if (CardUtils.ObjectExists(Session, intTemplate, objTemplate) == 1) {
                            Session.findObjectsInit(intTemplate, objTemplate);
                            PKCS11Object objFound = Session.findObject();
                            Session.findObjectsFinal();
                            strRet = new String(Base64.encode((byte[])objFound.getByteArrayAttributeValue(288)));
                        } else {
                            strRet = "KO-chiave non trovata";
                        }
                    }
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception ex) {
                strRet = "KO-" + ex.getMessage();
            }
        }
        return strRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String destroyCert(Card objCard, String KeyID, String strPIN) {
        String strReturn;
        block35: {
            strReturn = "";
            String strUserHash = "";
            String strRet = "";
            try {
                logger.info("Avvio destroyCert");
                if (objCard == null) break block35;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                if (Session == null || !strRet.equals("")) break block35;
                try {
                    logger.info("Eseguo login");
                    CardUtils.LoginUser(Session, strPIN);
                    logger.info("Verifico presenza certificato");
                    int[] intTemplate = new int[]{0, 258};
                    Object[] objTemplate = new Object[]{PKCS11Object.CERTIFICATE, KeyID};
                    Session.findObjectsInit(intTemplate, objTemplate);
                    PKCS11Object objFound = Session.findObject();
                    Session.findObjectsFinal();
                    if (objFound != null) {
                        logger.info("Avvio eliminazione certificato");
                        try {
                            objFound.destroy();
                            strRet = "OK";
                            logger.info("Certificato eliminato con successo");
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            strRet = "KO-Errore in fase di cancellazione Certificato";
                        }
                    } else {
                        logger.info("Certificato non presente");
                        strRet = "OK";
                    }
                    if (strRet.equals("OK")) {
                        logger.info("Verifico presenza chiave privata");
                        objTemplate[0] = PKCS11Object.PRIVATE_KEY;
                        Session.findObjectsInit(intTemplate, objTemplate);
                        objFound = Session.findObject();
                        Session.findObjectsFinal();
                        if (objFound != null) {
                            logger.info("Avvio eliminazione chiave privata");
                            try {
                                objFound.destroy();
                                strRet = "OK";
                                logger.info("Chiave privata eliminata con successo");
                            }
                            catch (PKCS11Exception ex) {
                                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                                strRet = "KO-Errore in fase di cancellazione chiave privata";
                            }
                        } else {
                            logger.info("Chiave privata non presente");
                            strRet = "OK";
                        }
                        if (strRet.equals("OK")) {
                            logger.info("Verifico presenza chiave pubblica");
                            objTemplate[0] = PKCS11Object.PUBLIC_KEY;
                            Session.findObjectsInit(intTemplate, objTemplate);
                            objFound = Session.findObject();
                            Session.findObjectsFinal();
                            if (objFound != null) {
                                logger.info("Avvio eliminazione chiave pubblica");
                                try {
                                    objFound.destroy();
                                    strRet = "OK";
                                    logger.info("Chiave pubblica eliminata con successo");
                                }
                                catch (PKCS11Exception ex) {
                                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                                    strRet = "KO-Errore in fase di cancellazione chiave pubblica";
                                }
                            } else {
                                logger.info("Chiave pubblica non presente");
                                strRet = "OK";
                            }
                        }
                    }
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-" + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                strRet = "KO-PKCS11Exception:" + ex.getMessage();
                logger.error("PKCS11Exception", (Throwable)ex);
            }
            catch (Exception ex) {
                strRet = "KO-" + ex.getMessage();
            }
            finally {
                logger.info("Fine destroyCert");
                strReturn = strRet.equals("") ? "OK" : strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String existsCert(Card objCard, String KeyID, String strPIN) {
        String strReturn;
        block8: {
            strReturn = "";
            String strRet = "KO-Errore verifica esistenza certificato";
            try {
                if (objCard == null) break block8;
                CardUtils.refreshCard(objCard);
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                    String string = CardUtils.existsCert(Session, KeyID, strPIN);
                    return string;
                }
                catch (PKCS11Exception ex) {
                    try {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        strRet = "KO-" + ex.getMessage();
                    }
                    catch (Exception ex2) {
                        strRet = "KO-" + ex2.getMessage();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                strReturn = strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String existsCert(PKCS11Session Session, String KeyID, String strPIN) {
        String strReturn;
        block17: {
            strReturn = "";
            String strRet = "KO-Errore verifica esistenza certificato";
            try {
                if (Session == null) break block17;
                try {
                    CardUtils.LoginUser(Session, strPIN);
                    int[] intTemplate = new int[]{0, 258};
                    Object[] objTemplate = new Object[]{PKCS11Object.CERTIFICATE, KeyID};
                    Session.findObjectsInit(intTemplate, objTemplate);
                    PKCS11Object objFound = Session.findObject();
                    Session.findObjectsFinal();
                    strRet = objFound != null ? "OK" : "KO";
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-" + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception ex) {
                strRet = "KO-" + ex.getMessage();
            }
            finally {
                strReturn = strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String existsKey(Card objCard, String KeyID, String strPIN, boolean blnPrivate) {
        String strReturn;
        block19: {
            strReturn = "";
            String strRet = "KO-Errore verifica esistenza certificato";
            try {
                if (objCard == null) break block19;
                CardUtils.refreshCard(objCard);
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                    if (Session == null) break block19;
                    try {
                        CardUtils.LoginUser(Session, strPIN);
                        int[] intTemplate = new int[]{0, 258};
                        Object[] objTemplate = new Object[]{PKCS11Object.PRIVATE_KEY, KeyID};
                        objTemplate[0] = blnPrivate ? PKCS11Object.PRIVATE_KEY : PKCS11Object.PUBLIC_KEY;
                        Session.findObjectsInit(intTemplate, objTemplate);
                        PKCS11Object objFound = Session.findObject();
                        Session.findObjectsFinal();
                        strRet = objFound != null ? "OK" : "KO";
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        strRet = "KO-" + ex.getMessage();
                    }
                    finally {
                        if (Session != null) {
                            try {
                                Session.logout();
                            }
                            catch (PKCS11Exception ex) {
                                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            }
                            Session.close();
                        }
                    }
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-" + ex.getMessage();
                }
            }
            catch (Exception ex) {
                strRet = "KO-" + ex.getMessage();
            }
            finally {
                strReturn = strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUserDataFile(Card objCard, String DataEmissione, String DataScadenza, String Cognome, String Nome, String DataNascita, String Sesso, String Statura, String CodiceFiscale, String Cittadinanza, String ComuneNascita, String ComuneResidenza, String IndirizzoResidenza, String AnnotazioniEspatrio, String AmministrazioneEmittente, String Nazione, String Matricola) {
        String strReturn;
        block30: {
            strReturn = "";
            String strUserHash = "";
            String strRet = "";
            try {
                if (objCard == null) break block30;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                if (Session == null || !strRet.equals("")) break block30;
                try {
                    CardUtils.LoginUser(Session, objCard.getCardFamily().getDefaultPIN());
                    if (!strRet.equals("")) break block30;
                    int[] intTemplate = new int[]{0};
                    Object[] objTemplate = new Object[]{PKCS11Object.DATA};
                    if (CardUtils.ObjectExists(Session, intTemplate, objTemplate) != 1) {
                        int len = 6;
                        int lenEmettitore = 4;
                        int lenDataEmissione = DataEmissione.length();
                        int lenDataScadenza = DataScadenza.length();
                        int lenCognome = Cognome.length();
                        int lenNome = Nome.length();
                        int lenDataNascita = DataNascita.length();
                        int lenSesso = Sesso.length();
                        int lenStatura = 0;
                        int lenCodiceFiscale = CodiceFiscale.length();
                        int lenCittadinanza = 0;
                        int lenComuneNascita = ComuneNascita.length();
                        int lenStatoEsteroNascita = 0;
                        int lenEstremiAttoNascita = 0;
                        int lenComuneResidenza = ComuneResidenza.length();
                        int lenIndirizzoResidenza = 0;
                        int lenMatricola = Matricola.length();
                        int lenAnnotazioni = 0;
                        String strBuffer = "";
                        if (lenEmettitore <= 0 || lenEmettitore >= 5 || lenDataEmissione <= 0 || lenDataEmissione >= 9 || lenDataScadenza <= 0 || lenDataScadenza >= 9 || lenCognome <= 0 || lenCognome >= 50 || lenNome >= 50 || lenDataNascita <= 0 || lenDataNascita >= 9 || lenSesso != 1 || lenCodiceFiscale != 16 || lenComuneNascita != 4 || lenComuneResidenza != 4) break block30;
                        strBuffer = CardUtils.getHexFromNumber(lenEmettitore, 2) + objCard.getSerial().substring(0, 4) + CardUtils.getHexFromNumber(lenDataEmissione, 2) + DataEmissione + CardUtils.getHexFromNumber(lenDataScadenza, 2) + DataScadenza + CardUtils.getHexFromNumber(lenCognome, 2) + Cognome + CardUtils.getHexFromNumber(lenNome, 2) + Nome + CardUtils.getHexFromNumber(lenDataNascita, 2) + DataNascita + CardUtils.getHexFromNumber(lenSesso, 2) + Sesso + CardUtils.getHexFromNumber(lenStatura, 2) + CardUtils.getHexFromNumber(lenCodiceFiscale, 2) + CodiceFiscale + CardUtils.getHexFromNumber(lenCittadinanza, 2) + CardUtils.getHexFromNumber(lenComuneNascita, 2) + ComuneNascita + CardUtils.getHexFromNumber(lenStatoEsteroNascita, 2) + CardUtils.getHexFromNumber(lenEstremiAttoNascita, 2) + CardUtils.getHexFromNumber(lenComuneResidenza, 2) + ComuneResidenza + CardUtils.getHexFromNumber(lenIndirizzoResidenza, 2) + CardUtils.getHexFromNumber(lenAnnotazioni, 2);
                        int intLenBuffer = strBuffer.length();
                        strBuffer = CardUtils.getHexFromNumber(len += intLenBuffer, 6) + strBuffer;
                        try {
                            Object[] objTemplateCreate;
                            int[] intTemplateCreate;
                            strUserHash = CardUtils.SHA1(strBuffer);
                            if (strUserHash == "") break block30;
                            char[] bufPDATA = new char[400];
                            char[] bufTempPDATA = strBuffer.toCharArray();
                            for (int i = 0; i < bufTempPDATA.length; ++i) {
                                bufPDATA[i] = bufTempPDATA[i];
                            }
                            if (lenMatricola > 0 && lenMatricola < 200) {
                                char[] bufMatricola = Matricola.toCharArray();
                                for (int i = 0; i < lenMatricola; ++i) {
                                    bufPDATA[201 + i] = bufMatricola[i];
                                }
                            }
                            if (CardUtils.ObjectExists(Session, intTemplateCreate = new int[]{0, 3}, objTemplateCreate = new Object[]{PKCS11Object.DATA, "PDATA"}) == 1) break block30;
                            try {
                                int[] intPrivateDataTemplate = new int[]{0, 1, 3, 17};
                                Object[] objPrivateDataTemplate = new Object[]{PKCS11Object.DATA, PKCS11Object.TRUE, "PDATA", new String(bufPDATA)};
                                try {
                                    Session.createObject(intPrivateDataTemplate, objPrivateDataTemplate);
                                }
                                catch (PKCS11Exception ex) {
                                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                                    strRet = "KO-Errore in fase di creazione file dati personali: " + ex.getMessage();
                                }
                                break block30;
                            }
                            catch (Exception ex) {
                                strRet = "KO-Errore in fase di ricerca file dati personali: " + ex.getMessage();
                            }
                        }
                        catch (NoSuchAlgorithmException ex) {
                            strRet = "KO-Errore in fase di creazione file dati personali: " + ex.getMessage();
                        }
                        catch (UnsupportedEncodingException ex2) {
                            strRet = "KO-Errore in fase di creazione file dati personali: " + ex2.getMessage();
                        }
                        break block30;
                    }
                    strRet = "KO-La card contiene gia' un PDATA";
                }
                catch (Exception ex) {
                    strRet = "KO-Errore in fase di Login: " + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception ex) {
                strRet = "KO-: " + ex.getMessage();
            }
            finally {
                strReturn = strRet.equals("") ? strUserHash : strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUserDataFileString(Card objCard, String DataEmissione, String DataScadenza, String Cognome, String Nome, String DataNascita, String Sesso, String Statura, String CodiceFiscale, String Cittadinanza, String ComuneNascita, String ComuneResidenza, String IndirizzoResidenza, String AnnotazioniEspatrio, String AmministrazioneEmittente, String Nazione, String Matricola) {
        String strReturn;
        block23: {
            strReturn = "";
            String strUserHash = "";
            String strRet = "";
            try {
                if (objCard == null) break block23;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                if (Session == null || !strRet.equals("")) break block23;
                try {
                    if (strRet.equals("")) {
                        int[] intTemplate = new int[]{0};
                        Object[] objTemplate = new Object[]{PKCS11Object.DATA};
                        if (CardUtils.ObjectExists(Session, intTemplate, objTemplate) != 1) {
                            int len = 6;
                            int lenEmettitore = 4;
                            int lenDataEmissione = DataEmissione.length();
                            int lenDataScadenza = DataScadenza.length();
                            int lenCognome = Cognome.length();
                            int lenNome = Nome.length();
                            int lenDataNascita = DataNascita.length();
                            int lenSesso = Sesso.length();
                            int lenStatura = 0;
                            int lenCodiceFiscale = CodiceFiscale.length();
                            int lenCittadinanza = 0;
                            int lenComuneNascita = ComuneNascita.length();
                            int lenStatoEsteroNascita = 0;
                            int lenEstremiAttoNascita = 0;
                            int lenComuneResidenza = ComuneResidenza.length();
                            int lenIndirizzoResidenza = 0;
                            int lenMatricola = Matricola.length();
                            int lenAnnotazioni = 0;
                            String strBuffer = "";
                            if (lenEmettitore > 0 && lenEmettitore < 5 && lenDataEmissione > 0 && lenDataEmissione < 9 && lenDataScadenza > 0 && lenDataScadenza < 9 && lenCognome > 0 && lenCognome < 50 && lenNome < 50 && lenDataNascita > 0 && lenDataNascita < 9 && lenSesso == 1 && lenCodiceFiscale == 16 && lenComuneNascita == 4 && lenComuneResidenza == 4) {
                                strBuffer = CardUtils.getHexFromNumber(lenEmettitore, 2) + objCard.getSerial().substring(0, 4) + CardUtils.getHexFromNumber(lenDataEmissione, 2) + DataEmissione + CardUtils.getHexFromNumber(lenDataScadenza, 2) + DataScadenza + CardUtils.getHexFromNumber(lenCognome, 2) + Cognome + CardUtils.getHexFromNumber(lenNome, 2) + Nome + CardUtils.getHexFromNumber(lenDataNascita, 2) + DataNascita + CardUtils.getHexFromNumber(lenSesso, 2) + Sesso + CardUtils.getHexFromNumber(lenStatura, 2) + CardUtils.getHexFromNumber(lenCodiceFiscale, 2) + CodiceFiscale + CardUtils.getHexFromNumber(lenCittadinanza, 2) + CardUtils.getHexFromNumber(lenComuneNascita, 2) + ComuneNascita + CardUtils.getHexFromNumber(lenStatoEsteroNascita, 2) + CardUtils.getHexFromNumber(lenEstremiAttoNascita, 2) + CardUtils.getHexFromNumber(lenComuneResidenza, 2) + ComuneResidenza + CardUtils.getHexFromNumber(lenIndirizzoResidenza, 2) + CardUtils.getHexFromNumber(lenAnnotazioni, 2);
                                int intLenBuffer = strBuffer.length();
                                strRet = strBuffer = CardUtils.getHexFromNumber(len += intLenBuffer, 6) + strBuffer;
                            } else {
                                strRet = "KO-I dati forniti son malformati";
                            }
                        } else {
                            strRet = "KO-La card contiene gi\u00e0\u00a0un PDATA";
                        }
                    }
                }
                catch (Exception ex) {
                    strRet = "KO-Errore in fase di creazione stringa PDATA: " + ex.getMessage();
                }
                finally {
                    try {
                        Session.logout();
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    }
                    Session.close();
                }
            }
            catch (Exception ex) {
                strRet = "KO-: " + ex.getMessage();
            }
            finally {
                strReturn = strRet.equals("") ? strUserHash : strRet;
            }
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUserDataFileV2(Card objCard, String strBuffer, String Pin) {
        String strReturn;
        block29: {
            strReturn = "";
            String strUserHash = "";
            String strRet = "";
            try {
                logger.info("Inizio createUserDataFileV2");
                logger.info("Buffer: " + strBuffer);
                if (objCard == null) break block29;
                PKCS11Session Session = null;
                try {
                    Session = objCard.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                if (Session == null || !strRet.equals("")) break block29;
                try {
                    logger.info("Effettuo login");
                    String strPin = Pin;
                    if (strPin.equals("")) {
                        strPin = objCard.getCardFamily().getDefaultPIN();
                    }
                    CardUtils.LoginUser(Session, strPin);
                    if (!strRet.equals("")) break block29;
                    int[] intTemplate = new int[]{0};
                    Object[] objTemplate = new Object[]{PKCS11Object.DATA};
                    logger.info("Verifico presenza oggetto dati");
                    if (CardUtils.ObjectExists(Session, intTemplate, objTemplate) != 1) {
                        logger.info("Oggetto dati assente provvedo a creazione");
                        try {
                            logger.info("Calcolo hash del buffer");
                            strUserHash = CardUtils.SHA1(strBuffer);
                            if (strUserHash == "") break block29;
                            byte[] bufPDATA = new byte[400];
                            byte[] bufTempPDATA = strBuffer.getBytes("ISO-8859-1");
                            for (int i = 0; i < bufTempPDATA.length; ++i) {
                                bufPDATA[i] = bufTempPDATA[i];
                            }
                            int[] intTemplateCreate = new int[]{0, 3};
                            Object[] objTemplateCreate = new Object[]{PKCS11Object.DATA, "PDATA"};
                            logger.info("Verifico presenza PDATA");
                            if (CardUtils.ObjectExists(Session, intTemplateCreate, objTemplateCreate) == 1) break block29;
                            logger.info("PDATA assente avvio creazione");
                            try {
                                logger.info("Definizione template");
                                int[] intPrivateDataTemplate = new int[]{0, 1, 3, 17};
                                Object[] objPrivateDataTemplate = new Object[]{PKCS11Object.DATA, PKCS11Object.TRUE, "PDATA", bufPDATA};
                                try {
                                    logger.info("Avvio creazione");
                                    Session.createObject(intPrivateDataTemplate, objPrivateDataTemplate);
                                    strRet = strUserHash;
                                }
                                catch (PKCS11Exception ex) {
                                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                                    strRet = "KO-Errore in fase di installazione PDATA: " + ex.getMessage();
                                }
                                break block29;
                            }
                            catch (Exception ex) {
                                logger.error("Errore in fase di creazione Template PDATA: " + ex.getMessage());
                                strRet = "KO-Errore in fase di creazione Template PDATA: " + ex.getMessage();
                            }
                        }
                        catch (NoSuchAlgorithmException ex) {
                            logger.error("Errore in fase di installazione PDATA: " + ex.getMessage());
                            strRet = "KO-Errore in fase di installazione PDATA: " + ex.getMessage();
                        }
                        catch (UnsupportedEncodingException ex2) {
                            strRet = "KO-Errore in fase di installazione PDATA: " + ex2.getMessage();
                        }
                        break block29;
                    }
                    logger.error("La card contiene gi\u00e0\u00a0 un PDATA");
                    strRet = "KO-La card contiene gi\u00e0\u00a0 un PDATA";
                }
                catch (Exception ex) {
                    logger.error("Errore in fase di Login: " + ex.getMessage());
                    strRet = "KO-Errore in fase di Login: " + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            Session.logout();
                        }
                        catch (PKCS11Exception ex) {
                            logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        }
                        Session.close();
                    }
                }
            }
            catch (Exception ex) {
                strRet = "KO-: " + ex.getMessage();
                logger.error("Errore in fase di generazione PDATA: " + ex.getMessage());
            }
            finally {
                strReturn = strRet.equals("") ? strUserHash : strRet;
                logger.info("Valore di ritorno: " + strReturn);
                logger.info("Fine createUserDataFileV2");
            }
        }
        return strReturn;
    }

    public static String createCSR(Card objCard, String PIN, String strTipoCSR, String KeyID, String Nome, String Cognome, String Organizzazione, String UnitaOrganizzativa1, String UnitaOrganizzativa2, String UnitaOrganizzativa3, String UnitaOrganizzativa4, String UnitaOrganizzativa5, String Localita, String SerialeUtente, String Titolo, String Email, String upn, String Description, String DateOfBirth, String HashPDATA, String OrgId) {
        return CardUtils._createCSR(objCard, PIN, strTipoCSR, KeyID, Nome, Cognome, Organizzazione, UnitaOrganizzativa1, UnitaOrganizzativa2, UnitaOrganizzativa3, UnitaOrganizzativa4, UnitaOrganizzativa5, Localita, SerialeUtente, Titolo, Email, upn, Description, DateOfBirth, HashPDATA, OrgId);
    }

    public static String createCSR(Card objCard, String PIN, String strTipoCSR, String KeyID, String Nome, String Cognome, String Organizzazione, String UnitaOrganizzativa1, String UnitaOrganizzativa2, String UnitaOrganizzativa3, String UnitaOrganizzativa4, String UnitaOrganizzativa5, String Localita, String SerialeUtente, String Titolo, String Email, String upn, String Description, String DateOfBirth, String HashPDATA) {
        return CardUtils.createCSR(objCard, PIN, strTipoCSR, KeyID, Nome, Cognome, Organizzazione, UnitaOrganizzativa1, UnitaOrganizzativa2, UnitaOrganizzativa3, UnitaOrganizzativa4, UnitaOrganizzativa5, Localita, SerialeUtente, Titolo, Email, upn, Description, DateOfBirth, HashPDATA, null);
    }

    public static String createCSR(Card objCard, String strTipoCSR, String KeyID, String Nome, String Cognome, String Organizzazione, String UnitaOrganizzativa1, String UnitaOrganizzativa2, String UnitaOrganizzativa3, String UnitaOrganizzativa4, String UnitaOrganizzativa5, String Localita, String SerialeUtente, String Titolo, String Email, String upn, String Description, String DateOfBirth, String HashPDATA) {
        return CardUtils.createCSR(objCard, "", strTipoCSR, KeyID, Nome, Cognome, Organizzazione, UnitaOrganizzativa1, UnitaOrganizzativa2, UnitaOrganizzativa3, UnitaOrganizzativa4, UnitaOrganizzativa5, Localita, SerialeUtente, Titolo, Email, upn, Description, DateOfBirth, HashPDATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _createCSR(Card objCard, String PIN, String strTipoCSR, String KeyID, String Nome, String Cognome, String Organizzazione, String UnitaOrganizzativa1, String UnitaOrganizzativa2, String UnitaOrganizzativa3, String UnitaOrganizzativa4, String UnitaOrganizzativa5, String Localita, String SerialeUtente, String Titolo, String Email, String upn, String Description, String DateOfBirth, String HashPDATA, String OrgId) {
        String strReturn;
        block100: {
            strReturn = "";
            String strRet = "";
            logger.debug("createCSR dump:");
            logger.debug("    TipoCSR=" + strTipoCSR);
            logger.debug("    KeyID=" + KeyID);
            logger.debug("    Nome=" + Nome);
            logger.debug("    Cognome=" + Cognome);
            logger.debug("    Organizzazione=" + Organizzazione);
            logger.debug("    UnitaOrganizzativa1=" + UnitaOrganizzativa1);
            logger.debug("    UnitaOrganizzativa2=" + UnitaOrganizzativa2);
            logger.debug("    UnitaOrganizzativa3=" + UnitaOrganizzativa3);
            logger.debug("    UnitaOrganizzativa4=" + UnitaOrganizzativa4);
            logger.debug("    UnitaOrganizzativa5=" + UnitaOrganizzativa5);
            logger.debug("    Localita=" + Localita);
            logger.debug("    SerialeUtente=" + SerialeUtente);
            logger.debug("    Titolo=" + Titolo);
            logger.debug("    Email=" + Email);
            logger.debug("    upn=" + upn);
            logger.debug("    Description=" + Description);
            logger.debug("    DateOfBirth=" + DateOfBirth);
            logger.debug("    HashPDATA=" + HashPDATA);
            logger.debug("    OrgId=" + OrgId);
            boolean bNoData = true;
            if (SerialeUtente != null && !SerialeUtente.isEmpty()) {
                SerialeUtente = SerialeUtente.replace("SERIALNUMBER=", "");
                if (!(SerialeUtente = CardUtils.removeIllegalChars(SerialeUtente)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (Cognome != null && !Cognome.isEmpty()) {
                Cognome = Cognome.replace("SURNAME=", "");
                if (!(Cognome = CardUtils.removeIllegalChars(Cognome)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (Nome != null && !Nome.isEmpty()) {
                Nome = Nome.replace("GIVENNAME=", "");
                if (!(Nome = CardUtils.removeIllegalChars(Nome)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (Titolo != null && !Titolo.isEmpty()) {
                Titolo = Titolo.replace("T=", "");
                if (!(Titolo = CardUtils.removeIllegalChars(Titolo)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (Localita != null && !Localita.isEmpty()) {
                Localita = Localita.replace("C=", "");
                if (!(Localita = CardUtils.removeIllegalChars(Localita)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (Organizzazione != null && !Organizzazione.isEmpty()) {
                Organizzazione = Organizzazione.replace("O=", "");
                if (!(Organizzazione = CardUtils.removeIllegalChars(Organizzazione)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (OrgId != null && !OrgId.isEmpty()) {
                OrgId = OrgId.replace("O=", "");
                if (!(OrgId = CardUtils.removeIllegalChars(OrgId)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (UnitaOrganizzativa5 != null && !UnitaOrganizzativa5.isEmpty()) {
                UnitaOrganizzativa5 = UnitaOrganizzativa5.replace("OU=", "");
                if (!(UnitaOrganizzativa5 = CardUtils.removeIllegalChars(UnitaOrganizzativa5)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (UnitaOrganizzativa4 != null && !UnitaOrganizzativa4.isEmpty()) {
                UnitaOrganizzativa4 = UnitaOrganizzativa4.replace("OU=", "");
                if (!(UnitaOrganizzativa4 = CardUtils.removeIllegalChars(UnitaOrganizzativa4)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (UnitaOrganizzativa3 != null && !UnitaOrganizzativa3.isEmpty()) {
                UnitaOrganizzativa3 = UnitaOrganizzativa3.replace("OU=", "");
                if (!(UnitaOrganizzativa3 = CardUtils.removeIllegalChars(UnitaOrganizzativa3)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (UnitaOrganizzativa2 != null && !UnitaOrganizzativa2.isEmpty()) {
                UnitaOrganizzativa2 = UnitaOrganizzativa2.replace("OU=", "");
                if (!(UnitaOrganizzativa2 = CardUtils.removeIllegalChars(UnitaOrganizzativa2)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (UnitaOrganizzativa1 != null && !UnitaOrganizzativa1.isEmpty()) {
                UnitaOrganizzativa1 = UnitaOrganizzativa1.replace("OU=", "");
                if (!(UnitaOrganizzativa1 = CardUtils.removeIllegalChars(UnitaOrganizzativa1)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (Description != null && !Description.isEmpty()) {
                Description = Description.replace("2.5.4.13=", "");
                if (!(Description = CardUtils.removeIllegalChars(Description)).isEmpty()) {
                    bNoData = false;
                }
            }
            if (bNoData) {
                strReturn = "KO-Errore generale: parametri non validi per la creazione del CSR.";
                return strReturn;
            }
            if (Email == null) {
                Email = "";
            }
            try {
                if (objCard == null) break block100;
                PKCS11Session Session = null;
                try {
                    CardUtils.refreshCard(objCard);
                    Session = objCard.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                }
                if (Session == null || !strRet.equals("")) break block100;
                try {
                    int[] intTemplate = new int[]{0, 258};
                    Object[] objTemplate = new Object[]{PKCS11Object.PUBLIC_KEY, KeyID};
                    PKCS11Object objFound = null;
                    try {
                        Session.findObjectsInit(intTemplate, objTemplate);
                        objFound = Session.findObject();
                        Session.findObjectsFinal();
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di ricerca chiave pubblica: " + ex.getMessage();
                    }
                    if (!strRet.equals("")) break block100;
                    if (objFound != null) {
                        PublicKey objPubKey = null;
                        PrivateKey objPriKey = null;
                        TokenSpi tk = null;
                        try {
                            try {
                                BigInteger modulus = new ASN1Integer(objFound.getByteArrayAttributeValue(288)).getPositiveValue();
                                BigInteger exponent = new ASN1Integer(objFound.getBigIntegerAttributeValue(290)).getPositiveValue();
                                RSAPublicKeySpec rsaKeySpec = new RSAPublicKeySpec(modulus, exponent);
                                KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunJSSE");
                                objPubKey = keyFactory.generatePublic(rsaKeySpec);
                            }
                            catch (NoSuchAlgorithmException e1) {
                                logger.error("Errore in fase di recupero chiave pubblica", (Throwable)e1);
                                strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di recupero chiave pubblica: " + e1.getMessage();
                            }
                            catch (InvalidKeySpecException e2) {
                                logger.error("Errore in fase di recupero chiave pubblica", (Throwable)e2);
                                strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di recupero chiave pubblica: " + e2.getMessage();
                            }
                            catch (Exception e) {
                                logger.error("Errore in fase di recupero chiave pubblica", (Throwable)e);
                                strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di recupero chiave pubblica: " + e.getMessage();
                            }
                            try {
                                String[] cert_alias;
                                tk = objCard.getToken();
                                tk.openSession(false, PIN);
                                for (String alias : cert_alias = TokenHelper.listObjects((TokenSpi)tk, null, (byte)12)) {
                                    if (!KeyID.equals(new String(Hex.decode((String)TokenHelper.getObjectID((TokenSpi)tk, (String)alias))))) continue;
                                    objPriKey = TokenHelper.getPrivateKeyByAlias((TokenSpi)tk, (String)alias);
                                }
                            }
                            catch (Exception ex) {
                                logger.error("Errore in fase di recupero chiave privata", (Throwable)ex);
                                strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di recupero chiave privata: " + ex.getMessage();
                            }
                        }
                        catch (Exception ex) {
                            logger.error("Errore in fase di recupero chiave", (Throwable)ex);
                            strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di recupero chiave: " + ex.getMessage();
                        }
                        try {
                            GeneralNames subjectAltName = new GeneralNames(new GeneralName(1, Email.toLowerCase().replace("\"", "")));
                            Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
                            Vector<X509Extension> values = new Vector<X509Extension>();
                            oids.add(X509Extension.subjectAlternativeName);
                            values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)subjectAltName)));
                            if (DateOfBirth != null && !DateOfBirth.equals("") && DateOfBirth.matches("^(0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\\d\\d$")) {
                                oids.add(X509Extension.subjectDirectoryAttributes);
                                ASN1EncodableVector objVec = new ASN1EncodableVector();
                                DateOfBirth = new SimpleDateFormat("yyyyMMdd").format(new SimpleDateFormat("dd/MM/yyyy").parse(DateOfBirth)) + "000000Z";
                                objVec.add((ASN1Encodable)new DERGeneralizedTime(DateOfBirth));
                                Attribute objDOBAttr = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1"), (ASN1Set)new DERSet(objVec));
                                Vector<Attribute> objVecL = new Vector<Attribute>();
                                objVecL.add(objDOBAttr);
                                SubjectDirectoryAttributes objSDA = new SubjectDirectoryAttributes(objVecL);
                                values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)objSDA)));
                            }
                            X509Extensions objExtensions = new X509Extensions(oids, values);
                            Attribute objAttribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet((ASN1Encodable)objExtensions));
                            X500Principal objPrincipal = null;
                            String strDN = "";
                            if (strTipoCSR.startsWith("FIRMA")) {
                                if (SerialeUtente != null && !SerialeUtente.equals("")) {
                                    strDN = strDN + "SERIALNUMBER=" + SerialeUtente;
                                }
                                if (Localita != null && !Localita.equals("")) {
                                    strDN = strDN + ", C=" + Localita;
                                }
                                if (Nome != null && !Nome.equals("") && Cognome != null && !Cognome.equals("")) {
                                    strDN = strDN + ", CN=" + Cognome + " " + Nome;
                                }
                                if (Nome != null && !Nome.equals("")) {
                                    strDN = strDN + ", GIVENNAME=" + Nome;
                                }
                                if (Cognome != null && !Cognome.equals("")) {
                                    strDN = strDN + ", SURNAME=" + Cognome;
                                }
                                if (Titolo != null && !Titolo.equals("")) {
                                    strDN = strDN + ", T=" + Titolo;
                                }
                                if (Organizzazione != null && !Organizzazione.equals("")) {
                                    strDN = strDN + ", O=" + Organizzazione;
                                }
                                if (OrgId != null && !OrgId.equals("")) {
                                    strDN = strDN + ", 2.5.4.97=" + OrgId;
                                }
                                if (UnitaOrganizzativa5 != null && !UnitaOrganizzativa5.equals("")) {
                                    strDN = strDN + ", OU=" + UnitaOrganizzativa5;
                                }
                                if (UnitaOrganizzativa4 != null && !UnitaOrganizzativa4.equals("")) {
                                    strDN = strDN + ", OU=" + UnitaOrganizzativa4;
                                }
                                if (UnitaOrganizzativa3 != null && !UnitaOrganizzativa3.equals("")) {
                                    strDN = strDN + ", OU=" + UnitaOrganizzativa3;
                                }
                                if (UnitaOrganizzativa2 != null && !UnitaOrganizzativa2.equals("")) {
                                    strDN = strDN + ", OU=" + UnitaOrganizzativa2;
                                }
                                if (UnitaOrganizzativa1 != null && !UnitaOrganizzativa1.equals("")) {
                                    strDN = strDN + ", OU=" + UnitaOrganizzativa1;
                                }
                                if (Description != null && !Description.equals("")) {
                                    strDN = strDN + ", 2.5.4.13=" + Description;
                                }
                            } else {
                                if (SerialeUtente != null && !SerialeUtente.equals("")) {
                                    strDN = strDN + "SERIALNUMBER=" + SerialeUtente;
                                }
                                if (Localita != null && !Localita.equals("")) {
                                    strDN = strDN + ", C=" + Localita;
                                }
                                if (SerialeUtente != null && !SerialeUtente.equals("") && HashPDATA != null && !HashPDATA.equals("")) {
                                    strDN = strDN + ", CN=" + SerialeUtente + "/" + objCard.getSerial() + "." + HashPDATA;
                                }
                                if (Nome != null && !Nome.equals("")) {
                                    strDN = strDN + ", GIVENNAME=" + Nome;
                                }
                                if (Cognome != null && !Cognome.equals("")) {
                                    strDN = strDN + ", SURNAME=" + Cognome;
                                }
                                if (Titolo != null && !Titolo.equals("")) {
                                    strDN = strDN + ", T=" + Titolo;
                                }
                                if (Organizzazione != null && !Organizzazione.equals("")) {
                                    strDN = strDN + ", O=" + Organizzazione;
                                }
                                if (UnitaOrganizzativa1 != null && !UnitaOrganizzativa1.equals("")) {
                                    strDN = strDN + ", OU=" + UnitaOrganizzativa1;
                                }
                            }
                            if (strDN.startsWith(", ")) {
                                strDN = strDN.substring(2);
                            }
                            strDN = strDN.replace("\"", "");
                            objPrincipal = new X500Principal(CardUtils.formatPlus(strDN));
                            try {
                                JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(objPrincipal, objPubKey);
                                requestBuilder.addAttribute(objAttribute.getAttrType(), objAttribute.getAttributeValues());
                                PKCS10CertificationRequest P10Req = requestBuilder.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider((Provider)ActalisSingleton.getActalisProvider()).build(objPriKey));
                                byte[] objCSR = P10Req.getEncoded();
                                if (objCSR != null) {
                                    new Base64();
                                    strRet = new String(Base64.encode((byte[])objCSR));
                                }
                                break block100;
                            }
                            catch (Exception ex) {
                                logger.error("Errore in fase di costruzione del CSR", (Throwable)ex);
                                strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di costruzione del CSR: " + ex.getMessage();
                                break block100;
                            }
                            finally {
                                if (tk != null) {
                                    tk.closeSession();
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.error("Errore in fase di costruzione del CSR", (Throwable)ex);
                            strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di costruzione del CSR: " + ex.getMessage();
                        }
                        break block100;
                    }
                    strRet = "KO-" + CardUtils.class.getName() + "-" + "Nessuna chiave pubblica corrispondente al keyID passato trovata";
                }
                catch (Exception ex) {
                    logger.error("Errore in fase di Login", (Throwable)ex);
                    strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di Login: " + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            try {
                                Session.logout();
                            }
                            catch (PKCS11Exception ex) {
                                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            }
                            Session.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (PKCS11Exception ex) {
                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                strRet = "KO-" + CardUtils.class.getName() + "-" + ex.getMessage();
            }
            finally {
                strReturn = strRet;
            }
        }
        return strReturn;
    }

    public static String createCSR_CNS(Card objCard, String PIN, String SerialNumber, String KeyID, String Country, String CommonName, String GivenName, String Surname, String Organization, String OrganizationUnit, String DateOfBirth, String Email, String HashPDATA, String Title, String SmartLogOn) {
        return CardUtils._createCSR_CNS(objCard, PIN, SerialNumber, KeyID, Country, CommonName, GivenName, Surname, Organization, OrganizationUnit, DateOfBirth, Email, HashPDATA, Title, SmartLogOn);
    }

    public static String createCSR_CNS(Card objCard, String SerialNumber, String KeyID, String Country, String CommonName, String GivenName, String Surname, String Organization, String OrganizationUnit, String DateOfBirth, String Email, String HashPDATA, String Title, String SmartLogOn) {
        return CardUtils._createCSR_CNS(objCard, "", SerialNumber, KeyID, Country, CommonName, GivenName, Surname, Organization, OrganizationUnit, DateOfBirth, Email, HashPDATA, Title, SmartLogOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _createCSR_CNS(Card objCard, String PIN, String SerialNumber, String KeyID, String Country, String CommonName, String GivenName, String Surname, String Organization, String OrganizationUnit, String DateOfBirth, String Email, String HashPDATA, String Title, String SmartLogOn) {
        String strRet;
        block80: {
            PKCS11Session Session;
            block79: {
                logger.debug("createCSR_CNS dump:");
                logger.debug("    SerialNumber=" + SerialNumber);
                logger.debug("    KeyID=" + KeyID);
                logger.debug("    Country=" + Country);
                logger.debug("    CommonName=" + CommonName);
                logger.debug("    GivenName=" + GivenName);
                logger.debug("    Surname=" + Surname);
                logger.debug("    Organization=" + Organization);
                logger.debug("    OrganizationUnit=" + OrganizationUnit);
                logger.debug("    DateOfBirth=" + DateOfBirth);
                logger.debug("    Email=" + Email);
                logger.debug("    HashPDATA=" + HashPDATA);
                logger.debug("    Title=" + Title);
                logger.debug("    SmartLogOn=" + SmartLogOn);
                if (objCard == null) {
                    return "KO-oggetto card non valido";
                }
                boolean bNoData = true;
                if (SerialNumber != null && !SerialNumber.isEmpty()) {
                    SerialNumber = SerialNumber.replace("SERIALNUMBER=", "");
                    if (!(SerialNumber = CardUtils.removeIllegalChars(SerialNumber)).isEmpty()) {
                        bNoData = false;
                    }
                }
                if (GivenName != null && !GivenName.isEmpty()) {
                    GivenName = GivenName.replace("GIVENNAME=", "");
                    if (!(GivenName = CardUtils.removeIllegalChars(GivenName)).isEmpty()) {
                        bNoData = false;
                    }
                }
                if (Surname != null && !Surname.isEmpty()) {
                    Surname = Surname.replace("SURNAME=", "");
                    if (!(Surname = CardUtils.removeIllegalChars(Surname)).isEmpty()) {
                        bNoData = false;
                    }
                }
                if (Organization != null && !Organization.isEmpty()) {
                    Organization = Organization.replace("O=", "");
                    if (!(Organization = CardUtils.removeIllegalChars(Organization)).isEmpty()) {
                        bNoData = false;
                    }
                }
                if (OrganizationUnit != null && !OrganizationUnit.isEmpty()) {
                    OrganizationUnit = OrganizationUnit.replace("OU=", "");
                    if (!(OrganizationUnit = CardUtils.removeIllegalChars(OrganizationUnit)).isEmpty()) {
                        bNoData = false;
                    }
                }
                if (Country != null && !Country.isEmpty()) {
                    Country = Country.replace("C=", "");
                    if (!(Country = CardUtils.removeIllegalChars(Country)).isEmpty()) {
                        bNoData = false;
                    }
                }
                if (Title != null && !Title.isEmpty()) {
                    Title = Title.replace("T=", "");
                    if (!(Title = CardUtils.removeIllegalChars(Title)).isEmpty()) {
                        bNoData = false;
                    }
                }
                if (bNoData) {
                    return "KO-parametri non validi per la creazione del CSR: SerialNumber, GivenName, Surname, Organization, OrganizationUnit, Country, Title non possono essere tutti nulli";
                }
                if (Email == null) {
                    Email = "";
                }
                strRet = "";
                Session = null;
                try {
                    CardUtils.refreshCard(objCard);
                    Session = objCard.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception ex) {
                    logger.debug(ex.getMessage() + " code: " + ex.getCode());
                    String string = strRet = "KO-Errore in fase di apertura sessione: " + ex.getMessage();
                    return string;
                }
                if (Session != null) break block79;
                String ex = "KO-Errore in fase di apertura sessione";
                return ex;
            }
            try {
                try {
                    int[] intTemplate = new int[]{0, 258};
                    Object[] objTemplate = new Object[]{PKCS11Object.PUBLIC_KEY, KeyID};
                    PKCS11Object[] objFound = null;
                    try {
                        ArrayList<PKCS11Object> lstObj = new ArrayList<PKCS11Object>();
                        Session.findObjectsInit(intTemplate, objTemplate);
                        PKCS11Object obj = null;
                        while ((obj = Session.findObject()) != null) {
                            lstObj.add(obj);
                        }
                        objFound = lstObj.toArray(new PKCS11Object[lstObj.size()]);
                        Session.findObjectsFinal();
                    }
                    catch (PKCS11Exception ex) {
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        strRet = "KO-" + ex.getMessage();
                    }
                    if (!strRet.equals("")) break block80;
                    if (objFound != null) {
                        int x = -1;
                        for (int j = 0; j < objFound.length; ++j) {
                            String id = new String(objFound[j].getByteArrayAttributeValue(258), "UTF-8");
                            if (!id.equals(KeyID)) continue;
                            x = j;
                        }
                        if (x >= 0) {
                            PublicKey objPubKey = null;
                            PrivateKey objPriKey = null;
                            TokenSpi tk = null;
                            try {
                                try {
                                    BigInteger modulus = new ASN1Integer(objFound[0].getByteArrayAttributeValue(288)).getPositiveValue();
                                    BigInteger exponent = new ASN1Integer(objFound[0].getBigIntegerAttributeValue(290)).getPositiveValue();
                                    RSAPublicKeySpec rsaKeySpec = new RSAPublicKeySpec(modulus, exponent);
                                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                                    objPubKey = keyFactory.generatePublic(rsaKeySpec);
                                }
                                catch (NoSuchAlgorithmException e1) {
                                    strRet = "KO-" + e1.getMessage();
                                }
                                catch (InvalidKeySpecException e2) {
                                    strRet = "KO-" + e2.getMessage();
                                }
                                catch (Exception e) {
                                    strRet = "KO-" + e.getMessage();
                                }
                                try {
                                    String[] cert_alias;
                                    tk = objCard.getToken();
                                    tk.openSession(false, PIN);
                                    for (String alias : cert_alias = TokenHelper.listObjects((TokenSpi)tk, null, (byte)12)) {
                                        if (!KeyID.equals(new String(Hex.decode((String)TokenHelper.getObjectID((TokenSpi)tk, (String)alias))))) continue;
                                        objPriKey = TokenHelper.getPrivateKeyByAlias((TokenSpi)tk, (String)alias);
                                        break;
                                    }
                                }
                                catch (Exception ex) {
                                    logger.error("Errore in fase di recupero chiave privata: ", (Throwable)ex);
                                    strRet = "KO-" + CardUtils.class.getName() + "-" + "Errore in fase di recupero chiave privata: " + ex.getMessage();
                                }
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                                strRet = "KO-" + ex.getMessage();
                            }
                            try {
                                GeneralNames subjectAltName = null;
                                if (SmartLogOn != null && !SmartLogOn.trim().equals("")) {
                                    DERSequence SmartLogOnNameSequence = new DERSequence(new ASN1Encodable[]{new ASN1ObjectIdentifier("1.3.6.1.4.1.311.20.2.3"), new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(SmartLogOn))});
                                    GeneralName SmartLogOnName = new GeneralName(0, (ASN1Encodable)SmartLogOnNameSequence);
                                    GeneralName EmailName = new GeneralName(1, Email.toLowerCase().replace("\"", ""));
                                    subjectAltName = new GeneralNames(new GeneralName[]{EmailName, SmartLogOnName});
                                } else {
                                    subjectAltName = new GeneralNames(new GeneralName(1, Email.toLowerCase().replace("\"", "")));
                                }
                                Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
                                Vector<X509Extension> values = new Vector<X509Extension>();
                                oids.add(X509Extension.subjectAlternativeName);
                                values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)subjectAltName)));
                                if (DateOfBirth != null && !DateOfBirth.equals("") && DateOfBirth.matches("^(0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\\d\\d$")) {
                                    oids.add(X509Extension.subjectDirectoryAttributes);
                                    ASN1EncodableVector objVec = new ASN1EncodableVector();
                                    DateOfBirth = new SimpleDateFormat("yyyyMMdd").format(new SimpleDateFormat("dd/MM/yyyy").parse(DateOfBirth)) + "000000Z";
                                    objVec.add((ASN1Encodable)new DERGeneralizedTime(DateOfBirth));
                                    Attribute objDOBAttr = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1"), (ASN1Set)new DERSet(objVec));
                                    Vector<Attribute> objVecL = new Vector<Attribute>();
                                    objVecL.add(objDOBAttr);
                                    SubjectDirectoryAttributes objSDA = new SubjectDirectoryAttributes(objVecL);
                                    values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)objSDA)));
                                }
                                X509Extensions objExtensions = new X509Extensions(oids, values);
                                Attribute objAttribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet((ASN1Encodable)objExtensions));
                                X500Principal objPrincipal = null;
                                String strDN = "";
                                if (SerialNumber != null && !SerialNumber.equals("")) {
                                    strDN = strDN + "SERIALNUMBER=" + SerialNumber;
                                }
                                if (Country != null && !Country.equals("")) {
                                    strDN = strDN + ", C=" + Country;
                                }
                                if (SerialNumber != null && !SerialNumber.equals("") && HashPDATA != null && !HashPDATA.equals("")) {
                                    strDN = strDN + ", CN=" + SerialNumber + "/" + objCard.getSerial() + "." + HashPDATA;
                                }
                                if (GivenName != null && !GivenName.equals("")) {
                                    strDN = strDN + ", GIVENNAME=" + GivenName;
                                }
                                if (Surname != null && !Surname.equals("")) {
                                    strDN = strDN + ", SURNAME=" + Surname;
                                }
                                if (Title != null && !Title.equals("")) {
                                    strDN = strDN + ", T=" + Title;
                                }
                                if (Organization != null && !Organization.equals("")) {
                                    strDN = strDN + ", O=" + Organization;
                                }
                                if (OrganizationUnit != null && !OrganizationUnit.equals("")) {
                                    strDN = strDN + ", OU=" + OrganizationUnit;
                                }
                                if (strDN.startsWith(", ")) {
                                    strDN = strDN.substring(2);
                                }
                                strDN = strDN.replace("\"", "");
                                objPrincipal = new X500Principal(CardUtils.formatPlus(strDN));
                                try {
                                    JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(objPrincipal, objPubKey);
                                    requestBuilder.addAttribute(objAttribute.getAttrType(), objAttribute.getAttributeValues());
                                    PKCS10CertificationRequest P10Req = requestBuilder.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider((Provider)ActalisSingleton.getActalisProvider()).build(objPriKey));
                                    byte[] objCSR = P10Req.getEncoded();
                                    if (objCSR != null) {
                                        new Base64();
                                        strRet = new String(Base64.encode((byte[])objCSR));
                                    }
                                    break block80;
                                }
                                catch (Exception ex) {
                                    logger.error(ex.getMessage(), (Throwable)ex);
                                    strRet = "KO-" + ex.getMessage();
                                    break block80;
                                }
                                finally {
                                    if (tk != null) {
                                        tk.closeSession();
                                    }
                                }
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                                strRet = "KO-" + ex.getMessage();
                            }
                            break block80;
                        }
                        strRet = "KO-Nessuna chiave pubblica corrispondente al keyID passato trovata";
                        break block80;
                    }
                    strRet = "KO-Nessuna chiave pubblica corrispondente al keyID passato trovata";
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    strRet = "KO-" + ex.getMessage();
                }
                finally {
                    if (Session != null) {
                        try {
                            try {
                                Session.logout();
                            }
                            catch (PKCS11Exception ex) {
                                logger.debug(ex.getMessage() + " code: " + ex.getCode());
                            }
                            Session.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (PKCS11Exception ex) {
                logger.error(ex.getMessage() + " code: " + ex.getCode());
                strRet = "KO-" + ex.getMessage();
            }
        }
        return strRet;
    }

    protected static String removeIllegalChars(String inputString) {
        if (inputString == null) {
            return "";
        }
        if (inputString.isEmpty()) {
            return "";
        }
        String outputString = "";
        if (inputString.startsWith("\\ ") || inputString.startsWith("\\#")) {
            outputString = inputString.substring(0, 2);
            inputString = inputString.substring(2);
        } else if (inputString.startsWith(" ") || inputString.startsWith("#")) {
            outputString = "\\" + inputString.substring(0, 1);
            inputString = inputString.substring(1);
        }
        while (inputString.length() > 0 && inputString.startsWith(" ")) {
            outputString = outputString + " ";
            inputString = inputString.substring(1);
        }
        boolean endWithSpace = false;
        if (inputString.endsWith(" ")) {
            endWithSpace = true;
        }
        boolean makeTrim = true;
        int countEscape = 0;
        for (int i = 0; i < inputString.length(); ++i) {
            char thisChar = inputString.charAt(i);
            if (thisChar == '\\') {
                ++countEscape;
            } else {
                if (thisChar == ',' || thisChar == '+' || thisChar == '<' || thisChar == '>' || thisChar == ';' || thisChar == '\"') {
                    if (i == 0 || countEscape % 2 == 0) {
                        outputString = outputString + "\\";
                    }
                } else if (endWithSpace && thisChar == ' ' && i >= inputString.trim().length()) {
                    if (countEscape % 2 != 0) {
                        makeTrim = false;
                    } else {
                        outputString = outputString.trim();
                    }
                } else if (countEscape % 2 != 0) {
                    outputString = outputString + "\\";
                }
                countEscape = 0;
            }
            outputString = outputString + thisChar;
        }
        if (countEscape % 2 != 0) {
            outputString = outputString + "\\";
        }
        if (makeTrim) {
            outputString = outputString.trim();
        }
        return outputString;
    }

    private static String SHA1(String Text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String strReturn = "";
        MessageDigest md = MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider);
        byte[] sha1hash = new byte[40];
        md.update(Text.getBytes("iso-8859-1"), 0, Text.length());
        sha1hash = md.digest();
        strReturn = new String(Base64.encode((byte[])sha1hash));
        return strReturn;
    }

    private static byte[] SHA256(String Text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] sha256hash;
        byte[] bobjReturn = null;
        MessageDigest md = MessageDigest.getInstance("SHA-256", ProvUtils.bcProvider);
        md.update(Text.getBytes("iso-8859-1"), 0, Text.length());
        bobjReturn = sha256hash = md.digest();
        return bobjReturn;
    }

    private static void LoginUser(PKCS11Session Session, String pin) throws PKCS11Exception {
        try {
            Session.logout();
        }
        catch (PKCS11Exception ex) {
            logger.debug(ex.getMessage() + " code: " + ex.getCode());
        }
        Session.login(false, pin);
    }

    private static List<CardFamilyMatch> identifyModules(CardUtilsConfig setup, List<ATR> lstATR, boolean verboseDetails) {
        logger.debug("identifyModules() start");
        if (logger.isDebugEnabled() && verboseDetails) {
            logger.debug("List of modules into DB");
            for (CardFamily currMod : cardService.getCardStore().getCardFamilies()) {
                logger.debug("  Module: " + currMod.getName());
            }
        }
        ArrayList<CardFamilyMatch> lstFamiliesMatchs = null;
        if (setup.getP11Override() != null && !setup.getP11Override().isEmpty()) {
            if (verboseDetails) {
                logger.debug("Loading custom override module " + setup.getP11Override());
            }
            boolean alreadyOpen = false;
            if (lastCustomOverride != null) {
                if (!lastCustomOverride.getLib().get(0).equals(setup.getP11Override())) {
                    try {
                        lastCustomOverride.getPKCS11(false).libFinalizePublic();
                    }
                    catch (Throwable ex) {
                        logger.error("Error closing custom module currently open (" + lastCustomOverride.getName() + "): " + ex.getMessage());
                    }
                    cardService.getCardStore().getCardFamilies().remove(lastCustomOverride);
                } else {
                    alreadyOpen = true;
                }
            }
            if (!alreadyOpen) {
                lastCustomOverride = new CardFamily(FamilyName.CUSTOM.get(), "12345", "12345678", CNSStrategy.NONE, DSStrategy.NONE);
                lastCustomOverride.getLib().add(new CardLibrary.CustomCardLibrary(setup.getP11Override()));
                cardService.getCardStore().getCardFamilies().add(lastCustomOverride);
            }
            lstFamiliesMatchs = new ArrayList<CardFamilyMatch>();
            lstFamiliesMatchs.add(new CardFamilyMatch(lastCustomOverride, "CUSTOMOVERRIDE"));
        } else {
            if (verboseDetails) {
                logger.debug("Select modules by ATR");
            }
            try {
                for (ATR objAtr : lstATR) {
                    CardFamilyMatch match;
                    if (lstFamiliesMatchs == null) {
                        lstFamiliesMatchs = new ArrayList();
                    }
                    if ((match = cardService.getFromAtr(objAtr)) == null) continue;
                    lstFamiliesMatchs.add(match);
                }
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
            }
            if (lstFamiliesMatchs != null && verboseDetails) {
                logger.info(String.format("%d CardFamilies selected:", lstFamiliesMatchs.size()));
                for (int iMod = 0; iMod < lstFamiliesMatchs.size(); ++iMod) {
                    logger.info(String.format("Lector %s CardFamily %s", ((CardFamilyMatch)lstFamiliesMatchs.get(iMod)).getTerminalName(), ((CardFamilyMatch)lstFamiliesMatchs.get(iMod)).getFamily().getName()));
                }
            } else if (verboseDetails) {
                logger.info("No module is selected!");
            }
        }
        if (setup.getRuntimeType() == 0) {
            String strLibraryName = "bit4xpki";
            if (Platform.isLinux()) {
                strLibraryName = "libbit4xpki.so";
            } else if (Platform.isMac()) {
                strLibraryName = "libbit4xpki.dylib";
            }
            CardFamily arubakeyCardFamily = new CardFamily("ArubaKeyModule", "12345", "12345678", CNSStrategy.LABEL, DSStrategy.LABEL);
            CardFamilyMatch akFamilyMatch = new CardFamilyMatch(arubakeyCardFamily, "AK");
            arubakeyCardFamily.getLib().add(new CardLibrary.CustomCardLibrary(strLibraryName));
            if (verboseDetails) {
                logger.info("Verifico presenza modulo ArubaKey precaricato");
            }
            int i = 0;
            for (CardFamily currMod : cardService.getCardStore().getCardFamilies()) {
                if (currMod.getName().equals("ArubaKeyModule")) {
                    if (verboseDetails) {
                        logger.info("Trovato - rimuovo");
                    }
                    cardService.getCardStore().getCardFamilies().remove(i);
                    break;
                }
                ++i;
            }
            if (arubakeyCardFamily == null) {
                if (verboseDetails) {
                    logger.info("Forzo caricamento modulo AK su lista moduli vuota");
                }
                cardService.getCardStore().getCardFamilies().add(arubakeyCardFamily);
                ArrayList<CardFamilyMatch> lst = new ArrayList<CardFamilyMatch>();
                lst.add(akFamilyMatch);
                lstFamiliesMatchs = lst;
            } else {
                if (verboseDetails) {
                    logger.info("Forzo caricamento modulo AK su lista moduli preesistente");
                }
                cardService.getCardStore().getCardFamilies().add(arubakeyCardFamily);
                lstFamiliesMatchs.add(akFamilyMatch);
            }
        }
        logger.debug("identifyModules() end");
        return lstFamiliesMatchs;
    }

    private static boolean needDoubleInit(CardFamily objCardFamily) throws Exception {
        if (objCardFamily == null) {
            throw new Exception("no module defined");
        }
        if (objCardFamily.getName().equals("ATH")) {
            return false;
        }
        return !objCardFamily.getName().equals("INCNEW");
    }

    private static ATR getATRByTerminalName(List<ATR> atrList, String terminalName) {
        terminalName = terminalName.trim();
        for (int iAtr = 0; iAtr < atrList.size(); ++iAtr) {
            String atrTerminalName = atrList.get(iAtr).getTerminalName();
            logger.info("terminalName: " + terminalName);
            atrTerminalName = atrTerminalName.trim();
            logger.info("atrTerminalName: " + atrTerminalName);
            if (!atrTerminalName.equalsIgnoreCase(terminalName)) continue;
            return atrList.get(iAtr);
        }
        return null;
    }

    @Deprecated
    public static Map<CardFamily, List<Card>> retrieveCardMap(ConfigParameter conf) throws IOException {
        CardUtilsConfig setup = new CardUtilsConfig();
        setup.setP11Override(conf.getP11Override());
        setup.setIgnoreATR(conf.getIgnoreAtr());
        setup.setRuntimeType(conf.getRuntimeType());
        return CardUtils.retrieveCardMap(setup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Map<CardFamily, List<Card>> retrieveCardMap(CardUtilsConfig setup) throws IOException {
        logger.debug("retrieveCardMap() start");
        HashMap<CardFamily, List<Card>> mapModule_CardList = new HashMap<CardFamily, List<Card>>();
        try {
            List<ATR> lstATR = SCardUtils.retrieveATR();
            int cardsPresent = lstATR.size();
            List<CardFamilyMatch> lstCardFamilies = CardUtils.identifyModules(setup, lstATR, true);
            if (lstCardFamilies == null) {
                throw new IOException(NO_MODULE_LOADED);
            }
            for (CardFamilyMatch currentCardFamily : lstCardFamilies) {
                List<Card> lstCards;
                if (currentCardFamily == null) continue;
                NativePKCS11 nativePKCS11 = null;
                try {
                    logger.debug("-- try to initialize the module " + currentCardFamily.getFamily().getName() + " --");
                    nativePKCS11 = CardService.initModule(currentCardFamily.getFamily());
                }
                catch (Exception ex) {
                    logger.debug("module is skipped because an exception was thrown");
                    continue;
                }
                if (nativePKCS11 == null) {
                    logger.debug("module is skipped because no native PKCS11 lib was selected");
                    continue;
                }
                PKCS11Slot[] slots = null;
                try {
                    slots = nativePKCS11.getSlotList(true);
                }
                catch (PKCS11Exception ex) {
                    logger.error(ex.getMessage() + " code: " + ex.getCode());
                }
                if (slots == null) {
                    logger.debug("module is skipped because no terminal slots are assigned to it");
                    continue;
                }
                boolean atLeastOneCardCurrModule = false;
                for (PKCS11Slot c : slots) {
                    if (!c.getInfo().tokenPresent()) continue;
                    atLeastOneCardCurrModule = true;
                    ++cardsPresent;
                }
                if (!atLeastOneCardCurrModule) {
                    logger.debug("module is skipped because no card is inserted into slots assigned to it");
                    continue;
                }
                if (mapModule_CardList.get(currentCardFamily.getFamily()) == null) {
                    mapModule_CardList.put(currentCardFamily.getFamily(), new ArrayList());
                }
                if ((lstCards = CardService.fromCardFamilyMatch(currentCardFamily, (List)mapModule_CardList.get(currentCardFamily.getFamily()))) == null || lstCards.size() <= 0) continue;
                for (Card card : lstCards) {
                    if (card.getSerial().equalsIgnoreCase(mstrBlackListSerial)) continue;
                    ((List)mapModule_CardList.get(currentCardFamily.getFamily())).add(card);
                }
            }
            if (cardsPresent == 0) {
                throw new IOException(NO_CARD_DETECTED);
            }
            if (mapModule_CardList.isEmpty()) {
                throw new IOException(NO_MODULE_LOADED);
            }
            boolean numberOfModulesWithDriver = false;
            int numberOfLoadedCard = NativePKCS11.nativeInstancesCount();
            if (!numberOfModulesWithDriver) {
                throw new IOException(NO_DRIVER_INIT);
            }
            if (numberOfLoadedCard == 0) {
                throw new IOException(NO_CARD_LOADED);
            }
        }
        finally {
            logger.debug("retrieveCardMap() end");
        }
        return mapModule_CardList;
    }

    private static boolean isMapContainSerial(String strSerial, Map<CardFamily, List<Card>> mapModule_CardList) {
        for (List<Card> lstCard : mapModule_CardList.values()) {
            for (Card card : lstCard) {
                if (!card.getSerial().equals(strSerial)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addCardForModuleToMap(Card card, CardFamily objCardFamily, Map<CardFamily, List<Card>> mapModule_CardList) {
        List<Card> lstCard = mapModule_CardList.get(objCardFamily);
        if (lstCard == null) {
            lstCard = new ArrayList<Card>();
            mapModule_CardList.put(objCardFamily, lstCard);
        }
        lstCard.add(card);
    }

    static {
        lastCustomOverride = null;
        logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        cardService = CardService.getInstance();
    }
}

