/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.vol.utils.Constants;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Vector;
import org.slf4j.Logger;

class Actalis_Object {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Object objSek = null;
    private Object objData = null;
    private Object objCert = null;
    private Object objPublic = null;
    private Object objPrivate = null;
    private Vector objs = null;
    private String id = null;
    private String label = null;
    private int type = -1;
    private int PRVKindex = -1;
    private int PUBKindex = -1;
    private Vector DUPLICATED_PUBKindex = null;
    private PublicKey publicKeyInfo = null;
    private String b64cert = null;
    private static final int DATA = 0;
    private static final int CERT = 1;
    private static final int PRVK = 3;
    private static final int PUBK = 2;
    private static final int SECK = 4;
    private static final int WRONG = 9;

    Actalis_Object(int type, Object obj, String id, String label) {
        this.id = id;
        this.addObj(type, obj, label);
    }

    void addObj(int type, Object obj, String label) {
        logger.debug("***ADD type=" + type + " label=" + label + " id=" + this.id);
        switch (type) {
            case 3: {
                if (this.label == null) {
                    this.label = label;
                }
                if (this.objs == null) {
                    this.objs = new Vector();
                }
                if (this.PRVKindex >= 0) {
                    this.type = 9;
                } else {
                    this.PRVKindex = this.objs.size();
                    this.objPrivate = obj;
                    logger.debug("savePrvKey index=" + this.PRVKindex);
                }
                this.objs.addElement(obj);
                break;
            }
            case 2: {
                if (this.label == null) {
                    this.label = label;
                }
                if (this.objs == null) {
                    this.objs = new Vector();
                }
                if (this.PUBKindex >= 0) {
                    if (this.DUPLICATED_PUBKindex == null) {
                        this.DUPLICATED_PUBKindex = new Vector();
                    }
                    this.DUPLICATED_PUBKindex.addElement(new Integer(this.objs.size()));
                    logger.debug("found multiple PubKey having same label/ID...");
                } else {
                    this.PUBKindex = this.objs.size();
                    this.objPublic = obj;
                    logger.debug("savePubKey index=" + this.PUBKindex);
                }
                this.objs.addElement(obj);
                break;
            }
            case 4: {
                this.label = label;
                this.objSek = obj;
                this.type = type;
                break;
            }
            case 0: {
                this.label = label;
                this.objData = obj;
                this.type = type;
                break;
            }
            case 1: {
                if (this.PRVKindex >= 0 && this.PUBKindex >= 0 && this.DUPLICATED_PUBKindex != null) {
                    logger.debug("setting the good Public Key ...");
                    PKCS11Object privk = (PKCS11Object)this.objs.elementAt(this.PRVKindex);
                    BigInteger modprivk = privk.getBigIntegerAttributeValue(288);
                    PKCS11Object p1 = (PKCS11Object)this.objs.elementAt(this.PUBKindex);
                    BigInteger modp1 = p1.getBigIntegerAttributeValue(288);
                    if (modprivk.compareTo(modp1) == 0) {
                        logger.debug("Public Key is already good.");
                    } else {
                        for (int i = 0; i < this.DUPLICATED_PUBKindex.size(); ++i) {
                            PKCS11Object p;
                            BigInteger modp;
                            Integer indice = (Integer)this.DUPLICATED_PUBKindex.elementAt(i);
                            if (indice >= this.objs.size() || modprivk.compareTo(modp = (p = (PKCS11Object)this.objs.elementAt(indice)).getBigIntegerAttributeValue(288)) != 0) continue;
                            this.PUBKindex = indice;
                            logger.debug("Public Key correctly found and configured. Index " + indice);
                            break;
                        }
                    }
                }
                this.label = label;
                this.objCert = obj;
                this.type = type;
                break;
            }
            default: {
                this.type = 9;
                if (this.objs == null) {
                    this.objs = new Vector();
                }
                this.objs.addElement(obj);
            }
        }
    }

    byte getType() {
        switch (this.type) {
            case 1: {
                if (this.PRVKindex >= 0) {
                    return 4;
                }
                if (this.PUBKindex >= 0) {
                    return 16;
                }
                return 2;
            }
            case -1: {
                if (this.PRVKindex >= 0) {
                    return 8;
                }
                return 16;
            }
            case 0: {
                return 1;
            }
        }
        return 16;
    }

    String getLabel() {
        return this.label;
    }

    String getID() {
        return this.id;
    }

    Object getData() {
        return this.objData;
    }

    Object getCert() {
        return this.objCert;
    }

    Object getSek() {
        return this.objSek;
    }

    Object getPublicKey() {
        try {
            logger.debug("getPubKey index=" + this.PUBKindex);
            return this.objPublic;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    Object getPrivateKey() {
        try {
            logger.debug("getPrivKey index=" + this.PRVKindex);
            return this.objPrivate;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    Object[] getAllObjects() {
        ArrayList<Object> lstReturn = new ArrayList<Object>();
        if (this.objCert != null) {
            lstReturn.add(this.objCert);
        }
        if (this.objSek != null) {
            lstReturn.add(this.objSek);
        }
        if (this.objData != null) {
            lstReturn.add(this.objData);
        }
        if (this.objs != null) {
            lstReturn.addAll(this.objs);
        }
        return lstReturn.toArray(new Object[lstReturn.size()]);
    }

    Object removeCert() {
        this.type = -1;
        Object temp = this.objCert;
        this.objCert = null;
        this.b64cert = null;
        return temp;
    }

    void rename(String label) {
        this.label = label;
    }

    PublicKey getPublicKeyInfo() {
        logger.debug("***getting module");
        return this.publicKeyInfo;
    }

    void setPublicKeyInfo(PublicKey pubKey) {
        logger.debug("***setting module ? PrvKey index=" + this.PRVKindex + " PubKey index=" + this.PUBKindex);
        switch (this.type) {
            case -1: 
            case 1: 
            case 2: 
            case 3: {
                logger.debug("***set module ");
                this.publicKeyInfo = pubKey;
                break;
            }
            default: {
                logger.debug("***skip set module for type " + this.type);
            }
        }
    }

    String getB64Cert() {
        logger.debug("***getting b64cert");
        return this.b64cert;
    }

    void setB64Cert(String cert) {
        logger.debug("***setting b64cert ? PrvKey index=" + this.PRVKindex + " PubKey index=" + this.PUBKindex);
        switch (this.type) {
            case -1: 
            case 1: 
            case 2: 
            case 3: {
                logger.debug("***set b64cert ");
                this.b64cert = cert;
                break;
            }
            default: {
                logger.debug("***skip set b64cert for type " + this.type);
            }
        }
    }
}

