/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.pkcs11.ASToken;
import it.actalis.ellips.capi.provider.pkcs11.AS_PrivateKey;
import it.actalis.vol.utils.Constants;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi;
import org.slf4j.Logger;

public class AS_RSACipher
extends CipherSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final int ENCRYPT_MODE = 1;
    private static final int DECRYPT_MODE = 2;
    private SecureRandom secureRandom;
    private int mode;
    private short useDevice = 0;
    private ASToken astk = null;
    static boolean debug = false;

    public AS_RSACipher() {
        super((AsymmetricBlockCipher)new RSAEngine());
        logger.debug("constructor OK");
        this.useDevice = 0;
    }

    public void engineSetMode(String mode) throws NoSuchAlgorithmException {
        switch (this.useDevice) {
            case 1: {
                logger.debug("engineSetMode device: " + mode);
                break;
            }
            case 0: {
                logger.debug("engineSetMode: " + mode);
            }
            case 2: {
                logger.debug("engineSetMode BouncyCastle  :" + mode);
                super.engineSetMode(mode);
            }
        }
    }

    public void engineSetPadding(String padding) throws NoSuchPaddingException {
        switch (this.useDevice) {
            case 1: {
                logger.debug("engineSetPadding device: " + padding);
                break;
            }
            case 0: {
                logger.debug("engineSetPadding: " + padding);
            }
            case 2: {
                logger.debug("engineSetPadding BouncyCastle: " + padding);
                super.engineSetPadding(padding);
            }
        }
    }

    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        logger.debug("engineInit AlgParSpec");
        this.engineInit(opmode, key, random);
    }

    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException {
        logger.debug("engineInit AlgParamet");
        this.engineInit(opmode, key, random);
    }

    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        logger.debug("engineInit check?");
        this.mode = opmode;
        this.secureRandom = random;
        try {
            if (key instanceof AS_PrivateKey) {
                logger.debug("engineInit is as_privatekey");
                this.useDevice = 1;
                AS_PrivateKey actKey = (AS_PrivateKey)key;
                this.astk = actKey.getCryptoDev();
            } else {
                logger.debug("engineInit is NOT as_privatekey");
                this.useDevice = (short)2;
                this.astk = null;
            }
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            throw new InvalidKeyException("Unable to init RSA key: " + exception.toString());
        }
        switch (this.useDevice) {
            case 0: {
                throw new InvalidKeyException("Invalid use device.");
            }
            case 1: {
                break;
            }
            case 2: {
                logger.debug("call BouncyCastle engineInit");
                try {
                    super.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new InvalidKeyException("InvalidAlgorithmParameterException: " + e.toString());
                }
                logger.debug("BouncyCastle engineInit checked");
            }
        }
    }

    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.useDevice != 1) {
            logger.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(input, inputOffset, inputLen);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        if (this.useDevice != 1) {
            logger.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetBlockSize() {
        if (this.useDevice != 1) {
            logger.debug("engineGetBlockSize call BouncyCastle");
            return super.engineGetBlockSize();
        }
        throw new RuntimeException("Method not supported.");
    }

    public byte[] engineGetIV() {
        if (this.useDevice != 1) {
            logger.debug("engineGetIV call BouncyCastle");
            return super.engineGetIV();
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetOutputSize(int inputLen) {
        if (this.useDevice != 1) {
            logger.debug("engineGetOutputSize: BouncyCastle ");
            return super.engineGetOutputSize(inputLen);
        }
        return 0;
    }

    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws BadPaddingException, IllegalBlockSizeException {
        if (this.useDevice == 2) {
            logger.debug("engineDoFinal: BouncyCastle inpLen=" + inputLen);
            try {
                return super.engineDoFinal(input, inputOffset, inputLen);
            }
            catch (IllegalBlockSizeException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new IllegalBlockSizeException("Buffer to short to hold result.");
            }
        }
        if (this.useDevice != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        byte[] copy = new byte[inputLen];
        System.arraycopy(input, inputOffset, copy, 0, inputLen);
        logger.debug("engineDoFinal: device: MODE: " + this.mode);
        if (this.mode == 1) {
            return this.encrypt(copy);
        }
        return this.decrypt(copy);
    }

    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (this.useDevice == 2) {
            logger.debug("engineDoFinal-2: BouncyCastle");
            return super.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
        }
        if (this.useDevice != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        logger.debug("engineDoFinal-2");
        byte[] out1 = this.engineDoFinal(input, inputOffset, inputLen);
        try {
            System.arraycopy(out1, 0, output, outputOffset, out1.length);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new IllegalBlockSizeException("Buffer to short to hold result.");
        }
        return out1.length;
    }

    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public AlgorithmParameters getParameters() {
        throw new RuntimeException("Method not supported.");
    }

    private byte[] encrypt(byte[] input) {
        logger.debug("[encrypt] hash.length " + input.length);
        byte[] sig = null;
        try {
            sig = this.astk.doSign(input);
            logger.debug("[encrypt] doSign ok");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiError(e);
        }
        if (sig == null) {
            throw new CapiError("Invalid signature", 3003);
        }
        return sig;
    }

    private byte[] decrypt(byte[] sig) {
        logger.debug("[decrypt] signature.length " + sig.length);
        byte[] hash = null;
        try {
            hash = this.astk.doDecrypt(sig);
            logger.debug("[decrypt] doDecrypt ok");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiError(e);
        }
        if (hash == null) {
            throw new CapiError("Invalid decryption", 3103);
        }
        logger.debug("[decrypt] hash.length " + hash.length);
        return hash;
    }
}

