/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.Composite;
import esecurity.desktop.swt.Cursor;
import esecurity.desktop.swt.Device;
import esecurity.desktop.swt.Display;
import esecurity.desktop.swt.Event;
import esecurity.desktop.swt.Image;
import esecurity.desktop.swt.Listener;
import esecurity.desktop.swt.Shell;
import java.awt.MouseInfo;

public class SWTViewResizer {
    private final Shell shell;
    private final Display display;
    private int minWidth;
    private int minHeight;
    private int offsetX = 0;
    private int offsetY = 0;
    private Composite resizeE;
    private Composite resizeW;
    private Composite resizeN;
    private Composite resizeS;
    private Composite resizeNE;
    private Composite resizeNW;
    private Composite resizeSE;
    private Composite resizeSW;
    private boolean resizeEventW = false;
    private boolean resizeEventN = false;
    private boolean resizeEventE = false;
    private boolean resizeEventS = false;
    private boolean disable = false;

    SWTViewResizer(Shell shell, Display display, int minWidth, int minHeight) {
        this.shell = shell;
        this.display = display;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.setResizeComposite();
        this.resizeNE.moveAbove(this.resizeN);
        this.resizeNE.moveAbove(this.resizeE);
        this.resizeNW.moveAbove(this.resizeN);
        this.resizeNW.moveAbove(this.resizeW);
        this.resizeSE.moveAbove(this.resizeS);
        this.resizeSE.moveAbove(this.resizeE);
        this.resizeSW.moveAbove(this.resizeS);
        this.resizeSW.moveAbove(this.resizeW);
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.resizeN.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            this.resizeE.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            this.resizeS.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            this.resizeW.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            this.resizeNE.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            this.resizeNW.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            this.resizeSE.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            this.resizeSW.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
        }
    }

    private void setResizeComposite() {
        this.resizeW = new Composite(this.shell, 0x40000000);
        this.resizeW.setLocation(0, 0);
        this.resizeW.setSize(5, this.minHeight);
        this.resizeW.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 13));
            }
        });
        this.resizeW.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventW = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeW.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                    SWTViewResizer.this.resizeEventW = true;
                }
            }
        });
        this.resizeW.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeW.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventW = false;
            }
        });
        this.resizeE = new Composite(this.shell, 0x40000000);
        this.resizeE.setLocation(this.minWidth - 5, 0);
        this.resizeE.setSize(5, this.minHeight);
        this.resizeE.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 12));
            }
        });
        this.resizeE.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventE = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeE.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                    SWTViewResizer.this.resizeEventE = true;
                }
            }
        });
        this.resizeE.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeE.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventE = false;
            }
        });
        this.resizeN = new Composite(this.shell, 0x40000000);
        this.resizeN.setLocation(0, 0);
        this.resizeN.setSize(this.minWidth, 5);
        this.resizeN.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 10));
            }
        });
        this.resizeN.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventN = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeN.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                    SWTViewResizer.this.resizeEventN = true;
                }
            }
        });
        this.resizeN.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeN.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventN = false;
            }
        });
        this.resizeS = new Composite(this.shell, 0x40000000);
        this.resizeS.setLocation(0, this.minHeight - 5);
        this.resizeS.setSize(this.minWidth, 5);
        this.resizeS.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 11));
            }
        });
        this.resizeS.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventS = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeS.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                    SWTViewResizer.this.resizeEventS = true;
                }
            }
        });
        this.resizeS.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeS.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventS = false;
            }
        });
        this.resizeNW = new Composite(this.shell, 0x40000000);
        this.resizeNW.setLocation(0, 0);
        this.resizeNW.setSize(5, 5);
        this.resizeNW.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 17));
            }
        });
        this.resizeNW.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventN = false;
                SWTViewResizer.this.resizeEventW = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeNW.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                    SWTViewResizer.this.offsetX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                    SWTViewResizer.this.resizeEventN = true;
                    SWTViewResizer.this.resizeEventW = true;
                }
            }
        });
        this.resizeNW.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeNW.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventN = false;
                SWTViewResizer.this.resizeEventW = false;
            }
        });
        this.resizeNE = new Composite(this.shell, 0x40000000);
        this.resizeNE.setLocation(this.minWidth - 5, 0);
        this.resizeNE.setSize(5, 5);
        this.resizeNE.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 14));
            }
        });
        this.resizeNE.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventN = false;
                SWTViewResizer.this.resizeEventE = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeNE.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                    SWTViewResizer.this.offsetX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                    SWTViewResizer.this.resizeEventN = true;
                    SWTViewResizer.this.resizeEventE = true;
                }
            }
        });
        this.resizeNE.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeNE.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventN = false;
                SWTViewResizer.this.resizeEventE = false;
            }
        });
        this.resizeSW = new Composite(this.shell, 0x40000000);
        this.resizeSW.setLocation(0, this.minHeight - 5);
        this.resizeSW.setSize(5, 5);
        this.resizeSW.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 16));
            }
        });
        this.resizeSW.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventS = false;
                SWTViewResizer.this.resizeEventW = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeSW.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                    SWTViewResizer.this.offsetX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                    SWTViewResizer.this.resizeEventS = true;
                    SWTViewResizer.this.resizeEventW = true;
                }
            }
        });
        this.resizeSW.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeSW.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventS = false;
                SWTViewResizer.this.resizeEventW = false;
            }
        });
        this.resizeSE = new Composite(this.shell, 0x40000000);
        this.resizeSE.setLocation(this.minWidth - 5, this.minHeight - 5);
        this.resizeSE.setSize(5, 5);
        this.resizeSE.addListener(6, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 15));
            }
        });
        this.resizeSE.addListener(7, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventS = false;
                SWTViewResizer.this.resizeEventE = false;
                SWTViewResizer.this.shell.setCursor(new Cursor(SWTViewResizer.this.display, 0));
            }
        });
        this.resizeSE.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (!SWTViewResizer.this.disable) {
                    SWTViewResizer.this.offsetY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                    SWTViewResizer.this.offsetX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                    SWTViewResizer.this.resizeEventS = true;
                    SWTViewResizer.this.resizeEventE = true;
                }
            }
        });
        this.resizeSE.addListener(5, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resize();
            }
        });
        this.resizeSE.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTViewResizer.this.resizeEventS = false;
                SWTViewResizer.this.resizeEventE = false;
            }
        });
    }

    private void resize() {
        int x = (int)MouseInfo.getPointerInfo().getLocation().getX();
        int y = (int)MouseInfo.getPointerInfo().getLocation().getY();
        int shellX = this.shell.getBounds().x;
        int shellY = this.shell.getBounds().y;
        int shellWidth = this.shell.getBounds().width;
        int shellHeight = this.shell.getBounds().height;
        int newX = shellX;
        int newY = shellY;
        int newWidth = shellWidth;
        int newHeight = shellHeight;
        int dy = y - this.offsetY;
        int dx = x - this.offsetX;
        if (this.resizeEventS && (dy < 0 || y > shellY + shellHeight)) {
            newHeight = shellHeight + dy > this.minHeight ? shellHeight + dy : this.minHeight;
        }
        if (this.resizeEventN && (dy >= 0 || y <= shellY)) {
            if (shellHeight - dy > this.minHeight) {
                newY = y;
                newHeight = shellHeight - dy;
            } else {
                newY = shellY + (shellHeight - this.minHeight);
                newHeight = this.minHeight;
            }
        }
        if (this.resizeEventE && (dx < 0 || x > shellX + shellWidth)) {
            newWidth = shellWidth + dx > this.minWidth ? shellWidth + dx : this.minWidth;
        }
        if (this.resizeEventW && (dx >= 0 || x <= shellX)) {
            if (shellWidth - dx > this.minWidth) {
                newX = x;
                newWidth = shellWidth - dx;
            } else {
                newX = shellX + (shellWidth - this.minWidth);
                newWidth = this.minWidth;
            }
        }
        this.offsetX = x;
        this.offsetY = y;
        this.shell.setBounds(newX, newY, newWidth, newHeight);
    }

    void updatePosition(int currentWidth, int currentHeight) {
        if (this.resizeN != null) {
            this.resizeN.setSize(currentWidth, 5);
        }
        if (this.resizeS != null) {
            this.resizeS.setSize(currentWidth, 5);
            this.resizeS.setLocation(0, currentHeight - 5);
        }
        if (this.resizeW != null) {
            this.resizeW.setSize(5, currentHeight);
        }
        if (this.resizeE != null) {
            this.resizeE.setSize(5, currentHeight);
            this.resizeE.setLocation(currentWidth - 5, 0);
        }
        if (this.resizeNE != null) {
            this.resizeNE.setLocation(currentWidth - 5, 0);
        }
        if (this.resizeNW != null) {
            this.resizeNW.setLocation(0, 0);
        }
        if (this.resizeSE != null) {
            this.resizeSE.setLocation(currentWidth - 5, currentHeight - 5);
        }
        if (this.resizeSW != null) {
            this.resizeSW.setLocation(0, currentHeight - 5);
        }
    }

    void moveAbove(Composite comp) {
        this.resizeNE.moveAbove(comp);
        this.resizeNW.moveAbove(comp);
        this.resizeSE.moveAbove(comp);
        this.resizeSW.moveAbove(comp);
        this.resizeN.moveAbove(comp);
        this.resizeS.moveAbove(comp);
        this.resizeW.moveAbove(comp);
        this.resizeE.moveAbove(comp);
    }

    void setMinDimension(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    void disable() {
        this.disable = true;
    }

    void enable() {
        this.disable = false;
    }
}

