/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.provider.remotesign;

import esecurity.internal.asb.gw.GwClient;
import esecurity.internal.asb.gw.GwClientI;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.provider.remotesign.ACPException;
import it.arubapec.ca.provider.remotesign.CNSSession;
import it.arubapec.ca.provider.remotesign.CertListResponseInfo;
import it.arubapec.ca.utils.ConfigParameter;
import it.arubapec.ca.utils.UserData;
import it.arubapec.signservice.ApplicationAuth;
import it.arubapec.signservice.Auth;
import it.arubapec.signservice.CertListResponse;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.CertsListRequestAuth;
import it.arubapec.signservice.ChangePassword;
import it.arubapec.signservice.CloseSessionRequest;
import it.arubapec.signservice.CreateSessionReturn;
import it.arubapec.signservice.CredentialListQuery;
import it.arubapec.signservice.CredentialListReturn;
import it.arubapec.signservice.GWReturn;
import it.arubapec.signservice.RetriveCredential;
import it.arubapec.signservice.RetriveCredentialReturn;
import it.arubapec.signservice.SendCredential;
import it.arubapec.signservice.StrongCredential;
import it.arubapec.signservice.TempPwdRequest;
import it.arubapec.signservice.TempPwdRequestEx;
import it.arubapec.signservice.TempPwdResponse;
import it.arubapec.signservice.TempPwdResponseEx;
import it.arubapec.signservice.TestCredential;
import it.arubapec.signservice.UserAuthenticationInfoRequest;
import it.arubapec.signservice.UserAuthenticationInfoResponse;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;

public class ASUtils {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static int checkPassword(ConfigParameter conf, String password) {
        int intReturn = -4;
        if (conf != null && conf.getUserNameAS() != null && !conf.getUserNameAS().equals("") && !password.equals("")) {
            String strUrl1 = "";
            String strUrl2 = "";
            if (System.currentTimeMillis() % 2L == 0L) {
                strUrl1 = conf.getServerAS();
                strUrl2 = conf.getServerAS2();
            } else {
                strUrl1 = conf.getServerAS2();
                strUrl2 = conf.getServerAS();
            }
            UrlClient objClient = new UrlClient(conf.getNetConf(), logger);
            boolean enforce_mode = conf.getEnforceMode() == null || conf.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (conf.getRemoteSignatureBasicAuthUser() != null && !conf.getRemoteSignatureBasicAuthUser().isEmpty() && conf.getRemoteSignatureBasicAuthPassword() != null && !conf.getRemoteSignatureBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(conf.getRemoteSignatureBasicAuthUser(), conf.getRemoteSignatureBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getUserDomainAS()), false, enforce_mode, conf.getUserNameAS());
            CertsListRequest request = new CertsListRequest();
            Auth id = new Auth();
            id.setDomain(conf.getUserDomainAS());
            id.setUser(conf.getUserNameAS());
            id.setUserPWD(password);
            CertListResponse response = null;
            if (conf.getApplicationUsername() != null && !"".equals(conf.getApplicationUsername()) && conf.getApplicationPassword() != null && !"".equals(conf.getApplicationPassword())) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(conf.getApplicationUsername());
                appauth.setApplicationpassword(conf.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            request.setIdentity(id);
            for (int nTrial = 0; nTrial < 2; ++nTrial) {
                String toUrl = strUrl1;
                if (nTrial == 1) {
                    toUrl = strUrl2;
                }
                try {
                    response = client.certlistop(toUrl, request);
                }
                catch (Exception ex) {
                    logger.error(toUrl + ": " + ex.getMessage());
                }
                if (response != null) {
                    intReturn = -1;
                    if (response.getStatus().equals("OK")) {
                        intReturn = 0;
                        break;
                    }
                }
                logger.warn(toUrl + ": fail!");
            }
        }
        return intReturn;
    }

    public static void userStatus(UserData conf, NetworkConfig netConf) throws ACPException {
        String strReturn = null;
        if (conf != null && conf.getUsername() != null && !conf.getUsername().isEmpty() && (conf.getPassword() != null && !conf.getPassword().equals("") || conf.getDelegatedPassword() != null && !conf.getDelegatedPassword().isEmpty())) {
            String strUrl1 = "";
            String strUrl2 = "";
            if (System.currentTimeMillis() % 2L == 0L) {
                strUrl1 = conf.getServerUrl1();
                strUrl2 = conf.getServerUrl2();
            } else {
                strUrl1 = conf.getServerUrl2();
                strUrl2 = conf.getServerUrl1();
            }
            UrlClient objClient = new UrlClient(netConf, logger);
            boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (conf.getBasicAuthUsername() != null && !conf.getBasicAuthUsername().isEmpty() && conf.getBasicAuthPassword() != null && !conf.getBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(conf.getBasicAuthUsername(), conf.getBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getDomain()), false, enforce_mode, conf.getUsername());
            CertsListRequest request = new CertsListRequest();
            Auth id = new Auth();
            id.setDomain(conf.getDomain());
            id.setUser(conf.getUsername());
            id.setUserPWD(conf.getPassword());
            if (conf.getDelegatedUsername() != null && !conf.getDelegatedUsername().isEmpty()) {
                id.setDelegated_user(conf.getDelegatedUsername());
                id.setDelegated_password(conf.getDelegatedPassword());
                id.setDelegated_domain(conf.getDelegatedDomain());
            }
            if (conf.getDelegatedUsername() != null && !conf.getDelegatedUsername().isEmpty()) {
                id.setDelegated_user(conf.getDelegatedUsername());
                id.setDelegated_password(conf.getDelegatedPassword());
                id.setDelegated_domain(conf.getDelegatedDomain());
            }
            if (conf.getDelegatedUsername() != null && !conf.getDelegatedUsername().isEmpty()) {
                id.setDelegated_user(conf.getDelegatedUsername());
                id.setDelegated_password(conf.getDelegatedPassword());
                id.setDelegated_domain(conf.getDelegatedDomain());
            }
            CertListResponse response = null;
            if (conf.getApplicationUsername() != null && !"".equals(conf.getApplicationUsername()) && conf.getApplicationPassword() != null && !"".equals(conf.getApplicationPassword())) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(conf.getApplicationUsername());
                appauth.setApplicationpassword(conf.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            request.setIdentity(id);
            try {
                URL url = new URL(strUrl1);
                logger.info("URL {}", (Object)url.getHost());
                logger.info("Enforce Mode {}", (Object)enforce_mode);
                logger.info("Enforce Mode value {}", (Object)netConf.getEnforceMode());
                response = client.certlistop(strUrl1, request);
            }
            catch (IOException ex) {
                logger.error("Errore Primario");
                logger.error(ex.getMessage(), (Throwable)ex);
                try {
                    response = client.certlistop(strUrl2, request);
                }
                catch (IOException ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                strReturn = response.getReturn_code();
            }
        }
        if (strReturn != null) {
            if (!strReturn.equals("0000")) {
                if (strReturn.equals("0002")) {
                    throw new ACPException("Invalid Credentials", "0002");
                }
                if (strReturn.equals("0025")) {
                    throw new ACPException("User Temporary Suspended", "0025");
                }
                if (strReturn.equals("0003")) {
                    throw new ACPException("Invalid OTP", "0003");
                }
                if (strReturn.equals("0005")) {
                    throw new ACPException("Invalid Delegating Credentials", "0005");
                }
                if (strReturn.equals("0006")) {
                    throw new ACPException("User Cert Change", "0006");
                }
                if (strReturn.equals("0007")) {
                    throw new ACPException("User Lock", "0007");
                }
                if (strReturn.equals("0008")) {
                    throw new ACPException("Delegating User Lock", "0008");
                }
                if (strReturn.equals("0009")) {
                    throw new ACPException("Invalid User Status", "0009");
                }
                if (strReturn.equals("0011")) {
                    throw new ACPException("User Cert Not Valid", "0011");
                }
                if (strReturn.equals("0021")) {
                    throw new ACPException("Password Expired", "0021");
                }
                throw new ACPException("UNKNOW ERROR", "FFFF");
            }
        } else {
            throw new ACPException("Connection Error", "FFFF");
        }
    }

    @Deprecated
    public static String createSession(String strURL, ConfigParameter conf, String password) {
        return null;
    }

    public static String createSession(String strURL, UserData conf, String password, String pin, NetworkConfig netConf) {
        if (conf == null || conf.getUsername() == null || conf.getUsername().isEmpty() || (password == null || password.isEmpty()) && conf.getDelegatedPassword().isEmpty()) {
            return "KO";
        }
        UrlClient objClient = new UrlClient(netConf, logger);
        boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
        URLCredentials creds = null;
        if (conf.getBasicAuthUsername() != null && !conf.getBasicAuthUsername().isEmpty() && conf.getBasicAuthPassword() != null && !conf.getBasicAuthPassword().isEmpty()) {
            creds = new URLCredentials(conf.getBasicAuthUsername(), conf.getBasicAuthPassword(), null, null);
        }
        GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getDomain()), false, enforce_mode, conf.getUsername());
        Auth id = new Auth();
        id.setDomain(conf.getDomain());
        id.setUser(conf.getUsername());
        id.setUserPWD(password);
        if (conf.getDelegatedUsername() != null && !conf.getDelegatedUsername().isEmpty()) {
            id.setDelegated_user(conf.getDelegatedUsername());
            id.setDelegated_password(conf.getDelegatedPassword());
            id.setDelegated_domain(conf.getDelegatedDomain());
        }
        if (conf.getApplicationUsername() != null && !conf.getApplicationUsername().isEmpty() && conf.getApplicationPassword() != null && !conf.getApplicationPassword().isEmpty()) {
            ApplicationAuth appauth = new ApplicationAuth();
            appauth.setApplicationuser(conf.getApplicationUsername());
            appauth.setApplicationpassword(conf.getApplicationPassword());
            id.setAppidentity(appauth);
        }
        TempPwdRequestEx req = new TempPwdRequestEx();
        req.setIdentity(id);
        req.setTypeAuth("OTP");
        req.setValue(pin);
        try {
            CreateSessionReturn response = client.create_session(strURL, req);
            if (response == null || response.getReturn_code() == null) {
                return null;
            }
            if (response.getReturn_code().equals("0000")) {
                return response.getSessionId();
            }
            return "KO-" + response.getReturn_code();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    @Deprecated
    public static String closeSession(String strURL, ConfigParameter conf, String passsword, String session) {
        return null;
    }

    public static String closeSession(String strURL, UserData conf, String passsword, String session, NetworkConfig netConf) {
        if (conf == null || conf.getUsername() == null || conf.getUsername().isEmpty() || (passsword == null || passsword.isEmpty()) && (conf.getDelegatedPassword() == null || conf.getDelegatedPassword().isEmpty())) {
            return "KO-INVALIDPARAMETERS";
        }
        UrlClient objClient = new UrlClient(netConf, logger);
        boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
        URLCredentials creds = null;
        if (conf.getBasicAuthUsername() != null && !conf.getBasicAuthUsername().isEmpty() && conf.getBasicAuthPassword() != null && !conf.getBasicAuthPassword().isEmpty()) {
            creds = new URLCredentials(conf.getBasicAuthUsername(), conf.getBasicAuthPassword(), null, null);
        }
        GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getDomain()), false, enforce_mode, conf.getUsername());
        CloseSessionRequest req = new CloseSessionRequest();
        Auth id = new Auth();
        id.setDomain(conf.getDomain());
        id.setUser(conf.getUsername());
        id.setUserPWD(passsword);
        if (conf.getDelegatedUsername() != null && !conf.getDelegatedUsername().isEmpty()) {
            id.setDelegated_user(conf.getDelegatedUsername());
            id.setDelegated_password(conf.getDelegatedPassword());
            id.setDelegated_domain(conf.getDelegatedDomain());
        }
        if (conf.getApplicationUsername() != null && !conf.getApplicationUsername().isEmpty() && conf.getApplicationPassword() != null && !conf.getApplicationPassword().isEmpty()) {
            ApplicationAuth appauth = new ApplicationAuth();
            appauth.setApplicationuser(conf.getApplicationUsername());
            appauth.setApplicationpassword(conf.getApplicationPassword());
            id.setAppidentity(appauth);
        }
        req.setIdentity(id);
        req.setSession_id(session);
        try {
            GWReturn response = client.close_session(strURL, req);
            if (response == null || response.getReturn_code() == null) {
                return null;
            }
            if (!response.getReturn_code().equals("0000")) {
                return "KO-" + response.getReturn_code();
            }
            return response.getStatus();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    @Deprecated
    public static String retrievePin(String strURL, ConfigParameter conf, String password) {
        return ASUtils.retrievePin(strURL, ASUtils.toUserData(conf), conf.getNetConf(), password);
    }

    public static String retrievePin(String strURL, UserData userData, NetworkConfig netConf, String password) {
        String strReturn = null;
        if (userData != null && userData.getUsername() != null && !userData.getUsername().isEmpty() && (password != null && !password.isEmpty() || userData.getDelegatedPassword() != null && !userData.getDelegatedPassword().isEmpty())) {
            UrlClient objClient = new UrlClient(netConf, logger);
            boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, userData.getUsername());
            CertsListRequest request = new CertsListRequest();
            Auth id = new Auth();
            id.setDomain(userData.getDomain());
            id.setUser(userData.getUsername());
            id.setUserPWD(password);
            if (userData.getDelegatedUsername() != null && !userData.getDelegatedUsername().isEmpty()) {
                id.setDelegated_user(userData.getDelegatedUsername());
                id.setDelegated_password(userData.getDelegatedPassword());
                id.setDelegated_domain(userData.getDelegatedDomain());
            }
            CertListResponse response = null;
            if (userData.getApplicationUsername() != null && !userData.getApplicationUsername().isEmpty() && userData.getApplicationPassword() != null && !userData.getApplicationPassword().isEmpty()) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(userData.getApplicationUsername());
                appauth.setApplicationpassword(userData.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            request.setIdentity(id);
            try {
                response = client.certlistop(userData.getServerUrl1(), request);
            }
            catch (Exception ex) {
                logger.error("Errore Primario");
            }
            if (response != null && response.getStatus().equals("OK")) {
                strReturn = response.getKey();
            }
        }
        return strReturn;
    }

    @Deprecated
    public static String retrieveTempPin(ConfigParameter conf, String pin) {
        return ASUtils.retrieveTempPin(ASUtils.toUserData(conf), conf.getNetConf(), pin);
    }

    public static String retrieveTempPin(UserData conf, NetworkConfig netConf, String pin) {
        String strReturn = "KO";
        if (conf != null && conf.getUsername() != null && !conf.getUsername().isEmpty() && pin != null && !pin.isEmpty()) {
            String strUrl1 = "";
            String strUrl2 = "";
            if (System.currentTimeMillis() % 2L == 0L) {
                strUrl1 = conf.getServerUrl1();
                strUrl2 = conf.getServerUrl2();
            } else {
                strUrl1 = conf.getServerUrl2();
                strUrl2 = conf.getServerUrl1();
            }
            UrlClient objClient = new UrlClient(netConf, logger);
            boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (conf.getBasicAuthUsername() != null && !conf.getBasicAuthUsername().isEmpty() && conf.getBasicAuthPassword() != null && !conf.getBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(conf.getBasicAuthUsername(), conf.getBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getDomain()), false, enforce_mode, conf.getUsername());
            TempPwdRequest request = new TempPwdRequest();
            Auth id = new Auth();
            id.setDomain(conf.getDomain());
            id.setUser(conf.getUsername());
            id.setUserPWD(conf.getPassword());
            id.setOtpPwd(pin);
            TempPwdResponse response = null;
            if (conf.getApplicationUsername() != null && !"".equals(conf.getApplicationUsername()) && conf.getApplicationPassword() != null && !"".equals(conf.getApplicationPassword())) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(conf.getApplicationUsername());
                appauth.setApplicationpassword(conf.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            request.setIdentity(id);
            boolean retry = false;
            try {
                response = client.temppwd(strUrl1, request);
                if (response == null) {
                    retry = true;
                }
            }
            catch (Exception ex) {
                logger.error("Errore Primario");
                logger.error(ex.getMessage(), (Throwable)ex);
                retry = true;
            }
            if (retry) {
                try {
                    response = client.temppwd(strUrl2, request);
                }
                catch (Exception ex) {
                    logger.error("Errore Secondario");
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (response != null) {
                strReturn = response.getStatus().equals("OK") ? response.getTmppwd() : response.getStatus();
            }
        }
        return strReturn;
    }

    @Deprecated
    public static String sendCred(ConfigParameter conf, String type) {
        return ASUtils.sendCred(ASUtils.toUserData(conf), conf.getNetConf(), type);
    }

    public static String sendCred(UserData userData, NetworkConfig config, String type) {
        String strReturn = "KO";
        if (userData != null && userData.getUsername() != null && !userData.getUsername().isEmpty() && type != null && !type.isEmpty()) {
            String strUrl1 = "";
            String strUrl2 = "";
            if (System.currentTimeMillis() % 2L == 0L) {
                strUrl1 = userData.getServerUrl1();
                strUrl2 = userData.getServerUrl2();
            } else {
                strUrl1 = userData.getServerUrl2();
                strUrl2 = userData.getServerUrl1();
            }
            UrlClient objClient = new UrlClient(config, logger);
            boolean enforce_mode = config.getEnforceMode() == null || config.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, userData.getUsername());
            SendCredential request = new SendCredential();
            Auth id = new Auth();
            id.setDomain(userData.getDomain());
            id.setUser(userData.getUsername());
            id.setUserPWD(userData.getPassword());
            if (userData.getDelegatedUsername() != null && !userData.getDelegatedUsername().isEmpty()) {
                id.setDelegated_user(userData.getDelegatedUsername());
                id.setDelegated_password(userData.getDelegatedPassword());
                id.setDelegated_domain(userData.getDelegatedDomain());
            }
            String response = null;
            if (userData.getApplicationUsername() != null && !userData.getApplicationUsername().isEmpty() && userData.getApplicationPassword() != null && !userData.getApplicationPassword().isEmpty()) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(userData.getApplicationUsername());
                appauth.setApplicationpassword(userData.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            request.setIdentity(id);
            request.setTypeAuth(type);
            boolean retry = false;
            try {
                response = client.send_credential(strUrl1, request);
                if (response == null) {
                    retry = true;
                }
            }
            catch (Exception ex) {
                logger.error("Errore Primario");
                logger.error(ex.getMessage(), (Throwable)ex);
                retry = true;
            }
            if (retry) {
                try {
                    response = client.send_credential(strUrl2, request);
                }
                catch (Exception ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                strReturn = response;
            }
        }
        return strReturn;
    }

    @Deprecated
    public static String verifyPin(ConfigParameter conf, String pin) {
        return ASUtils.verifyPin(ASUtils.toUserData(conf), conf.getNetConf(), pin);
    }

    public static String verifyPin(UserData userData, NetworkConfig conf, String pin) {
        String strReturn = "KO";
        if (userData != null && userData.getUsername() != null && !userData.getUsername().isEmpty() && pin != null && !pin.equals("")) {
            String strUrl1 = "";
            String strUrl2 = "";
            if (System.currentTimeMillis() % 2L == 0L) {
                strUrl1 = userData.getServerUrl1();
                strUrl2 = userData.getServerUrl2();
            } else {
                strUrl1 = userData.getServerUrl2();
                strUrl2 = userData.getServerUrl1();
            }
            UrlClient objClient = new UrlClient(conf, logger);
            boolean enforce_mode = conf.getEnforceMode() == null || conf.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, userData.getUsername());
            StrongCredential request = new StrongCredential();
            Auth id = new Auth();
            id.setDomain(userData.getDomain());
            id.setUser(userData.getUsername());
            id.setUserPWD(userData.getPassword());
            id.setOtpPwd(pin);
            if (userData.getDelegatedUsername() != null && !userData.getDelegatedUsername().isEmpty()) {
                id.setDelegated_user(userData.getDelegatedUsername());
                id.setDelegated_password(userData.getDelegatedPassword());
                id.setDelegated_domain(userData.getDelegatedDomain());
            }
            String response = null;
            if (userData.getApplicationUsername() != null && !"".equals(userData.getApplicationUsername()) && userData.getApplicationPassword() != null && !"".equals(userData.getApplicationPassword())) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(userData.getApplicationUsername());
                appauth.setApplicationpassword(userData.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            request.setIdentity(id);
            request.setTypeAuth("OTP");
            boolean retry = false;
            try {
                response = client.verify_otp(strUrl1, request);
                if (response == null) {
                    retry = true;
                }
            }
            catch (Exception ex) {
                logger.error("Errore Primario");
                logger.error(ex.getMessage(), (Throwable)ex);
                retry = true;
            }
            if (retry) {
                try {
                    response = client.verify_otp(strUrl2, request);
                }
                catch (Exception ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                strReturn = response;
            }
        }
        return strReturn;
    }

    public static CNSSession openCNSSession(ConfigParameter conf, String username, String domain, byte[] pkcs7) {
        CNSSession objReturn = new CNSSession();
        objReturn.setError_code(-4);
        if (pkcs7 != null && pkcs7.length > 0) {
            String strUrl1 = "";
            String strUrl2 = "";
            if (System.currentTimeMillis() % 2L == 0L) {
                strUrl1 = conf.getServerAS();
                strUrl2 = conf.getServerAS2();
            } else {
                strUrl1 = conf.getServerAS2();
                strUrl2 = conf.getServerAS();
            }
            UrlClient objClient = new UrlClient(conf.getNetConf(), logger);
            boolean enforce_mode = conf.getEnforceMode() == null || conf.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (conf.getRemoteSignatureBasicAuthUser() != null && !conf.getRemoteSignatureBasicAuthUser().isEmpty() && conf.getRemoteSignatureBasicAuthPassword() != null && !conf.getRemoteSignatureBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(conf.getRemoteSignatureBasicAuthUser(), conf.getRemoteSignatureBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getUserDomainAS()), false, enforce_mode, conf.getUserNameAS());
            TempPwdRequestEx request = new TempPwdRequestEx();
            Auth id = new Auth();
            id.setDomain(conf.getUserDomainAS());
            id.setUser(conf.getUserNameAS());
            conf.getAsMustUrl();
            TempPwdResponseEx response = null;
            if (conf.getApplicationUsername() != null && !"".equals(conf.getApplicationUsername()) && conf.getApplicationPassword() != null && !"".equals(conf.getApplicationPassword())) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(conf.getApplicationUsername());
                appauth.setApplicationpassword(conf.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            request.setIdentity(id);
            request.setTypeAuth("CNS2");
            request.setBlobvalue(pkcs7);
            boolean retry = false;
            try {
                response = client.temppwd_ext(strUrl1, request);
                if (response == null) {
                    retry = true;
                }
            }
            catch (Exception ex) {
                logger.error("Errore Primario");
                logger.error(ex.getMessage(), (Throwable)ex);
                retry = true;
            }
            if (retry) {
                try {
                    response = client.temppwd_ext(strUrl2, request);
                }
                catch (Exception ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null && response.getStatus().equals("OK")) {
                objReturn = new CNSSession();
                objReturn.setTmp_password(response.getCns_session());
                objReturn.setTmp_otp(response.getTmppwd());
                objReturn.setUser_name(username);
                objReturn.setDomain(domain);
                objReturn.setError_code(0);
            } else if (response != null) {
                if (response.getStatus().equals("KO-0001")) {
                    objReturn.setError_code(1);
                } else if (response.getStatus().equals("KO-0002")) {
                    objReturn.setError_code(2);
                } else if (response.getStatus().equals("KO-0003")) {
                    objReturn.setError_code(3);
                } else if (response.getStatus().equals("KO-0004")) {
                    objReturn.setError_code(4);
                }
            }
        }
        return objReturn;
    }

    public static CNSSession openCNSSession(ConfigParameter conf, String pin) {
        CNSSession objReturn = new CNSSession();
        objReturn.setError_code(-4);
        String strUrl1 = "";
        String strUrl2 = "";
        if (System.currentTimeMillis() % 2L == 0L) {
            strUrl1 = conf.getServerAS();
            strUrl2 = conf.getServerAS2();
        } else {
            strUrl1 = conf.getServerAS2();
            strUrl2 = conf.getServerAS();
        }
        UrlClient objClient = new UrlClient(conf.getNetConf(), logger);
        boolean enforce_mode = conf.getEnforceMode() == null || conf.getEnforceMode().equals("S");
        URLCredentials creds = null;
        if (conf.getRemoteSignatureBasicAuthUser() != null && !conf.getRemoteSignatureBasicAuthUser().isEmpty() && conf.getRemoteSignatureBasicAuthPassword() != null && !conf.getRemoteSignatureBasicAuthPassword().isEmpty()) {
            creds = new URLCredentials(conf.getRemoteSignatureBasicAuthUser(), conf.getRemoteSignatureBasicAuthPassword(), null, null);
        }
        GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getUserDomainAS()), false, enforce_mode, conf.getUserNameAS());
        TempPwdRequestEx request = new TempPwdRequestEx();
        Auth id = new Auth();
        id.setDomain(conf.getUserDomainAS());
        id.setUser(conf.getUserNameAS());
        TempPwdResponseEx response = null;
        if (conf.getApplicationUsername() != null && !"".equals(conf.getApplicationUsername()) && conf.getApplicationPassword() != null && !"".equals(conf.getApplicationPassword())) {
            ApplicationAuth appauth = new ApplicationAuth();
            appauth.setApplicationuser(conf.getApplicationUsername());
            appauth.setApplicationpassword(conf.getApplicationPassword());
            id.setAppidentity(appauth);
        }
        request.setIdentity(id);
        request.setTypeAuth("CNS");
        request.setBlobvalue(pin.getBytes());
        boolean retry = false;
        try {
            response = client.temppwd_ext(strUrl1, request);
            if (response == null) {
                retry = true;
            }
        }
        catch (Exception ex) {
            logger.error("Errore Primario");
            logger.error(ex.getMessage(), (Throwable)ex);
            retry = true;
        }
        if (retry) {
            try {
                response = client.temppwd_ext(strUrl2, request);
            }
            catch (Exception ex1) {
                logger.error("Errore Secondario");
                logger.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
        if (response != null && response.getStatus().equals("OK")) {
            objReturn = new CNSSession();
            objReturn.setTmp_password(response.getCns_session());
            objReturn.setTmp_otp(response.getTmppwd());
            objReturn.setUser_name(conf.getUserNameAS());
            objReturn.setDomain(conf.getUserDomainAS());
            objReturn.setError_code(0);
        } else if (response != null) {
            if (response.getStatus().equals("KO-0001")) {
                objReturn.setError_code(1);
            } else if (response.getStatus().equals("KO-0002")) {
                objReturn.setError_code(2);
            } else if (response.getStatus().equals("KO-0003")) {
                objReturn.setError_code(3);
            } else if (response.getStatus().equals("KO-0004")) {
                objReturn.setError_code(4);
            }
        }
        return objReturn;
    }

    public static CertListResponseInfo certList(ConfigParameter conf, CertsListRequest request) {
        CertListResponseInfo objReturn = null;
        String serviceurl = null;
        if (conf != null && conf.getUserNameAS() != null && !conf.getUserNameAS().equals("")) {
            boolean retry;
            CertListResponse response;
            GwClientI client;
            String strUrl2;
            block14: {
                String strUrl1 = "";
                strUrl2 = "";
                if (conf.getAsMustUrl() != null) {
                    strUrl1 = conf.getAsMustUrl();
                } else if (System.currentTimeMillis() % 2L == 0L) {
                    strUrl1 = conf.getServerAS();
                    strUrl2 = conf.getServerAS2();
                } else {
                    strUrl1 = conf.getServerAS2();
                    strUrl2 = conf.getServerAS();
                }
                UrlClient objClient = new UrlClient(conf.getNetConf(), logger);
                boolean enforce_mode = conf.getEnforceMode() == null || conf.getEnforceMode().equals("S");
                URLCredentials creds = null;
                if (conf.getRemoteSignatureBasicAuthUser() != null && !conf.getRemoteSignatureBasicAuthUser().isEmpty() && conf.getRemoteSignatureBasicAuthPassword() != null && !conf.getRemoteSignatureBasicAuthPassword().isEmpty()) {
                    creds = new URLCredentials(conf.getRemoteSignatureBasicAuthUser(), conf.getRemoteSignatureBasicAuthPassword(), null, null);
                }
                client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getUserDomainAS()), false, enforce_mode, request.getIdentity().getUser());
                response = null;
                if (conf.getApplicationUsername() != null && !"".equals(conf.getApplicationUsername()) && conf.getApplicationPassword() != null && !"".equals(conf.getApplicationPassword())) {
                    ApplicationAuth appauth = new ApplicationAuth();
                    Auth id = request.getIdentity();
                    appauth.setApplicationuser(conf.getApplicationUsername());
                    appauth.setApplicationpassword(conf.getApplicationPassword());
                    id.setAppidentity(appauth);
                    request.setIdentity(id);
                }
                retry = false;
                try {
                    response = client.certlistop(strUrl1, request);
                    serviceurl = strUrl1;
                    if (response == null && conf.getAsMustUrl() == null) {
                        retry = true;
                    }
                }
                catch (Exception ex) {
                    logger.error("Errore Primario");
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (conf.getAsMustUrl() != null) break block14;
                    retry = true;
                }
            }
            if (retry) {
                try {
                    response = client.certlistop(strUrl2, request);
                    serviceurl = strUrl2;
                }
                catch (Exception ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null && response.getStatus().equals("OK")) {
                objReturn = new CertListResponseInfo();
                objReturn.setCertlist(response.getCertlist());
                objReturn.setDescription(response.getDescription());
                objReturn.setKey(response.getKey());
                objReturn.setReturn_code(response.getReturn_code());
                objReturn.setStatus(response.getStatus());
                objReturn.setServiceurl(serviceurl);
            }
        }
        return objReturn;
    }

    @Deprecated
    public static CertListResponseInfo certListAuth(ConfigParameter conf, CertsListRequestAuth request) {
        return ASUtils.certListAuth(ASUtils.toUserData(conf), conf.getNetConf(), conf.getAsMustUrl(), request);
    }

    public static CertListResponseInfo certListAuth(UserData userData, NetworkConfig netConf, String asMustUrl, CertsListRequestAuth request) {
        CertListResponseInfo objReturn = null;
        String serviceurl = null;
        if (userData != null && userData.getUsername() != null && !userData.getUsername().equals("")) {
            boolean retry;
            CertListResponse response;
            GwClientI client;
            String strUrl2;
            block14: {
                String strUrl1 = "";
                strUrl2 = "";
                if (asMustUrl != null) {
                    strUrl1 = asMustUrl;
                } else if (System.currentTimeMillis() % 2L == 0L) {
                    strUrl1 = userData.getServerUrl1();
                    strUrl2 = userData.getServerUrl2();
                } else {
                    strUrl1 = userData.getServerUrl2();
                    strUrl2 = userData.getServerUrl1();
                }
                UrlClient objClient = new UrlClient(netConf, logger);
                boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
                URLCredentials creds = null;
                if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                    creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
                }
                client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, request.getUsername());
                response = null;
                if (userData.getApplicationUsername() != null && !userData.getApplicationUsername().isEmpty() && userData.getApplicationPassword() != null && !userData.getApplicationPassword().isEmpty()) {
                    ApplicationAuth appauth = new ApplicationAuth();
                    appauth.setApplicationuser(userData.getApplicationUsername());
                    appauth.setApplicationpassword(userData.getApplicationPassword());
                    request.setIdentity(appauth);
                }
                retry = false;
                try {
                    response = client.certlistopauth(strUrl1, request);
                    serviceurl = strUrl1;
                    if (response == null && asMustUrl == null) {
                        retry = true;
                    }
                }
                catch (Exception ex) {
                    logger.error("Errore Primario");
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (asMustUrl != null) break block14;
                    retry = true;
                }
            }
            if (retry) {
                try {
                    response = client.certlistopauth(strUrl2, request);
                    serviceurl = strUrl2;
                }
                catch (Exception ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null && response.getStatus().equals("OK")) {
                objReturn = new CertListResponseInfo();
                objReturn.setCertlist(response.getCertlist());
                objReturn.setDescription(response.getDescription());
                objReturn.setKey(response.getKey());
                objReturn.setReturn_code(response.getReturn_code());
                objReturn.setStatus(response.getStatus());
                objReturn.setServiceurl(serviceurl);
            }
        }
        return objReturn;
    }

    @Deprecated
    public static String[] auth_methods(ConfigParameter conf) {
        return ASUtils.auth_methods(ASUtils.toUserData(conf), conf.getNetConf(), conf.getAsMustUrl());
    }

    public static String[] auth_methods(UserData conf, NetworkConfig netConf, String asMustUrl) {
        String[] objReturn = null;
        if (conf != null && conf.getUsername() != null && !conf.getUsername().isEmpty()) {
            boolean retry;
            String[] response;
            GwClientI client;
            String strUrl2;
            Auth id;
            block15: {
                id = new Auth();
                id.setDomain(conf.getDomain());
                id.setUser(conf.getUsername());
                id.setUserPWD(conf.getPassword());
                if (conf.getDelegatedUsername() != null && !conf.getDelegatedUsername().isEmpty()) {
                    id.setDelegated_user(conf.getDelegatedUsername());
                    id.setDelegated_password(conf.getDelegatedPassword());
                    id.setDelegated_domain(conf.getDelegatedDomain());
                }
                String strUrl1 = "";
                strUrl2 = "";
                if (asMustUrl != null) {
                    strUrl1 = asMustUrl;
                } else if (System.currentTimeMillis() % 2L == 0L) {
                    strUrl1 = conf.getServerUrl1();
                    strUrl2 = conf.getServerUrl2();
                } else {
                    strUrl1 = conf.getServerUrl2();
                    strUrl2 = conf.getServerUrl1();
                }
                UrlClient objClient = new UrlClient(netConf, logger);
                boolean enforce_mode = netConf == null || netConf.equals("S");
                URLCredentials creds = null;
                if (conf.getBasicAuthUsername() != null && !conf.getBasicAuthUsername().isEmpty() && conf.getBasicAuthPassword() != null && !conf.getBasicAuthPassword().isEmpty()) {
                    creds = new URLCredentials(conf.getBasicAuthUsername(), conf.getBasicAuthPassword(), null, null);
                }
                client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)conf.getDomain()), false, enforce_mode, conf.getUsername());
                response = null;
                if (conf.getApplicationUsername() != null && !"".equals(conf.getApplicationUsername()) && conf.getApplicationPassword() != null && !"".equals(conf.getApplicationPassword())) {
                    ApplicationAuth appauth = new ApplicationAuth();
                    appauth.setApplicationuser(conf.getApplicationUsername());
                    appauth.setApplicationpassword(conf.getApplicationPassword());
                    id.setAppidentity(appauth);
                }
                retry = false;
                try {
                    response = client.auth_methods(strUrl1, id);
                    if (response == null && asMustUrl == null) {
                        retry = true;
                    }
                }
                catch (Exception ex) {
                    logger.error("Errore Primario");
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (asMustUrl != null) break block15;
                    retry = true;
                }
            }
            if (retry) {
                try {
                    response = client.auth_methods(strUrl2, id);
                }
                catch (Exception ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                objReturn = response;
            }
        }
        return objReturn;
    }

    @Deprecated
    public static RetriveCredentialReturn retrieve_credential(ConfigParameter conf, RetriveCredential request) {
        return ASUtils.retrieve_credential(ASUtils.toUserData(conf), conf.getNetConf(), conf.getAsMustUrl(), request);
    }

    public static RetriveCredentialReturn retrieve_credential(UserData userData, NetworkConfig netConf, String asMustUrl, RetriveCredential request) {
        RetriveCredentialReturn objReturn = null;
        if (userData != null && userData.getUsername() != null && !userData.getUsername().isEmpty()) {
            boolean retry;
            RetriveCredentialReturn response;
            GwClientI client;
            String strUrl2;
            block14: {
                String strUrl1 = "";
                strUrl2 = "";
                if (asMustUrl != null) {
                    strUrl1 = asMustUrl;
                } else if (System.currentTimeMillis() % 2L == 0L) {
                    strUrl1 = userData.getServerUrl1();
                    strUrl2 = userData.getServerUrl2();
                } else {
                    strUrl1 = userData.getServerUrl2();
                    strUrl2 = userData.getServerUrl1();
                }
                UrlClient objClient = new UrlClient(netConf, logger);
                boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
                URLCredentials creds = null;
                if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                    creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
                }
                client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, request.getIdentity().getUser());
                response = null;
                if (userData.getApplicationUsername() != null && !userData.getApplicationUsername().isEmpty() && userData.getApplicationPassword() != null && !userData.getApplicationPassword().isEmpty()) {
                    Auth id = request.getIdentity();
                    ApplicationAuth appauth = new ApplicationAuth();
                    appauth.setApplicationuser(userData.getApplicationUsername());
                    appauth.setApplicationpassword(userData.getApplicationPassword());
                    id.setAppidentity(appauth);
                    request.setIdentity(id);
                }
                retry = false;
                try {
                    response = client.retrieve_credential(strUrl1, request);
                    if (response == null && asMustUrl == null) {
                        retry = true;
                    }
                }
                catch (Exception ex) {
                    logger.error("Errore Primario");
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (asMustUrl != null) break block14;
                    retry = true;
                }
            }
            if (retry) {
                try {
                    response = client.retrieve_credential(strUrl2, request);
                }
                catch (Exception ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                objReturn = response;
            }
        }
        return objReturn;
    }

    public static GWReturn test_otp(ConfigParameter conf, TestCredential request) {
        return ASUtils.test_otp(ASUtils.toUserData(conf), conf.getNetConf(), conf.getAsMustUrl(), request);
    }

    public static GWReturn test_otp(UserData userData, NetworkConfig netConf, String asMustUrl, TestCredential request) {
        GWReturn objReturn = new GWReturn();
        if (userData != null && userData.getUsername() != null && !userData.getUsername().isEmpty()) {
            boolean retry;
            GWReturn response;
            GwClientI client;
            String strUrl2;
            block14: {
                String strUrl1 = "";
                strUrl2 = "";
                if (asMustUrl != null) {
                    strUrl1 = asMustUrl;
                } else if (System.currentTimeMillis() % 2L == 0L) {
                    strUrl1 = userData.getServerUrl1();
                    strUrl2 = userData.getServerUrl2();
                } else {
                    strUrl1 = userData.getServerUrl2();
                    strUrl2 = userData.getServerUrl1();
                }
                UrlClient objClient = new UrlClient(netConf, logger);
                boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
                URLCredentials creds = null;
                if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                    creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
                }
                client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, null);
                response = null;
                if (userData.getApplicationUsername() != null && !userData.getApplicationUsername().isEmpty() && userData.getApplicationPassword() != null && !userData.getApplicationPassword().isEmpty()) {
                    ApplicationAuth appauth = request.getAppidentity();
                    appauth.setApplicationuser(userData.getApplicationUsername());
                    appauth.setApplicationpassword(userData.getApplicationPassword());
                    request.setAppidentity(appauth);
                }
                retry = false;
                try {
                    response = client.test_otp(strUrl1, request);
                    if (response == null && asMustUrl == null) {
                        retry = true;
                    }
                }
                catch (Exception ex) {
                    objReturn.setStatus("KO");
                    objReturn.setDescription("Errore server");
                    logger.error("Errore Primario");
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (userData != null) break block14;
                    retry = true;
                }
            }
            if (retry) {
                try {
                    response = client.test_otp(strUrl2, request);
                }
                catch (Exception ex1) {
                    objReturn.setStatus("KO");
                    objReturn.setDescription("Errore server");
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                objReturn = response;
            }
        }
        return objReturn;
    }

    @Deprecated
    public static CredentialListReturn credentials_query(ConfigParameter conf, CredentialListQuery request) {
        return ASUtils.credentials_query(ASUtils.toUserData(conf), conf.getNetConf(), conf.getAsMustUrl(), request);
    }

    public static CredentialListReturn credentials_query(UserData userData, NetworkConfig netConf, String asMustUrl, CredentialListQuery request) {
        CredentialListReturn objReturn = new CredentialListReturn();
        if (userData != null) {
            boolean retry;
            CredentialListReturn response;
            GwClientI client;
            String strUrl2;
            block14: {
                String strUrl1 = "";
                strUrl2 = "";
                if (asMustUrl != null) {
                    strUrl1 = asMustUrl;
                } else if (System.currentTimeMillis() % 2L == 0L) {
                    strUrl1 = userData.getServerUrl1();
                    strUrl2 = userData.getServerUrl2();
                } else {
                    strUrl1 = userData.getServerUrl2();
                    strUrl2 = userData.getServerUrl1();
                }
                UrlClient objClient = new UrlClient(netConf, logger);
                boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
                URLCredentials creds = null;
                if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                    creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
                }
                client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, null);
                response = null;
                if (userData.getApplicationUsername() != null && !userData.getApplicationUsername().isEmpty() && userData.getApplicationPassword() != null && !userData.getApplicationPassword().isEmpty()) {
                    ApplicationAuth appauth = request.getAppidentity();
                    appauth.setApplicationuser(userData.getApplicationUsername());
                    appauth.setApplicationpassword(userData.getApplicationPassword());
                    request.setAppidentity(appauth);
                }
                retry = false;
                try {
                    response = client.credentials_query(strUrl1, request);
                    if (response == null && asMustUrl == null) {
                        retry = true;
                    }
                }
                catch (Exception ex) {
                    objReturn.setStatus("KO");
                    objReturn.setDescription("Errore server");
                    logger.error("Errore Primario");
                    logger.error(ex.getMessage(), (Throwable)ex);
                    if (asMustUrl != null) break block14;
                    retry = true;
                }
            }
            if (retry) {
                try {
                    response = client.credentials_query(strUrl2, request);
                }
                catch (Exception ex1) {
                    objReturn.setStatus("KO");
                    objReturn.setDescription("Errore server");
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                objReturn = response;
            }
        }
        return objReturn;
    }

    public static void changePassword(ConfigParameter config, String newPassword, String otp) throws ACPException {
        ASUtils.changePassword(ASUtils.toUserData(config), config.getNetConf(), newPassword, otp);
    }

    public static void changePassword(UserData userData, NetworkConfig netConf, String newPassword, String otp) throws ACPException {
        String strReturn = null;
        if (!(userData == null || userData.getUsername() == null || userData.getUsername().equals("") || newPassword == null || "".equals(newPassword) || otp == null || "".equals(otp))) {
            String strUrl1 = "";
            String strUrl2 = "";
            if (System.currentTimeMillis() % 2L == 0L) {
                strUrl1 = userData.getServerUrl1();
                strUrl2 = userData.getServerUrl2();
            } else {
                strUrl1 = userData.getServerUrl2();
                strUrl2 = userData.getServerUrl1();
            }
            UrlClient objClient = new UrlClient(netConf, logger);
            boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
            URLCredentials creds = null;
            if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
                creds = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
            }
            GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, userData.getUsername());
            ChangePassword request = new ChangePassword();
            StrongCredential strongCredential = new StrongCredential();
            Auth id = new Auth();
            id.setDomain(userData.getDomain());
            id.setUser(userData.getUsername());
            id.setUserPWD(userData.getPassword());
            if (userData.getDelegatedUsername() != null && !userData.getDelegatedUsername().isEmpty()) {
                id.setDelegated_user(userData.getDelegatedUsername());
                id.setDelegated_password(userData.getDelegatedPassword());
                id.setDelegated_domain(userData.getDelegatedDomain());
            }
            GWReturn response = null;
            if (userData.getApplicationUsername() != null && !userData.getApplicationUsername().isEmpty() && userData.getApplicationPassword() != null && !userData.getApplicationPassword().isEmpty()) {
                ApplicationAuth appauth = new ApplicationAuth();
                appauth.setApplicationuser(userData.getApplicationUsername());
                appauth.setApplicationpassword(userData.getApplicationPassword());
                id.setAppidentity(appauth);
            }
            strongCredential.setIdentity(id);
            strongCredential.setTypeAuth("OTP");
            strongCredential.setValue(otp);
            request.setCredential(strongCredential);
            request.setNewpassword(newPassword);
            try {
                URL url = new URL(strUrl1);
                logger.info("URL {}", (Object)url.getHost());
                logger.info("Enforce Mode {}", (Object)enforce_mode);
                logger.info("Enforce Mode value {}", (Object)netConf.getEnforceMode());
                response = client.changePassword(strUrl1, request);
            }
            catch (IOException ex) {
                logger.error("Errore Primario");
                logger.error(ex.getMessage(), (Throwable)ex);
                try {
                    response = client.changePassword(strUrl2, request);
                }
                catch (IOException ex1) {
                    logger.error("Errore Secondario");
                    logger.error(ex1.getMessage(), (Throwable)ex1);
                }
            }
            if (response != null) {
                strReturn = response.getReturn_code();
            }
        }
        if (strReturn != null) {
            if (!strReturn.equals("0000")) {
                if (strReturn.equals("0002")) {
                    throw new ACPException("Invalid Credentials", "0002");
                }
                if (strReturn.equals("0025")) {
                    throw new ACPException("User Temporary Suspended", "0025");
                }
                if (strReturn.equals("0003")) {
                    throw new ACPException("Invalid OTP", "0003");
                }
                if (strReturn.equals("0005")) {
                    throw new ACPException("Invalid Delegating Credentials", "0005");
                }
                if (strReturn.equals("0006")) {
                    throw new ACPException("User Cert Change", "0006");
                }
                if (strReturn.equals("0007")) {
                    throw new ACPException("User Lock", "0007");
                }
                if (strReturn.equals("0008")) {
                    throw new ACPException("Delegating User Lock", "0008");
                }
                if (strReturn.equals("0009")) {
                    throw new ACPException("Invalid User Status", "0009");
                }
                if (strReturn.equals("0011")) {
                    throw new ACPException("User Cert Not Valid", "0011");
                }
                if (strReturn.equals("0021")) {
                    throw new ACPException("Password Expired", "0021");
                }
                if (strReturn.equals("0023")) {
                    throw new ACPException("Password Mismatch", "0023");
                }
                if (strReturn.equals("0024")) {
                    throw new ACPException("Invalid Password Length", "0024");
                }
                throw new ACPException("UNKNOW ERROR", "FFFF");
            }
        } else {
            throw new ACPException("Connection Error", "FFFF");
        }
    }

    public static String userAuthenticationInfo(UserData userData, NetworkConfig netConf, String asMustUrl) throws ACPException {
        UrlClient urlClient = new UrlClient(netConf, logger);
        URLCredentials urlCredentials = null;
        if (userData.getBasicAuthUsername() != null && !userData.getBasicAuthUsername().isEmpty() && userData.getBasicAuthPassword() != null && !userData.getBasicAuthPassword().isEmpty()) {
            urlCredentials = new URLCredentials(userData.getBasicAuthUsername(), userData.getBasicAuthPassword(), null, null);
        }
        boolean enforce_mode = netConf.getEnforceMode() == null || netConf.getEnforceMode().equals("S");
        GwClientI client = GwClient.getInstance(urlClient, logger, urlCredentials, ArubaTrustStore.getTSRS((String)userData.getDomain()), false, enforce_mode, userData.getUsername());
        UserAuthenticationInfoRequest request = new UserAuthenticationInfoRequest();
        request.setUsername(userData.getUsername());
        request.setDomain(userData.getDomain());
        ApplicationAuth appAuth = new ApplicationAuth();
        appAuth.setApplicationuser(userData.getApplicationUsername());
        appAuth.setApplicationpassword(userData.getApplicationPassword());
        request.setAppidentity(appAuth);
        String strUrl1 = "";
        String strUrl2 = "";
        if (asMustUrl != null) {
            strUrl1 = asMustUrl;
        } else if (System.currentTimeMillis() % 2L == 0L) {
            strUrl1 = userData.getServerUrl1();
            strUrl2 = userData.getServerUrl2();
        } else {
            strUrl1 = userData.getServerUrl2();
            strUrl2 = userData.getServerUrl1();
        }
        UserAuthenticationInfoResponse response = null;
        try {
            URL url = new URL(strUrl1);
            logger.info("URL {}", (Object)url.getHost());
            response = client.userAuthenticationInfo(strUrl1, request);
        }
        catch (IOException ex) {
            logger.error("Errore Primario");
            logger.error(ex.getMessage(), (Throwable)ex);
            try {
                response = client.userAuthenticationInfo(strUrl2, request);
            }
            catch (IOException ex1) {
                logger.error("Errore Secondario");
                logger.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
        if (response == null || response.getReturn_code() == null) {
            throw new ACPException("Connection Error", "FFFF");
        }
        if (response.getReturn_code().equals("0000")) {
            return response.getCredentialKey();
        }
        if (response.getReturn_code().equals("0015")) {
            throw new ACPException("Invalid App Credentials", "0015");
        }
        if (response.getReturn_code().equals("0002")) {
            throw new ACPException("Invalid Credentials", "0002");
        }
        if (response.getReturn_code().equals("0009")) {
            throw new ACPException("Invalid User Status", "0009");
        }
        if (response.getReturn_code().equals("0007")) {
            throw new ACPException("User Locked", "0007");
        }
        if (response.getReturn_code().equals("0026")) {
            throw new ACPException("Credential proxy not configured", "0026");
        }
        if (response.getReturn_code().equals("0027")) {
            throw new ACPException("Credential proxy not enabled", "0027");
        }
        throw new ACPException("UNKNOW ERROR", "FFFF");
    }

    private static UserData toUserData(ConfigParameter conf) {
        if (conf == null) {
            return null;
        }
        UserData userData = new UserData();
        userData.setUsername(conf.getUserNameAS());
        userData.setPassword(conf.getPasswordAS());
        userData.setDomain(conf.getUserDomainAS());
        userData.setServerUrl1(conf.getServerAS());
        userData.setServerUrl2(conf.getServerAS2());
        userData.setBasicAuthUsername(conf.getRemoteSignatureBasicAuthUser());
        userData.setBasicAuthPassword(conf.getRemoteSignatureBasicAuthPassword());
        userData.setApplicationUsername(conf.getApplicationUsername());
        userData.setApplicationUsername(conf.getApplicationUsername());
        userData.setDelegatedUsername(conf.getAsDelegatedUser());
        userData.setDelegatedPassword(conf.getAsDelegatedPassword());
        userData.setDelegatedDomain(conf.getAsDelegatedDomain());
        return userData;
    }
}

