/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.capi.hsmservice.HsmLigthwareClient;
import esecurity.capi.hsmservice.beans.HsmCertificate;
import esecurity.capi.hsmservice.beans.HsmDecrypt;
import esecurity.capi.hsmservice.beans.HsmDecryptReturn;
import esecurity.capi.hsmservice.beans.HsmOpenSession;
import esecurity.capi.hsmservice.beans.HsmOpenSessionReturn;
import esecurity.capi.hsmservice.beans.HsmTokenCert;
import esecurity.capi.hsmservice.beans.HsmUtilsReturn;
import esecurity.capi.hsmservice.beans.HsmValidateCredentials;
import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.rs.RemoteHsmInitializeParameters;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Iterator;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class HsmBeToken
extends TokenSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String TOKEN_RS = "HsmBeToken";
    private static final int MAX_PIN_LENGHT = 100;
    private static final int MIN_PIN_LENGHT = 0;
    private static final int MAX_RSA_KEY_LENGTH = 2048;
    private static final int MIN_RSA_KEY_LENGTH = 768;
    private static final String SERIAL_NUMBER = "0";
    private boolean public_session_open = false;
    private String userid;
    private HsmLigthwareClient client = null;
    private String selectedUrl;
    private String sessionid;
    private String sessionPassword;
    private HashMap<String, String> lstCert = new HashMap();

    public HsmBeToken() {
    }

    public HsmBeToken(RemoteHsmInitializeParameters param) throws CapiException {
        this.initializeLib(param);
    }

    public void initializeLib(String[] args) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void initializeLib(TokenParameters param) throws CapiException {
        String alternateUrl = null;
        if (param instanceof RemoteHsmInitializeParameters) {
            RemoteHsmInitializeParameters par = (RemoteHsmInitializeParameters)param;
            if (par == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (par.getIdentity() == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (par.getIdentity().getUserid() == null) {
                throw new CapiException("Wrong args usern", 1001);
            }
            if (par.getIdentity().getPassword() == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (par.getUrl1() == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (par.getUrl2() != null) {
                if (System.currentTimeMillis() % 2L == 0L) {
                    this.selectedUrl = par.getUrl1();
                    alternateUrl = par.getUrl2();
                } else {
                    this.selectedUrl = par.getUrl2();
                    alternateUrl = par.getUrl1();
                }
            } else {
                this.selectedUrl = par.getUrl1();
            }
            this.userid = par.getIdentity().getUserid();
            UrlClient urlClient = new UrlClient(par.getNetworkConfig(), logger);
            urlClient.setSSLHallHostVerified(true);
            urlClient.setSSLTrustAllRoot(true);
            this.client = new HsmLigthwareClient(urlClient, logger);
            HsmValidateCredentials req = new HsmValidateCredentials();
            req.setUserid(par.getIdentity().getUserid());
            req.setPassword(par.getIdentity().getPassword());
            HsmUtilsReturn ret = this.client.validateCredentials(null, this.selectedUrl, req);
            if (ret != null && ret.getCode() != null && ret.getCode().equals("0001") && alternateUrl != null) {
                ret = this.client.validateCredentials(null, alternateUrl, req);
                this.selectedUrl = alternateUrl;
            }
            if (ret == null || ret.getCode() == null || !ret.getCode().equals("0000")) {
                throw new CapiException("Hsm Failed To Logon", 2016);
            }
            HsmTokenCert req2 = new HsmTokenCert();
            req2.setUserid(par.getIdentity().getUserid());
            req2.setPassword(par.getIdentity().getPassword());
            HsmCertificate[] arrCert = this.client.tokenCert(null, this.selectedUrl, req2);
            if (arrCert != null) {
                for (HsmCertificate cert : arrCert) {
                    this.lstCert.put(cert.getId(), new String(Base64.encode((byte[])cert.getCertificate())));
                }
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public void finalizeLib() {
    }

    public String[] getLibInfo() {
        String tokenType = "Hsm Be Service Token";
        String libraryName = "";
        String libraryDescription = "Ellips Hsm Be Service Token";
        String libraryVersion = "1.0";
        String libraryManufacturer = "ArubaPEC S.p.A.";
        String slotDescription = "";
        String slotManufacturer = "ArubaPEC S.p.A.";
        String tokenModel = "";
        String tokenManufacturer = "ArubaPEC S.p.A.";
        return new String[]{tokenType, libraryName, libraryDescription, libraryVersion, libraryManufacturer, slotDescription, slotManufacturer, tokenModel, tokenManufacturer};
    }

    public String getLibName() {
        return null;
    }

    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    public String getLabel() throws CapiException {
        throw new CapiException("Ellips Hsm Be Service Token doesn't support retrieving key's information", 1004);
    }

    public String getSerialNumber() throws CapiException {
        return SERIAL_NUMBER;
    }

    public int getFreeSpace() throws CapiException {
        return -1;
    }

    public void changePIN(String oldPin, String newPin) throws CapiException {
        throw new CapiException("Ellips Hsm Be Service Token doesn't support PIN changing", 1004);
    }

    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        throw new CapiException("Ellips Hsm Be Service Token doesn't support PUK changing", 1004);
    }

    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("Ellips Hsm Be Service Token doesn't support unblocking", 1004);
    }

    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    public int getMinPINLen() throws CapiException {
        return 0;
    }

    public void openSession(boolean asSO, String pin) throws CapiException {
        if (this.sessionid == null) {
            HsmOpenSession req = new HsmOpenSession();
            req.setUserid(this.userid);
            req.setPassword(pin);
            HsmOpenSessionReturn ret = this.client.openSession(null, this.selectedUrl, req);
            if (ret == null || ret.getCode() == null || !ret.getCode().equals("0000")) {
                logger.error("cannot open session: " + (ret == null || ret.getCode() == null || !ret.getCode().equals("0000")));
                logger.error("return code : " + ret.getCode());
                throw new CapiException("Invalid Pin", 2016);
            }
            this.sessionid = ret.getSessionid();
            this.sessionPassword = pin;
        }
    }

    public void openSession(boolean asSO, String pin, int slot) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    public void openPublicSession() throws CapiException {
        this.public_session_open = true;
    }

    public void closeSession() throws CapiException {
        logger.debug("Closing session");
        this.sessionid = null;
        this.sessionPassword = null;
        this.public_session_open = false;
    }

    public boolean isSessionOpen() throws CapiException {
        return this.sessionid != null && !this.sessionid.isEmpty() || this.public_session_open;
    }

    public byte[] getData(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    public void setData(String alias, byte[] data, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    public String getCert(String alias) throws CapiException {
        if (this.lstCert.get(alias) != null) {
            return this.lstCert.get(alias);
        }
        return null;
    }

    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate cert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    public boolean canImport() {
        return false;
    }

    public boolean canExport(String alias) {
        return false;
    }

    public int canUnblock() {
        return 0;
    }

    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    public PrivateKey expCred(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    public PublicKey getPublicKey(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving public keys", 1004);
    }

    public PrivateKey getPrivateKey(String alias) throws CapiException {
        if (this.lstCert.get(alias) != null) {
            Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
            Certificate certf = new Certificate(Base64.decode((String)this.getCert(alias)));
            ret.setPublicInfo((PublicKey)((RSAPublicKey)certf.getInternalCert().getPublicKey()));
            ret.setCryptoDev((TokenSpi)this);
            return ret;
        }
        return null;
    }

    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public int getKeyLength(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        if (this.sessionid == null) {
            throw new CapiException("Session not opened", 10013);
        }
        HsmDecrypt req = new HsmDecrypt();
        req.setUserid(this.userid);
        req.setPassword(this.sessionPassword);
        req.setSessionid(this.sessionid);
        req.setByteToDecrypt(digest);
        HsmDecryptReturn ret = this.client.decrypt(null, this.selectedUrl, req);
        if (ret == null || ret.getCode() == null || !ret.getCode().equals("0000")) {
            logger.error("cannot decrypt: " + (ret == null || ret.getCode() == null || !ret.getCode().equals("0000")));
            logger.error("return code : " + ret.getCode());
            if (ret != null && ret.getCode() != null && ret.getCode().equals("0002")) {
                throw new CapiException("Internal Login", 2015);
            }
            throw new CapiException("Internal Error", 1003);
        }
        return ret.getDecryptedData();
    }

    public String[] listObjects(String expr, byte filter) throws CapiException {
        try {
            if (this.lstCert.size() > 0) {
                String[] res = new String[this.lstCert.size()];
                int i = 0;
                Iterator<String> i$ = this.lstCert.keySet().iterator();
                while (i$.hasNext()) {
                    String key;
                    res[i] = key = i$.next();
                }
                ++i;
                return res;
            }
            return new String[0];
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
    }

    public void deleteObject(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public byte getObjectType(String alias) throws CapiException {
        return 2;
    }

    public String getObjectID(String alias) throws CapiException {
        return alias;
    }

    public int getObjectSize(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void setCert(String alias, Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    public boolean exist(String alias) throws CapiException {
        for (String id : this.listObjects(null, (byte)2)) {
            if (!alias.equals(id)) continue;
            return true;
        }
        return false;
    }

    public String generateID(String[] args) {
        return this.userid;
    }

    public String[] getAuth_methods() {
        return null;
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(String alias, X500Name subject) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePasssword) throws CapiException {
        return new byte[0];
    }

    public boolean requiredExtendedAuth() {
        return false;
    }

    public RecoverySessionCredential openSessionWithExtendedAuth(boolean asSO, String pin, ExtendedCredentials cred) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resetToken(String puk) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

