/*
 * Decompiled with CFR 0.152.
 */
package esecurity.capi.hsmservice;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.capi.hsmservice.beans.HsmCertificate;
import esecurity.capi.hsmservice.beans.HsmCloseSession;
import esecurity.capi.hsmservice.beans.HsmDecrypt;
import esecurity.capi.hsmservice.beans.HsmDecryptReturn;
import esecurity.capi.hsmservice.beans.HsmOpenSession;
import esecurity.capi.hsmservice.beans.HsmOpenSessionReturn;
import esecurity.capi.hsmservice.beans.HsmSign;
import esecurity.capi.hsmservice.beans.HsmSignReturn;
import esecurity.capi.hsmservice.beans.HsmTokenCert;
import esecurity.capi.hsmservice.beans.HsmUtilsReturn;
import esecurity.capi.hsmservice.beans.HsmValidateCredentials;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import org.slf4j.Logger;

public class HsmLigthwareClient {
    private UrlClient client;
    private Logger logger;
    private ObjectMapper mapper = new ObjectMapper();

    public HsmLigthwareClient(UrlClient client, Logger logger) {
        this.client = client;
        this.logger = logger;
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public HsmCertificate[] tokenCert(URLCredentials creds, String baseUrl, HsmTokenCert request) {
        UrlReturn resCertId = null;
        try {
            RequestData rdate = new RequestData();
            rdate.setPostdata(this.mapper.writeValueAsBytes((Object)request));
            rdate.setType("JSON");
            resCertId = this.client.urlRequest(this.createUrl(baseUrl, "HsmBEService/webresources/hsmutils/token_certs"), "POST", rdate, creds);
            HsmCertificate[] certs = (HsmCertificate[])this.mapper.readValue(new String(resCertId.getData()), HsmCertificate[].class);
            return certs;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public HsmUtilsReturn validateCredentials(URLCredentials creds, String baseUrl, HsmValidateCredentials request) {
        HsmUtilsReturn objReturn = new HsmUtilsReturn();
        objReturn.setCode("0001");
        objReturn.setMsg("General Error");
        UrlReturn resCertId = null;
        try {
            RequestData rdate = new RequestData();
            rdate.setPostdata(this.mapper.writeValueAsBytes((Object)request));
            rdate.setType("JSON");
            resCertId = this.client.urlRequest(this.createUrl(baseUrl, "HsmBEService/webresources/hsmutils/validate_credentials"), "POST", rdate, creds);
            if (resCertId.getData() != null) {
                return (HsmUtilsReturn)this.mapper.readValue(new String(resCertId.getData()), HsmUtilsReturn.class);
            }
            objReturn.setMsg("Network Error");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    public HsmOpenSessionReturn openSession(URLCredentials creds, String baseUrl, HsmOpenSession request) {
        HsmOpenSessionReturn objReturn = new HsmOpenSessionReturn();
        objReturn.setCode("0001");
        objReturn.setMsg("General Error");
        UrlReturn resCertId = null;
        try {
            RequestData rdate = new RequestData();
            rdate.setPostdata(this.mapper.writeValueAsBytes((Object)request));
            rdate.setType("JSON");
            resCertId = this.client.urlRequest(this.createUrl(baseUrl, "HsmBEService/webresources/hsmutils/open_session"), "POST", rdate, creds);
            if (resCertId.getData() != null) {
                return (HsmOpenSessionReturn)this.mapper.readValue(new String(resCertId.getData()), HsmOpenSessionReturn.class);
            }
            objReturn.setMsg("Network Error");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    public HsmUtilsReturn closeSession(URLCredentials creds, String baseUrl, HsmCloseSession request) {
        HsmUtilsReturn objReturn = new HsmUtilsReturn();
        objReturn.setCode("0001");
        objReturn.setMsg("General Error");
        UrlReturn resCertId = null;
        try {
            RequestData rdate = new RequestData();
            rdate.setPostdata(this.mapper.writeValueAsBytes((Object)request));
            rdate.setType("JSON");
            resCertId = this.client.urlRequest(this.createUrl(baseUrl, "HsmBEService/webresources/hsmutils/close_session"), "POST", rdate, creds);
            if (resCertId.getData() != null) {
                return (HsmUtilsReturn)this.mapper.readValue(new String(resCertId.getData()), HsmUtilsReturn.class);
            }
            objReturn.setMsg("Network Error");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    public HsmSignReturn sign(URLCredentials creds, String baseUrl, HsmSign request) {
        HsmSignReturn objReturn = new HsmSignReturn();
        objReturn.setCode("0001");
        objReturn.setMsg("General Error");
        UrlReturn resCertId = null;
        try {
            RequestData rdate = new RequestData();
            rdate.setPostdata(this.mapper.writeValueAsBytes((Object)request));
            rdate.setType("JSON");
            resCertId = this.client.urlRequest(this.createUrl(baseUrl, "HsmBEService/webresources/hsmutils/sign"), "POST", rdate, creds);
            if (resCertId.getData() != null) {
                return (HsmSignReturn)this.mapper.readValue(new String(resCertId.getData()), HsmSignReturn.class);
            }
            objReturn.setMsg("Network Error");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    public HsmDecryptReturn decrypt(URLCredentials creds, String baseUrl, HsmDecrypt request) {
        HsmDecryptReturn objReturn = new HsmDecryptReturn();
        objReturn.setCode("0001");
        objReturn.setMsg("General Error");
        UrlReturn resCertId = null;
        try {
            RequestData rdate = new RequestData();
            rdate.setPostdata(this.mapper.writeValueAsBytes((Object)request));
            rdate.setType("JSON");
            resCertId = this.client.urlRequest(this.createUrl(baseUrl, "HsmBEService/webresources/hsmutils/decrypt"), "POST", rdate, creds);
            if (resCertId.getData() != null) {
                return (HsmDecryptReturn)this.mapper.readValue(new String(resCertId.getData()), HsmDecryptReturn.class);
            }
            objReturn.setMsg("Network Error");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    private String createUrl(String base, String path) {
        if (base.endsWith("/")) {
            return base + path;
        }
        return base + "/" + path;
    }
}

