/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.TokenHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OperatorStreamException;
import org.bouncycastle.operator.RuntimeOperatorException;

public class VerRsContentSignerBuilder {
    private SecureRandom random;
    private String signatureAlgorithm;
    private AlgorithmIdentifier sigAlgId;
    private Provider provider;

    public VerRsContentSignerBuilder(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(signatureAlgorithm);
    }

    public VerRsContentSignerBuilder setProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public VerRsContentSignerBuilder setProvider(String providerName) {
        this.provider = Security.getProvider(providerName);
        return this;
    }

    public VerRsContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(final PrivateKey privateKey) throws OperatorCreationException {
        return new ContentSigner(){
            private final ByteArrayOutputStream stream = new ByteArrayOutputStream();

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return VerRsContentSignerBuilder.this.sigAlgId;
            }

            public OutputStream getOutputStream() {
                this.stream.reset();
                return this.stream;
            }

            public byte[] getSignature() {
                try {
                    byte[] byte_to_sign = this.stream.toByteArray();
                    return TokenHelper.doVerifiedSignature((Actalis_PrivateKey)((Actalis_PrivateKey)privateKey), (byte[])byte_to_sign, (int)0);
                }
                catch (Throwable e) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                }
            }
        };
    }

    private static class SignatureOutputStream
    extends OutputStream {
        private final Signature sig;

        SignatureOutputStream(Signature sig) {
            this.sig = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.sig.update(bytes, off, len);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.sig.update(bytes);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new OperatorStreamException("exception in content signer: " + e.getMessage(), (Throwable)e);
            }
        }

        byte[] getSignature() throws SignatureException {
            return this.sig.sign();
        }
    }
}

