/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public class EncryptedEnvelope {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int DES_EDE3_CBC = 0;
    public static final int RC2_CBC = 1;
    public static final int AES256_CBC = 2;
    public static final int CAMELLIA256_CBC = 3;
    private int status = -1;
    private static final int ST_CREATE = 0;
    private static final int ST_CREATE_DATA = 1;
    private static final int ST_CIPH_ADDING = 2;
    private static final int ST_CIPH = 3;
    private static final int ST_PARSE = 4;
    private byte[] data = null;
    private byte[] decryptedContent = null;
    CMSEnvelopedDataGenerator fact = null;
    protected CMSEnvelopedData envelopedData = null;
    protected String contentEA = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
    static boolean debug = false;

    public EncryptedEnvelope() throws CapiException {
        this.status = 0;
        this.contentEA = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
        logger.debug("data encryption algorithm set to DES_EDE3_CBC");
        this.envelopedData = null;
    }

    public EncryptedEnvelope(int mode) throws CapiException {
        this.status = 0;
        if (mode == 3) {
            this.contentEA = CMSEnvelopedDataGenerator.CAMELLIA256_CBC;
            logger.debug("Content encryption algorithm set to CAMELLIA256_CBC");
            this.envelopedData = null;
            return;
        }
        if (mode == 2) {
            this.contentEA = CMSEnvelopedDataGenerator.AES256_CBC;
            logger.debug("Content encryption algorithm set to AES256_CBC");
            this.envelopedData = null;
            return;
        }
        if (mode == 1) {
            this.contentEA = CMSEnvelopedDataGenerator.RC2_CBC;
            logger.debug("Content encryption algorithm set to RC2_CBC");
            this.envelopedData = null;
            return;
        }
        if (mode == 0) {
            this.contentEA = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
            logger.debug("Content encryption algorithm set to DES_EDE3_CBC");
            this.envelopedData = null;
            return;
        }
        throw new CapiException("Supplied mode is invalid", 1002);
    }

    public void setData(byte[] data) throws CapiException {
        if (this.status > 1) {
            throw new CapiException("Not allowed if recipient(s) already set or ciphered", 51002);
        }
        if (data == null) {
            throw new CapiException("Null data", 1001);
        }
        this.data = Arrays.copyOf((byte[])data, (int)data.length);
        this.status = 1;
    }

    public void addRecipient(byte[] certificate) throws CapiException {
        X509Certificate x509cert = new Certificate(certificate).getInternalCert();
        this.addRecipient(x509cert);
    }

    public void addRecipient(byte[] certificate, boolean useSubjKeyId) throws CapiException {
        Certificate capicer = new Certificate(certificate);
        X509Certificate x509cert = capicer.getInternalCert();
        if (x509cert == null) {
            throw new CapiException("No certificate", 30005);
        }
        if (!useSubjKeyId) {
            this.addRecipient(x509cert);
            return;
        }
        byte[] skid = capicer.getSubjectKeyIdentifier();
        if (skid == null || skid.length <= 0) {
            throw new CapiException("Missing Extension Subject Key Identifier", 30006);
        }
        this.addRecipient(x509cert, skid);
    }

    public void addRecipientFromToken(TokenSpi tk, String alias) throws CapiException {
        byte[] cert = null;
        try {
            logger.debug("[addRecipientFromToken] getting credential...");
            cert = Util.getBytes((String)tk.getCert(alias));
            logger.debug("[addRecipientFromToken] getting credential ok");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        this.addRecipient(cert);
    }

    public String getEncoded() throws CapiException {
        if (this.status < 2) {
            throw new CapiException("Recipient(s) must be set before", 51001);
        }
        if (this.status == 4 || this.status == 3) {
            throw new CapiException("Cannot ciphered", 51002);
        }
        byte[] enc = null;
        try {
            logger.debug("Creating envelopedData ...");
            if (this.envelopedData != null) {
                throw new CapiException("Why envelopedData not null ?", 51002);
            }
            if (this.fact == null) {
                throw new CapiException("Factory is null ?", 51002);
            }
            JceCMSContentEncryptorBuilder cEncB = new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(this.contentEA));
            cEncB.setProvider(ProvUtils.bcProvider);
            this.envelopedData = this.fact.generate((CMSTypedData)new CMSProcessableByteArray(this.data), cEncB.build());
            enc = this.envelopedData.getEncoded();
            if (enc == null) {
                throw new CapiException("Encoding error during ciphering", 50022);
            }
            logger.debug("DOPO getEncoded ...");
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Encoding error", 50022);
        }
        catch (CapiError err) {
            logger.debug(err.getMessage(), (Throwable)err);
            throw err.getCapiException();
        }
        try {
            ContentInfo ci = ContentInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])enc));
            StringWriter strWriter = new StringWriter();
            PEMWriter pemWriter = new PEMWriter((Writer)strWriter);
            pemWriter.writeObject((Object)ci);
            pemWriter.close();
            String temp = new String(strWriter.getBuffer());
            return temp;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error encoding encrypted envelope", 50022);
        }
    }

    private void loadB64orPEMEnvelope(byte[] encoded) throws CapiException {
        try {
            logger.debug("trying Base64 decode ... ");
            byte[] derByte = Util.base64Decode((byte[])encoded);
            this.envelopedData = new CMSEnvelopedData((InputStream)new ByteArrayInputStream(derByte));
        }
        catch (Exception e) {
            PEMParser pemParser = new PEMParser((Reader)new StringReader(new String(encoded)));
            try {
                logger.debug("not Base64, trying PEM Tagged format  ... ");
                ContentInfo cInfo = (ContentInfo)pemParser.readObject();
                if (cInfo == null) {
                    throw new CapiException("Envelope format unknown or not implemented", 50021);
                }
                if (!cInfo.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.envelopedData)) {
                    throw new CapiException("Not a valid enveloped-data object - wrong header " + cInfo.getContentType().getId(), 50021);
                }
                this.envelopedData = new CMSEnvelopedData(cInfo);
            }
            catch (Exception e1) {
                logger.debug(e1.getMessage(), (Throwable)e1);
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
        }
    }

    public EncryptedEnvelope(String encoded) throws CapiException {
        this.status = 4;
        if (encoded == null) {
            throw new CapiException("Null data", 1001);
        }
        this.loadB64orPEMEnvelope(encoded.getBytes());
        if (this.envelopedData == null) {
            logger.debug("null envelopedData");
            throw new CapiException("Internal error", 50050);
        }
        logger.debug("parsed ok");
        logger.debug("Getting information about ECI...");
        String contentTypeOID = this.envelopedData.toASN1Structure().getContentType().getId();
        logger.debug("Content type: " + contentTypeOID);
        logger.debug("Content encryption algorithm: " + this.envelopedData.getEncryptionAlgOID() + " (" + EncryptedEnvelope.getContentEncryptionAlgName(this.envelopedData.getEncryptionAlgOID()) + ")");
    }

    public static String getContentEncryptionAlgName(String oid) {
        if (oid.trim().equals(CMSEnvelopedDataGenerator.CAMELLIA256_CBC)) {
            return "CAMELLIA256_CBC";
        }
        if (oid.trim().equals(CMSEnvelopedDataGenerator.AES256_CBC)) {
            return "AES256_CBC";
        }
        if (oid.trim().equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC)) {
            return "DES_EDE3_CBC";
        }
        if (oid.trim().equals(CMSEnvelopedDataGenerator.RC2_CBC)) {
            return "RC2_CBC";
        }
        return null;
    }

    public EncryptedEnvelope(byte[] encoded) throws CapiException {
        this.status = 4;
        if (encoded == null) {
            throw new CapiException("Null data", 1001);
        }
        try {
            this.envelopedData = new CMSEnvelopedData((InputStream)new ByteArrayInputStream(encoded));
            logger.debug("DER format");
        }
        catch (CMSException cmse) {
            this.loadB64orPEMEnvelope(encoded);
        }
        if (this.envelopedData == null) {
            logger.debug("null envelopedData");
            throw new CapiException("Internal error", 50050);
        }
        logger.debug("parsed ok");
        logger.debug("Getting information about ECI...");
        String contentTypeOID = this.envelopedData.toASN1Structure().getContentType().getId();
        logger.debug("Content type: " + contentTypeOID);
        logger.debug("Content encryption algorithm: " + this.envelopedData.getEncryptionAlgOID());
    }

    public String getEncryptionAlgorithm() {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return this.contentEA;
        }
        return this.envelopedData.getEncryptionAlgOID();
    }

    public String[] listRecipients(String separator) throws CapiException {
        if (this.envelopedData == null) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        try {
            logger.debug("getting recipients...");
            RecipientInformationStore rec_infos = this.envelopedData.getRecipientInfos();
            Collection recColl = rec_infos.getRecipients();
            Vector recVector = new Vector(recColl);
            logger.debug("recipients are " + recVector.size());
            String[] res = new String[recVector.size()];
            for (int i = 0; i < recVector.size(); ++i) {
                RecipientInformation ri = (RecipientInformation)recVector.elementAt(i);
                KeyTransRecipientId ktri = (KeyTransRecipientId)ri.getRID();
                res[i] = ktri.getSerialNumber().toString() + separator + ktri.getIssuer().toString();
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    public byte[] decrypt(TokenSpi tk, String alias) throws CapiException {
        if (this.status < 3) {
            throw new CapiException("Data must be encrypted before", 51001);
        }
        X509Certificate cert = null;
        PrivateKey privKey = null;
        try {
            logger.debug("[decrypt] getting credential from token...");
            String pemcert = tk.getCert(alias);
            if (pemcert == null) {
                throw new CapiException("alias not found", 51010);
            }
            Certificate capicer = new Certificate(Util.getBytes((String)pemcert));
            cert = capicer.getInternalCert();
            logger.debug("...cert ok");
            KeyTransRecipientId recId = new KeyTransRecipientId(JcaX500NameUtil.getIssuer((X509Certificate)cert), cert.getSerialNumber());
            RecipientInformationStore rec_infos = this.envelopedData.getRecipientInfos();
            KeyTransRecipientInformation recipient = (KeyTransRecipientInformation)rec_infos.get((RecipientId)recId);
            if (recipient != null) {
                logger.debug("[decrypt] recipient  Issuer and Serial number match token alias certificate");
            } else {
                logger.debug("[decrypt] try using subject key identifier...");
                byte[] skid = capicer.getSubjectKeyIdentifier();
                if (skid == null || skid.length == 0) {
                    throw new CapiException("Token alias certificate not match", 51010);
                }
                recId = new KeyTransRecipientId(skid);
                recipient = (KeyTransRecipientInformation)rec_infos.get((RecipientId)recId);
                if (recipient != null) {
                    logger.debug("[decrypt] recipient SubjectKeyIdentifier match token alias certificate");
                } else {
                    throw new CapiException("Token alias certificate not match", 51010);
                }
            }
            privKey = tk.getPrivateKey(alias);
            String contentEncAlg = this.envelopedData.getEncryptionAlgOID();
            if (contentEncAlg.equalsIgnoreCase(CMSEnvelopedDataGenerator.DES_EDE3_CBC)) {
                logger.debug("[decrypt] content encryption algorithm is DES_EDE3_CBC");
            } else if (contentEncAlg.equalsIgnoreCase(CMSEnvelopedDataGenerator.RC2_CBC)) {
                logger.debug("[decrypt] content encryption algorithm is RC2_CBC");
            } else {
                logger.debug("[decrypt] content encryption algorithm is " + contentEncAlg);
            }
            JceKeyTransEnvelopedRecipient jceR = new JceKeyTransEnvelopedRecipient(privKey);
            jceR.setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privKey));
            jceR.setContentProvider(ProvUtils.bcProvider);
            this.decryptedContent = recipient.getContent((Recipient)jceR);
            logger.debug("decrypt done.");
            return Arrays.copyOf((byte[])this.decryptedContent, (int)this.decryptedContent.length);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        catch (CapiError err) {
            logger.debug(err.getMessage(), (Throwable)err);
            throw err.getCapiException();
        }
    }

    public byte[] decryptAS(String alias, String PIN) throws CapiException {
        throw new CapiException("unsupported token type", 1003);
    }

    public byte[] getData() {
        if (this.status == 0 || this.status == 1 || this.status == 2) {
            return Arrays.copyOf((byte[])this.data, (int)this.data.length);
        }
        return Arrays.copyOf((byte[])this.decryptedContent, (int)this.decryptedContent.length);
    }

    public String toString() {
        try {
            switch (this.status) {
                case 0: 
                case 1: {
                    return "Envelope not ciphered yet";
                }
                case 3: 
                case 4: {
                    return this.envelopedData.toString();
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return this.getClass().getName();
    }

    private void addRecipient(X509Certificate x509Cert, byte[] subjectKeyIdentifier) throws CapiException {
        if (this.status < 1) {
            throw new CapiException("Data must be set before", 50000);
        }
        if (this.status == 4 || this.status == 3) {
            throw new CapiException("Cannot add recipient", 51002);
        }
        logger.debug("adding Recipient ...");
        try {
            if (this.status != 2) {
                this.fact = new CMSEnvelopedDataGenerator();
            }
            JceKeyTransRecipientInfoGenerator rgen = null;
            if (subjectKeyIdentifier != null) {
                logger.debug("Recipient subjectkeyidentifier ...");
                rgen = new JceKeyTransRecipientInfoGenerator(subjectKeyIdentifier, x509Cert.getPublicKey());
            } else {
                logger.debug("Recipient Issuer and Serial number ...");
                rgen = new JceKeyTransRecipientInfoGenerator(x509Cert);
            }
            this.fact.addRecipientInfoGenerator((RecipientInfoGenerator)rgen.setProvider(ProvUtils.bcProvider));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        logger.debug("Recipient added.");
        this.status = 2;
    }

    private void addRecipient(X509Certificate x509Cert) throws CapiException {
        this.addRecipient(x509Cert, null);
    }
}

