/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.utils;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;

public class CapiProcess {
    private Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String executablePath = "";
    private String parameters = "";
    private WinNT.HANDLE processHandle;
    private Process process;

    public CapiProcess(String executablePath, List<String> parameters) {
        this.executablePath = executablePath.trim();
        for (String p : parameters) {
            this.parameters = this.parameters + p + " ";
        }
        if (Platform.isWindows()) {
            this.logger.info("Windows process " + this.executablePath + " " + this.parameters);
        } else if (Platform.isLinux()) {
            this.logger.info("Unix process " + this.executablePath + " " + this.parameters);
        } else if (Platform.isMac()) {
            this.logger.info("OSX process " + this.executablePath + " " + this.parameters);
        }
    }

    public CapiProcess(String executablePath, String parameters) {
        this.executablePath = executablePath.trim();
        this.parameters = parameters.trim();
        if (Platform.isWindows()) {
            this.logger.info("Windows process " + this.executablePath + " " + this.parameters);
        } else if (Platform.isLinux()) {
            this.logger.info("Unix process " + this.executablePath + " " + this.parameters);
        } else if (Platform.isMac()) {
            this.logger.info("OSX process " + this.executablePath + " " + this.parameters);
        }
    }

    public boolean start() {
        if (Platform.isWindows()) {
            return this.startWindowsProcess();
        }
        if (Platform.isLinux()) {
            return this.startUnixProcess();
        }
        if (Platform.isMac()) {
            return this.startOSXProcess();
        }
        return false;
    }

    private boolean startWindowsProcess() {
        WinBase.PROCESS_INFORMATION info = new WinBase.PROCESS_INFORMATION();
        boolean success = Kernel32.INSTANCE.CreateProcess(this.executablePath, " " + this.parameters, null, null, false, new WinDef.DWORD(0L), null, this.executablePath.substring(0, this.executablePath.lastIndexOf("\\")), new WinBase.STARTUPINFO(), info);
        this.processHandle = info.hProcess;
        return success;
    }

    private boolean startUnixProcess() {
        try {
            this.process = Runtime.getRuntime().exec(this.executablePath + " " + this.parameters);
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean startOSXProcess() {
        try {
            this.process = Runtime.getRuntime().exec(this.executablePath + " " + this.parameters);
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public int startAndWait() {
        if (Platform.isWindows()) {
            return this.startAndWaitWindowsProcess();
        }
        if (Platform.isLinux()) {
            return this.startAndWaitUnixProcess();
        }
        if (Platform.isMac()) {
            return this.startAndWaitOSXProcess();
        }
        return -3;
    }

    private int startAndWaitWindowsProcess() {
        WinBase.PROCESS_INFORMATION info = new WinBase.PROCESS_INFORMATION();
        Kernel32.INSTANCE.CreateProcess(this.executablePath, " " + this.parameters, null, null, false, new WinDef.DWORD(0L), null, this.executablePath.substring(0, this.executablePath.lastIndexOf("\\")), new WinBase.STARTUPINFO(), info);
        return Kernel32.INSTANCE.WaitForSingleObject(info.hProcess, -1);
    }

    private int startAndWaitUnixProcess() {
        int returnCode = 0;
        try {
            this.process = Runtime.getRuntime().exec(this.executablePath + " " + this.parameters);
            returnCode = this.process.waitFor();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return -1;
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return -2;
        }
        return returnCode;
    }

    private int startAndWaitOSXProcess() {
        int returnCode = 0;
        try {
            this.process = Runtime.getRuntime().exec(this.executablePath + " " + this.parameters);
            returnCode = this.process.waitFor();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return -1;
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return -2;
        }
        return returnCode;
    }

    public WinNT.HANDLE getProcessHandle() {
        return this.processHandle;
    }

    public int closeProcess() {
        if (Platform.isWindows()) {
            return this.closeWindowsProcess();
        }
        if (Platform.isLinux()) {
            return this.closeUnixProcess();
        }
        if (Platform.isMac()) {
            return this.closeOSXProcess();
        }
        return -1;
    }

    private int closeWindowsProcess() {
        Kernel32.INSTANCE.TerminateProcess(this.processHandle, 0);
        int error = Kernel32.INSTANCE.GetLastError();
        if (error != 0) {
            this.logger.error("Error " + error);
        }
        return error;
    }

    private int closeUnixProcess() {
        this.process.destroy();
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return -1;
        }
    }

    private int closeOSXProcess() {
        this.process.destroy();
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return -1;
        }
    }
}

