/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.utils;

import com.sun.jna.Platform;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.CapiProcess;
import it.arubapec.ca.utils.CompilationOption;
import it.arubapec.ca.utils.ProcessHandler;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import org.slf4j.Logger;

public class ApplicationUtils {
    public static boolean bLogEnabled = true;
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static String getAppPath() {
        if (CompilationOption.test && CompilationOption.testUpdatePath != null) {
            return CompilationOption.testUpdatePath;
        }
        String strReturn = "";
        String customBaseDir = System.getProperty("launcher.ArubaSign.custom.basedir");
        if (bLogEnabled) {
            logger.debug("launcher.ArubaSign.custom.basedir=" + customBaseDir);
        }
        if (customBaseDir == null || customBaseDir.isEmpty()) {
            String strPathTmp = ApplicationUtils.class.getResource(ApplicationUtils.class.getSimpleName() + ".class").getPath();
            strReturn = ApplicationUtils.getAppPathByClassUrl(strPathTmp);
        } else {
            strReturn = customBaseDir;
        }
        return strReturn;
    }

    public static String getAppPath(String appName) {
        if (appName == null || appName.isEmpty()) {
            return ApplicationUtils.getAppPath();
        }
        if (CompilationOption.test && CompilationOption.testUpdatePath != null) {
            return CompilationOption.testUpdatePath;
        }
        String propName = "launcher." + appName + ".custom.basedir";
        String customBaseDir = System.getProperty(propName);
        if (bLogEnabled) {
            logger.info(propName + "=" + customBaseDir);
        }
        if (customBaseDir == null || customBaseDir.isEmpty()) {
            return ApplicationUtils.getAppPath();
        }
        return customBaseDir;
    }

    public static String getAppPathByClassUrl(String strPathTmp) {
        String strReturn;
        block9: {
            strReturn = "";
            if (strPathTmp.contains(".jar!")) {
                try {
                    if (bLogEnabled) {
                        logger.debug(strPathTmp);
                    }
                    strPathTmp = URLDecoder.decode(strPathTmp, "UTF8");
                    if (bLogEnabled) {
                        logger.debug("Decode:" + strPathTmp);
                    }
                    strPathTmp = strPathTmp.substring(0, strPathTmp.indexOf(".jar!"));
                    strPathTmp = strPathTmp.substring(0, strPathTmp.lastIndexOf(47));
                    strPathTmp = strPathTmp.substring(0, strPathTmp.lastIndexOf(47));
                    strPathTmp = Platform.isWindows() ? strPathTmp.substring(6) : strPathTmp.substring(5);
                    if (bLogEnabled) {
                        logger.debug("Parsato:" + strPathTmp);
                    }
                    strReturn = strPathTmp;
                    if (bLogEnabled) {
                        logger.debug("Return:" + strReturn);
                    }
                    break block9;
                }
                catch (Exception ex) {
                    if (bLogEnabled) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    break block9;
                }
            }
            if (bLogEnabled) {
                logger.info("Path non valido " + strPathTmp);
            }
        }
        return strReturn;
    }

    public static List<Integer> closeAll() {
        return ProcessHandler.closeAllProcess();
    }

    public static void openFileWithDefProgram(String path) throws IOException {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(new File(path));
        } else {
            logger.error("Desktop not supported");
        }
    }

    public static void launch(String cmd, String parameter, boolean closeOnExit) throws IOException {
        CapiProcess process = new CapiProcess(cmd, parameter);
        if (closeOnExit) {
            ProcessHandler.addProcess(process);
        }
        process.start();
    }

    public static void launch(String cmd, List<String> parameter, boolean closeOnExit) throws IOException {
        CapiProcess process = new CapiProcess(cmd, parameter);
        if (closeOnExit) {
            ProcessHandler.addProcess(process);
        }
        process.start();
    }

    public static boolean runningOnJava6() {
        String strVersion = System.getProperty("java.version");
        return strVersion.startsWith("1.6");
    }
}

