/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.utils;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Utils {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String enchar = "ISO8859_1";

    public static Date getSigningDateFromTStamp(byte[] ts) {
        if (ts == null) {
            return null;
        }
        try {
            TimeStampToken tst = new TimeStampToken(ts);
            return Utils.getSigningDateFromTStamp(tst);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getSigningDateFromTStamp(TimeStampToken tst) {
        if (tst == null) {
            return null;
        }
        try {
            String time = tst.getTimeStamp();
            TimeZone tz = TimeZone.getTimeZone("GMT");
            SimpleDateFormat tstDF = new SimpleDateFormat("yyyyMMddHHmmss");
            tstDF.setTimeZone(tz);
            return tstDF.parse(time.trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDigestAlgorithmValid(String digestAlgorithm, Calendar signingDate) {
        String digestAlgorithmToVerify = digestAlgorithm.toLowerCase().replace("-", "");
        if (digestAlgorithmToVerify.contains("sha256")) {
            return true;
        }
        Calendar currentDate = Calendar.getInstance();
        return currentDate.before(Constants.CNIPA45_THRESHOLD_DATE) || signingDate.before(Constants.CNIPA45_THRESHOLD_DATE);
    }

    public static String getFilename(String[] txtList) {
        String txt = "";
        String filename = "";
        for (int i = 0; i < txtList.length; ++i) {
            txt = txt + txtList[i];
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider);
            sha1.reset();
            sha1.update(txt.getBytes());
            byte[] crpDigested = sha1.digest();
            for (int k = 0; k < crpDigested.length; ++k) {
                filename = filename.concat(Utils.byteToHex(crpDigested[k]));
            }
            filename = filename.toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            filename = "";
        }
        return filename;
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String splice(String[] values) {
        String result = "";
        for (int i = 0; i < values.length; ++i) {
            result = result + values[i] + "~";
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    public static String parseXMLDate(String dateString) {
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        try {
            Date date = df1.parse(dateString);
            dateString = df2.format(date);
            return dateString;
        }
        catch (ParseException e) {
            return dateString;
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static void inputStreamToOutputStream(InputStream is, OutputStream os) throws IOException {
        int nRead;
        byte[] data = new byte[4096];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            os.write(data, 0, nRead);
        }
        os.flush();
    }

    public static String getFileName(String filename) {
        if (filename.indexOf("/") >= 0) {
            return filename.substring(filename.lastIndexOf("/") + 1, filename.length());
        }
        if (filename.indexOf("\\") >= 0) {
            return filename.substring(filename.lastIndexOf("\\") + 1, filename.length());
        }
        return filename;
    }

    public static String signatureToString(byte[] hash) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String s;
            int b = hash[i];
            if (b < 0) {
                b += 256;
            }
            if ((s = Integer.toHexString(b)).length() % 2 != 0) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String calculateDigest(InputStream inputStream, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        int bytesRead;
        if (digestAlgorithm == null || digestAlgorithm.equalsIgnoreCase("")) {
            digestAlgorithm = "SHA-256";
        }
        MessageDigest digestEngine = MessageDigest.getInstance(digestAlgorithm, ProvUtils.bcProvider);
        byte[] dataBuffer = new byte[4096];
        while ((bytesRead = inputStream.read(dataBuffer)) >= 0) {
            digestEngine.update(dataBuffer, 0, bytesRead);
        }
        byte[] contentHash = digestEngine.digest();
        return Utils.signatureToString(contentHash);
    }

    public static String calculateDigest(InputStream inputStream, OutputStream outputStream, String digestAlgorithm) throws VolException {
        try {
            int bytesRead;
            if (digestAlgorithm == null || digestAlgorithm.equalsIgnoreCase("")) {
                digestAlgorithm = "SHA-256";
            }
            MessageDigest digestEngine = MessageDigest.getInstance(digestAlgorithm);
            byte[] dataBuffer = new byte[4096];
            while ((bytesRead = inputStream.read(dataBuffer)) >= 0) {
                outputStream.write(dataBuffer, 0, bytesRead);
                digestEngine.update(dataBuffer, 0, bytesRead);
            }
            outputStream.flush();
            byte[] contentHash = digestEngine.digest();
            return Utils.signatureToString(contentHash);
        }
        catch (Exception e) {
            throw new VolException(e);
        }
    }

    public static String retrieveCommonName(String distinguishedName) {
        try {
            X509Principal x509principal = new X509Principal(distinguishedName);
            Vector v = x509principal.getValues(new ASN1ObjectIdentifier("2.5.4.3"));
            if (v.size() > 0) {
                return (String)v.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return distinguishedName;
    }

    public static String base64Encode(String msg) {
        return new String(Base64.encode((byte[])msg.getBytes()));
    }

    public static byte[] base64DecodeStr(String data) throws CapiException {
        if (data == null) {
            return null;
        }
        return Base64.decode((String)data);
    }

    public static byte[] base64Encode(byte[] data) {
        if (data == null) {
            return null;
        }
        return Base64.encode((byte[])data);
    }

    public static String newString(byte[] b) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b, enchar);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String base64EncodeStr(byte[] data) {
        if (data == null) {
            return null;
        }
        return Utils.newString(Utils.base64Encode(data));
    }

    public static String getNewId() {
        return String.valueOf(Util.secureRandom.nextInt(10000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPdf(String inputFilePath) {
        if (inputFilePath.isEmpty()) {
            return false;
        }
        File f = new File(inputFilePath);
        if (!f.exists()) {
            return false;
        }
        boolean bRet = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            byte[] data = new byte[5];
            int nRead = fis.read(data, 0, data.length);
            if (nRead != -1) {
                String str = new String(data);
                bRet = str.startsWith("%FDF-") || str.startsWith("%PDF-");
            }
        }
        catch (IOException e) {
            bRet = false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkXml(File inputFile) {
        if (inputFile == null) {
            return false;
        }
        if (!inputFile.exists()) {
            return false;
        }
        boolean bRet = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(inputFile);
            bRet = Utils.checkXml(fis);
        }
        catch (IOException ex) {
            bRet = false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkXml(FileInputStream fis) {
        if (fis == null) {
            return false;
        }
        boolean bRet = false;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                    throw exception;
                }
            });
            Document doc = builder.parse(fis);
            bRet = true;
        }
        catch (SAXException e) {
            bRet = false;
        }
        catch (ParserConfigurationException e) {
            bRet = false;
        }
        catch (IOException e) {
            bRet = false;
        }
        return bRet;
    }

    public static int translateReasonToRevocation(String rcAsString) {
        if (rcAsString == null || rcAsString.equalsIgnoreCase("")) {
            return 0;
        }
        if (rcAsString.equals("AffiliationChanged")) {
            return 3;
        }
        if (rcAsString.equals("CACompromise")) {
            return 2;
        }
        if (rcAsString.equals("CertificateHold")) {
            return 6;
        }
        if (rcAsString.equals("CessationOfOperation")) {
            return 5;
        }
        if (rcAsString.equals("KeyCompromise")) {
            return 1;
        }
        if (rcAsString.equals("RemoveFromCRL")) {
            return 8;
        }
        if (rcAsString.equals("Superseded")) {
            return 4;
        }
        if (rcAsString.equals("Unspecified")) {
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile, boolean replace) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        } else if (replace) {
            destFile.delete();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String oidToHashAlgName(String id) {
        if (id == null) {
            return "";
        }
        if (id.equals("1.3.14.3.2.26")) {
            return DigestAlgorithm.SHA1.name();
        }
        if (id.equals("1.2.840.11359.2.5")) {
            return DigestAlgorithm.MD5.name();
        }
        if (id.equals("2.16.840.1.101.3.4.2.1")) {
            return DigestAlgorithm.SHA256.name();
        }
        return id;
    }

    public static String hashAlgNameToOid(String name) {
        if (name.equalsIgnoreCase("SHA-1") || name.equalsIgnoreCase(Constants.SHA1)) {
            return DigestAlgorithm.SHA1.getId();
        }
        if (name.equalsIgnoreCase("MD5")) {
            return DigestAlgorithm.MD5.getId();
        }
        if (name.equalsIgnoreCase("SHA-256") || name.equalsIgnoreCase(Constants.SHA256)) {
            return DigestAlgorithm.SHA256.getId();
        }
        return name;
    }
}

