/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.parser.SignerInfoDataParser;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignatureTransform;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import esecurity.validator.xades.bean.XadesSigningCertificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XadesSignerInfoDataParser
extends SignerInfoDataParser {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SignerInfoData parse(byte[] rawSignature) {
        XadesSignerInfoData objReturn = null;
        try {
            Element certificateValues;
            Element unsignedPropsElem;
            Element sigMethod;
            objReturn = new XadesSignerInfoData();
            Document xmlSi = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(rawSignature));
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            Element canonMethod = (Element)xpath.evaluate("/Signature/SignedInfo/CanonicalizationMethod", xmlSi.getDocumentElement(), XPathConstants.NODE);
            if (canonMethod != null) {
                String id = canonMethod.getAttribute("Algorithm");
                objReturn.setCanonicalizationMethod(id);
            }
            if ((sigMethod = (Element)xpath.evaluate("/Signature/SignedInfo/SignatureMethod", xmlSi.getDocumentElement(), XPathConstants.NODE)) != null) {
                String id = sigMethod.getAttribute("Algorithm");
                objReturn.setSignatureMethod(id);
            }
            NodeList nl = (NodeList)xpath.evaluate("/Signature/SignedInfo/Reference", xmlSi.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element transformsElem;
                Element digValue;
                Element digMethod;
                XadesSignatureReference ref = new XadesSignatureReference();
                Element refElem = (Element)nl.item(i);
                if (refElem.hasAttribute("URI")) {
                    ref.setURI(refElem.getAttribute("URI"));
                }
                if (refElem.hasAttribute("Type")) {
                    ref.setType(refElem.getAttribute("Type"));
                }
                if ((digMethod = (Element)xpath.evaluate("./DigestMethod", refElem, XPathConstants.NODE)) != null) {
                    String id = digMethod.getAttribute("Algorithm");
                    ref.setDigestMethodAlgorithm(id);
                }
                if ((digValue = (Element)xpath.evaluate("./DigestValue", refElem, XPathConstants.NODE)) != null) {
                    String value = digValue.getTextContent();
                    ref.setDigestValue(Base64.decode((String)value));
                }
                if ((transformsElem = (Element)xpath.evaluate("./Transforms", refElem, XPathConstants.NODE)) != null) {
                    NodeList nl3 = (NodeList)xpath.evaluate("./Transform", transformsElem, XPathConstants.NODESET);
                    for (int j = 0; j < nl3.getLength(); ++j) {
                        Element transformElem = (Element)nl3.item(j);
                        XadesSignatureTransform xst = new XadesSignatureTransform();
                        if (transformElem.hasAttribute("Algorithm")) {
                            xst.setAlgorithm(transformElem.getAttribute("Algorithm"));
                        }
                        ref.getTransforms().add(xst);
                    }
                }
                objReturn.getReferences().add(ref);
            }
            Element signatureValue = (Element)xpath.evaluate("/Signature/SignatureValue", xmlSi.getDocumentElement(), XPathConstants.NODE);
            objReturn.setSignatureValue(signatureValue.getTextContent().replace("\r", "").replace("\n", "").trim());
            Element qualifPropsRefElem = (Element)xpath.evaluate("/Signature/Object/QualifyingPropertiesReference", xmlSi.getDocumentElement(), XPathConstants.NODE);
            Element signedPropsElem = (Element)xpath.evaluate("/Signature/Object/QualifyingProperties/SignedProperties", xmlSi.getDocumentElement(), XPathConstants.NODE);
            if (signedPropsElem != null) {
                objReturn.setHasSignedProperties(true);
                objReturn.setSignedPropsId(signedPropsElem.getAttribute("Id"));
                Element signedSignatureProperties = (Element)xpath.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties", xmlSi.getDocumentElement(), XPathConstants.NODE);
                if (signedSignatureProperties != null) {
                    Element sigPolicyIdElem;
                    Element signingCertificateElemV2;
                    String digestValue;
                    Element signingCertificateElem;
                    Element signingTimeElem = (Element)xpath.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SigningTime", xmlSi.getDocumentElement(), XPathConstants.NODE);
                    if (signingTimeElem != null) {
                        String signingTimeStr = signingTimeElem.getFirstChild().getNodeValue();
                        try {
                            DatatypeFactory.newInstance().newXMLGregorianCalendar(signingTimeStr).toGregorianCalendar();
                            objReturn.setHasSigningTime(true);
                        }
                        catch (Exception nl3) {
                            // empty catch block
                        }
                    }
                    if ((signingCertificateElem = (Element)xpath.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SigningCertificate", xmlSi.getDocumentElement(), XPathConstants.NODE)) != null) {
                        NodeList nl2 = (NodeList)xpath.evaluate("./Cert", signingCertificateElem, XPathConstants.NODESET);
                        for (int k = 0; k < nl2.getLength(); ++k) {
                            Element certElem = (Element)nl2.item(k);
                            if (certElem == null) continue;
                            try {
                                XadesSigningCertificate signingCert = new XadesSigningCertificate();
                                Element digestMethodElem = (Element)xpath.evaluate("./CertDigest/DigestMethod", certElem, XPathConstants.NODE);
                                Element digestValueElem = (Element)xpath.evaluate("./CertDigest/DigestValue", certElem, XPathConstants.NODE);
                                Element issuerNameElem = (Element)xpath.evaluate("./IssuerSerial/X509IssuerName", certElem, XPathConstants.NODE);
                                Element serialNumberElem = (Element)xpath.evaluate("./IssuerSerial/X509SerialNumber", certElem, XPathConstants.NODE);
                                if (digestMethodElem.hasAttribute("Algorithm")) {
                                    signingCert.setDigestMethod(digestMethodElem.getAttribute("Algorithm"));
                                }
                                if ((digestValue = digestValueElem.getTextContent()) != null) {
                                    digestValue = digestValue.trim();
                                }
                                signingCert.setDigestValue(digestValue);
                                signingCert.setIssuerName(issuerNameElem.getTextContent());
                                signingCert.setSerialNumber(new BigInteger(serialNumberElem.getTextContent()));
                                signingCert.setVersion(1);
                                objReturn.getSigningCertificates().add(signingCert);
                                continue;
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }
                    if ((signingCertificateElemV2 = (Element)xpath.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SigningCertificateV2", xmlSi.getDocumentElement(), XPathConstants.NODE)) != null) {
                        NodeList nl2 = (NodeList)xpath.evaluate("./Cert", signingCertificateElemV2, XPathConstants.NODESET);
                        for (int k = 0; k < nl2.getLength(); ++k) {
                            Element certElem = (Element)nl2.item(k);
                            if (certElem == null) continue;
                            try {
                                XadesSigningCertificate signingCert = new XadesSigningCertificate();
                                Element digestMethodElem = (Element)xpath.evaluate("./CertDigest/DigestMethod", certElem, XPathConstants.NODE);
                                Element digestValueElem = (Element)xpath.evaluate("./CertDigest/DigestValue", certElem, XPathConstants.NODE);
                                Element issuerNameV2Elem = (Element)xpath.evaluate("./IssuerSerialV2", certElem, XPathConstants.NODE);
                                if (digestMethodElem.hasAttribute("Algorithm")) {
                                    signingCert.setDigestMethod(digestMethodElem.getAttribute("Algorithm"));
                                }
                                if ((digestValue = digestValueElem.getTextContent()) != null) {
                                    digestValue = digestValue.trim();
                                }
                                signingCert.setDigestValue(digestValue);
                                if (issuerNameV2Elem != null) {
                                    signingCert.setIssuerName(issuerNameV2Elem.getTextContent());
                                }
                                signingCert.setVersion(2);
                                objReturn.getSigningCertificates().add(signingCert);
                                continue;
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }
                    if ((sigPolicyIdElem = (Element)xpath.evaluate("/Signature/Object/QualifyingProperties/SignedProperties/SignedSignatureProperties/SignaturePolicyIdentifier", xmlSi.getDocumentElement(), XPathConstants.NODE)) != null) {
                        objReturn.setHasSignaturePolicyIdentifier(true);
                    }
                }
            } else if (qualifPropsRefElem != null) {
                objReturn.setHasSignedProperties(true);
            }
            Element keyInfoElem = (Element)xpath.evaluate("/Signature/KeyInfo", xmlSi.getDocumentElement(), XPathConstants.NODE);
            if (keyInfoElem != null) {
                objReturn.setKeyInfoId(keyInfoElem.getAttribute("Id"));
                Element x509Elem = (Element)xpath.evaluate("/Signature/KeyInfo//X509Certificate", keyInfoElem, XPathConstants.NODE);
                if (x509Elem != null) {
                    objReturn.setHasKeyInfo(true);
                }
            }
            if ((unsignedPropsElem = (Element)xpath.evaluate("/Signature/Object/QualifyingProperties/UnsignedProperties", xmlSi.getDocumentElement(), XPathConstants.NODE)) != null && (certificateValues = (Element)xpath.evaluate("./CertificateValues", unsignedPropsElem, XPathConstants.NODE)) == null) return objReturn;
        }
        catch (Exception ex) {
            objReturn = null;
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }
}

