/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.xml.parser.SignedXMLEnvelope;
import it.actalis.ellips.capi.xml.parser.XadesParserHelper;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class XadesParser
extends SignatureParser {
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public XadesParser(SignatureParserBuilder builder) {
        super(builder);
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    @Override
    public ParsedTransientDocument parse(InputHandler source, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) throws ParsingException {
        ParsedTransientDocument doc;
        block9: {
            doc = new ParsedTransientDocument(source);
            Closeable oh = null;
            if (timeZone != null) {
                this.df.setTimeZone(timeZone);
            }
            try {
                SignedXMLEnvelope env = new SignedXMLEnvelope(source, fileSelector);
                XadesParserHelper.parseXadesEnvelope(doc, env, this.df, false, true, fileSelector, config);
            }
            catch (CapiException ex) {
                if (ex.getErrorCode() == 50001) {
                    doc.setSigned(false);
                    break block9;
                }
                throw new ParsingException("Unable to parse file", ex);
            }
            catch (Exception ex) {
                throw new ParsingException("Unable to parse file", ex);
            }
            finally {
                Util.closeQuietly(oh);
            }
        }
        return doc;
    }
}

