/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DLSequence;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class ECUtils {
    public static PublicKey rebuildPublicKeyFromRawCard(byte[] params, byte[] points) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        ASN1ObjectIdentifier curveId = (ASN1ObjectIdentifier)ASN1ObjectIdentifier.fromByteArray((byte[])params);
        if (!(curveId.getId().equals("1.2.840.10045.3.1.7") || curveId.getId().equals("1.3.132.0.34") || curveId.getId().equals("1.3.132.0.35"))) {
            throw new IOException("Invalid Curve Params");
        }
        DEROctetString ocs = (DEROctetString)DEROctetString.fromByteArray((byte[])points);
        DERBitString bitStirng = new DERBitString(ocs.getOctets());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DERSequenceGenerator genSeq = new DERSequenceGenerator((OutputStream)os);
        genSeq.addObject((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.10045.2.1"));
        genSeq.addObject((ASN1Encodable)curveId);
        genSeq.close();
        DLSequence seq = (DLSequence)DERSequence.fromByteArray((byte[])os.toByteArray());
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        DERSequenceGenerator seq2 = new DERSequenceGenerator((OutputStream)os2);
        seq2.addObject((ASN1Encodable)seq);
        seq2.addObject((ASN1Encodable)bitStirng);
        seq2.close();
        AlgorithmId id = AlgorithmId.parse(new DerValue(seq.getEncoded()));
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(os2.toByteArray());
        KeyFactory factory = KeyFactory.getInstance(id.getName());
        PublicKey ec = factory.generatePublic(pubKeySpec);
        return ec;
    }
}

