/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.slf4j.Logger;

public class TSLUtils {
    public static String extendedNationId(String id) {
        if (id.equalsIgnoreCase("at")) {
            return "Austria";
        }
        if (id.equalsIgnoreCase("be")) {
            return "Belgium";
        }
        if (id.equalsIgnoreCase("bg")) {
            return "Bulgaria";
        }
        if (id.equalsIgnoreCase("cy")) {
            return "Cyprus";
        }
        if (id.equalsIgnoreCase("cz")) {
            return "Czech Republic";
        }
        if (id.equalsIgnoreCase("de")) {
            return "Germany";
        }
        if (id.equalsIgnoreCase("dk")) {
            return "Denmark";
        }
        if (id.equalsIgnoreCase("ee")) {
            return "Estonia";
        }
        if (id.equalsIgnoreCase("gr")) {
            return "Greece";
        }
        if (id.equalsIgnoreCase("es")) {
            return "Spain";
        }
        if (id.equalsIgnoreCase("fi")) {
            return "Finland";
        }
        if (id.equalsIgnoreCase("fr")) {
            return "France";
        }
        if (id.equalsIgnoreCase("hr")) {
            return "Croatia";
        }
        if (id.equalsIgnoreCase("hu")) {
            return "Hungary";
        }
        if (id.equalsIgnoreCase("ie")) {
            return "Ireland";
        }
        if (id.equalsIgnoreCase("is")) {
            return "Iceland";
        }
        if (id.equalsIgnoreCase("it")) {
            return "Italy";
        }
        if (id.equalsIgnoreCase("li")) {
            return "Liechtenstein";
        }
        if (id.equalsIgnoreCase("lt")) {
            return "Lettonia";
        }
        if (id.equalsIgnoreCase("lu")) {
            return "Luxembourg";
        }
        if (id.equalsIgnoreCase("lv")) {
            return "Latvia";
        }
        if (id.equalsIgnoreCase("mt")) {
            return "Malta";
        }
        if (id.equalsIgnoreCase("nl")) {
            return "Netherlands";
        }
        if (id.equalsIgnoreCase("no")) {
            return "Norway";
        }
        if (id.equalsIgnoreCase("pl")) {
            return "Poland";
        }
        if (id.equalsIgnoreCase("pt")) {
            return "Portugal";
        }
        if (id.equalsIgnoreCase("ro")) {
            return "Romania";
        }
        if (id.equalsIgnoreCase("se")) {
            return "Sweden";
        }
        if (id.equalsIgnoreCase("si")) {
            return "Slovenia";
        }
        if (id.equalsIgnoreCase("sk")) {
            return "Slovakia";
        }
        if (id.equalsIgnoreCase("org") || id.equalsIgnoreCase("uk")) {
            return "United Kingdom";
        }
        return "European Community";
    }

    public static String getNationalityFromUrl(String nationalTSLUrl) {
        if (Util.isNullOrEmpty(nationalTSLUrl)) {
            return "";
        }
        String tslUrlKey = nationalTSLUrl.replace("http://", "");
        if ((tslUrlKey = tslUrlKey.replace("https://", "")).contains("UK_TSL")) {
            return "uk";
        }
        String[] parts = tslUrlKey.split("/");
        if (parts.length < 1) {
            return "";
        }
        tslUrlKey = parts[0];
        if ((parts = tslUrlKey.split("\\.")).length < 1) {
            return "";
        }
        return parts[parts.length - 1];
    }

    public static int listDBCertificates(CertDB cDB, String outFilePath, Logger logger) throws CertDBException, IOException {
        int nCertListed = 0;
        if (logger != null) {
            logger.info("exporting cdb to text file...");
        }
        OutputStreamWriter fw = null;
        try {
            File outFile;
            boolean bPrintOut = true;
            if (outFilePath.isEmpty()) {
                bPrintOut = false;
            }
            if ((outFile = new File(outFilePath)).exists()) {
                outFile.delete();
            }
            outFile.createNewFile();
            if (!outFile.exists() || !outFile.canWrite()) {
                bPrintOut = false;
            }
            CertDBItem[] rootEnt = cDB.list(4);
            CertDBItem[] intermediateEnt = cDB.list(2);
            CertDBItem[] endEnt = cDB.list(1);
            nCertListed += rootEnt.length;
            nCertListed += intermediateEnt.length;
            nCertListed += endEnt.length;
            if (bPrintOut) {
                int i;
                fw = new FileWriter(outFile.getAbsoluteFile(), true);
                fw.write("\n------------------------\nCERTIFICATE INTO DATABASE\n------------------------\n");
                fw.write("\nROOT CA (" + String.format("%d", rootEnt.length) + ")");
                fw.write("\nINTERMEDIATE CA (" + String.format("%d", intermediateEnt.length) + ")");
                fw.write("\nOTHERS (" + String.format("%d", endEnt.length) + ")");
                fw.write("\n\nTOTAL CERTIFICATES: " + String.format("%d", nCertListed));
                fw.write("\n//////////////////////////////////////////////////////////////////// ROOT CA:\n");
                for (i = 0; i < rootEnt.length; ++i) {
                    fw.write("\t" + String.format("%d", rootEnt[i].getID()) + " " + rootEnt[i].getName() + "\n\t" + rootEnt[i].getSubject() + "\n\n");
                }
                fw.write("\n//////////////////////////////////////////////////////////////////// INTERMEDIATE CA:\n");
                for (i = 0; i < intermediateEnt.length; ++i) {
                    fw.write("\t" + String.format("%d", intermediateEnt[i].getID()) + " " + intermediateEnt[i].getName() + "\n\t" + intermediateEnt[i].getSubject() + "\n\n");
                }
                fw.write("\n//////////////////////////////////////////////////////////////////// OTHERS:\n");
                for (i = 0; i < endEnt.length; ++i) {
                    fw.write("\t" + String.format("%d", endEnt[i].getID()) + " " + endEnt[i].getName() + "\n\t" + endEnt[i].getSubject() + "\n\n");
                }
                fw.close();
            }
        }
        catch (CertDBException ex) {
            if (logger != null) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
        catch (IOException ex) {
            if (logger != null) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (logger != null) {
            logger.info(nCertListed + " certificates exported");
        }
        return nCertListed;
    }

    public static Date getLastTSLModifiedDate(String TSLUrl, NetworkConfig netConf, Logger logger) {
        try {
            UrlClient uClient = new UrlClient(netConf, logger);
            Date remoteDate = uClient.getLastModifiedDate(TSLUrl, null);
            if (remoteDate.compareTo(new Date(0L)) == 0) {
                return null;
            }
            return remoteDate;
        }
        catch (Exception ex) {
            if (logger != null) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }
}

