/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.crl.CRLUtils;
import esecurity.validator.x509status.ocsp.HttpOCSPClient;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.LTResource;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;

public class LTResourceResolver {
    private NetworkConfig config = HTTP.defaultConfig;
    private Logger logger;
    private CertDB certDb;

    public LTResourceResolver(NetworkConfig config, Logger logger, CertDB certDb) {
        if (config != null) {
            this.config = config;
        }
        this.logger = logger == null ? EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME) : logger;
        this.certDb = certDb;
    }

    public LTResource resolve(X509Certificate cert) throws CapiException, IOException, CertificateException {
        return this.resolve(cert, null);
    }

    public LTResource resolve(X509Certificate cert, Date timeStampDate) throws CapiException, IOException, CertificateException {
        LTResource ltRes = new LTResource();
        CertDBItem[] chainItems = this.certDb.onLineVerify(this.config, cert.getEncoded());
        if (chainItems.length == 0) {
            throw new CapiException("Unable to resolve the certificate chain for cert " + cert.getSubjectDN(), 1003);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        sdf.setTimeZone(Constants.DEFAULT_TIMEZONE);
        for (int iItem = 0; iItem < chainItems.length; ++iItem) {
            ltRes.addCert(chainItems[iItem].getCertificate().getInternalCert());
            int maxTrials = 2;
            OCSPResponse ocspResp = null;
            for (int iTrial = 0; iTrial < maxTrials && (ocspResp = this.resolveOcsp(cert, chainItems[iItem].getCertificate().getInternalCert())) != null; ++iTrial) {
                if (ocspResp.getBasicOcspResponse().getCerts() == null || ocspResp.getBasicOcspResponse().getCerts().length == 0) {
                    this.logger.debug("OCSP response for certificate " + cert.getSubjectDN() + " has not certificate itself. Try with CRL...");
                    ocspResp = null;
                    break;
                }
                String errMsg = "";
                boolean validResp = true;
                if (timeStampDate != null && ocspResp.getProducedAt().before(timeStampDate)) {
                    errMsg = String.format("OCSP response date (%s) produced before than time stamp (%s)", sdf.format(ocspResp.getProducedAt()), sdf.format(timeStampDate));
                    this.logger.debug("trial " + (iTrial + 1) + ": " + errMsg);
                    validResp = false;
                }
                if (validResp) break;
                if (iTrial == maxTrials) {
                    throw new CapiException(errMsg, 1003);
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (ocspResp != null) {
                ltRes.addOcspResponse(ocspResp);
                for (X509CertificateHolder oCert : ocspResp.getBasicOcspResponse().getCerts()) {
                    X509Certificate ocspCert = new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(oCert);
                    ltRes.addCert(ocspCert);
                    try {
                        ocspCert.verify(chainItems[iItem].getCertificate().getPublicKey());
                    }
                    catch (Exception ex) {
                        CertDBItem[] items2 = this.certDb.onLineVerify(this.config, oCert.getEncoded());
                        if (items2 == null || items2.length <= 0) continue;
                        for (CertDBItem cert_item : items2) {
                            ltRes.addCert(cert_item.getCertificate().getInternalCert());
                        }
                    }
                }
                continue;
            }
            CRL crlResp = this.resolveCrl(cert);
            if (crlResp == null) {
                throw new CapiException("Unable to get revocation status for certificate " + cert.getSubjectDN(), 30005);
            }
            ltRes.addCrl(crlResp);
        }
        if (!ltRes.isResolved()) {
            throw new CapiException("Unable to resolve LT resources for certificate " + cert.getSubjectDN(), 1003);
        }
        return ltRes;
    }

    private OCSPResponse resolveOcsp(X509Certificate cert, X509Certificate rootCert) {
        try {
            HttpOCSPClient client = new HttpOCSPClient(this.config, this.logger, this.certDb);
            if (this.retrieveOCSPUrl(cert) != null) {
                return client.sendOCSPRequest(this.retrieveOCSPUrl(cert), cert, rootCert);
            }
        }
        catch (CapiException ex) {
            this.logger.error("unable to call OCSP: " + ex.getMessage() + " " + ex.getErrorCode(), (Throwable)ex);
        }
        catch (OCSPException ex) {
            this.logger.error("unable to call OCSP: " + ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            this.logger.error("unable to call OCSP: " + ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private String retrieveOCSPUrl(X509Certificate cert) {
        try {
            byte[] ext = cert.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (ext != null) {
                ASN1Primitive obj = X509ExtensionUtil.fromExtensionValue((byte[])ext);
                AuthorityInformationAccess objAccess = AuthorityInformationAccess.getInstance((Object)((ASN1Sequence)obj));
                for (AccessDescription access : objAccess.getAccessDescriptions()) {
                    if (!access.getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) continue;
                    DERTaggedObject obj3 = (DERTaggedObject)access.getAccessLocation().toASN1Primitive();
                    ASN1Primitive obj4 = obj3.getObjectParser(6, true).toASN1Primitive();
                    return obj4.toString();
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
        return null;
    }

    private CRL resolveCrl(X509Certificate cert) {
        UrlClient client = new UrlClient(this.config);
        ValidatorConfig valConfig = new ValidatorConfig();
        valConfig.setElement("verify.mode", "CRLONLY");
        return CRLUtils.getCrlForCertificate(client, valConfig, new Certificate(cert), new Date(), this.certDb);
    }
}

