/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.vol.utils.Constants;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class Crypto {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String HASH_ALG_SHA1 = "SHA-1";
    public static final String HASH_ALG_MD2 = "MD2";
    public static final String HASH_ALG_MD5 = "MD5";
    public static final String HASH_ALG_RIPEMD128 = "RIPEMD128";
    public static final String HASH_ALG_RIPEMD160 = "RIPEMD160";
    public static final String HASH_ALG_SHA256 = Constants.SHA256;

    public Crypto() {
        logger.debug("constructor OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(String alias, byte[] hash) throws CapiException {
        logger.debug("sign using alias " + alias);
        if (hash == null || alias == null) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tk = Token.getTokenSpi(alias);
        if (tk == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        TokenSpi tokenSpi = tk;
        synchronized (tokenSpi) {
            PrivateKey sk = tk.getPrivateKey(alias);
            return this.signHash(hash, sk);
        }
    }

    public void verify(byte[] hash, byte[] signature, byte[] signerCert) throws CapiException {
        logger.debug("verify");
        if (hash == null || signature == null || signerCert == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Certificate cert = new Certificate(signerCert);
        PublicKey pk = cert.getPublicKey();
        boolean result = false;
        try {
            Cipher rsa = Cipher.getInstance("RSA/ECB/PKCS1Padding", ProvUtils.bcProvider);
            rsa.init(2, pk);
            byte[] res = rsa.doFinal(signature);
            if (Util.equalsBlock(res, hash)) {
                result = true;
            } else {
                logger.debug("failed verify without errors:");
                logger.debug("orig.hash: " + new String(Hex.encode((byte[])hash)));
                logger.debug("resulting: " + new String(Hex.encode((byte[])res)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        catch (NoSuchPaddingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        catch (BadPaddingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (IllegalBlockSizeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (InvalidKeyException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid key format", 3000);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
        if (!result) {
            throw new CapiException("Invalid signature", 3010);
        }
    }

    public byte[] hash(byte[] data, String algName) throws CapiException {
        logger.debug("hash (byte[])");
        if (data == null || algName == null) {
            throw new CapiException("null params", 1001);
        }
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance(algName.toUpperCase(), ProvUtils.bcProvider);
            logger.debug("hash getInstance OK for " + algName + ProvUtils.bcProvider);
            sha.update(data);
            return sha.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid algorithm", 3011);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    public byte[] hash(InputStream input, String algName) throws CapiException {
        return this.hash(input, algName, 512);
    }

    public byte[] hash(InputStream input, String algName, int blocksize) throws CapiException {
        logger.debug("hash (inputstream block= " + blocksize + ")");
        if (input == null || algName == null) {
            throw new CapiException("null params", 1001);
        }
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance(algName.toUpperCase(), ProvUtils.bcProvider);
            logger.debug("hash getInstance OK for " + algName + ProvUtils.bcProvider);
            byte[] block = new byte[blocksize];
            int nread = 0;
            while ((nread = input.read(block)) != -1) {
                if (nread == 0) continue;
                if (nread == block.length) {
                    sha.update(block);
                    continue;
                }
                logger.debug("Crypto: hash last block read;len =" + nread);
                byte[] copy = new byte[nread];
                System.arraycopy(block, 0, copy, 0, nread);
                sha.update(copy);
            }
            input.close();
            return sha.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid algorithm", 3011);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    private byte[] signHash(byte[] data, PrivateKey rsask) throws CapiException {
        try {
            Cipher rsa = Cipher.getInstance("RSA/ECB/PKCS1Padding", "Actalis");
            rsa.init(1, rsask);
            return rsa.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        catch (NoSuchPaddingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
        catch (BadPaddingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (IllegalBlockSizeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (InvalidKeyException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid key format", 3000);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (CapiError err) {
            logger.debug(err.getMessage(), (Throwable)err);
            throw err.getCapiException();
        }
    }
}

