/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.outputs.StreamOutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.provider.MultipartWrapper;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.slf4j.Logger;

public class URLOutputHandler
extends StreamOutputHandler {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private URL outputUrl = null;
    private NetworkConfig netConf = null;
    private URLCredentials credentials = null;
    private UrlClient client = null;
    private MultipartWrapper multipart = null;

    public URLOutputHandler(URL url, NetworkConfig config, URLCredentials creds, String name, Long finalSize) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Please specify a non-null URL!");
        }
        this.outputUrl = url;
        this.netConf = config != null ? config : new NetworkConfig();
        this.credentials = creds;
        this.client = new UrlClient(this.netConf, logger);
        this.multipart = this.client.getMultipartWrapper(this.outputUrl, this.credentials);
        this.multipart.initOverallMultipart();
        this.initStreamOutputHandler(null, name == null ? "DEFAULT" : name, finalSize, true);
        this.type = DataHandler.DATA_TYPE.URL;
    }

    public URLOutputHandler(URL url, NetworkConfig config, URLCredentials creds, String name) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        this(url, config, creds, name, null);
    }

    public URLOutputHandler(URL url, NetworkConfig config, URLCredentials creds) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        this(url, config, creds, null);
    }

    public URLOutputHandler(URL url, NetworkConfig config) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        this(url, config, null);
    }

    public URLOutputHandler(URL url) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        this(url, null);
    }

    @Override
    protected void initBeforeFirstWrite() throws IOException {
        this.outputStream = this.multipart.addMultipartBinarySection("uploadedFile", this.name);
        this.outputStream.flush();
    }

    @Override
    protected void finalizeBeforeClosing() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
        this.multipart.finalizeOverallMultipart();
    }

    @Override
    public void close() throws IOException {
        this.multipart.finalizeRequestExecution();
        super.close();
        int responseCode = this.multipart.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Server returned error status code " + responseCode);
        }
    }
}

