/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core.msg;

import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.vol.exception.VolException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageFactory {
    private ResourceBundle dictionary = null;
    private LanguagesCode selectedLanguage = LanguagesCode.EN;

    public MessageFactory(LanguagesCode language) throws VolException {
        this.initLang(language, "VOLNGDictionary");
    }

    public MessageFactory(LanguagesCode language, String bundleName) throws VolException {
        this.initLang(language, bundleName);
    }

    public MessageFactory(LanguagesCode language, String bundleName, ClassLoader classLoader) throws VolException {
        this.initLang(language, bundleName);
    }

    private void initLang(LanguagesCode language, String bundleName) throws VolException {
        this.initLang(language, bundleName, MessageFactory.class.getClassLoader());
    }

    private void initLang(LanguagesCode language, String bundleName, ClassLoader classLoader) throws VolException {
        if (language == LanguagesCode.IT) {
            this.dictionary = ResourceBundle.getBundle(bundleName + "_it_IT", Locale.ITALY, classLoader);
        } else if (language == LanguagesCode.EN) {
            this.dictionary = ResourceBundle.getBundle(bundleName + "_en_GB", Locale.UK, classLoader);
        } else if (language == LanguagesCode.DE) {
            this.dictionary = ResourceBundle.getBundle(bundleName + "_de_DE", Locale.GERMAN, classLoader);
        } else {
            throw new VolException("Unsupported language");
        }
        this.selectedLanguage = language;
    }

    public String getMessage(EsecurityMessage message, Object ... args) {
        String base_message = null;
        try {
            base_message = this.dictionary.getString(message.getCode());
        }
        catch (Exception ex) {
            base_message = message.getDefaultMessage();
        }
        String strReturn = MessageFormat.format(base_message, args);
        return strReturn;
    }
}

