/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

public class CapiException
extends Exception {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private int errorCode = 0;
    private int detailReason = -1;
    static boolean debug = false;
    public static final int NULL_ARGS = 1001;
    public static final int WRONG_ARGS = 1002;
    public static final int INTERNAL_ERR = 1003;
    public static final int NOT_SUPPORTED = 1004;
    public static final int USER_CANCELED = 1005;
    public static final int WRONG_PAGE = 1006;
    public static final int PIN_WRONG_OR_ALTERED = 2000;
    public static final int PIN_WRONG = 2001;
    public static final int PIN_BLOCK = 2003;
    public static final int PUK_WRONG = 2005;
    public static final int PIN_INVALID = 2006;
    public static final int PIN_EXPIRED = 2007;
    public static final int PUK_BLOCK = 2008;
    public static final int PUK_INVALID = 2009;
    public static final int PUK_EXPIRED = 2010;
    public static final int PIN_NOT_BLOCKED = 2011;
    public static final int REMOTE_SIG_INVALID_CREDENTIALS = 2012;
    public static final int REMOTE_SIG_INVALID_OTP = 2014;
    public static final int REMOTE_SIG_INVALID_LOGIN = 2015;
    public static final int REMOTE_SIG_INVALID_PIN = 2016;
    public static final int REMOTE_SIG_PASSWORD_EXPIRED = 2017;
    public static final int REMOTE_SIG_INVALID_SESSION = 2018;
    public static final int REMOTE_SIG_OPERATIONAL_STATUS_BLOCKED = 2019;
    public static final int REMOTE_SIG_TIMEOUT = 2020;
    public static final int REMOTE_SIG_MAX_REQUEST_EXCEEDED = 2021;
    public static final int REMOTE_SIG_USER_LOCKED = 2022;
    public static final int REMOTE_SIG_INVALID_STATUS = 2023;
    public static final int REMOTE_SIG_INVALID_CERTIFICATE = 2024;
    public static final int REMOTE_SIG_INVALID_APP_CREDENTIALS = 2025;
    public static final int REMOTE_SIG_CERT_CHANGED = 2026;
    public static final int REMOTE_SIG_OPEN_SESSION_DENIED = 2027;
    public static final int REMOTE_SIG_PASSWORD_MISMATCH = 2028;
    public static final int REMOTE_SIG_INVALID_PASSWORD_LENGTH = 2029;
    public static final int REMOTE_SIG_TEMPORARY_SUSPENDED = 2030;
    public static final int KEY_FORMAT = 3000;
    public static final int SIGN_ERROR = 3003;
    public static final int INVALID_SIGNATURE = 3010;
    public static final int INVALID_ALGORITHM = 3011;
    public static final int CIPH_ERROR = 3103;
    public static final int FILE_READ_ERROR = 4000;
    public static final int FILE_WRITE_ERROR = 4001;
    public static final int FILE_NOT_FOUND = 4002;
    public static final int B64_DECODE = 5001;
    public static final int DATE_FORMAT = 6000;
    public static final int NUMBER_FORMAT = 6001;
    public static final int DATE_TIMEZONE = 6002;
    public static final int TK_NOT_FOUND = 10000;
    public static final int TK_ALREADY_INITED = 10002;
    public static final int TK_NOT_INITED = 10003;
    public static final int TK_NOT_INITIALIZED = 10010;
    public static final int TK_NOT_INSERTED = 10011;
    public static final int TK_REMOVED = 10012;
    public static final int TK_NOT_LOGGED = 10013;
    public static final int TK_SLOT_UNVAILABLE = 10014;
    public static final int TK_SLOT_NOT_EXPECTED_OBJECT = 10015;
    public static final int TK_ALIAS_NOT_DATA = 10020;
    public static final int TK_ALIAS_NOT_KEY = 10021;
    public static final int TK_ALIAS_NOT_CERT = 10022;
    public static final int TK_ALIAS_NOT_EXIST = 10023;
    public static final int TK_ALIAS_ALREADY_EXIST = 10024;
    public static final int TK_ALIAS_NOT_KEY_CERT = 10025;
    public static final int TK_MEMORY_FULL = 10030;
    public static final int TK_UNSUPPORTED_KEY_LEN = 10031;
    public static final int TK_KEY_GEN_ERR = 10032;
    public static final int TK_CERT_NOT_MATCHING = 10033;
    public static final int TK_UNSUPPORTED_MODE = 10034;
    public static final int TK_PKCS12_FORMAT = 10035;
    public static final int TK_PKCS12_WRONG_PIN = 10036;
    public static final int TK_WRONG_KEY_USAGE = 10037;
    public static final int TK_INVALID_USE = 10038;
    public static final int TK_INTERNAL_ERR = 10040;
    public static final int FS_PATH_NOT_EXIST = 12000;
    public static final int FS_PATH_NOT_A_DIR = 12001;
    public static final int FS_FILE_FORMAT = 12003;
    public static final int FS_FILE_SAVE = 12004;
    public static final int FS_NOT_SAME_TKID = 12005;
    public static final int FS_NOT_SAME_HMAC = 12006;
    public static final int P11_LIBRARY = 11000;
    public static final int P11_DEVICE_ERROR = 11001;
    public static final int P11_NOT_SUPPORTED = 11002;
    public static final int P11_INVALID_SLOT = 11003;
    public static final int P11_INVALID_TOKEN = 11004;
    public static final int P11_ATTR_READ_ONLY = 11010;
    public static final int P11_ATTR_SENSITIVE = 11011;
    public static final int P11_KEY_UNEXTRACTABLE = 11012;
    public static final int P11_INVALID_MECHANISM = 11013;
    public static final int P11_LOGIN_ERROR = 11014;
    public static final int CERT_EXPIRED = 30000;
    public static final int CERT_NOT_YET_VALID = 30001;
    public static final int CERT_FORMAT = 30002;
    public static final int CERT_VERIFY = 30003;
    public static final int CERT_VERIFY_ISS = 30004;
    public static final int CERT_INTERNAL_ERR = 30005;
    public static final int CERT_SUBJ_KEYID_INVALID = 30006;
    public static final int CERT_ALTERED = 30007;
    public static final int CERT_NOT_FOUND = 30008;
    public static final int CRL_FORMAT = 31000;
    public static final int CRL_VERIFY = 31001;
    public static final int CRL_VERIFY_ISS = 31002;
    public static final int CRL_INTERNAL_ERR = 31003;
    public static final int CRL_NOT_REVOKED = 31004;
    public static final int CRL_RETRIEVE_ERR = 31005;
    public static final int CRL_EXPIRED = 31006;
    public static final int CRL_NOT_YET_VALID = 31007;
    public static final int OCSP_FAILED = 31008;
    public static final int CRL_WITHOUT_EXPIRED_CERTS = 31009;
    public static final int CRL_WITH_EXPIRED_CERTS_CRT_TOO_OLD = 31012;
    public static final int OCSP_WITHOUT_ARCHIVE_CUTOFF = 31010;
    public static final int OCSP_WITH_ARCHIVE_CUTOFF_CRT_TOO_OLD = 31011;
    public static final int ENV_NO_DATA = 50000;
    public static final int ENV_NOT_SIGNED = 50001;
    public static final int ENV_ALREADY_SIGNED = 50002;
    public static final int ENV_PDF_ALREADY_CLOSED = 50003;
    public static final int ENV_PDF_ERR = 50004;
    public static final int ENV_INVALID_SIGNER = 50010;
    public static final int ENV_WRONG_TYPE = 50021;
    public static final int ENV_ENCODING_ERR = 50022;
    public static final int ENV_FORMAT = 50023;
    public static final int ENV_IO_OR_ENCODING_ERR = 50025;
    public static final int ENV_NOT_ALLOWED = 50026;
    public static final int ENV_FATAL = 50040;
    public static final int ENV_ALG_SHA1_FORBIDDEN = 50041;
    public static final int ENV_INTERNAL_ERR = 50050;
    public static final int ENV_RESOURCE_RETRIEVE_ERR = 50051;
    public static final int ENV_INTERRUPTED = 50052;
    public static final int ENV_CANNOT_GET_TIMESTAMP = 50053;
    public static final int ENV_NOT_CIPHERED = 51001;
    public static final int ENV_ALREADY_CIPHERED = 51002;
    public static final int ENV_INVALID_CIPHER = 51010;
    public static final int CDB_INTERNAL_ERR = 80000;
    public static final int CDB_PWD_WRONG_OR_ALTERED = 80001;
    public static final int CDB_PWD_WRONG = 80002;
    public static final int CDB_FILE_FORMAT = 80003;
    public static final int CDB_FILE_NOT_FOUND = 80004;
    public static final int CDB_READ_ERROR = 80005;
    public static final int CDB_WRITE_ERROR = 80006;
    public static final int CDB_FILE_ALTERED = 80007;
    public static final int CDB_INVALID_TYPE = 80008;
    public static final int CDB_INVALID_TRUST = 80009;
    public static final int CDB_CANNOT_ADD = 80010;
    public static final int CDB_ALREADY_IN = 80011;
    public static final int CDB_UNKNOWN_TYPE = 80012;
    public static final int CDB_NO_CHAIN = 80020;
    public static final int CDB_BROKEN_OR_UNTRUSTED_CHAIN = 80021;
    public static final int CDB_VERIFYSTATUS_VERIFIED = 82100;
    public static final int CDB_VERIFYSTATUS_TRUSTED = 82101;
    public static final int CDB_VERIFYSTATUS_UNTRUSTED = 82111;
    public static final int CDB_VERIFYSTATUS_NOT_EVAL_OR_INHERIT = 82112;
    public static final int CDB_VERIFYSTATUS_UNSUPPORTED_CRIT_EXT = 82113;
    public static final int CDB_VERIFYSTATUS_NO_ISSUER_FOUND = 82114;
    public static final int LDAP_NO_USER = 90000;
    public static final int LDAP_WRONG_PWD = 90001;
    public static final int LDAP_UNAVAILABLE = 90002;
    public static final int LDAP_UNKNOWN = 90003;
    public static final int LDAP_WRONG_TYPE = 90004;
    public static final int LDAP_CONNECTION = 90005;
    public static final int LDAP_NO_SUCH_FIELD = 90006;
    public static final int LDAP_MALFORMED_URL = 90010;
    public static final int LDAP_INTERRUPTED = 90020;
    public static final int HTTP_NO_LOCALHOSTNAME = 91000;
    public static final int HTTP_FAILED_RECOVER = 91001;
    public static final int HTTP_FAILED_CONNECT = 91002;
    public static final int HTTP_FAILED_IO = 91003;
    public static final int HTTP_404 = 91004;
    public static final int HTTP_403 = 91005;
    public static final int HTTP_407 = 91006;
    public static final int HTTP_ERROR = 91007;
    public static final int HTTP_PROXY_ERROR = 91008;
    public static final int HTTPS_SSLHANDSHAKE_ERROR = 92000;
    public static final int HTTPS_SERVER_NOT_AUTHENTICATED = 92001;
    public static final int HTTPS_SSL_PROTOCOL_ERROR = 92002;
    public static final int HTTPS_SSL_KEY_ERROR = 92003;
    public static final int DTS_ERROR = 93000;
    public static final int DTS_NO_SRV = 93001;
    public static final int DTS_NO_ALG = 93002;
    public static final int AS_VENDOR_NET_ERR = -2147483136;
    public static final int AS_VENDOR_NET_UNK = -2147483135;
    public static final int AS_VENDOR_NET_CONN = -2147483134;
    public static final int AS_VENDOR_NET_RCV = -2147483133;
    public static final int AS_VENDOR_NET_SND = -2147483132;
    public static final int AS_VENDOR_NET_NOSOCK = -2147483131;
    public static final int AS_VENDOR_NET_ARGS = -2147483130;
    public static final int AS_VENDOR_NET_LIB = -2147483129;
    public static final int AS_VENDOR_NET_MEM = -2147483128;
    public static final int AS_VENDOR_NET_MSGS = -2147483127;
    public static final int AS_VENDOR_NET_TIMEOUT = -2147483126;
    public static final int AS_VENDOR_NET_WND = -2147483125;
    public static final int AS_VENDOR_NET_AGAIN = -2147483124;
    public static final int AS_VENDOR_NET_QUIT = -2147483123;
    public static final int AS_VENDOR_NO_SERVER = -2147483122;
    public static final int AS_VENDOR_NOCARD_FOUND = -2147483121;
    public static final int AS_VENDOR_REMOTE_CALLE = -2147483120;
    public static final int AS_VENDOR_INVALID_MAC = -2147483117;
    public static final int AS_VENDOR_NO_MAC_KEY = -2147483116;

    public CapiException(String message, int errorCode) {
        this(message, errorCode, -1);
    }

    public CapiException(String message, int errorCode, int reason) {
        this(message, errorCode, reason, null);
    }

    public CapiException(String message, int errorCode, Throwable innerException) {
        this(message, errorCode, -1, innerException);
    }

    public CapiException(String message, int errorCode, int reason, Throwable innerException) {
        super(message, innerException);
        this.errorCode = errorCode;
        this.detailReason = reason;
        logger.debug("" + errorCode + ": " + message + "(" + reason + ")");
        if (innerException != null) {
            logger.debug("Inner exception is: " + innerException);
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getDetailReason() {
        return this.detailReason;
    }

    public void setDetailReason(int reason) {
        this.detailReason = reason;
    }
}

