/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.filter.Base64InputFilter;
import it.actalis.ellips.capi.datahandlers.inputs.filter.PEMInputFilter;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;

public class CRL {
    private static CertificateFactory cf;
    private static final Logger logger;
    public static final int reason_unspecified = 0;
    public static final int reason_keyCompromise = 1;
    public static final int reason_caCompromise = 2;
    public static final int reason_affiliationChanged = 3;
    public static final int reason_superseded = 4;
    public static final int reason_cessationOfOperation = 5;
    public static final int reason_certificateHold = 6;
    public static final int reason_removeFromCRL = 8;
    public static final int reason_privilegeWithdrawn = 9;
    public static final int reason_aACompromise = 10;
    private String downloadedUrl = "";
    X509CRL theCRL = null;
    static boolean debug;
    private static final String ExpiredCertsOnCRL = "2.5.29.60";
    private static final String IssuingDistributionPoint = "2.5.29.28";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public CRL(byte[] encoded) throws CapiException {
        InputHandler source = null;
        try {
            source = DataHandlerBuilder.get().setBytes(encoded).buildInput();
            this.init(source);
        }
        catch (CapiException e) {
            try {
                throw e;
                catch (Exception e2) {
                    logger.debug(e2.getMessage(), (Throwable)e2);
                    throw new CapiException("CRL format unknown or not implemented", 31000);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(source);
                throw throwable;
            }
        }
        Util.closeQuietly(source);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CRL(InputStream is) throws CapiException {
        InputHandler source = null;
        try {
            source = DataHandlerBuilder.get().setInputStream(is).buildInput();
            this.init(source);
        }
        catch (CapiException e) {
            try {
                throw e;
                catch (Exception e2) {
                    logger.debug(e2.getMessage(), (Throwable)e2);
                    throw new CapiException("CRL format unknown or not implemented", 31000);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(source);
                throw throwable;
            }
        }
        Util.closeQuietly(source);
    }

    private void init(InputHandler source) throws CapiException {
        try {
            boolean bIsPem;
            int firstByte = source.getInputAsNewStream().read();
            boolean bIsDer = firstByte == 48;
            boolean bl = bIsPem = firstByte == 45;
            if (!bIsPem && !bIsDer) {
                source.addFilter(new Base64InputFilter());
            } else if (bIsPem) {
                source.addFilter(new PEMInputFilter());
            }
            this.theCRL = (X509CRL)cf.generateCRL(source.getInputAsNewStream());
            X500Principal x500Principal = this.theCRL.getIssuerX500Principal();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format unknown or not implemented", 31000);
        }
    }

    public String getEncoded() throws CapiException {
        try {
            if (this.theCRL == null) {
                throw new CapiException("Internal error", 31003);
            }
            byte[] dercrl = this.theCRL.getEncoded();
            return Util.base64EncodeStr(dercrl);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public X509CRL getInternalCRL() {
        return this.theCRL;
    }

    public byte[] getDEREncoded() throws CapiException {
        try {
            if (this.theCRL == null) {
                throw new CapiException("Internal error", 31003);
            }
            byte[] dercrl = this.theCRL.getEncoded();
            return dercrl;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public LinkedList<String> getIdps() throws CapiException {
        LinkedList<String> objReturn = null;
        try {
            byte[] val = this.theCRL.getExtensionValue(IssuingDistributionPoint);
            if (val == null) {
                logger.debug("CRL Issuing DP extension not found");
                return null;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])val));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            IssuingDistributionPoint issCdp = org.bouncycastle.asn1.x509.IssuingDistributionPoint.getInstance((Object)extIn.readObject());
            if (issCdp == null) {
                return null;
            }
            DistributionPointName dpn = issCdp.getDistributionPoint();
            GeneralNames gns = (GeneralNames)dpn.getName();
            GeneralName[] vgn = gns.getNames();
            objReturn = new LinkedList<String>();
            for (int j = 0; j < vgn.length; ++j) {
                ASN1String s;
                if (vgn[j].getTagNo() == 6) {
                    s = (ASN1String)vgn[j].getName();
                    objReturn.add(s.getString());
                    continue;
                }
                if (vgn[j].getTagNo() == 4) {
                    s = (X500Name)vgn[j].getName();
                    objReturn.add(s.toString());
                    continue;
                }
                objReturn.add(vgn[j].toString());
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Issuer name format alert", 31000);
        }
        return objReturn;
    }

    public String getIssuerDN() throws CapiException {
        try {
            X500Principal p = this.theCRL.getIssuerX500Principal();
            return p.getName();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Issuer name format alert", 31000);
        }
    }

    public Date getExpiredCertsOnCRL() throws CapiException {
        try {
            byte[] val = this.theCRL.getExtensionValue(ExpiredCertsOnCRL);
            if (val == null) {
                return null;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])val));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            ASN1GeneralizedTime gentime = ASN1GeneralizedTime.getInstance((Object)extIn.readObject());
            if (gentime == null) {
                return null;
            }
            Date date = gentime.getDate();
            return date;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("extension ExpiredCertsOnCRL alert", 31000);
        }
    }

    public boolean checkIssuingDistributionPoint(String url, boolean isCACert) throws CapiException {
        try {
            int i;
            byte[] val = this.theCRL.getExtensionValue(IssuingDistributionPoint);
            if (val == null) {
                logger.debug("CRL Issuing DP extension not found");
                return true;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])val));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            IssuingDistributionPoint issCdp = org.bouncycastle.asn1.x509.IssuingDistributionPoint.getInstance((Object)extIn.readObject());
            if (issCdp == null) {
                return true;
            }
            if (issCdp.onlyContainsUserCerts() && !isCACert) {
                logger.debug("CRL Issuing DP contains only user certificate match User certificate ");
            } else if (issCdp.onlyContainsCACerts() && isCACert) {
                logger.debug("CRL Issuing DP contains only CA certificate match CA certificate ");
            } else {
                logger.debug("CRL not valid: CRL Issuing DP onlyContainsUserCerts is " + issCdp.onlyContainsUserCerts() + " and mismatch certificate type");
                return false;
            }
            DistributionPointName dpn = issCdp.getDistributionPoint();
            GeneralNames gns = (GeneralNames)dpn.getName();
            GeneralName[] vgn = gns.getNames();
            Vector<String> v = new Vector<String>();
            v.setSize(0);
            for (int j = 0; j < vgn.length; ++j) {
                ASN1String s;
                if (vgn[j].getTagNo() == 6) {
                    s = (ASN1String)vgn[j].getName();
                    v.addElement(s.getString());
                    continue;
                }
                if (vgn[j].getTagNo() == 4) {
                    s = (X500Name)vgn[j].getName();
                    v.addElement(s.toString());
                    continue;
                }
                v.addElement(vgn[j].toString());
            }
            String[] list = new String[v.size()];
            for (i = 0; i < list.length; ++i) {
                list[i] = (String)v.elementAt(i);
            }
            logger.debug("Checking validity of Certificate DP: " + url);
            for (i = 0; i < list.length; ++i) {
                logger.debug("Verifying CRL Issuing DP: " + list[i]);
                if (list[i].compareToIgnoreCase(url) != 0) continue;
                logger.debug("Found CRL Issuing DP matching Certificate DP");
                return true;
            }
            logger.debug("CRL not valid: Not found CRL Issuing DP matching Certificate DP.");
            return false;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("exception checking IssuingDistributionPoint", 31000);
        }
    }

    public boolean canUseFor(Certificate cert, Date verifyDate) throws CapiException {
        boolean blnReturn = false;
        String[] urls = cert.getCdpURLs();
        Date curVerifyDate = new Date();
        if (verifyDate != null) {
            curVerifyDate = verifyDate;
        }
        if (this.theCRL.getThisUpdate().after(cert.getInternalCert().getNotBefore()) && (curVerifyDate.after(this.theCRL.getThisUpdate()) && curVerifyDate.before(this.theCRL.getNextUpdate()) || this.theCRL.getThisUpdate().after(curVerifyDate))) {
            String cert_issuer = cert.getIssuerDN();
            String crl_issuer = this.getIssuerDN();
            if (CRL.retrieveCommonName(cert_issuer).equalsIgnoreCase(CRL.retrieveCommonName(crl_issuer)) && urls != null) {
                for (String url : urls) {
                    if (!this.checkIssuingDistributionPoint(url, cert.getBasicConstraints())) continue;
                    blnReturn = true;
                    break;
                }
            }
        }
        return blnReturn;
    }

    private static String retrieveCommonName(String distinguishedName) {
        try {
            X509Principal x509principal = new X509Principal(distinguishedName);
            Vector v = x509principal.getValues(new ASN1ObjectIdentifier("2.5.4.3"));
            if (v.size() > 0) {
                return (String)v.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return distinguishedName;
    }

    public boolean canUseFor(X509Certificate cert, Date verifyDate) throws CertificateEncodingException, CapiException {
        return this.canUseFor(new Certificate(cert.getEncoded()), verifyDate);
    }

    public boolean isRevoked(BigInteger serialNumber) throws CapiException {
        if (serialNumber == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            X509CRLEntry entry = null;
            entry = this.theCRL.getRevokedCertificate(serialNumber);
            return entry != null;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public boolean isRevoked(byte[] certificate) throws CapiException {
        if (certificate == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Certificate c = new Certificate(certificate);
            return this.theCRL.isRevoked(c.getInternalCert());
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public boolean isRevokedAccordingToDigitPA(byte[] certificate, Date checkDate) throws CapiException {
        if (this.isRevoked(certificate)) {
            Date revDate = null;
            try {
                Certificate c = new Certificate(certificate);
                revDate = Util.parseDate(this.getRevocationDate(c.getSerialNumber()), "yyyyMMddHHmmss");
            }
            catch (Exception e) {
                logger.debug("[doWork] No valid revocation date specified");
                return true;
            }
            if (checkDate != null && revDate != null) {
                return checkDate.compareTo(revDate) >= 0;
            }
            return true;
        }
        Certificate c = null;
        try {
            c = new Certificate(certificate);
            c.isValid();
            return false;
        }
        catch (CertificateExpiredException e) {
        }
        catch (CertificateNotYetValidException e) {
            return false;
        }
        catch (CapiException e) {
            throw e;
        }
        String dateFormat = "yyyyMMddHHmmss";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date expiredCertsOnCRL = null;
        try {
            expiredCertsOnCRL = this.getExpiredCertsOnCRL();
        }
        catch (Exception e) {
            throw new CapiException("CRL ExpiredCertsOnCRL parsing exception", 31003);
        }
        if (expiredCertsOnCRL == null) {
            throw new CapiException("Certificate expired, CRL without expired certs", 31009);
        }
        String exp = c.getValidityNotAfter(dateFormat);
        Date crtExpiry = null;
        try {
            crtExpiry = sdf.parse(exp);
        }
        catch (ParseException e) {
            throw new CapiException("Certificate expiry date parsing exception", 30002);
        }
        if (crtExpiry.compareTo(expiredCertsOnCRL) >= 0) {
            return false;
        }
        throw new CapiException("Certificate has expired before the date in extension ExpiredCertsOnCRL ", 31012);
    }

    public String getThisUpdate(String format) throws CapiException {
        try {
            Date d = this.theCRL.getThisUpdate();
            return Util.formatDate(d, format);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String getNextUpdate(String format) throws CapiException {
        try {
            Date d = this.theCRL.getNextUpdate();
            if (d == null) {
                return null;
            }
            return Util.formatDate(d, format);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public void verify(byte[] cacert) throws CapiException {
        if (cacert == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Certificate ca = new Certificate(cacert);
            String issuer = this.theCRL.getIssuerX500Principal().getName("RFC2253");
            String subject = ca.getInternalCert().getSubjectX500Principal().getName();
            if (!issuer.equalsIgnoreCase(subject)) {
                logger.debug("issuer: " + issuer);
                logger.debug("subject: " + subject);
                throw new CapiException("IssuerDN does not match", 31002);
            }
            PublicKey key = ca.getPublicKey();
            this.theCRL.verify(key);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SignatureException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("The signature is not valid", 31001);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("The signature is not valid", 31001);
        }
    }

    public BigInteger[] listCertificates() throws CapiException {
        try {
            Set<? extends X509CRLEntry> certs = this.theCRL.getRevokedCertificates();
            if (certs == null || certs.isEmpty()) {
                return new BigInteger[0];
            }
            Object[] certs_arr = certs.toArray();
            BigInteger[] list_sn = new BigInteger[certs_arr.length];
            for (int i = 0; i < certs_arr.length; ++i) {
                X509CRLEntry tmp_rc = (X509CRLEntry)certs_arr[i];
                list_sn[i] = tmp_rc.getSerialNumber();
            }
            return list_sn;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String[] listCertificates(char separator) throws CapiException {
        try {
            logger.debug("CRL:listCertificates:getRevokedCertificates");
            Set<? extends X509CRLEntry> certs = this.theCRL.getRevokedCertificates();
            logger.debug("CRL:listCertificates:set null ?");
            if (certs == null || certs.isEmpty()) {
                return new String[0];
            }
            logger.debug("CRL:listCertificates:set not null");
            Object[] certs_arr = certs.toArray();
            String[] list = new String[certs_arr.length];
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < certs_arr.length; ++i) {
                X509CRLEntry rc = (X509CRLEntry)certs_arr[i];
                sb.setLength(0);
                String bigh = Util.bigIntToHexStr(rc.getSerialNumber());
                sb.append(bigh);
                sb.append(separator);
                String rdate = this.getRevocationDate(rc.getSerialNumber());
                sb.append(rdate);
                sb.append(separator);
                int rcode = this.getReasonCode(rc.getSerialNumber());
                sb.append(rcode);
                sb.append(separator);
                list[i] = sb.toString();
            }
            return list;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String getRevocationDate(BigInteger serialNumber) throws CapiException {
        if (serialNumber == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            X509CRLEntry rc = this.theCRL.getRevokedCertificate(serialNumber);
            if (rc == null) {
                throw new CapiException("Cert is NOT revoked", 31004);
            }
            Date d = rc.getRevocationDate();
            return Util.formatDate(d, null);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public int getReasonCode(BigInteger serialNumber) throws CapiException {
        if (serialNumber == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            X509CRLEntry rc = this.theCRL.getRevokedCertificate(serialNumber);
            if (rc == null) {
                throw new CapiException("Cert is NOT revoked", 31004);
            }
            if (!rc.hasExtensions()) {
                return 0;
            }
            byte[] reason = rc.getExtensionValue(Extension.reasonCode.getId());
            if (reason == null) {
                return 0;
            }
            ASN1Enumerated reasonCode = (ASN1Enumerated)X509ExtensionUtil.fromExtensionValue((byte[])reason);
            return reasonCode.getValue().intValue();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CRL format alert", 31000);
        }
    }

    public String toString() {
        String ret = null;
        String newline = System.getProperty("line.separator");
        try {
            ret = "CRL " + this.theCRL.getType() + " version " + this.theCRL.getVersion() + newline + "Signature Algorithm: " + this.theCRL.getSigAlgName() + newline + "Issuer: " + this.getIssuerDN() + newline + "this update: " + Util.formatDate(this.theCRL.getThisUpdate(), "EEE, d MMM yyyy HH:mm:ss z") + newline + "next update: " + Util.formatDate(this.theCRL.getNextUpdate(), "EEE, d MMM yyyy HH:mm:ss z") + newline + (this.theCRL.getRevokedCertificates() != null && !this.theCRL.getRevokedCertificates().isEmpty() ? this.theCRL.getRevokedCertificates().size() : 0) + " revoked certificates" + newline;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
        return ret;
    }

    public String getDownloadedUrl() {
        return this.downloadedUrl;
    }

    public void setDownloadedUrl(String downloadedUrl) {
        this.downloadedUrl = downloadedUrl;
    }

    static {
        logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        debug = false;
    }
}

