/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.certdb.CertDBDiff;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.certdb.CertDBUtils;
import it.actalis.ellips.capi.certdb.ThreadControlloCertDb;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.Version;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.bc.Base64;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniFileException;
import it.actalis.ellips.capi.util.ini.SignedIniFile;
import it.actalis.ellips.capi.util.map.LRUMap;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.encoders.DecoderException;
import org.slf4j.Logger;

public class CertDB {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static LRUMap<String, CertDB> dbCache = new LRUMap(10);
    private static Thread thControlloCertDb = null;
    private static ThreadControlloCertDb thObjControlloCertDb = null;
    private String filePath = null;
    private SignedIniFile db = null;
    private byte[] dbPwd = null;
    private long lastModified = -1L;
    private final String cdbVersion = "100";
    private List<String> errorUrl = new LinkedList<String>();
    public static final String CDB_DEFAULT_KEY = "1234567890AAbbCCdd";

    private CertDB(String filePath, String pwd, boolean createNew) throws CertDBException {
        this(filePath, pwd, createNew, false);
    }

    private CertDB(String filePath, String pwd, boolean createNew, boolean bLazyLoad) throws CertDBException {
        byte[] pwdarr = null;
        try {
            pwdarr = Util.getBytes(pwd);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CertDBException(e.getMessage(), 80000);
        }
        this.dbPwd = pwdarr;
        this.filePath = filePath;
        try {
            if (createNew) {
                File f = new File(filePath);
                if (f.exists()) {
                    logger.debug("cdb already present ...");
                } else {
                    logger.debug("creating new cdb ...");
                    this.db = new SignedIniFile(String.format(Constants.CERT_DB_HEADER, "100", Version.getVersion()));
                    this.db.store(filePath, pwdarr);
                    logger.debug("new cdb was created");
                    f = new File(filePath);
                    this.lastModified = f.lastModified();
                }
            }
            if (!bLazyLoad) {
                this.init();
            }
        }
        catch (IniFileException e) {
            throw CertDBException.convertDB(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CertDBException("Wrong password or altered", 80001);
        }
        catch (FileNotFoundException e) {
            throw new CertDBException("File not found", 80004);
        }
        catch (IOException e) {
            throw new CertDBException("I/O error", 80005);
        }
        catch (CapiException e) {
            throw new CertDBException(e.getMessage(), 80005);
        }
        catch (Exception e) {
            throw new CertDBException(e.getMessage(), 80005);
        }
    }

    public static synchronized void startUpdateControl() {
        if (thObjControlloCertDb == null) {
            thObjControlloCertDb = new ThreadControlloCertDb(dbCache);
            thControlloCertDb = new Thread(thObjControlloCertDb);
            thControlloCertDb.setDaemon(true);
            thControlloCertDb.start();
        }
    }

    public static synchronized void stopUpdateControl() throws InterruptedException {
        if (thObjControlloCertDb != null) {
            thObjControlloCertDb.shutdown();
            thControlloCertDb.join();
            thObjControlloCertDb = null;
            thControlloCertDb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertDB getInstance(String filePath, String pwd, boolean createNew, boolean cached) throws CertDBException {
        if (!cached) {
            return new CertDB(filePath, pwd, createNew);
        }
        CertDB db = (CertDB)dbCache.get(filePath);
        if (db != null) {
            return db;
        }
        LRUMap<String, CertDB> lRUMap = dbCache;
        synchronized (lRUMap) {
            db = (CertDB)dbCache.get(filePath);
            if (db != null) {
                return db;
            }
            db = new CertDB(filePath, pwd, createNew);
            dbCache.put(filePath, db);
        }
        return db;
    }

    private SignedIniFile getDB() {
        if (this.db != null) {
            return this.db;
        }
        try {
            this.init();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        catch (UnrecoverableKeyException ex) {
            logger.error(ex.getMessage());
        }
        catch (IniFileException ex) {
            logger.error(ex.getMessage());
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return this.db;
    }

    private synchronized void init() throws IOException, UnrecoverableKeyException, IniFileException, CapiException, UnsupportedEncodingException, InstantiationException, InstantiationException, IllegalAccessException {
        if (this.db == null) {
            this.db = new SignedIniFile(this.filePath, this.dbPwd, CertDBItem.class);
            File f = new File(this.filePath);
            this.lastModified = f.lastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CertDBItem item) throws CertDBException {
        if (item.getParent() != null && item.getParent() != this) {
            throw new CertDBException("Cannot add Item, already in another DB", 80010);
        }
        if (item.getType() == 0) {
            throw new CertDBException("Cannot add item, type is UNKNOWN", 80012);
        }
        if (item.getType() == 8) {
            throw new CertDBException("Cannot add item, type is SUSPECT", 80008);
        }
        SignedIniFile signedIniFile = this.db;
        synchronized (signedIniFile) {
            String cert = item.getIniPropertyStringValue("cert");
            if (this.getDB().containsProperty("cert", cert)) {
                throw new CertDBException("Certificate already present", 80011);
            }
            int id = 0;
            String key = CertDB.generateKeyByItem(item, id);
            if (id == 0) {
                while (this.getDB().containsObject(key)) {
                    key = CertDB.generateKeyByItem(item, ++id);
                }
            }
            item.setID(key);
            item.setParent(this);
            this.getDB().setObject(key, item);
        }
    }

    static String generateKeyByItem(CertDBItem item, int counter) {
        return CertDB.generateKeyByName(item.getSubject(), counter);
    }

    static String generateKeyByName(String name, int counter) {
        String strReturn = null;
        try {
            strReturn = new String(Base64.encode((byte[])name.getBytes("UTF-8"))) + "-" + counter;
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return strReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(CertDBItem item) throws CertDBException {
        SignedIniFile signedIniFile = this.db;
        synchronized (signedIniFile) {
            boolean oldKeyFormat = true;
            try {
                Integer.parseInt(item.getID());
            }
            catch (NumberFormatException ex) {
                oldKeyFormat = false;
            }
            if (oldKeyFormat) {
                this.getDB().removeObject(new Integer(item.getID()).toString());
            } else {
                this.getDB().removeObject(item.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(CertDBItem item) throws CertDBException {
        try {
            SignedIniFile signedIniFile = this.db;
            synchronized (signedIniFile) {
                if (this.contains(item.getCert(false)) == null) {
                    return false;
                }
                this.getDB().setObject(item.getID(), item);
                return true;
            }
        }
        catch (CapiException ex) {
            return false;
        }
    }

    public CertDBItem[] list(int type) throws CertDBException {
        return this.list(type, 127);
    }

    public CertDBItem[] list(int type, int usageFilter) throws CertDBException {
        logger.debug("getting object list ... ");
        String[] ids = this.getDB().getObjectList2();
        logger.debug("selecting items list ... ");
        Vector<CertDBItem> allDbs = new Vector<CertDBItem>();
        for (int i = 0; i < ids.length; ++i) {
            CertDBItem item = this.getEntry(ids[i]);
            if (usageFilter != 127 && (usageFilter & item.getUsage()) == 0) {
                logger.debug("list: skipped usage for " + item.getName());
                continue;
            }
            if ((type & item.getType()) <= 0) continue;
            allDbs.addElement(item);
        }
        logger.debug("returning items list ... ");
        CertDBItem[] dbs = new CertDBItem[allDbs.size()];
        for (int i = 0; i < allDbs.size(); ++i) {
            dbs[i] = (CertDBItem)allDbs.elementAt(i);
        }
        return dbs;
    }

    public int getSize() {
        return this.getDB().size();
    }

    public void onLineVerify(NetworkConfig config, byte[] cert, List<CertDBItem> chain) throws CapiException {
        this.intOnLineVerify(config, cert, chain);
    }

    public CertDBItem[] onLineVerify(NetworkConfig config, CertDBItem dbItem) throws CapiException {
        byte[] encCert = new byte[]{};
        try {
            encCert = dbItem.getCertificate().getInternalCert().getEncoded();
        }
        catch (CertificateEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid certificate", 30005, e);
        }
        return this.intOnLineVerify(config, encCert);
    }

    public CertDBItem[] onLineVerify(NetworkConfig config, byte[] cert) throws CapiException {
        return this.intOnLineVerify(config, cert);
    }

    public CertDBItem[] onLineVerify(ValidationContextParameters contextParams) throws CapiException {
        byte[] encCert = new byte[]{};
        try {
            encCert = contextParams.getSignerCertificate().getCert().getInternalCert().getEncoded();
        }
        catch (CertificateEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid certificate", 30005, e);
        }
        return this.intOnLineVerify(contextParams.getConfig().getNetConfiguration(), encCert);
    }

    private CertDBItem[] intOnLineVerify(NetworkConfig config, byte[] cert) throws CapiException {
        ArrayList<CertDBItem> chain = new ArrayList<CertDBItem>();
        this.intOnLineVerify(config, cert, chain);
        return chain.toArray(new CertDBItem[chain.size()]);
    }

    private void intOnLineVerify(NetworkConfig config, byte[] cert, List<CertDBItem> chain) throws CapiException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("verify chain element: " + new Certificate(cert).getName() + ", " + new Certificate(cert).getOcspUrl() + ", " + Arrays.toString(new Certificate(cert).getCdpURLs()));
            }
            this.verify(cert, null, chain);
        }
        catch (CapiException ex) {
            Certificate objCert = !chain.isEmpty() ? new Certificate(chain.get(chain.size() - 1).getCert(true)) : new Certificate(cert);
            if (Util.isNullOrEmpty(objCert.getCaIssuer())) {
                throw ex;
            }
            if (objCert.getIssuerDN().equals(objCert.getSubjectDN())) {
                throw ex;
            }
            UrlClient client = new UrlClient(config, logger);
            UrlReturn ret = client.downloadUrl(objCert.getCaIssuer(), null, null);
            if (ret == null || ret.getStatus() == null || !ret.getStatus().equals("OK") || ret.getData() == null) {
                throw ex;
            }
            CertDBItem dbItem = this.canImport(ret.getData());
            dbItem.setSource(4);
            chain.add(dbItem);
            byte[] encCert = new byte[]{};
            try {
                encCert = dbItem.getCertificate().getInternalCert().getEncoded();
            }
            catch (CertificateEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new CapiException("Invalid certificate", 30005, e);
            }
            this.onLineVerify(config, encCert, chain);
            this.add(dbItem);
        }
    }

    public boolean resolveChainOnLine(NetworkConfig config, byte[] cert, LinkedList<CertDBItem> dbItems) throws CapiException {
        boolean bRet = false;
        String caIssuerLink = "";
        try {
            Certificate objCert = new Certificate(cert);
            if (objCert.getIssuerDN().equals(objCert.getSubjectDN())) {
                throw new CapiException("this is self-signed certificate", 30005, 0);
            }
            caIssuerLink = objCert.getCaIssuer();
            if (Util.isNullOrEmpty(caIssuerLink)) {
                throw new CapiException("current certificate has not caIssuer information: incomplete chain", 30005, 1);
            }
            if (this.errorUrl.contains(caIssuerLink = caIssuerLink.toLowerCase())) {
                return false;
            }
            byte[] caIssuerByteCert = null;
            UrlClient client = new UrlClient(config, logger);
            try {
                UrlReturn ret = client.downloadUrl(caIssuerLink, null, null);
                if (ret == null || ret.getStatus() == null || !ret.getStatus().equals("OK") || ret.getData() == null || ret.getData().length == 0) {
                    throw new CapiException("unable to download the caIssuer certificate", 30005, 1);
                }
                caIssuerByteCert = Util.getBytesFromPemOrBase64(ret.getData());
            }
            catch (Exception ret) {
                // empty catch block
            }
            if (caIssuerByteCert == null) {
                throw new CapiException("unable to download the caIssuer certificate", 30005, 2);
            }
            CertDBItem caIssuerItem = this.canImport(caIssuerByteCert);
            for (int i = 0; i < dbItems.size(); ++i) {
                if (!Arrays.equals(dbItems.get(i).getCert(true), caIssuerItem.getCert(true))) continue;
                throw new CapiException("caIssuer certificate is not as expected: chain loop!", 30005, 1);
            }
            dbItems.add(caIssuerItem);
            bRet = this.resolveChainOnLine(config, caIssuerItem.getCert(true), dbItems);
        }
        catch (CapiException ex) {
            if (ex.getDetailReason() == 0) {
                bRet = true;
            } else if (!(ex instanceof CertDBException)) {
                logger.info(ex.getMessage() + " -> " + caIssuerLink);
            }
        }
        catch (DecoderException ex) {
            logger.info("unable to decode caIssuer certificate " + caIssuerLink);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (!bRet && !this.errorUrl.contains(caIssuerLink)) {
            this.errorUrl.add(caIssuerLink);
        }
        return bRet;
    }

    public CertDBItem[] verify(byte[] cert) throws CertDBException, CapiException {
        logger.debug("verifying cert byte[]");
        return this.verify(cert, null, null);
    }

    public CertDBItem[] verify(CertDBItem cert) throws CertDBException, CapiException {
        logger.debug("verifying cert DBItem");
        return this.verify(null, cert, null);
    }

    public void changePwd(String oldPwd, String newPwd) throws CertDBException {
        try {
            if (!Util.equalsBlock(Util.getBytes(oldPwd), this.dbPwd)) {
                throw new CertDBException("Wrong password", 80002);
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CertDBException("Wrong password", 80002);
        }
        try {
            this.dbPwd = Util.getBytes(newPwd);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CertDBException(e.getMessage(), 80000);
        }
        logger.debug("changing pwd to DB...");
        try {
            this.store();
            logger.debug("changed  pwd to DB...");
        }
        catch (CertDBException cdbe) {
            logger.debug(cdbe.getMessage(), (Throwable)cdbe);
            try {
                this.dbPwd = Util.getBytes(oldPwd);
            }
            catch (CapiException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CertDBException(e.getMessage(), 80000);
            }
            throw cdbe;
        }
    }

    public CertDBItem canImport(byte[] cert) throws CapiException, CertDBException {
        return this.canImport(cert, null);
    }

    public CertDBItem canImport(byte[] cert, List<CertDBItem.EllipsUsage> ellipsUsages) throws CapiException, CertDBException {
        return this.canImport(cert, null, 2);
    }

    public CertDBItem canImport(byte[] cert, List<CertDBItem.EllipsUsage> ellipsUsages, int sourceType) throws CapiException, CertDBException {
        Certificate c = new Certificate(cert);
        SignedIniFile signedIniFile = this.db;
        synchronized (signedIniFile) {
            CertDBItem item = this.contains(cert);
            if (item != null) {
                throw new CertDBException("Cannot import item, already in DB", 80011);
            }
            item = new CertDBItem(null, cert, ellipsUsages);
            item.setSource(sourceType);
            switch (item.getType()) {
                case 1: 
                case 2: {
                    List<String> items = this.findByName(CertDBUtils.getIssuerFromCert(c));
                    if (items.isEmpty() || sourceType == 1) {
                        return item;
                    }
                    CertDBItem item_issuer = null;
                    try {
                        item_issuer = this.verifyIssuers(items, c);
                        return item;
                    }
                    catch (CertDBException cde) {
                        logger.debug(cde.getMessage(), (Throwable)cde);
                        throw cde;
                    }
                }
                case 4: {
                    return item;
                }
                case 8: {
                    throw new CertDBException("Cannot import a certificate altered", 80008);
                }
            }
            throw new CertDBException("Cannot import unknown certificate", 80012);
        }
    }

    public void store() throws CertDBException {
        this.store(this.filePath, false);
    }

    public void store(String filePath) throws CertDBException {
        this.store(filePath, true);
    }

    public void store(File file) throws CertDBException {
        this.store(file.getAbsolutePath(), true);
    }

    private void store(String file, boolean checkCurrentCdb) throws CertDBException {
        try {
            this.getDB().setLoadTkId(String.format(Constants.CERT_DB_HEADER, "100", Version.getVersion()).getBytes());
            this.getDB().store(file, this.dbPwd, checkCurrentCdb);
        }
        catch (IniFileException e) {
            throw CertDBException.convertDB(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CertDBException("Wrong password or altered", 80001);
        }
        catch (IOException e) {
            throw new CertDBException("I/O error", 80006);
        }
        File f = new File(this.filePath);
        this.lastModified = f.lastModified();
    }

    public CertDBItem contains(byte[] cert) throws CapiException {
        Certificate c = new Certificate(cert);
        List<String> items = this.findByName(CertDBUtils.getSubjectFromCert(c));
        if (items.size() == 0) {
            return null;
        }
        for (int i = 0; i < items.size(); ++i) {
            try {
                String dbcert = this.db.getProperty(items.get(i), "cert");
                Certificate dbcert2 = new Certificate(Util.getBytes(dbcert));
                if (!dbcert2.equals(c)) continue;
                return this.getEntry(items.get(i));
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private List<String> findByName(String certName) {
        LinkedList<String> lstKey = new LinkedList<String>();
        int id = 0;
        String key = CertDB.generateKeyByName(certName, id);
        while (this.getDB().getObject(key) != null) {
            lstKey.add(key);
            key = CertDB.generateKeyByName(certName, ++id);
        }
        return lstKey;
    }

    private CertDBItem getEntry(String id) {
        CertDBItem item = (CertDBItem)this.getDB().getObject(id);
        item.setParent(this);
        item.setID(id);
        return item;
    }

    private CertDBItem[] verify(byte[] cert, CertDBItem itself, List<CertDBItem> chain) throws CertDBException, CapiException {
        int i;
        Vector<CertDBItem> tmp = new Vector<CertDBItem>();
        int tmp_index = -1;
        boolean end = false;
        boolean found_itself_issuer = false;
        int maxLoop = 20;
        int statusItself = 82112;
        Vector tmpStatus = new Vector();
        CertDBItem certItem = null;
        Certificate objCert = null;
        if (itself == null) {
            objCert = new Certificate(cert);
            certItem = this.contains(cert);
        } else {
            objCert = itself.getCertificate();
            certItem = itself;
        }
        while (!end && --maxLoop > 0) {
            Certificate newc;
            if (found_itself_issuer) {
                int pathLen;
                tmp.addElement(certItem);
                ++tmp_index;
                if (objCert.hasUnsupportedCriticalExtension()) {
                    this.setStatus(tmp_index, 82113, tmpStatus);
                }
                if ((pathLen = objCert.getBasicConstraintsPathLen()) >= 0 && tmp_index > pathLen) {
                    logger.debug("verify KO: violated pathLen:" + pathLen);
                    this.setStatus(tmp_index, 82111, tmpStatus);
                    end = true;
                    continue;
                }
                int trust_val = certItem.getTrust();
                if (trust_val == 2) {
                    logger.debug("verify OK: cert trusted");
                    this.setStatus(tmp_index, 82101, tmpStatus);
                    end = true;
                    continue;
                }
                if (trust_val == 0) {
                    logger.debug("verify KO: cert UNtrusted");
                    this.setStatus(tmp_index, 82111, tmpStatus);
                    end = true;
                    continue;
                }
                logger.debug("verify: inheriting status from parent");
            } else {
                if (objCert.hasUnsupportedCriticalExtension()) {
                    logger.debug("hasUnsupportedCritExt");
                }
                if (certItem != null) {
                    logger.debug("verify: cert is already in CertDB");
                    int trust_val = certItem.getTrust();
                    if (trust_val == 2) {
                        logger.debug("verify OK: cert trusted");
                        statusItself = this.setStatusItself(82101, statusItself);
                        end = true;
                        continue;
                    }
                    if (trust_val == 0) {
                        logger.debug("verify KO: cert UNtrusted");
                        statusItself = this.setStatusItself(82111, statusItself);
                        end = true;
                        continue;
                    }
                    logger.debug("verify: inheriting status from parent");
                }
            }
            List<String> items = this.findByName(CertDBUtils.getIssuerFromCert(objCert));
            CertDBItem item_verified = null;
            try {
                item_verified = this.verifyIssuers(items, objCert);
                if (found_itself_issuer) {
                    this.setStatus(tmp_index, 82100, tmpStatus);
                } else {
                    statusItself = this.setStatusItself(82100, statusItself);
                    found_itself_issuer = true;
                }
            }
            catch (CertDBException cde) {
                logger.debug(cde.getMessage(), (Throwable)cde);
                if (found_itself_issuer) {
                    this.setStatus(tmp_index, cde.getErrorCode(), tmpStatus);
                } else {
                    statusItself = this.setStatusItself(cde.getErrorCode(), statusItself);
                    found_itself_issuer = true;
                }
                end = true;
                continue;
            }
            if (chain != null) {
                chain.add(item_verified);
            }
            if ((newc = new Certificate(item_verified.getCert(false))).equals(objCert)) {
                end = true;
            } else {
                objCert = newc;
            }
            certItem = item_verified;
        }
        if (maxLoop <= 0) {
            logger.debug("verify: Max number of loops reached");
            throw new CertDBException("Too many loop", 80000);
        }
        int[] res_status = new int[tmpStatus.size()];
        CertDBItem[] res = new CertDBItem[tmp.size()];
        for (i = 0; i < res.length; ++i) {
            res[i] = (CertDBItem)tmp.elementAt(i);
            res_status[i] = Integer.parseInt((String)tmpStatus.elementAt(i));
        }
        if (statusItself == 82101 || statusItself == 82100) {
            if (res.length == 0) {
                if (statusItself == 82101) {
                    return res;
                }
                throw new CertDBException("Why VERIFIED and no chain ?", 80020);
            }
            for (i = 0; i < res_status.length; ++i) {
                if (res_status[i] == 82101 || res_status[i] == 82100) continue;
                throw new CertDBException("The chain is incomplete or untrusted", 80021, res, res_status, statusItself);
            }
            return res;
        }
        if (res.length == 0) {
            switch (statusItself) {
                case 82111: {
                    throw new CertDBException("untrusted", 82111, res, res_status, statusItself);
                }
                case 30007: {
                    throw new CertDBException("altered?", 30007, res, res_status, statusItself);
                }
            }
            throw new CertDBException("Issuer certificate not found", 80020, res, res_status, statusItself);
        }
        throw new CertDBException("The chain is incomplete or untrusted", 80021, res, res_status, statusItself);
    }

    private CertDBItem verifyIssuers(List<String> dbItems, Certificate certificate) throws CertDBException {
        return this.verifyIssuers(dbItems, certificate, null);
    }

    private CertDBItem verifyIssuers(List<String> dbItems, Certificate certificate, ValidationProfile validationProfile) throws CertDBException {
        int i;
        if (dbItems.isEmpty()) {
            throw new CertDBException("no issuer(s) found in CertDB", 82114, null, null);
        }
        int[] verifyIssStatus = new int[dbItems.size()];
        CertDBItem[] verifyIss = new CertDBItem[dbItems.size()];
        for (i = 0; i < dbItems.size(); ++i) {
            verifyIss[i] = null;
            try {
                CertDBItem issuerDBItem = this.getEntry(dbItems.get(i));
                logger.debug("Loop " + i + ": trying with " + issuerDBItem.getName());
                try {
                    certificate.verify(issuerDBItem.getCert(false));
                    verifyIssStatus[i] = 82100;
                    if (validationProfile != null && !issuerDBItem.isAdmittedByProfile(validationProfile)) {
                        throw new CapiException("issuer not admitted by selected validation profile", 1003);
                    }
                    return issuerDBItem;
                }
                catch (CapiException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    verifyIss[i] = issuerDBItem;
                    verifyIssStatus[i] = e.getErrorCode();
                    continue;
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    verifyIssStatus[i] = 1003;
                    continue;
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                verifyIssStatus[i] = 1003;
            }
        }
        logger.debug("no verified found; list status errors ...");
        block14: for (i = 0; i < verifyIssStatus.length; ++i) {
            switch (verifyIssStatus[i]) {
                case 1001: {
                    logger.debug("[" + i + "]=null_args  " + verifyIssStatus[i] + ":" + verifyIss[i]);
                    continue block14;
                }
                case 30002: {
                    logger.debug("[" + i + "]=cert_format" + verifyIssStatus[i] + ":" + verifyIss[i]);
                    continue block14;
                }
                case 30004: {
                    logger.debug("[" + i + "]=crtverifyss" + verifyIssStatus[i] + ":" + verifyIss[i]);
                    continue block14;
                }
                case 30003: {
                    logger.debug("[" + i + "]=cert_verify" + verifyIssStatus[i] + ":" + verifyIss[i]);
                    continue block14;
                }
                case 30006: {
                    logger.debug("[" + i + "]=cert_subjki" + verifyIssStatus[i] + ":" + verifyIss[i]);
                    continue block14;
                }
                case 30007: {
                    logger.debug("[" + i + "]=certaltered" + verifyIssStatus[i] + ":" + verifyIss[i]);
                    continue block14;
                }
                default: {
                    logger.debug("[" + i + "]=" + dbItems.get(i) + verifyIssStatus[i] + ":" + verifyIss[i]);
                }
            }
        }
        throw new CertDBException("issuer(s) not verified", verifyIssStatus[0], null, null);
    }

    private int setStatusItself(int newStatus, int statusItself) {
        switch (statusItself) {
            case 82100: 
            case 82112: {
                logger.debug("status itself ex-valid set to " + newStatus);
                statusItself = newStatus;
                return statusItself;
            }
            case 82101: {
                if (newStatus == 82100) break;
                logger.debug("status itself ex-valid set to " + newStatus);
                statusItself = newStatus;
                return statusItself;
            }
            case 82113: {
                if (newStatus == 82112 || newStatus == 82101 || newStatus == 82111 || newStatus == 82100) break;
                logger.debug("status itself ex-! set to " + newStatus);
                statusItself = newStatus;
                return statusItself;
            }
            case 82111: {
                if (newStatus == 82112 || newStatus == 82101 || newStatus == 82100) break;
                logger.debug("status itself ex-! set to " + newStatus);
                statusItself = newStatus;
                return statusItself;
            }
            default: {
                if (newStatus == 82112 || newStatus == 82101 || newStatus == 82100 || newStatus == 82113 || newStatus == 82111) break;
                logger.debug("status itself ex-X set to " + newStatus);
                statusItself = newStatus;
                return statusItself;
            }
        }
        logger.debug("status itself value =" + statusItself);
        logger.debug("not overwritten with=" + newStatus);
        return statusItself;
    }

    private void setStatus(int pos, int newStatus, Vector tmpStatus) {
        if (pos >= tmpStatus.size()) {
            logger.debug("status appending " + newStatus + " at pos:" + pos);
            tmpStatus.insertElementAt(new Integer(newStatus).toString(), pos);
            return;
        }
        int status = Integer.parseInt((String)tmpStatus.elementAt(pos));
        switch (status) {
            case 82100: 
            case 82112: {
                logger.debug("status ex-valid set to " + newStatus);
                tmpStatus.insertElementAt(new Integer(newStatus).toString(), pos);
                return;
            }
            case 82101: {
                if (newStatus == 82100) break;
                logger.debug("status ex-valid set to " + newStatus);
                tmpStatus.insertElementAt(new Integer(newStatus).toString(), pos);
                return;
            }
            case 82113: {
                if (newStatus == 82112 || newStatus == 82101 || newStatus == 82111 || newStatus == 82100) break;
                logger.debug("status ex-! set to " + newStatus);
                tmpStatus.insertElementAt(new Integer(newStatus).toString(), pos);
                return;
            }
            case 82111: {
                if (newStatus == 82112 || newStatus == 82101 || newStatus == 82100) break;
                logger.debug("status ex-! set to " + newStatus);
                tmpStatus.insertElementAt(new Integer(newStatus).toString(), pos);
                return;
            }
            default: {
                if (newStatus == 82112 || newStatus == 82101 || newStatus == 82100 || newStatus == 82113 || newStatus == 82111) break;
                logger.debug("status ex-X set to " + newStatus);
                tmpStatus.insertElementAt(new Integer(newStatus).toString(), pos);
                return;
            }
        }
        logger.debug("status value =" + status);
        logger.debug("not overwritten with=" + newStatus);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static CertDB instanceFromList(LinkedList<X509Certificate> certs, String filePath, String pwd) throws CertDBException {
        File newCdbFile = new File(filePath);
        if (newCdbFile.exists()) {
            newCdbFile.delete();
        }
        CertDB db = new CertDB(filePath, pwd, true);
        if (certs == null) {
            return db;
        }
        for (X509Certificate cert : certs) {
            try {
                CertDBItem item = db.canImport(cert.getEncoded());
                db.add(item);
            }
            catch (CapiException capiException) {
            }
            catch (CertificateEncodingException certificateEncodingException) {}
        }
        return db;
    }

    public KeyStore toTrustStore() throws CertDBException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance("JKS");
        store.load(null, null);
        CertDBItem[] items = this.list(6);
        for (int i = 0; i < items.length; ++i) {
            try {
                store.setCertificateEntry("cert_" + i, items[i].getCertificate().getInternalCert());
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return store;
    }

    public void refresh() throws CertDBException {
        File f = new File(this.filePath);
        if (this.lastModified < f.lastModified()) {
            try {
                this.db = null;
                this.init();
            }
            catch (IniFileException e) {
                throw CertDBException.convertDB(e);
            }
            catch (UnrecoverableKeyException e) {
                throw new CertDBException("Wrong password or altered", 80001);
            }
            catch (FileNotFoundException e) {
                throw new CertDBException("File not found", 80004);
            }
            catch (IOException e) {
                throw new CertDBException("I/O error", 80005);
            }
            catch (CapiException e) {
                throw new CertDBException(e.getMessage(), 80005);
            }
            catch (Exception e) {
                throw new CertDBException(e.getMessage(), 80005);
            }
        }
    }

    public String getVersion() {
        return new String(this.getDB().getLoadTkId());
    }

    public String getVersionCdbFormat() {
        String header = new String(this.getDB().getLoadTkId());
        if (header.contains("[")) {
            header = header.replace("Ellips CertDB v. ", "");
            int index = header.indexOf("[");
            String cdbVer = header.substring(0, index).trim();
            return cdbVer;
        }
        return null;
    }

    public String getVersionCAPI() {
        String header = new String(this.getDB().getLoadTkId());
        if ((header = header.replace("Ellips CertDB v. ", "")).contains("[")) {
            int index = header.indexOf("[");
            String capiVer = header.substring(index + 1, header.length() - 1).trim();
            return capiVer;
        }
        String capiVer = header.substring(0, header.length()).trim();
        return capiVer;
    }

    @Deprecated
    public void mergeFromPreviousVersionOld(CertDB previousDB, boolean removeSystemRoots) throws CertDBException, CapiException {
        logger.info("Merge CertDB from previous version");
        logger.info("- current version: " + this.getVersion());
        logger.info("- previous version: " + previousDB.getVersion());
        if (!this.isMergeableWith(previousDB)) {
            throw new CapiException("current cdb is not mergeable with the previous one: previous cdb format is newer than current", 80003);
        }
        for (CertDBItem oldItem : previousDB.list(7)) {
            int oldSource = oldItem.getSource();
            CertDBItem newItem = this.contains(oldItem.getCert(true));
            if (newItem != null) {
                if (oldSource == 3 || oldSource == 2 || newItem.getSource() == 0 || oldSource != 0) continue;
                newItem.resetEllipsUsage();
                newItem.addEllipsUsages(oldItem.getEllipsUsages());
                newItem.setSource(0);
                continue;
            }
            newItem = this.canImport(oldItem.getCert(true), null, oldSource);
            if (oldSource != 3) {
                if (oldSource == 2) {
                    newItem.setSource(2);
                    newItem.addEllipsUsages(oldItem.getEllipsUsages());
                    this.add(newItem);
                }
                if (oldSource != 0 || removeSystemRoots) continue;
                newItem.setSource(0);
                newItem.addEllipsUsages(oldItem.getEllipsUsages());
                this.add(newItem);
                continue;
            }
            newItem.setSource(2);
            try {
                this.add(newItem);
            }
            catch (CertDBException cdbe) {
                logger.error(cdbe.getMessage(), (Throwable)cdbe);
            }
        }
    }

    public void mergeFromPreviousVersion(CertDB previousDB) throws CertDBException, CapiException {
        this.mergeFromPreviousVersion(previousDB, false);
    }

    public void mergeFromPreviousVersion(CertDB previousDB, boolean removeSystemRoots) throws CertDBException, CapiException {
        logger.info("Merge CertDB from previous version");
        logger.info("- current version: " + this.getVersion());
        logger.info("- previous version: " + previousDB.getVersion());
        if (!this.isMergeableWith(previousDB)) {
            throw new CapiException("current cdb is not mergeable with the previous one: previous cdb format is newer than current", 80003);
        }
        for (CertDBItem oldItem : previousDB.list(7)) {
            CertDBItem newItem = this.contains(oldItem.getCert(true));
            this.convertOldItemToNewItem(oldItem, newItem, removeSystemRoots);
        }
    }

    private void convertOldItemToNewItem(CertDBItem oldItem, CertDBItem newItem, boolean removeSystemRoots) throws CapiException {
        block24: {
            block23: {
                if (oldItem == null || newItem == null) break block23;
                switch (oldItem.getSource()) {
                    case 0: {
                        switch (newItem.getSource()) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                newItem.resetEllipsUsage();
                                newItem.addEllipsUsages(oldItem.getEllipsUsages());
                                newItem.setSource(0);
                                break block24;
                            }
                            case 0: {
                                break block24;
                            }
                            default: {
                                throw new CapiException("Unexpected item source", 80000);
                            }
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break block24;
                    }
                    default: {
                        throw new CapiException("Unexpected item source", 80000);
                    }
                }
            }
            if (oldItem != null) {
                newItem = this.canImport(oldItem.getCert(true), null, oldItem.getSource());
                boolean addIt = true;
                switch (oldItem.getSource()) {
                    case 3: {
                        newItem.setSource(2);
                        newItem.addEllipsUsages(oldItem.getEllipsUsages());
                        break;
                    }
                    case 0: {
                        if (removeSystemRoots) {
                            addIt = false;
                            break;
                        }
                        newItem.setSource(0);
                        newItem.addEllipsUsages(oldItem.getEllipsUsages());
                        break;
                    }
                    case 1: {
                        addIt = false;
                        break;
                    }
                    case 2: {
                        newItem.setSource(2);
                        newItem.addEllipsUsages(oldItem.getEllipsUsages());
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        throw new CapiException("Unexpected item source", 80000);
                    }
                }
                if (addIt) {
                    try {
                        this.add(newItem);
                    }
                    catch (CertDBException cdbe) {
                        logger.error(cdbe.getMessage(), (Throwable)cdbe);
                    }
                }
            } else if (newItem != null) {
                // empty if block
            }
        }
    }

    public boolean isMergeableWith(CertDB previousDB) {
        if (previousDB.getVersionCdbFormat() == null) {
            return true;
        }
        String previousFormatVer = previousDB.getVersionCdbFormat();
        String currentFormatVer = this.getVersionCdbFormat();
        if (currentFormatVer == null) {
            return false;
        }
        return currentFormatVer.compareTo(previousFormatVer) >= 0;
    }

    public int cleanPreTSLOrphans() throws CapiException {
        int totDeleted = 0;
        boolean orphanFound = true;
        int maxLevel = 3;
        int level = 0;
        while (orphanFound && level < 3) {
            orphanFound = false;
            ++level;
            for (CertDBItem preTSLItem : this.list(7)) {
                if (preTSLItem.getSource() != 5) continue;
                byte[] pretslAKI = preTSLItem.getCertificate().getAuthorityKeyIdentifier();
                boolean hasLink = false;
                for (CertDBItem childItem : this.list(7)) {
                    byte[] childAKI;
                    if (childItem.getType() != 2 && childItem.getSource() != 5 || !Util.equalsBlock(pretslAKI, childAKI = childItem.getCertificate().getAuthorityKeyIdentifier())) continue;
                    hasLink = true;
                    break;
                }
                if (hasLink) continue;
                this.delete(preTSLItem);
                orphanFound = true;
                ++totDeleted;
                logger.info("removed orphan root " + preTSLItem.getID());
            }
        }
        return totDeleted;
    }

    public CertDBDiff diffFrom(CertDB previousCdb) throws CertDBException, CapiException {
        return this.diffFrom(previousCdb, null);
    }

    public CertDBDiff diffFrom(CertDB previousCdb, ArrayList<Certificate> diffExclusions) throws CertDBException, CapiException {
        int iEx;
        CertDBDiff diff = new CertDBDiff();
        for (CertDBItem prevItem : previousCdb.list(7)) {
            CertDBItem curItem;
            if (diffExclusions != null) {
                boolean skip = false;
                for (iEx = 0; iEx < diffExclusions.size(); ++iEx) {
                    if (!new Certificate(prevItem.getCert(true)).equals(diffExclusions.get(iEx))) continue;
                    skip = true;
                }
                if (skip) continue;
            }
            if ((curItem = this.contains(prevItem.getCert(true))) != null) {
                if (curItem.isEqualTo(prevItem)) continue;
                diff.addUpdated(prevItem, curItem);
                continue;
            }
            diff.addRemove(prevItem);
        }
        for (CertDBItem newItem : this.list(7)) {
            CertDBItem curItem;
            if (diffExclusions != null) {
                boolean skip = false;
                for (iEx = 0; iEx < diffExclusions.size(); ++iEx) {
                    if (!new Certificate(newItem.getCert(true)).equals(diffExclusions.get(iEx))) continue;
                    skip = true;
                }
                if (skip) continue;
            }
            if ((curItem = previousCdb.contains(newItem.getCert(true))) != null) continue;
            diff.addAdded(newItem);
        }
        return diff;
    }

    public boolean isValidChain(CertDBItem[] chain, ValidationProfile validationProfile) {
        if (chain == null) {
            return false;
        }
        boolean trustedRootPresent = false;
        boolean admittedByProfile = true;
        for (CertDBItem item : chain) {
            if (item.getSource() != 6 && item.getSource() != 4 && !item.isAdmittedByProfile(validationProfile)) {
                logger.debug(String.format("certificate %s is not valid for selected validation profile %s", item.getName(), validationProfile.name()));
                admittedByProfile = false;
            }
            if (ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE.equals((Object)validationProfile)) {
                if (1 != item.getSource()) continue;
                trustedRootPresent = true;
                continue;
            }
            if (6 == item.getSource() || 4 == item.getSource()) continue;
            trustedRootPresent = true;
        }
        return admittedByProfile && trustedRootPresent;
    }
}

