/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class ValidatedDocumentUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final String NOTHING_INFO = "NESSUNA INFO PRESENTE";

    public static boolean hasMessage(ValidatedDocument validatedDoc, ValidatorMessageEnum messageEnum) {
        for (ValidatedSigner signer : validatedDoc.getReferenceSigners()) {
            if (ValidatedDocumentUtils.hasMessage(signer, messageEnum)) {
                return true;
            }
            for (ValidatedSigner cSigner : signer.getCounterSigners()) {
                if (!ValidatedDocumentUtils.hasMessage(cSigner, messageEnum)) continue;
                return true;
            }
            for (ValidatedSigner tSigner : signer.getTimeStamps()) {
                if (!ValidatedDocumentUtils.hasMessage(tSigner, messageEnum)) continue;
                return true;
            }
            ValidatedCertificate certificate = signer.getCert();
            if (!ValidatedDocumentUtils.hasMessage(certificate, messageEnum)) continue;
            return true;
        }
        for (ValidatedDocument refDoc : validatedDoc.getSubResults()) {
            if (!ValidatedDocumentUtils.hasMessage(refDoc, messageEnum)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMessage(ValidatedBean validatedObject, ValidatorMessageEnum messageEnum) {
        if (validatedObject.hasMessage(messageEnum)) {
            return true;
        }
        for (int iMessage = 0; iMessage < validatedObject.getMessages().size(); ++iMessage) {
            if (!ValidatedDocumentUtils.hasSubMessage(validatedObject.getMessages().get(iMessage), messageEnum.getCode())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSubMessage(ValidatorMessage validatorMessage, String messageEnum) {
        if (validatorMessage.getMessageCode().equals(messageEnum)) {
            return true;
        }
        for (int iNote = 0; iNote < validatorMessage.getNotes().size(); ++iNote) {
            if (!ValidatedDocumentUtils.hasSubMessage(validatorMessage.getNotes().get(iNote), messageEnum)) continue;
            return true;
        }
        return false;
    }

    public static List<ValidatorMessage> getAllMessages(ValidatedBean validatedObject) {
        LinkedList<ValidatorMessage> msgList = new LinkedList<ValidatorMessage>();
        for (ValidatorMessage message : validatedObject.getMessages()) {
            msgList.add(message);
            for (ValidatorMessage note : message.getNotes()) {
                msgList.addAll(ValidatedDocumentUtils.getAllSubMessages(note));
            }
        }
        return msgList;
    }

    public static List<ValidatorMessage> getAllSubMessages(ValidatorMessage validatorMessage) {
        LinkedList<ValidatorMessage> msgList = new LinkedList<ValidatorMessage>();
        msgList.add(validatorMessage);
        for (ValidatorMessage note : validatorMessage.getNotes()) {
            msgList.addAll(ValidatedDocumentUtils.getAllSubMessages(note));
        }
        return msgList;
    }

    public static List<ValidatorMessage> getAllMessages(ValidatedBean validatedObject, List<String> ignore) {
        LinkedList<ValidatorMessage> msgList = new LinkedList<ValidatorMessage>();
        for (ValidatorMessage message : validatedObject.getMessages()) {
            if (ignore.contains(message.getMessageCode())) continue;
            msgList.add(message);
            for (ValidatorMessage note : message.getNotes()) {
                msgList.addAll(ValidatedDocumentUtils.getAllSubMessages(note, ignore));
            }
        }
        return msgList;
    }

    public static List<ValidatorMessage> getAllSubMessages(ValidatorMessage validatorMessage, List<String> ignore) {
        LinkedList<ValidatorMessage> msgList = new LinkedList<ValidatorMessage>();
        if (!ignore.contains(validatorMessage.getMessageCode())) {
            msgList.add(validatorMessage);
            for (ValidatorMessage note : validatorMessage.getNotes()) {
                msgList.addAll(ValidatedDocumentUtils.getAllSubMessages(note));
            }
        }
        return msgList;
    }

    public static String toString(ValidatedDocument validatedDoc) {
        return ValidatedDocumentUtils.toString(validatedDoc, "");
    }

    public static String toString(ValidatedDocument validatedDoc, String initSpaces) {
        if (validatedDoc == null) {
            return "";
        }
        if (initSpaces == null) {
            initSpaces = "";
        }
        String ret = "";
        StringBuilder stringBuilder = new StringBuilder().append(ret);
        ret = ret + String.format("%s %s\n", initSpaces, validatedDoc.getShortName());
        ret = stringBuilder.append(ret).toString();
        for (ValidatorMessage docMsg : validatedDoc.getMessages()) {
            ret = ret + String.format("%s %s - %s - %s\n", new Object[]{initSpaces, docMsg.getLevel(), docMsg.getMessageCode(), docMsg.getMessage()});
        }
        initSpaces = initSpaces + " ";
        for (int iSigner = 0; iSigner < validatedDoc.getSigners().size(); ++iSigner) {
            ret = ret + ValidatedDocumentUtils.toString(validatedDoc.getSigners().get(iSigner), initSpaces, String.format("#%02d#", iSigner + 1));
        }
        for (ValidatedDocument refDoc : validatedDoc.getSubResults()) {
            ret = ret + ValidatedDocumentUtils.toString(refDoc, initSpaces + "  ");
        }
        return ret;
    }

    public static String toString(ValidatedSigner validatedSigner) {
        return ValidatedDocumentUtils.toString(validatedSigner, "", null);
    }

    public static String toString(ValidatedSigner validatedSigner, String initSpaces) {
        return ValidatedDocumentUtils.toString(validatedSigner, initSpaces, null);
    }

    public static String toString(ValidatedSigner validatedSigner, String initSpaces, String signerId) {
        if (validatedSigner == null) {
            return "";
        }
        String ret = "";
        for (ValidatorMessage signMsg : validatedSigner.getMessages()) {
            ret = signerId != null ? ret + String.format("%sFirma %s - %s\n", initSpaces, signerId, validatedSigner.getSignerName()) : ret + String.format("%sFirma - %s\n", initSpaces, validatedSigner.getSignerName());
            ret = ret + String.format("%s %s - %s - %s\n", new Object[]{initSpaces, signMsg.getLevel(), signMsg.getMessageCode(), signMsg.getMessage()});
            for (ValidatorMessage sigNoteMsg : signMsg.getNotes()) {
                ret = ret + ValidatedDocumentUtils.toString(sigNoteMsg, initSpaces + "  ");
            }
            ret = ret + ValidatedDocumentUtils.toString(validatedSigner.getCert(), initSpaces);
            if (!validatedSigner.getCounterSigners().isEmpty()) {
                ret = ret + String.format("%sControfirme %s\n", initSpaces, signerId);
            }
            for (ValidatedSigner counter : validatedSigner.getCounterSigners()) {
                ret = ret + ValidatedDocumentUtils.toString(counter, initSpaces + "  ", signerId);
            }
            if (!validatedSigner.getTimeStamps().isEmpty()) {
                ret = ret + String.format("%sMarche temporali %s\n", initSpaces, signerId);
            }
            for (ValidatedSigner timeStamp : validatedSigner.getTimeStamps()) {
                ret = ret + ValidatedDocumentUtils.toString(timeStamp, initSpaces + "  ", signerId);
            }
        }
        return ret;
    }

    public static String toString(ValidatedCertificate validatedCert) {
        return ValidatedDocumentUtils.toString(validatedCert, "");
    }

    public static String toString(ValidatedCertificate validatedCert, String initSpaces) {
        if (validatedCert == null) {
            return "";
        }
        String cdbData = " [no cdb data]";
        try {
            CertDBItem[] chain = validatedCert.getCert().getValidatedChain();
            CertDBItem item = chain[0];
            cdbData = item.getSourceAsString() + " " + item.getStatus() + " " + item.getTrustAsString() + " " + item.getTypeAsString() + " " + item.getEllipsUsages().toString();
        }
        catch (CertDBException ex) {
            logger.debug(ex.getMessage());
        }
        String ret = "";
        ret = ret + String.format("%sCertificato - %s - %s\n", initSpaces, validatedCert.getCertSubject(), cdbData);
        for (ValidatorMessage certMsg : validatedCert.getMessages()) {
            ret = ret + String.format("%s %s - %s - %s\n", new Object[]{initSpaces, certMsg.getLevel(), certMsg.getMessageCode(), certMsg.getMessage()});
            for (ValidatorMessage certNoteMsg : certMsg.getNotes()) {
                ret = ret + ValidatedDocumentUtils.toString(certNoteMsg, initSpaces + "  ");
            }
        }
        if (validatedCert.getIssuer() != null) {
            ret = ret + ValidatedDocumentUtils.toString(validatedCert.getIssuer(), initSpaces + "   ");
        }
        return ret;
    }

    public static String toString(ValidatorMessage vMessage, String initSpaces) {
        if (vMessage == null) {
            return "";
        }
        String ret = "";
        ret = ret + String.format("%s %s - %s - %s\n", new Object[]{initSpaces, vMessage.getLevel(), vMessage.getMessageCode(), vMessage.getMessage()});
        for (ValidatorMessage signMsg : vMessage.getNotes()) {
            ret = ret + String.format("%s %s - %s - %s\n", new Object[]{initSpaces, signMsg.getLevel(), signMsg.getMessageCode(), signMsg.getMessage()});
            for (ValidatorMessage sigNoteMsg : signMsg.getNotes()) {
                ret = ret + ValidatedDocumentUtils.toString(sigNoteMsg, initSpaces + "  ");
            }
        }
        return ret;
    }

    public static boolean globalStatusCheck(ValidatedDocument validatedDoc) {
        return validatedDoc.isSigned() && validatedDoc.isOverAllOk(true);
    }

    public static final HashMap<String, ValidatedSigner> getAllSigners(ValidatedDocument validatedDoc) throws CertificateEncodingException {
        HashMap<String, ValidatedSigner> retMap = new HashMap<String, ValidatedSigner>();
        for (ValidatedSigner signer : validatedDoc.getReferenceSigners()) {
            String key;
            String string = key = signer.getSignatureInformation().getSignatureInfo() != null ? new String(signer.getSignatureInformation().getSignatureInfo()) : NOTHING_INFO;
            if (!retMap.containsKey(key)) {
                retMap.put(key, signer);
            }
            for (ValidatedSigner tsSigner : signer.getTimeStamps()) {
                String tsKey = tsSigner.getSignatureInformation().getSignatureInfo() != null ? new String(tsSigner.getSignatureInformation().getSignatureInfo()) : NOTHING_INFO;
                if (retMap.containsKey(tsKey)) continue;
                retMap.put(tsKey, tsSigner);
            }
            for (ValidatedSigner cSigner : signer.getCounterSigners()) {
                HashMap<String, ValidatedSigner> subMap = ValidatedDocumentUtils.getAllCounterSigners(cSigner);
                for (String subKey : subMap.keySet()) {
                    if (retMap.containsKey(subKey)) continue;
                    retMap.put(subKey, subMap.get(subKey));
                }
            }
        }
        for (ValidatedDocument subDoc : validatedDoc.getSubResults()) {
            HashMap<String, ValidatedSigner> subMap = ValidatedDocumentUtils.getAllSigners(subDoc);
            for (String subKey : subMap.keySet()) {
                if (retMap.containsKey(subKey)) continue;
                retMap.put(subKey, subMap.get(subKey));
            }
        }
        return retMap;
    }

    private static final HashMap<String, ValidatedSigner> getAllCounterSigners(ValidatedSigner cSigner) throws CertificateEncodingException {
        HashMap<String, ValidatedSigner> retMap = new HashMap<String, ValidatedSigner>();
        String csKey = cSigner.getSignatureInformation().getSignatureInfo() != null ? new String(cSigner.getSignatureInformation().getSignatureInfo()) : NOTHING_INFO;
        retMap.put(csKey, cSigner);
        for (ValidatedSigner signer : cSigner.getCounterSigners()) {
            HashMap<String, ValidatedSigner> subMap = ValidatedDocumentUtils.getAllCounterSigners(signer);
            for (String subKey : subMap.keySet()) {
                if (retMap.containsKey(subKey)) continue;
                retMap.put(subKey, subMap.get(subKey));
            }
        }
        return retMap;
    }
}

