/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.Extension;

public class StepX509ExtensionsCheck
extends MultipleValidationSubStepImpl {
    public StepX509ExtensionsCheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> msgs = new LinkedList<ValidatorMessage>();
        if (param != null && param.getSignerCertificate() != null && param.getSignature() == null || param.getSignature().getFormat() != null && !param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
            String keyUsage = "";
            try {
                keyUsage = param.getSignerCertificate().getCert().keyUsageToString(param.getSignerCertificate().getCert().getKeyUsage());
            }
            catch (CapiException e) {
                keyUsage = "";
            }
            if (param.getSignature() != null && !param.getSignature().getFormat().equals((Object)SignatureFormat.TST) && !keyUsage.contains("nonRepudiation")) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0011_NODIGITALSIGNATURE, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
            }
        }
        if (param != null && param.getSignerCertificate() != null && Constants.DPCM_AGID_189_2017_DEADLINE.before(param.getSignerCertificate().getCert().getInternalCert().getNotBefore())) {
            try {
                if (param.getSignerCertificate().getCert().getAuthorityKeyIdentifier() == null) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0008_AKI_NOT_PRESENT, new Object[0]));
                }
            }
            catch (CapiException ex) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0008_AKI_NOT_PRESENT, new Object[0]));
            }
            try {
                if (param.getSignerCertificate().getCert().hasExtension(Extension.policyMappings.getId())) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0010_POLICY_MAPPINGS_NOT_ALLOWED, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException ex) {
                // empty catch block
            }
            try {
                String[] policies = param.getSignerCertificate().getCert().getPolicies(',');
                if (policies == null || policies.length < 1) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0011_CERTIFICATE_POLICIES_NOT_PRESENT, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException ex) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0011_CERTIFICATE_POLICIES_NOT_PRESENT, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
            }
            try {
                if (param.getSignerCertificate().getCert().hasExtension(Extension.nameConstraints.getId())) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0012_NAME_CONSTRAINTS_NOT_ALLOWED, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException ex) {
                // empty catch block
            }
            try {
                if (param.getSignerCertificate().getCert().hasExtension(Extension.inhibitAnyPolicy.getId())) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0013_INHIBIT_ANY_POLICY_NOT_ALLOWED, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException ex) {
                // empty catch block
            }
            String ocspUrl = null;
            String[] crlDistribuitionPoint = null;
            try {
                ocspUrl = param.getSignerCertificate().getCert().getOcspUrl();
            }
            catch (CapiException capiException) {
                // empty catch block
            }
            try {
                crlDistribuitionPoint = param.getSignerCertificate().getCert().getCdpURLs();
            }
            catch (CapiException capiException) {
                // empty catch block
            }
            if (ocspUrl == null && (crlDistribuitionPoint == null || crlDistribuitionPoint.length == 0 || crlDistribuitionPoint[0] == null || crlDistribuitionPoint[0].isEmpty())) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0021_OCSP_AND_CRL_INFORMATION_NOT_PRESENT, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
            }
        }
        return msgs;
    }
}

