/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;

public class StepX509ETSIDigestAlgorithmCompliance
extends SingleValidationSubStepImpl {
    public StepX509ETSIDigestAlgorithmCompliance() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        Date certificateDate;
        if (param != null && param.getSignerCertificate() != null && (certificateDate = param.getSignerCertificate().getCert().getInternalCert().getNotBefore()).after(Constants.DPCM_AGID_121_2019)) {
            String digestAlgorithmName = DefaultCMSSignatureAlgorithmNameGenerator.INSTANCE.getDigestAlgName(new ASN1ObjectIdentifier(param.getSignerCertificate().getCert().getInternalCert().getSigAlgOID()));
            DigestAlgorithm digAlg = DigestAlgorithm.valueFromJavaName(digestAlgorithmName);
            if (digAlg == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0025_DIGEST_ALGORITHM_NOT_SUPPORTED, digestAlgorithmName);
            }
            if (digAlg.isForbidden()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN, digestAlgorithmName);
            }
            if (!digAlg.isRecommended()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0021_ETSI_DIGEST_ALGORITHM_NOT_RECOMMENDED, digestAlgorithmName);
            }
        }
        return null;
    }
}

