/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.steps.SignatureValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.steps.core.StepCertificatePresence;
import esecurity.validator.steps.core.StepFormat;
import esecurity.validator.steps.core.StepSignatureIntegrity;
import esecurity.validator.steps.core.StepSignatureIntegrityRelaxedCheck;
import esecurity.validator.steps.core.StepValidationProfile;
import esecurity.validator.steps.core.tst.TimeStampStepSignatureDPCM45Compliance;
import esecurity.validator.steps.core.tst.TimeStampStepSignatureDigestAlgoCheck;
import esecurity.validator.steps.core.tst.TimeStampStepSignatureETSICompliance;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=1)
@StepContext(formats={ValidationSignatureFormats.TST})
public class StepTimeStampValidity
extends SignatureValidationStep {
    public StepTimeStampValidity() {
        this.subSteps.add(new StepFormat());
        this.subSteps.add(new StepSignatureIntegrity());
        this.subSteps.add(new StepSignatureIntegrityRelaxedCheck());
        this.subSteps.add(new StepCertificatePresence());
        this.subSteps.add(new TimeStampStepSignatureDPCM45Compliance());
        this.subSteps.add(new TimeStampStepSignatureETSICompliance());
        this.subSteps.add(new TimeStampStepSignatureDigestAlgoCheck());
        this.subSteps.add(new StepValidationProfile());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
        MessageLevel certTsaLevel = MessageLevel.ERROR;
        if (param.getSignerCertificate() != null) {
            certTsaLevel = StepsUtils.retrieveWorstLevel(param.getSignerCertificate().getMessages());
        }
        if (level == MessageLevel.ERROR || certTsaLevel == MessageLevel.ERROR) {
            if (param.getSignerCertificate() == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0028_NOT_VERIFICABLE_TIMESTAMP, new Object[0]);
            }
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0027_INVALID_TIMESTAMP, new Object[0]);
        }
        return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.IS0006_MARK_VALID, new Object[0]);
    }
}

