/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

@StepOrder(order=3)
@StepContext(formats={ValidationSignatureFormats.TST})
public class StepSignatureIntegrity
extends MultipleValidationSubStepImpl {
    public StepSignatureIntegrity() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> msg = new LinkedList<ValidatorMessage>();
        if (param != null && param.getSignature() != null) {
            if (param.getSignature().getFormat() == SignatureFormat.TST) {
                if (!param.getSignature().isCorrupted()) {
                    msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0004_MARK_INTACT, new Object[0]));
                } else {
                    msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0004_MARK_CORRUPTED, new Object[0]));
                    if (param.getSignature().getTstSpecific() != null && !param.getSignature().getTstSpecific().isRelatedToDoc()) {
                        msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0025_NOTIMESTAMPRELATED, new Object[0]));
                    }
                }
            } else if (!param.getSignature().isCorrupted()) {
                msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0003_SIGN_INTACT, new Object[0]));
            } else {
                msg.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0003_SIGN_CORRUPTED, new Object[0]));
            }
        }
        return msg;
    }
}

