/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepContext(formats={ValidationSignatureFormats.ALL_SIGNATURE_FORMATS}, profiles={ValidationProfile.ALL_PROFILES}, priority=0)
@StepOrder(order=2)
public class StepDocumentIntegrity
extends SingleValidationStepImpl {
    public StepDocumentIntegrity() {
        super(ValidationType.DOCUMENT);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessag, ValidationContextParameters param) {
        try {
            boolean docCorrupted = false;
            for (ReferenceDoc doc : param.getSignature().getRefDocs()) {
                if (!doc.getId().equals(param.getDoc().getId())) continue;
                docCorrupted = !doc.isMessageDigestMatch();
                break;
            }
            if (docCorrupted) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ED0001_INVALID_DIGEST, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

