/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationStep;
import esecurity.validator.steps.SingleValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationSubStep;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class ValidationStep
implements Comparable<ValidationStep> {
    protected final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private ValidationType type;
    protected LinkedList<ValidationSubStep> subSteps = new LinkedList();

    public ValidationStep(ValidationType type) {
        this.type = type;
    }

    public ValidationType getType() {
        return this.type;
    }

    @Override
    public int compareTo(ValidationStep o) {
        int this_order = ValidationStep.retrieveAnnotationOrder(this) == null ? 100 : ValidationStep.retrieveAnnotationOrder(this).order();
        int comparable_order = ValidationStep.retrieveAnnotationOrder(o) == null ? 100 : ValidationStep.retrieveAnnotationOrder(o).order();
        return this_order - comparable_order;
    }

    public static StepContext retrieveAnnotationContext(ValidationStep contr) {
        StepContext objReturn = null;
        if (contr.getClass().getAnnotations().length > 0) {
            for (Annotation anno : contr.getClass().getAnnotations()) {
                if (!(anno instanceof StepContext)) continue;
                objReturn = (StepContext)anno;
                break;
            }
        }
        return objReturn;
    }

    public static StepOrder retrieveAnnotationOrder(ValidationStep contr) {
        StepOrder objReturn = null;
        if (contr.getClass().getAnnotations().length > 0) {
            for (Annotation anno : contr.getClass().getAnnotations()) {
                if (!(anno instanceof StepOrder)) continue;
                objReturn = (StepOrder)anno;
                break;
            }
        }
        return objReturn;
    }

    protected LinkedList<ValidatorMessage> checkSubSteps(ValidationContextParameters param) {
        LinkedList<ValidatorMessage> subMessage = new LinkedList<ValidatorMessage>();
        for (ValidationSubStep step : this.subSteps) {
            if (step instanceof SingleValidationStep) {
                ValidatorMessage msg = ((SingleValidationStep)((Object)step)).check(param);
                if (msg == null) continue;
                subMessage.add(msg);
                continue;
            }
            List<ValidatorMessage> msgs = ((MultipleValidationStep)((Object)step)).checks(param);
            if (msgs == null) continue;
            subMessage.addAll(msgs);
        }
        return subMessage;
    }
}

