/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationSubStep;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public abstract class SingleValidationSubStepImpl
extends ValidationSubStep
implements SingleValidationStep {
    public SingleValidationSubStepImpl(ValidationType type) {
        super(type);
    }

    @Override
    public ValidatorMessage check(ValidationContextParameters param) {
        ValidatorMessage objReturn = null;
        try {
            LinkedList<ValidatorMessage> subMessage = this.checkSubSteps(param);
            subMessage = StepsUtils.filterMessageByProfile(subMessage, param.getProfile());
            objReturn = this.innerCheck(subMessage, param);
            if (objReturn != null) {
                for (ValidatorMessage subMsg : subMessage) {
                    objReturn.addNotes(subMsg);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ValidationStep  \"{}\" ha generato un messaggio codice {} livello {}:", new Object[]{this.getClass().getName(), objReturn.getMessageCode(), objReturn.getLevel().toString()});
                }
            }
        }
        catch (Throwable ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ValidationStep \"{}\" ha generato un errore non gestito: ", (Object)this.getClass().getName(), (Object)ex);
            }
            objReturn = new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        return objReturn;
    }

    protected abstract ValidatorMessage innerCheck(LinkedList<ValidatorMessage> var1, ValidationContextParameters var2);
}

