/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.VerifiedSerial;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import org.slf4j.Logger;

public class CRLUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void addRefCrl(LinkedList<RefCRL> lstCurrentRefCrl, CRL crl, LinkedList<X509Certificate> certChain) {
        LinkedList<X509Certificate> relatedCerts = new LinkedList<X509Certificate>();
        for (X509Certificate cert : certChain) {
            try {
                if (!crl.canUseFor(cert, cert.getNotBefore())) continue;
                relatedCerts.add(cert);
            }
            catch (CertificateEncodingException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (relatedCerts.size() == 0) {
            return;
        }
        RefCRL objReturn = null;
        boolean bVerified = false;
        try {
            String id = Utils.calculateDigest(new ByteArrayInputStream(crl.getInternalCRL().getEncoded()), Constants.SHA256);
            for (RefCRL rcrl : lstCurrentRefCrl) {
                if (!rcrl.getId().equals(id)) continue;
                objReturn = rcrl;
                break;
            }
            if (objReturn == null) {
                objReturn = new RefCRL();
                objReturn.setId(id);
                lstCurrentRefCrl.add(objReturn);
            }
            for (X509Certificate cert : certChain) {
                if (!Utils.retrieveCommonName(crl.getIssuerDN()).equals(Utils.retrieveCommonName(cert.getSubjectDN().toString()))) continue;
                crl.verify(cert.getEncoded());
                objReturn.setId(id);
                objReturn.setIssuerDn(crl.getIssuerDN());
                objReturn.setIdps(crl.getIdps());
                objReturn.setUpdateDate(crl.getInternalCRL().getThisUpdate());
                objReturn.setNextUpdate(crl.getInternalCRL().getNextUpdate());
                bVerified = true;
                break;
            }
        }
        catch (CertificateEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (CRLException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        objReturn.setValid(bVerified);
        for (X509Certificate cert : relatedCerts) {
            try {
                VerifiedSerial ser = new VerifiedSerial();
                BigInteger serial = cert.getSerialNumber();
                ser.setSerial(serial.toString(16));
                ser.setRevoked(crl.isRevoked(cert.getSerialNumber()));
                if (ser.isRevoked()) {
                    ser.setReasonCode(crl.getReasonCode(serial));
                    ser.setRevocationDate(crl.getInternalCRL().getRevokedCertificate(serial).getRevocationDate());
                }
                objReturn.addVerifiedSerial(ser);
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

