/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.ValidationDate;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.signature.SignatureLevel;
import java.util.Date;
import java.util.LinkedList;

public class ValidatedSigner
extends ValidatedBean {
    private String signerName;
    private LinkedList<ValidatedSigner> counterSigners = new LinkedList();
    private LinkedList<ValidatedSigner> timeStamps = new LinkedList();
    private ValidatedCertificate cert;
    private SignatureFormat format;
    private ContainerFormat containerFormat;
    private SignatureLevel level;
    private Date signatureDate;
    private ValidationDate verificationDate;
    private LinkedList<ReferenceDoc> refDocs = new LinkedList();
    private SignatureInformation signatureInformation;

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public SignatureFormat getFormat() {
        return this.format;
    }

    public void setFormat(SignatureFormat format) {
        this.format = format;
    }

    public ContainerFormat getContainerFormat() {
        return this.containerFormat;
    }

    public void setContainerFormat(ContainerFormat containerFormat) {
        this.containerFormat = containerFormat;
    }

    public SignatureLevel getLevel() {
        return this.level;
    }

    public void setLevel(SignatureLevel level) {
        this.level = level;
    }

    public Date getSignatureDate() {
        return this.signatureDate;
    }

    public void setSignatureDate(Date signatureData) {
        this.signatureDate = signatureData;
    }

    public ValidationDate getVerificationDate() {
        return this.verificationDate;
    }

    public void setVerificationDate(ValidationDate verificationDate) {
        this.verificationDate = verificationDate;
    }

    public LinkedList<ValidatedSigner> getCounterSigners() {
        return this.counterSigners;
    }

    public void setCounterSigners(LinkedList<ValidatedSigner> counterSigners) {
        for (int i = 0; i < counterSigners.size(); ++i) {
            this.addCounterSigner(counterSigners.get(i));
        }
    }

    @JsonIgnore
    public void addCounterSigner(ValidatedSigner counterSigner) {
        if (!this.counterSigners.contains(counterSigner)) {
            this.counterSigners.add(counterSigner);
        }
    }

    public LinkedList<ValidatedSigner> getTimeStamps() {
        return this.timeStamps;
    }

    public void setTimeStamps(LinkedList<ValidatedSigner> timestamps) {
        for (int i = 0; i < timestamps.size(); ++i) {
            this.addTimeStamp(timestamps.get(i));
        }
    }

    @JsonIgnore
    public void addTimeStamp(ValidatedSigner timestamp) {
        if (!this.timeStamps.contains(timestamp)) {
            this.timeStamps.add(timestamp);
        }
    }

    public ValidatedCertificate getCert() {
        return this.cert;
    }

    public void setCert(ValidatedCertificate cert) {
        this.cert = cert;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.cert != null && this.cert.isValid();
    }

    @Override
    public boolean hasBeanWarnings() {
        return super.hasBeanWarnings() || this.cert != null && this.cert.hasBeanWarnings();
    }

    public LinkedList<ReferenceDoc> getRefDocs() {
        return this.refDocs;
    }

    public void setRefDocs(LinkedList<ReferenceDoc> refDocs) {
        for (int i = 0; i < refDocs.size(); ++i) {
            this.addRefDoc(refDocs.get(i));
        }
    }

    @JsonIgnore
    public void addRefDoc(ReferenceDoc refDoc) {
        if (!this.refDocs.contains(refDoc)) {
            this.refDocs.add(refDoc);
        }
    }

    @JsonIgnore
    public SignatureInformation getSignatureInformation() {
        return this.signatureInformation;
    }

    @JsonIgnore
    public void setSignatureInformation(SignatureInformation signatureInformation) {
        this.signatureInformation = signatureInformation;
    }
}

