/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.CrlBean;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.vol.utils.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ValidatedCertificate
extends ValidatedBean {
    private String certSerial = null;
    private String certNotBefore = null;
    private String certNotAfter = null;
    private String certSubject = null;
    private String certIssuer = null;
    private String certName = null;
    private ValidatedCertificate issuer;
    private CertificateStatus certStatus = null;
    private Certificate cert = null;
    private boolean rsVerified = false;

    @JsonIgnore
    public Certificate getCert() {
        return this.cert;
    }

    public void setCert(Certificate cert) {
        this.cert = cert;
    }

    public String getCertSerial() {
        return this.certSerial;
    }

    public void setCertSerial(String certSerial) {
        this.certSerial = certSerial;
    }

    public String getCertNotBefore() {
        return this.certNotBefore;
    }

    public void setCertNotBefore(String certNotBefore) {
        this.certNotBefore = certNotBefore;
    }

    public String getCertNotAfter() {
        return this.certNotAfter;
    }

    public void setCertNotAfter(String certNotAfter) {
        this.certNotAfter = certNotAfter;
    }

    public String getCertSubject() {
        return this.certSubject;
    }

    public void setCertSubject(String certSubject) {
        this.certSubject = certSubject;
    }

    public String getCertIssuer() {
        return this.certIssuer;
    }

    public void setCertIssuer(String certIssuer) {
        this.certIssuer = certIssuer;
    }

    public ValidatedCertificate getIssuer() {
        return this.issuer;
    }

    public void setIssuer(ValidatedCertificate issuer) {
        this.issuer = issuer;
    }

    public String getCertName() {
        return this.certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public boolean isCertRevoked() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getCertRevoked();
    }

    public void setCertRevoked(boolean revoked) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCertRevoked(revoked);
    }

    public boolean isCertTimeValid() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getCertTimeValid();
    }

    public void setCertTimeValid(boolean valid) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCertTimeValid(valid);
    }

    public boolean isCertCorrupted() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getCertCorrupted();
    }

    public void setCertCorrupted(boolean corrupted) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCertCorrupted(corrupted);
    }

    public boolean isCertTrusted() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getCertTrusted();
    }

    public void setCertTrusted(boolean trusted) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCertTrusted(trusted);
    }

    public boolean isCertValid() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getCertValid();
    }

    public void setCertValid(boolean valid) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCertValid(valid);
    }

    public boolean isRsVerified() throws CapiException {
        return this.rsVerified;
    }

    public void setRsVerified(boolean verified) {
        this.rsVerified = verified;
    }

    public Date getRevocationDate() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getRevocationDate();
    }

    public void setRevocationDate(Date revocationDate) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setRevocationDate(revocationDate);
    }

    public String getRevocationReason() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getRevocationReason();
    }

    public void setRevocationReason(String revocationReason) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setRevocationReason(revocationReason);
    }

    public String getInvalidityReason() throws CapiException {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        return this.certStatus.getInvalidityReason();
    }

    public void setInvalidityReason(String invalidityReason) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setInvalidityReason(invalidityReason);
    }

    public String getCrlStatus() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getCrlStatus();
    }

    public void setCrlStatus(String crlStatus) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCrlStatus(crlStatus);
    }

    public String getVerificationType() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getVerificationType();
    }

    public void setVerificationType(String verificationType) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setVerificationType(verificationType);
    }

    public CrlBean getCrlBean() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.getCrlBean();
    }

    public void setCrlBean(CrlBean crlBean) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCrlBean(crlBean);
    }

    public boolean isCheckAnotherHelper() throws CapiException {
        if (this.certStatus == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.certStatus.isCheckAnotherHelper();
    }

    public void setCheckAnotherHelper(boolean check) {
        if (this.certStatus == null) {
            this.certStatus = new CertificateStatus();
        }
        this.certStatus.setCheckAnotherHelper(check);
    }

    public static ValidatedCertificate newInstance(Certificate cert) {
        ValidatedCertificate vCertificate = new ValidatedCertificate();
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            df.setTimeZone(Constants.DEFAULT_TIMEZONE);
            vCertificate.setCert(cert);
            vCertificate.setCertIssuer(cert.getIssuerDN());
            vCertificate.setCertSubject(cert.getSubjectDN());
            vCertificate.setCertNotAfter(df.format(cert.getInternalCert().getNotAfter()));
            vCertificate.setCertNotBefore(df.format(cert.getInternalCert().getNotBefore()));
            vCertificate.setCertSerial(Util.bigIntToHexStr(cert.getSerialNumber()));
            vCertificate.setCertName(cert.getName());
            vCertificate.setRsVerified(cert.isRsVerified());
        }
        catch (CapiException capiException) {
            // empty catch block
        }
        return vCertificate;
    }

    public boolean equals(Object anObject) {
        return anObject instanceof ValidatedCertificate && ((ValidatedCertificate)anObject).getCert().getInternalCert().equals(this.getCert().getInternalCert());
    }
}

