/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import esecurity.validator.bean.CertStatusValidation;
import esecurity.validator.bean.RefCRL;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.signature.SignatureLevel;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class LevelValidation {
    protected SignatureLevel level = SignatureLevel.BES;
    protected CertStatusValidation signerStatus = null;
    protected CertStatusValidation tsaSignerStatus = null;
    protected X509Certificate signerCertificate = null;
    protected CertDBItem[] signerChain = null;
    protected X509Certificate tsaCertificate = null;
    protected CertDBItem[] tsaChain = null;
    protected LinkedList<X509Certificate> chain = null;
    protected LinkedList<BasicOCSPResp> ocsps = null;
    protected LinkedList<RefCRL> crls = null;
    protected Date verificationDate;

    public SignatureLevel getLevel() {
        return this.level;
    }

    public void setLevel(SignatureLevel level) {
        this.level = level;
    }

    public CertStatusValidation getSignerStatus() {
        return this.signerStatus;
    }

    public void setSignerStatus(CertStatusValidation signerStatus) {
        this.signerStatus = signerStatus;
    }

    public CertStatusValidation getTsaSignerStatus() {
        return this.tsaSignerStatus;
    }

    public void setTsaSignerStatus(CertStatusValidation tsaSignerStatus) {
        this.tsaSignerStatus = tsaSignerStatus;
    }

    public CertDBItem[] getSignerChain() {
        return this.signerChain;
    }

    public void setSignerChain(CertDBItem[] signerChain) {
        this.signerChain = signerChain;
    }

    public CertDBItem[] getTsaChain() {
        return this.tsaChain;
    }

    public void setTsaChain(CertDBItem[] tsaChain) {
        this.tsaChain = tsaChain;
    }

    public X509Certificate getSignerCertificate() {
        return this.signerCertificate;
    }

    public void setSignerCertificate(X509Certificate signerCertificate) {
        this.signerCertificate = signerCertificate;
    }

    public X509Certificate getTsaCertificate() {
        return this.tsaCertificate;
    }

    public void setTsaCertificate(X509Certificate tsaCertificate) {
        this.tsaCertificate = tsaCertificate;
    }

    public LinkedList<X509Certificate> getChain() {
        return this.chain;
    }

    public void setChain(LinkedList<X509Certificate> chain) {
        this.chain = chain;
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        return this.ocsps;
    }

    public void setOcsps(LinkedList<BasicOCSPResp> ocsps) {
        this.ocsps = ocsps;
    }

    public LinkedList<RefCRL> getCrls() {
        return this.crls;
    }

    public void setCrls(LinkedList<RefCRL> crls) {
        this.crls = crls;
    }

    public Date getVerificationDate() {
        return this.verificationDate;
    }

    public void setVerificationDate(Date verificationDate) {
        this.verificationDate = verificationDate;
    }

    public X509Certificate getChainRootCertificate(X509Certificate certificate) throws CapiException {
        X509Certificate rootCert;
        block6: {
            block7: {
                if (certificate == null) {
                    return null;
                }
                rootCert = null;
                if (this.signerCertificate == null || !this.signerCertificate.equals(certificate)) break block7;
                if (this.signerChain == null || this.signerChain.length <= 0) break block6;
                int iCert = 0;
                while (rootCert == null && iCert < this.signerChain.length) {
                    String issuerDN = this.signerChain[iCert].getCertificate().getIssuerDN();
                    boolean bFound = false;
                    for (int i = 0; i < this.signerChain.length; ++i) {
                        String curCertDN;
                        if (i == iCert || !(curCertDN = this.signerChain[iCert].getCertificate().getSubjectDN()).equals(issuerDN)) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    rootCert = this.signerChain[iCert].getCertificate().getInternalCert();
                    break block6;
                }
                break block6;
            }
            if (this.tsaCertificate != null && this.tsaCertificate.equals(certificate) && this.tsaChain != null && this.tsaChain.length > 0) {
                int iCert = 0;
                while (rootCert == null && iCert < this.tsaChain.length) {
                    String issuerDN = this.tsaChain[iCert].getCertificate().getIssuerDN();
                    boolean bFound = false;
                    for (int i = 0; i < this.tsaChain.length; ++i) {
                        String curCertDN;
                        if (i == iCert || !(curCertDN = this.tsaChain[iCert].getCertificate().getSubjectDN()).equals(issuerDN)) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    rootCert = this.tsaChain[iCert].getCertificate().getInternalCert();
                    break;
                }
            }
        }
        return rootCert;
    }

    public CertDBItem[] getChain(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        if (this.signerCertificate != null && this.signerCertificate.equals(certificate)) {
            return this.getSignerChain();
        }
        if (this.tsaCertificate != null && this.tsaCertificate.equals(certificate)) {
            return this.getTsaChain();
        }
        return null;
    }
}

