/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts;

import com.amazonaws.util.Base64;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.parser.utils.DerParserUtils;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.DigestUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.Accuracy;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.StoreException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class TimeStampToken {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final ASN1ObjectIdentifier ID_ETSI_TSTS = new ASN1ObjectIdentifier("0.4.0.19422.1.1");
    private boolean eidasCompliance = false;
    private List<Certificate> lstCert = new ArrayList<Certificate>();
    private Certificate tsaCert = null;
    private TimeStampResponse tsr = null;
    private org.bouncycastle.tsp.TimeStampToken tst = null;

    public TimeStampToken(byte[] data) throws CapiException {
        byte[] derData = data;
        try {
            if (!Util.isDerSequence(data)) {
                derData = Util.base64Decode(data);
            }
            this.tsr = new TimeStampResponse(derData);
            this.tst = this.tsr.getTimeStampToken();
        }
        catch (Exception e) {
            try {
                ASN1InputStream is = new ASN1InputStream(derData);
                ASN1Sequence sec = ASN1Sequence.getInstance((Object)is.readObject());
                this.tst = new org.bouncycastle.tsp.TimeStampToken(ContentInfo.getInstance((Object)sec));
            }
            catch (IOException | TSPException ex) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new CapiException(e.getMessage(), 50040);
            }
        }
        try {
            LinkedList certHolders = new LinkedList(this.tst.toCMSSignedData().getCertificates().getMatches((Selector)this.tst.getSID()));
            if (!certHolders.isEmpty()) {
                this.tsaCert = new Certificate(((X509CertificateHolder)certHolders.get(0)).getEncoded());
                Collection certs = this.tst.toCMSSignedData().getCertificates().getMatches(null);
                for (X509CertificateHolder cholder : certs) {
                    this.lstCert.add(new Certificate(cholder.getEncoded()));
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException(ex.getMessage(), 50040);
        }
        if (this.tst.getTimeStampInfo().getAccuracy() != null && this.tst.getTimeStampInfo().getExtensions() != null) {
            DERSequence exts = (DERSequence)this.tst.getTimeStampInfo().getExtensions().toASN1Primitive();
            for (int i = 0; i < exts.size(); ++i) {
                if (!((ASN1ObjectIdentifier)((DERSequence)exts.getObjectAt(i).toASN1Primitive()).getObjectAt(0)).getId().equals("1.3.6.1.5.5.7.1.3")) continue;
                try {
                    byte[] value = ((DEROctetString)((DERSequence)exts.getObjectAt(i).toASN1Primitive()).getObjectAt(1)).getOctets();
                    DLSequence seq = (DLSequence)ASN1Primitive.fromByteArray((byte[])value);
                    if (!((ASN1ObjectIdentifier)((DLSequence)seq.getObjectAt(0)).getObjectAt(0).toASN1Primitive()).equals((ASN1Primitive)ID_ETSI_TSTS)) continue;
                    this.eidasCompliance = true;
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public String getTimeStamp() {
        ASN1GeneralizedTime gtime = new ASN1GeneralizedTime(this.tst.getTimeStampInfo().getGenTime());
        return gtime.getTime().substring(0, 14) + "Z";
    }

    public String getPolicyId() {
        return this.tst.getTimeStampInfo().getPolicy().getId();
    }

    public BigInteger getSerialNumber() {
        return this.tst.getTimeStampInfo().getSerialNumber();
    }

    public String getTSAName() {
        return this.tst.getTimeStampInfo().getTsa().getName().toString();
    }

    public BigInteger getNonce() {
        return this.tst.getTimeStampInfo().getNonce();
    }

    public Accuracy getAccuracy() throws ApiGeneralException {
        return this.tst.getTimeStampInfo().getAccuracy();
    }

    public int getStatus() {
        if (this.tsr != null) {
            return this.tsr.getStatus();
        }
        return 0;
    }

    public byte[] toByteArray(boolean base64) throws CapiException, IOException {
        return this.toByteArray(base64, false);
    }

    public byte[] toByteArray(boolean base64, boolean asTST) throws CapiException, IOException {
        byte[] arrReturn = null;
        if (asTST) {
            arrReturn = this.tst.getEncoded();
        } else if (this.tsr != null) {
            arrReturn = this.tsr.getEncoded();
        } else {
            throw new CapiException("Crypto Exception: TSResp toByteArray from a TST", 50040);
        }
        if (base64) {
            return Base64.encode((byte[])arrReturn);
        }
        return arrReturn;
    }

    public String toString() {
        return this.tst.toString();
    }

    public Certificate getTSACert() throws CapiException {
        try {
            LinkedList certHolders = new LinkedList(this.tst.toCMSSignedData().getCertificates().getMatches((Selector)this.tst.getSID()));
            if (certHolders.isEmpty()) {
                return null;
            }
            return new Certificate(((X509CertificateHolder)certHolders.get(0)).getEncoded());
        }
        catch (CapiException | IOException | StoreException e) {
            throw new CapiException(e.getMessage(), 50040);
        }
    }

    public List<Certificate> listCertificates() throws ApiGeneralException {
        return this.lstCert;
    }

    public boolean compare(byte[] message, boolean messageIsHash) {
        logger.debug("compare...");
        try {
            if (messageIsHash) {
                return java.util.Arrays.equals(this.tst.getTimeStampInfo().getMessageImprintDigest(), message);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(message);
            return this.compare(is);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean compare(InputStream message) {
        try {
            byte[] rec_digest = DigestUtils.calculate(DigestAlgorithm.valueFromCadesId(this.tst.getTimeStampInfo().getMessageImprintAlgOID().getId()), message);
            byte[] digest = this.tst.getTimeStampInfo().getMessageImprintDigest();
            logger.debug("[verify]digest: " + new String(Hex.encode((byte[])digest)));
            logger.debug("[verify]recalc. digest: " + new String(Hex.encode((byte[])rec_digest)));
            return Arrays.areEqual((byte[])digest, (byte[])rec_digest);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean verifySignature() throws CapiException {
        if (this.tsaCert == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        try {
            logger.debug("tsaCert not null");
            SignerInformationVerifier ver = new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build(new Certificate(this.tsaCert.getInternalCert()).getInternalCert());
            return this.tst.isSignatureValid(ver);
        }
        catch (OperatorCreationException | TSPException e) {
            logger.error(e.getMessage(), e);
            throw new CapiException("Crypto Exception verifying SignerInfo signature: " + e.getMessage(), 50010);
        }
    }

    public byte[] getHashedMessage() {
        return this.tst.getTimeStampInfo().getMessageImprintDigest();
    }

    public String getSignerDigestAlg() {
        if (DigestAlgorithm.SHA1.getId().equals(this.tst.getTimeStampInfo().getMessageImprintAlgOID().getId())) {
            return "SHA1";
        }
        if (DigestAlgorithm.SHA256.getId().equals(this.tst.getTimeStampInfo().getMessageImprintAlgOID().getId())) {
            return "SHA256";
        }
        return this.tst.getTimeStampInfo().getMessageImprintAlgOID().getId();
    }

    public boolean hasSigningCertificate() throws CapiException {
        if (this.tsaCert == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        return this.hasSigningCertificate(this.tsaCert.getInternalCert());
    }

    private boolean hasSigningCertificate(X509Certificate c) throws CapiException {
        AttributeTable signedAttTable = this.tst.getSignedAttributes();
        if (signedAttTable == null) {
            logger.debug("No signed attribute table found.");
            return false;
        }
        Attribute attr = signedAttTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate);
        if (attr == null) {
            logger.debug("No signing certificate attribute found.");
            return false;
        }
        try {
            logger.debug("Found signing certificate attribute V1");
            SigningCertificate signCert = SigningCertificate.getInstance((Object)attr.getAttrValues().getObjectAt(0));
            ESSCertID certID = ESSCertID.getInstance((Object)signCert.getCerts()[0]);
            logger.debug("Validating the first ESSCertID ...");
            DerParserUtils.validateESSCertID(certID, c);
        }
        catch (CapiException e) {
            throw new CapiException("Cannot parse ESSCertID", 3010, e);
        }
        logger.debug("ESSCertID V1 successfully validated.");
        return true;
    }

    public boolean hasSigningCertificateV2() throws CapiException {
        if (this.tsaCert == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        return this.getSigningCertificateV2HashAlg(this.tsaCert.getInternalCert()) != null;
    }

    public String getSigningCertificateV2HashAlg() throws CapiException {
        if (this.tsaCert == null) {
            throw new CapiException("TSA certificate not present.", 50010);
        }
        return this.getSigningCertificateV2HashAlg(this.tsaCert.getInternalCert());
    }

    private String getSigningCertificateV2HashAlg(X509Certificate c) throws CapiException {
        AttributeTable signedAttTable = this.tst.getSignedAttributes();
        if (signedAttTable == null) {
            logger.debug("No signed attribute table found.");
            return null;
        }
        Attribute attr = signedAttTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        if (attr == null) {
            logger.debug("No signing certificate attribute V2 found.");
            return null;
        }
        logger.debug("Found signing certificate attribute V2.");
        ASN1Sequence seq = (ASN1Sequence)attr.getAttrValues().getObjectAt(0);
        SigningCertificateV2 signCertV2 = SigningCertificateV2.getInstance((Object)seq);
        ESSCertIDv2[] certIDarray = null;
        ESSCertIDv2 certID = null;
        try {
            certIDarray = signCertV2.getCerts();
            certID = certIDarray[0];
        }
        catch (Exception e) {
            logger.debug("Cannot instantiate ESSCertIDv2: Exception " + e.getMessage() + ". Retrying...");
            ASN1Sequence certIDseq = ASN1Sequence.getInstance((Object)seq.getObjectAt(0));
            if (certIDseq.size() <= 0) {
                throw new CapiException("Cannot parse ESSCertIDv2", 3010);
            }
            ASN1Sequence ESSv2 = ASN1Sequence.getInstance((Object)certIDseq.getObjectAt(0));
            if (ESSv2.size() == 1) {
                logger.debug("ESSCertIDv2 contains only SHA256 Hash");
                byte[] certHash = ASN1OctetString.getInstance((Object)ESSv2.getObjectAt(0).toASN1Primitive()).getOctets();
                certID = new ESSCertIDv2(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), certHash);
            }
            certID = ESSCertIDv2.getInstance((Object)ESSv2);
        }
        if (certID != null) {
            logger.debug("Validating the first ESSCertID ...");
            DerParserUtils.validateESSCertID(certID, c);
            logger.debug("ESSCertID V2 successfully validated.");
            return certID.getHashAlgorithm().getAlgorithm().getId();
        }
        throw new CapiException("Cannot parse ESSCertIDv2", 3010);
    }

    public Date getDate() {
        try {
            String time = this.getTimeStamp();
            TimeZone tz = TimeZone.getTimeZone("GMT");
            SimpleDateFormat tstDF = new SimpleDateFormat("yyyyMMddHHmmss");
            tstDF.setTimeZone(tz);
            Date st = tstDF.parse(time.trim());
            return st;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isEIDASCompliance() {
        return this.eidasCompliance;
    }

    public String getSignerEncryptionAlg() {
        return this.tst.toCMSSignedData().getSignerInfos().get(this.tst.getSID()).getEncryptionAlgOID();
    }

    public org.bouncycastle.tsp.TimeStampToken getInternalTst() {
        return this.tst;
    }
}

