/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.DTMPException;
import esecurity.dts.util.DTMPThread;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.util.DigestUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class Client
extends DTSClient {
    private Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final String DEFAULT_HOST = "tsa.actalis.it";
    public static final int RFC_DEFAULT_PORT = 318;
    public static final long MIN_TIMEOUT = 100L;
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final long MAX_TIMEOUT = 60000L;
    private String tsaUrl = null;
    private HTTP http = null;
    private long timeout;
    private String serverAddr;
    private int serverPort;

    public Client() throws IllegalParamException {
        this.setServer(DEFAULT_HOST, 318);
        this.setTimeout(5000L);
    }

    @Override
    public void initializeClient(TSAData tsaData, NetworkConfig networkConfig, String requestedUrl) throws IllegalParamException {
        this.tsaData = tsaData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = requestedUrl;
    }

    @Override
    public void setServer(String serverAddr, int serverPort) {
        this.serverAddr = serverAddr;
        this.serverPort = serverPort;
    }

    @Override
    public void setServer(String tsaUrl, HTTP http) throws IllegalParamException {
        this.tsaUrl = tsaUrl;
        this.http = http;
    }

    @Override
    public void setTimeout(long timeOut) throws IllegalParamException {
        this.timeout = timeOut;
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message) throws CapiException, TSAException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message) throws CapiException, TSAException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message, BigInteger nonce, boolean certReq) throws CapiException {
        TimeStampToken tst = null;
        try {
            byte[] tsReqArray = this.createTimeStampReq(policy, algorithm, message, nonce, certReq, false, false);
            tst = this.socketTransport(tsReqArray);
        }
        catch (Exception ex) {
            throw new CapiException(ex.getMessage(), 1003);
        }
        return tst;
    }

    private byte[] createTimeStampReq(String policyId, String hashAlgorithm, Object message, BigInteger nonce, boolean certReq, boolean hash, boolean base64) throws IllegalParamException, CapiException {
        if (hashAlgorithm == null) {
            throw new IllegalParamException("hashAlgorithm", "null");
        }
        if (message == null) {
            throw new IllegalParamException("message", "null");
        }
        try {
            TimeStampRequestGenerator tsrGen = new TimeStampRequestGenerator();
            tsrGen.setReqPolicy(new ASN1ObjectIdentifier(policyId));
            tsrGen.setCertReq(certReq);
            DigestAlgorithm algo = DigestAlgorithm.valueFromJavaName(hashAlgorithm);
            if (algo == null) {
                algo = DigestAlgorithm.valueFromCadesId(hashAlgorithm);
            }
            byte[] digest = null;
            if (hash) {
                this.logger.debug("hash=" + new String(Hex.encode((byte[])((byte[])message))));
                digest = (byte[])message;
            } else {
                digest = message instanceof InputStream ? DigestUtils.calculate(algo, (InputStream)message) : DigestUtils.calculate(algo, (byte[])message);
            }
            TimeStampRequest req = tsrGen.generate(new ASN1ObjectIdentifier(hashAlgorithm), digest, nonce);
            if (base64) {
                return Base64.encode((byte[])req.getEncoded());
            }
            return req.getEncoded();
        }
        catch (Exception e) {
            this.logger.debug(null, (Throwable)e);
            throw new CapiException(e.getMessage(), 1003);
        }
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message, BigInteger nonce, boolean certReq) throws IllegalParamException, CapiException, TSAException {
        TimeStampToken tst = null;
        try {
            byte[] tsReqArray = this.createTimeStampReq(policy, algorithm, message, nonce, certReq, false, false);
            tst = this.socketTransport(tsReqArray);
        }
        catch (Exception ex) {
            throw new CapiException(ex.getMessage(), 1003);
        }
        return tst;
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash) throws CapiException, IOException, TSAException {
        return this.timeStampHash(policy, algorithm, hash, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash, BigInteger nonce, boolean certReq) throws IOException, CapiException {
        TimeStampToken tst = null;
        try {
            byte[] tsReqArray = this.createTimeStampReq(policy, algorithm, hash, nonce, certReq, true, false);
            tst = this.socketTransport(tsReqArray);
        }
        catch (InterruptedException ex) {
            throw new CapiException(ex.getMessage(), 1003);
        }
        return tst;
    }

    @Override
    public TimeStampResponse getMark(InputStream message, boolean certReq) throws ApiGeneralException, IOException, TSAException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public String getRequest(String policy, String algorithm, byte[] message, boolean messageIsHash, BigInteger nonce, boolean certReq) throws IllegalParamException, CapiException {
        byte[] tsReqArray = this.createTimeStampReq(policy, algorithm, message, nonce, certReq, messageIsHash, true);
        return new String(tsReqArray);
    }

    public String getRequest(String policy, String algorithm, InputStream message, BigInteger nonce, boolean certReq) throws IllegalParamException, CapiException {
        byte[] tsReqArray = this.createTimeStampReq(policy, algorithm, message, nonce, certReq, false, true);
        return new String(tsReqArray);
    }

    public TimeStampToken sendRequest(String tsReqBase64) throws CapiException, IOException, InterruptedException {
        byte[] tsReqArray = null;
        try {
            byte[] der = Base64.decode((String)tsReqBase64);
            TimeStampRequest tsr = new TimeStampRequest(der);
            tsReqArray = tsr.getEncoded();
        }
        catch (Exception e) {
            this.logger.debug(null, (Throwable)e);
            throw new CapiException(e.getMessage(), 50040);
        }
        TimeStampToken tst = this.socketTransport(tsReqArray);
        return tst;
    }

    private TimeStampToken socketTransport(byte[] tsReq) throws IOException, InterruptedException, CapiException {
        if (this.http != null) {
            byte[] res;
            try {
                res = this.http.doPost(this.tsaUrl, "application/timestamp-query", new ByteArrayInputStream(tsReq), null);
            }
            catch (CapiException e) {
                this.logger.debug(null, (Throwable)e);
                throw new CapiException("Capi Error: " + e.getMessage(), 50040);
            }
            return new TimeStampToken(res);
        }
        try {
            DTMPThread dtmpt = new DTMPThread(this.serverAddr, this.serverPort, tsReq);
            dtmpt.setDaemon(true);
            dtmpt.start();
            dtmpt.join(this.timeout);
            if (dtmpt.isAlive()) {
                dtmpt.stop();
                throw new InterruptedException("Server timeout: " + this.timeout);
            }
            return new TimeStampToken(dtmpt.getData());
        }
        catch (DTMPException e) {
            this.logger.debug(null, (Throwable)e);
            throw new CapiException("Protocol Error: " + e.getMessage(), 50040);
        }
        catch (CapiException e) {
            this.logger.debug(null, (Throwable)e);
            throw new CapiException("Capi Error: " + e.getMessage(), 50040);
        }
    }

    @Override
    public byte[] stamp(InputStream is, TimeStampOptions options) {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public byte[] stampEx(InputStream is, TimeStampOptions options) throws TSAException {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
        catch (CapiException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }
}

