/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.soap.SOAPConnection;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ARSSDTSClient
extends DTSClient {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
    private static final String TSA_REQUEST = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:tsr>\n         <MarkRequest>\n            <user>%s</user>\n            <password>%s</password>\n%s            <transport>BYNARYNET</transport>\n            <binaryinput>%s</binaryinput>\n         </MarkRequest>\n      </arub:tsr>\n   </soapenv:Body>\n</soapenv:Envelope>";

    public ARSSDTSClient(String arss_server, String user, String password) {
        this.tsaData = new TSAData("", "", "", user, password, "", "");
        this.requestedUrl = arss_server;
        this.netConf = new NetworkConfig();
    }

    public ARSSDTSClient(String arss_server, String user, String password, NetworkConfig netConf) {
        this.tsaData = new TSAData("", "", "", user, password, "", "");
        this.requestedUrl = arss_server;
        this.netConf = netConf;
    }

    @Override
    public void initializeClient(TSAData tsaData, NetworkConfig networkConfig, String requestedUrl) throws IllegalParamException {
        if (requestedUrl == null) {
            throw new IllegalParamException("requestedUrl cannot be null in ARSSDTSClient");
        }
        this.tsaData = tsaData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = requestedUrl;
    }

    @Override
    public void setServer(String tsaUrl, HTTP http) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public void setServer(String serverAddr, int serverPort) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public void setTimeout(long timeOut) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message) throws CapiException, IOException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message) throws CapiException, TSAException, IOException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message, BigInteger nonce, boolean certReq) throws TSAException, CapiException, IOException {
        ByteArrayInputStream in = null;
        TimeStampToken ret = null;
        try {
            in = new ByteArrayInputStream(message);
            ret = this.timeStamp(policy, algorithm, in, nonce, certReq);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message, BigInteger nonce, boolean certReq) throws CapiException, IOException {
        try {
            byte[] encoded64 = Utils.base64Encode(IOUtils.toByteArray((InputStream)message));
            TimeStampToken timeStampToken = this.timeStampHash(policy, algorithm, encoded64, nonce, certReq);
            return timeStampToken;
        }
        catch (CapiException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash) throws ApiGeneralException, IOException {
        return this.timeStampHash(policy, algorithm, hash, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash, BigInteger nonce, boolean certReq) throws ApiGeneralException, IOException {
        TimeStampToken objReturn = null;
        try {
            TimeStampResponse tsr = new TimeStampResponse(this.mark(hash));
            objReturn = new TimeStampToken(tsr.getTimeStampToken().getEncoded());
        }
        catch (TSPException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    @Override
    public TimeStampResponse getMark(InputStream message, boolean certReq) throws ApiGeneralException, IOException, TSAException {
        TimeStampResponse objReturn = null;
        try {
            byte[] hash = Utils.base64Encode(IOUtils.toByteArray((InputStream)message));
            objReturn = new TimeStampResponse(this.mark(hash));
        }
        catch (TSPException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    private byte[] mark(byte[] hash) throws IOException {
        byte[] arrReturn = null;
        String url = "";
        if (this.tsaData.getTSAUrl() != null && !this.tsaData.getTSAUrl().isEmpty()) {
            url = "<url>" + this.tsaData.getTSAUrl() + "</url>\n";
        }
        String xml = String.format(TSA_REQUEST, this.tsaData.getTSAUser(), this.tsaData.getTSAPassword(), url, new String(hash));
        String xml_ret = SOAPConnection.sendXMLUrl2((String)this.requestedUrl, (String)xml, (NetworkConfig)this.netConf, (String)"\"\"", null, (KeyStore)ArubaTrustStore.getTSRS(), (boolean)false);
        try {
            NodeList nl_binaryoutput;
            Element objElStat;
            NodeList nl_return_code;
            NodeList nl2;
            DocumentBuilder db = df.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml_ret.getBytes()));
            NodeList nl = doc.getElementsByTagName("return");
            if (nl.getLength() > 0 && (nl2 = doc.getElementsByTagName("return")).getLength() > 0 && (nl_return_code = (objElStat = (Element)nl2.item(0)).getElementsByTagName("return_code")).getLength() > 0 && nl_return_code.item(0).getTextContent().equals("0000") && (nl_binaryoutput = objElStat.getElementsByTagName("binaryoutput")).getLength() > 0) {
                arrReturn = Base64.decode((String)nl_binaryoutput.item(0).getTextContent());
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (arrReturn == null) {
            throw new IOException("Errore nella richiesta TSA");
        }
        return arrReturn;
    }

    @Override
    public byte[] stamp(InputStream is, TimeStampOptions options) {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (TSAException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (ApiGeneralException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public void setNetConf(NetworkConfig netConf) {
        this.netConf = netConf;
    }

    @Override
    public byte[] stampEx(InputStream is, TimeStampOptions options) throws TSAException {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
        catch (ApiGeneralException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }
}

