/*
 * Decompiled with CFR 0.152.
 */
package demo.cms.tsp;

import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.smime.attributes.SignatureTimeStampToken;
import iaik.tsp.MessageImprint;
import iaik.tsp.PKIFailureInfo;
import iaik.tsp.PKIStatus;
import iaik.tsp.PKIStatusInfo;
import iaik.tsp.TSTInfo;
import iaik.tsp.TimeStampReq;
import iaik.tsp.TimeStampResp;
import iaik.tsp.TimeStampToken;
import iaik.tsp.TspException;
import iaik.tsp.transport.http.TspHttpClient;
import iaik.tsp.transport.http.TspHttpResponse;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Random;

public class TimeStampListener
extends SDSEncodeListener {
    private PrintWriter g;
    private TspException a;
    private boolean d;
    private ObjectID c;
    private TimeStampResp e;
    private TimeStampReq f;
    private String b;

    private void a(TimeStampResp timeStampResp) throws TspException {
        Object object;
        PKIStatusInfo pKIStatusInfo = timeStampResp.getPKIStatusInfo();
        PKIStatus pKIStatus = pKIStatusInfo.getPKIStatus();
        int n = pKIStatus.getStatus();
        if (n != 0 && n != 1) {
            PKIFailureInfo pKIFailureInfo = pKIStatusInfo.getPKIFailureInfo();
            throw new TspException("TSA reported failure: " + pKIStatus + (pKIFailureInfo == null ? "" : "(" + pKIFailureInfo + ")"));
        }
        TimeStampToken timeStampToken = timeStampResp.getTimeStampToken();
        if (timeStampToken == null) {
            throw new TspException("Got invalid response from TSA: TimeStampToken is missing");
        }
        this.a("Verify TSA signature.");
        X509Certificate x509Certificate = (X509Certificate)timeStampToken.getSigningCertificate();
        if (x509Certificate == null) {
            throw new TspException("Invalid response: does not contain the requested TSA certificate!");
        }
        timeStampToken.verifyTimeStampToken((java.security.cert.X509Certificate)x509Certificate);
        this.a("TSA signature ok.");
        TSTInfo tSTInfo = timeStampToken.getTSTInfo();
        this.a("Validate MessageImprint.");
        MessageImprint messageImprint = tSTInfo.getMessageImprint();
        if (!messageImprint.equals((Object)this.f.getMessageImprint())) {
            throw new TspException("Response MessageImprint does not match to request imprint!");
        }
        this.a("MessageImprint ok.");
        BigInteger bigInteger = this.f.getNonce();
        if (bigInteger != null) {
            this.a("Validate Nonce.");
            object = tSTInfo.getNonce();
            if (object == null) {
                throw new TspException("Invalid Response! Does not contain nonce!");
            }
            if (!bigInteger.equals(object)) {
                throw new TspException("Response nonce does not match to request nonce!");
            }
            this.a("Nonce ok.");
        }
        if ((object = this.f.getTSAPolicyID()) != null) {
            this.a("Validate TSA policy id.");
            if (!object.equals((Object)tSTInfo.getTSAPolicyID())) {
                throw new TspException("TSA policy not trusted!");
            }
            this.a("TSA policy id ok.");
        }
    }

    private void a(SignerInfo signerInfo) throws TspException {
        Attribute[] attributeArray;
        AlgorithmID algorithmID;
        Object object;
        if (this.e == null) {
            object = signerInfo.getSignatureValue();
            this.a("Calculate MessageImprint.");
            algorithmID = AlgorithmID.sha1;
            attributeArray = null;
            try {
                attributeArray = algorithmID.getMessageDigestInstance();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new TspException("Cannot calculate MessageImprint! Algorithm SHA-1 not supported!");
            }
            byte[] byArray = attributeArray.digest((byte[])object);
            MessageImprint messageImprint = new MessageImprint(algorithmID, byArray);
            this.a("Create TimeStamp request.");
            this.f = new TimeStampReq();
            this.f.setMessageImprint(messageImprint);
            this.f.setCertReq(true);
            if (this.c != null) {
                this.f.setTSAPolicyID(this.c);
            }
            BigInteger bigInteger = new BigInteger(64, new Random());
            this.f.setNonce(bigInteger);
            try {
                this.a("Send request to " + this.b + "...");
                TspHttpClient tspHttpClient = new TspHttpClient(new URL(this.b));
                TspHttpResponse tspHttpResponse = tspHttpClient.sendRequest(this.f);
                if (tspHttpResponse.isErrorResponse()) {
                    throw new TspException("Error connecting to TSA: " + tspHttpResponse.getErrorMsg());
                }
                this.e = tspHttpResponse.getTimeStampResp();
                this.a("Validate response.");
                this.a(this.e);
            }
            catch (IOException iOException) {
                throw new TspException("Error connecting to TSA: " + iOException.toString());
            }
            catch (CodingException codingException) {
                throw new TspException("Error encoding tsp request: " + codingException.getMessage());
            }
        }
        try {
            this.a("Create and set unsigned SignatureTimeStampToken attribute.");
            object = this.e.getTimeStampToken();
            algorithmID = new SignatureTimeStampToken(object.toASN1Object());
            attributeArray = new Attribute[]{new Attribute((AttributeValue)algorithmID)};
            signerInfo.addUnsignedAttributes(attributeArray);
            return;
        }
        catch (CodingException codingException) {
            throw new TspException("Error encoding TimeStampToken attribute: " + codingException.getMessage());
        }
        catch (CMSException cMSException) {
            throw new TspException("Error adding SignatureTimeStampToken attribute: " + cMSException.getMessage());
        }
    }

    public void setTimeStampResponse(TimeStampResp timeStampResp) {
        this.e = timeStampResp;
    }

    public void setTSAPolicyID(ObjectID objectID) {
        this.c = objectID;
    }

    public void setStopOnTSPProcessingError(boolean bl) {
        this.d = bl;
    }

    public void setDebugStream(OutputStream outputStream) {
        if (outputStream == null) {
            this.g = null;
            return;
        }
        this.g = new PrintWriter(outputStream, true);
    }

    public TspException getTspFailure() {
        return this.a;
    }

    public TimeStampResp getTimeStampResponse() {
        return this.e;
    }

    public TimeStampReq getTimeStampRequest() {
        return this.f;
    }

    private void a(String string) {
        if (this.g != null) {
            this.g.println(string);
        }
    }

    protected void beforeComputeSignature(SignedDataStream signedDataStream) throws CMSException {
    }

    protected void afterComputeSignature(SignedDataStream signedDataStream) throws CMSException {
        SignerInfo signerInfo = signedDataStream.getSignerInfos()[0];
        try {
            this.a("Verify SignerInfo signature.");
            signedDataStream.verify(0);
            this.a("Signature ok.");
            this.a(signerInfo);
            return;
        }
        catch (SignatureException signatureException) {
            throw new CMSException("Signature verification ERROR from signer: " + signerInfo.getSignerIdentifier() + signatureException.getMessage());
        }
        catch (TspException tspException) {
            this.a = tspException;
            if (this.d) {
                throw new CMSException("Error getting timestamp for signer: " + signerInfo.getSignerIdentifier() + tspException.toString());
            }
            return;
        }
    }

    public TimeStampListener(String string) {
        if (string == null) {
            throw new NullPointerException("TSA URL must not be null!");
        }
        this.b = string;
        this.d = true;
    }
}

