/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.xml.crypto.xades.EncapsulatedX509Certificate;
import iaik.xml.crypto.xades.impl.dom.properties.EncapsulatedPKIDataType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Node;

public class EncapsulatedX509CertificateImpl
extends EncapsulatedPKIDataType
implements EncapsulatedX509Certificate {
    private X509Certificate a;

    protected void setEncodedPKIValue(InputStream inputStream, String string) throws MarshalException {
        if (string == null || string.equals("http://uri.etsi.org/01903/v1.2.2#DER") || string.equals("http://uri.etsi.org/01903/v1.2.2#BER")) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                this.a = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            }
            catch (CertificateException certificateException) {
                throw new MarshalException("Failed to decode certificate, " + certificateException.getMessage(), certificateException);
            }
        } else {
            throw new MarshalException("Failed to decode certificate, encoding mechanism '" + string + "' is not supported");
        }
    }

    public X509Certificate getX509Certificate() {
        return this.a;
    }

    public String getLocalName() {
        return "EncapsulatedX509Certificate";
    }

    protected InputStream getEncodedPKIValue(String string) throws MarshalException {
        if (string == null || string.equals("http://uri.etsi.org/01903/v1.2.2#DER")) {
            try {
                return new ByteArrayInputStream(this.a.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new MarshalException("Failed to encode certificate, " + certificateEncodingException.getMessage(), certificateEncodingException);
            }
        }
        throw new MarshalException("Failed to encode certificate, encoding mechanism '" + string + "' is not supported");
    }

    public EncapsulatedX509CertificateImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.a == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public EncapsulatedX509CertificateImpl(X509Certificate x509Certificate, String string, String string2) {
        super(string, string2);
        if (x509Certificate == null) {
            throw new NullPointerException("Argument 'certificate' must not be null");
        }
        this.a = x509Certificate;
    }
}

